/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.liveontologies.puli.CachingProof;
import org.liveontologies.puli.DynamicProof;
import org.liveontologies.puli.EmptyProof;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceDerivabilityChecker;
import org.liveontologies.puli.InferenceExpander;
import org.liveontologies.puli.Producer;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.ProofPrinter;
import org.liveontologies.puli.ProofUnion;
import org.liveontologies.puli.PrunedProof;
import org.liveontologies.puli.RemoveAssertedProof;

public class Proofs {
    public static DynamicProof EMPTY_PROOF = new EmptyProof();

    public static <I extends Inference<?>> DynamicProof<I> emptyProof() {
        return EMPTY_PROOF;
    }

    public static boolean isDerivable(Proof<?> proof, Object conclusion) {
        return new InferenceDerivabilityChecker(proof).isDerivable(conclusion);
    }

    public static <I extends Inference<?>> Proof<I> union(Iterable<? extends Proof<? extends I>> proofs) {
        return new ProofUnion(proofs);
    }

    public static <I extends Inference<?>> Proof<I> union(Proof<? extends I> ... proofs) {
        return new ProofUnion<I>(proofs);
    }

    public static <I extends Inference<?>> Proof<I> removeAssertedInferences(Proof<? extends I> proof) {
        return Proofs.removeAssertedInferences(proof, Collections.emptySet());
    }

    public static <I extends Inference<?>> Proof<I> removeAssertedInferences(Proof<? extends I> proof, Set<?> assertedConclusions) {
        return new RemoveAssertedProof<I>(proof, assertedConclusions);
    }

    public static <I extends Inference<?>> DynamicProof<I> cache(DynamicProof<? extends I> proof) {
        return new CachingProof<I>(proof);
    }

    public static <C, I extends Inference<? extends C>> Set<C> unfoldRecursively(Proof<? extends I> proof, C goal, Producer<? super I> producer) {
        Object next;
        HashSet result = new HashSet();
        ArrayDeque toExpand = new ArrayDeque();
        result.add(goal);
        toExpand.add(goal);
        while ((next = toExpand.poll()) != null) {
            for (Inference inf : proof.getInferences(next)) {
                producer.produce(inf);
                for (Object premise : inf.getPremises()) {
                    if (!result.add(premise)) continue;
                    toExpand.add(premise);
                }
            }
        }
        return result;
    }

    public static int countInferences(Proof<?> proof, Object goal) {
        final int[] counter = new int[]{0};
        Proofs.unfoldRecursively(proof, goal, new Producer<Inference<?>>(){

            @Override
            public void produce(Inference<?> object) {
                counter[0] = counter[0] + 1;
            }
        });
        return counter[0];
    }

    public static <C, I extends Inference<? extends C>> Set<C> getEssentialConclusions(Proof<I> proof, C goal) {
        HashSet<C> result = new HashSet<C>();
        InferenceDerivabilityChecker<C, I> checker = new InferenceDerivabilityChecker<C, I>(proof);
        for (C candidate : Proofs.unfoldRecursively(proof, goal, Producer.Dummy.get())) {
            checker.block(candidate);
            if (!checker.isDerivable(goal)) {
                result.add(candidate);
            }
            checker.unblock(candidate);
        }
        return result;
    }

    public static <C, I extends Inference<? extends C>> void expand(Set<C> derivable, Proof<? extends I> proof, C goal, Producer<? super I> producer) {
        InferenceExpander.expand(derivable, proof, goal, producer);
    }

    public static <I extends Inference<?>> Proof<I> prune(Proof<? extends I> proof, Object goal) {
        return new PrunedProof<I>(proof, goal);
    }

    public static void print(Proof<?> proof, Object goal) {
        try {
            ProofPrinter.print(proof, goal);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while printing the proof", e);
        }
    }
}

