/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.liveontologies.puli.collections.AbstractCollection2;
import org.liveontologies.puli.collections.Condition;
import org.liveontologies.puli.collections.DelegatingIterator;
import org.liveontologies.puli.collections.FilteredIterator;

public class BloomTrieCollection2<C extends Collection<?>>
extends AbstractCollection2<C> {
    private static final short FILTER_SHIFT_ = 6;
    private static final int FILTER_MASK_ = BloomTrieCollection2.getMask((short)6);
    private static final long LONG_MASK_ = -1L;
    private Node<C> root_ = new LeafNode();
    private int size_ = 0;

    private static int getMask(short bits) {
        return (1 << bits) - 1;
    }

    private static long getFilter(Collection<?> s) {
        long result = 0L;
        for (Object e : s) {
            int hash = e.hashCode();
            int pos = hash & FILTER_MASK_;
            result |= 1L << (pos ^= (hash >>>= 6) & FILTER_MASK_);
        }
        return result;
    }

    private static long getFilter2(Collection<?> s) {
        long result = 0L;
        for (Object e : s) {
            int hash = e.hashCode() >>> 12;
            int pos = hash & FILTER_MASK_;
            result |= 1L << (pos ^= (hash >>>= 6) & FILTER_MASK_);
        }
        return result;
    }

    @Override
    public boolean add(C s) {
        Node<C> newRoot = this.root_.add(s, -1L, BloomTrieCollection2.getFilter(s), BloomTrieCollection2.getFilter2(s));
        if (newRoot != null) {
            this.root_ = newRoot;
        }
        ++this.size_;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Collection) {
            Collection s = (Collection)o;
            return this.root_.contains(s, -1L, BloomTrieCollection2.getFilter(s), BloomTrieCollection2.getFilter2(s));
        }
        return false;
    }

    @Override
    public void clear() {
        this.root_ = new LeafNode();
        this.size_ = 0;
    }

    @Override
    public boolean isMinimal(Collection<?> s) {
        return this.root_.isMinimal(s, -1L, BloomTrieCollection2.getFilter(s), BloomTrieCollection2.getFilter2(s));
    }

    @Override
    public boolean isMaximal(Collection<?> s) {
        return this.root_.isMaximal(s, -1L, BloomTrieCollection2.getFilter(s), BloomTrieCollection2.getFilter2(s));
    }

    @Override
    public Iterable<C> subCollectionsOf(final Collection<?> s) {
        return new Iterable<C>(){
            final Condition<C> subsetCondition = new Condition<C>(){

                @Override
                public boolean holds(C o) {
                    return s.containsAll((Collection<?>)o);
                }
            };
            final long filter = BloomTrieCollection2.access$000(s);
            final long filter2 = BloomTrieCollection2.access$100(s);

            @Override
            public Iterator<C> iterator() {
                return new DelegatingIterator<C>(BloomTrieCollection2.this.root_.subCollectionsOf(this.subsetCondition, -1L, this.filter, this.filter2)){

                    @Override
                    public void remove() {
                        super.remove();
                        BloomTrieCollection2.this.size_--;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<C> superCollectionsOf(final Collection<?> s) {
        return new Iterable<C>(){
            final Condition<C> supersetCondition = new Condition<C>(){

                @Override
                public boolean holds(C o) {
                    return o.containsAll(s);
                }
            };
            final long filter = BloomTrieCollection2.access$000(s);
            final long filter2 = BloomTrieCollection2.access$100(s);

            @Override
            public Iterator<C> iterator() {
                return new DelegatingIterator<C>(BloomTrieCollection2.this.root_.superCollectionsOf(this.supersetCondition, -1L, this.filter, this.filter2)){

                    @Override
                    public void remove() {
                        super.remove();
                        BloomTrieCollection2.this.size_--;
                    }
                };
            }
        };
    }

    @Override
    public Iterator<C> iterator() {
        return new DelegatingIterator<C>(this.root_.iterator(-1L)){

            @Override
            public void remove() {
                super.remove();
                BloomTrieCollection2.this.size_--;
            }
        };
    }

    @Override
    public int size() {
        return this.size_;
    }

    static /* synthetic */ long access$000(Collection x0) {
        return BloomTrieCollection2.getFilter(x0);
    }

    static /* synthetic */ long access$100(Collection x0) {
        return BloomTrieCollection2.getFilter2(x0);
    }

    static /* synthetic */ int access$400(short x0) {
        return BloomTrieCollection2.getMask(x0);
    }

    static class LeafNode<C extends Collection<?>>
    implements Node<C> {
        private static final int INIT_CAPACITY_ = 8;
        private static final int SPLIT_CAPACITY_ = 64;
        private final Object[] collections_;
        private final long[] fragments_;
        private final long[] filters2_;
        private int size_ = 0;

        LeafNode() {
            this(-1L);
        }

        LeafNode(long mask) {
            this(mask, 8);
        }

        LeafNode(long mask, int capacity) {
            this.collections_ = new Object[capacity];
            this.fragments_ = mask == 0L ? null : new long[capacity];
            this.filters2_ = new long[capacity];
        }

        LeafNode(LeafNode<C> from) {
            int capacity = from.collections_.length << 1;
            this.size_ = from.size_;
            this.collections_ = new Object[capacity];
            System.arraycopy(from.collections_, 0, this.collections_, 0, this.size_);
            this.filters2_ = new long[capacity];
            System.arraycopy(from.filters2_, 0, this.filters2_, 0, this.size_);
            if (from.fragments_ != null) {
                this.fragments_ = new long[capacity];
                System.arraycopy(from.fragments_, 0, this.fragments_, 0, this.size_);
            } else {
                this.fragments_ = null;
            }
        }

        C getCollection(int index) {
            return (C)((Collection)this.collections_[index]);
        }

        long getFragment(int index) {
            if (this.fragments_ == null) {
                return 0L;
            }
            return this.fragments_[index];
        }

        @Override
        public Node<C> add(C s, long mask, long fragment, long filter2) {
            Node<C> replacement;
            if (this.size_ < this.collections_.length) {
                this.collections_[this.size_] = s;
                if (this.fragments_ != null) {
                    this.fragments_[this.size_] = fragment;
                }
                this.filters2_[this.size_] = filter2;
                ++this.size_;
                return null;
            }
            if (mask == 0L || this.size_ < 64) {
                replacement = new LeafNode<C>(this);
            } else {
                replacement = new InternalNode(mask);
                for (int i = 0; i < this.collections_.length; ++i) {
                    replacement.add(this.getCollection(i), mask, this.getFragment(i), this.filters2_[i]);
                }
            }
            replacement.add(s, mask, fragment, filter2);
            return replacement;
        }

        void remove(int pos) {
            if (pos < 0 || pos >= this.size_) {
                throw new IndexOutOfBoundsException("Position " + pos + " must be between 0 " + (this.size_ - 1));
            }
            --this.size_;
            this.collections_[pos] = this.collections_[this.size_];
            if (this.fragments_ != null) {
                this.fragments_[pos] = this.fragments_[this.size_];
            }
            this.filters2_[pos] = this.filters2_[this.size_];
        }

        @Override
        public boolean contains(Collection<?> s, long mask, long fragment, long filter2) {
            for (int i = 0; i < this.size_; ++i) {
                if (filter2 != this.filters2_[i] || !s.equals(this.collections_[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isMinimal(Collection<?> s, long mask, long fragment, long filter2) {
            for (int i = 0; i < this.size_; ++i) {
                if ((fragment | this.getFragment(i)) != fragment || (filter2 | this.filters2_[i]) != filter2 || !s.containsAll((Collection<?>)this.getCollection(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isMaximal(Collection<?> s, long mask, long fragment, long filter2) {
            for (int i = 0; i < this.size_; ++i) {
                if ((fragment & this.getFragment(i)) != fragment || (filter2 & this.filters2_[i]) != filter2 || !this.getCollection(i).containsAll(s)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<C> iterator(long mask) {
            return new Iterator<C>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < LeafNode.this.size_;
                }

                @Override
                public C next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result = LeafNode.this.getCollection(this.pos);
                    ++this.pos;
                    return result;
                }

                @Override
                public void remove() {
                    if (this.pos == 0) {
                        throw new IllegalStateException();
                    }
                    --this.pos;
                    LeafNode.this.remove(this.pos);
                }
            };
        }

        @Override
        public Iterator<C> subCollectionsOf(Condition<? super C> subsetCondition, long mask, long fragment, long filter2) {
            return new FilteredIterator<C>(this.iterator(mask), subsetCondition);
        }

        @Override
        public Iterator<C> superCollectionsOf(Condition<? super C> supersetCondition, long mask, long fragment, long filter2) {
            return new FilteredIterator<C>(this.iterator(mask), supersetCondition);
        }
    }

    static class InternalNode<C extends Collection<?>>
    implements Node<C> {
        private static final short BUCKET_SHIFT_ = 6;
        private static final int BUCKET_MASK_ = BloomTrieCollection2.access$400((short)6);
        private static final Iterator<?> EMPTY_ITERATOR_ = Collections.EMPTY_LIST.iterator();
        private final Node<C>[] children_;

        InternalNode(long mask) {
            if (mask == 0L) {
                throw new IllegalArgumentException();
            }
            this.children_ = new Node[(int)((long)BUCKET_MASK_ & mask) + 1];
        }

        @Override
        public Node<C> add(C s, long mask, long fragment, long filter2) {
            Node<C> updated;
            int pos = (int)(fragment & (long)BUCKET_MASK_ & mask);
            mask >>>= 6;
            fragment >>>= 6;
            if (this.children_[pos] == null) {
                this.children_[pos] = new LeafNode(mask);
            }
            if ((updated = this.children_[pos].add(s, mask, fragment, filter2)) != null) {
                this.children_[pos] = updated;
            }
            return null;
        }

        @Override
        public boolean contains(Collection<?> s, long mask, long fragment, long filter2) {
            int pos = (int)(fragment & (long)BUCKET_MASK_ & mask);
            mask >>>= 6;
            fragment >>>= 6;
            if (this.children_[pos] == null) {
                return false;
            }
            return this.children_[pos].contains(s, fragment, mask, filter2);
        }

        @Override
        public boolean isMinimal(Collection<?> s, long mask, long fragment, long filter2) {
            int fragmentMask = (int)(fragment & mask & (long)BUCKET_MASK_);
            mask >>>= 6;
            fragment >>>= 6;
            int pos = 0;
            Node<C> child;
            while ((child = this.children_[pos]) == null || child.isMinimal(s, mask, fragment, filter2)) {
                if (pos == fragmentMask) {
                    return true;
                }
                pos |= ~fragmentMask;
                ++pos;
                pos &= fragmentMask;
            }
            return false;
        }

        @Override
        public boolean isMaximal(Collection<?> s, long mask, long fragment, long filter2) {
            int fragmentMask = (int)(fragment & mask & (long)BUCKET_MASK_);
            int pos = (int)(mask & (long)BUCKET_MASK_);
            mask >>>= 6;
            fragment >>>= 6;
            Node<C> child;
            while ((child = this.children_[pos]) == null || child.isMaximal(s, mask, fragment, filter2)) {
                if (pos == fragmentMask) {
                    return true;
                }
                pos &= ~fragmentMask;
                --pos;
                pos |= fragmentMask;
            }
            return false;
        }

        @Override
        public Iterator<C> iterator(long mask) {
            return new BaseIterator(mask);
        }

        @Override
        public Iterator<C> subCollectionsOf(Condition<? super C> subsetCondition, long mask, long fragment, long filter2) {
            return new SubIterator(subsetCondition, mask, fragment, filter2);
        }

        @Override
        public Iterator<C> superCollectionsOf(Condition<? super C> supersetCondition, long mask, long fragment, long filter2) {
            return new SuperIterator(supersetCondition, mask, fragment, filter2);
        }

        static /* synthetic */ Iterator access$500() {
            return EMPTY_ITERATOR_;
        }

        class SuperIterator
        extends BaseIterator {
            final Condition<? super C> supersetCondition;
            final long nextFragment;
            final long filter2;
            final int fragmentMask;
            boolean noMorePos;

            SuperIterator(Condition<? super C> supersetCondition, long mask, long fragment, long filter2) {
                super(mask);
                this.noMorePos = false;
                this.supersetCondition = supersetCondition;
                this.nextFragment = fragment >>> 6;
                this.filter2 = filter2;
                this.fragmentMask = (int)(fragment & mask & (long)BUCKET_MASK_);
                this.pos = (int)(mask & (long)BUCKET_MASK_);
            }

            @Override
            void advancePos() {
                if (this.pos == this.fragmentMask) {
                    this.noMorePos = true;
                    return;
                }
                this.pos &= ~this.fragmentMask;
                --this.pos;
                this.pos |= this.fragmentMask;
            }

            @Override
            boolean noMorePos() {
                return this.noMorePos;
            }

            @Override
            Iterator<C> getChildIterator(Node<C> child) {
                return child.superCollectionsOf(this.supersetCondition, this.nextMask, this.nextFragment, this.filter2);
            }
        }

        class SubIterator
        extends BaseIterator {
            final Condition<? super C> subsetCondition;
            final long nextFragment;
            final long filter2;
            final int fragmentMask;
            boolean noMorePos;

            SubIterator(Condition<? super C> subsetCondition, long mask, long fragment, long filter2) {
                super(mask);
                this.noMorePos = false;
                this.subsetCondition = subsetCondition;
                this.nextFragment = fragment >>> 6;
                this.filter2 = filter2;
                this.fragmentMask = (int)(fragment & mask & (long)BUCKET_MASK_);
            }

            @Override
            void advancePos() {
                if (this.pos == this.fragmentMask) {
                    this.noMorePos = true;
                    return;
                }
                this.pos |= ~this.fragmentMask;
                ++this.pos;
                this.pos &= this.fragmentMask;
            }

            @Override
            boolean noMorePos() {
                return this.noMorePos;
            }

            @Override
            Iterator<C> getChildIterator(Node<C> child) {
                return child.subCollectionsOf(this.subsetCondition, this.nextMask, this.nextFragment, this.filter2);
            }
        }

        class BaseIterator
        implements Iterator<C> {
            final long nextMask;
            int pos = 0;
            Iterator<C> iter = InternalNode.access$500();
            boolean iterInSync = true;

            BaseIterator(long mask) {
                this.nextMask = mask >>> 6;
            }

            void advancePos() {
                ++this.pos;
            }

            boolean noMorePos() {
                return this.pos == InternalNode.this.children_.length;
            }

            Iterator<C> getChildIterator(Node<C> child) {
                return child.iterator(this.nextMask);
            }

            @Override
            public void remove() {
                if (!this.iterInSync) {
                    throw new NoSuchElementException();
                }
                this.iter.remove();
            }

            @Override
            public boolean hasNext() {
                while (!this.iter.hasNext()) {
                    Node child;
                    do {
                        if (this.noMorePos()) {
                            return false;
                        }
                        child = InternalNode.this.children_[this.pos];
                        this.advancePos();
                    } while (child == null);
                    this.iterInSync = false;
                    this.iter = this.getChildIterator(child);
                }
                return true;
            }

            @Override
            public C next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Collection result = (Collection)this.iter.next();
                this.iterInSync = true;
                return result;
            }
        }
    }

    static interface Node<C extends Collection<?>> {
        public Node<C> add(C var1, long var2, long var4, long var6);

        public boolean contains(Collection<?> var1, long var2, long var4, long var6);

        public boolean isMinimal(Collection<?> var1, long var2, long var4, long var6);

        public boolean isMaximal(Collection<?> var1, long var2, long var4, long var6);

        public Iterator<C> iterator(long var1);

        public Iterator<C> subCollectionsOf(Condition<? super C> var1, long var2, long var4, long var6);

        public Iterator<C> superCollectionsOf(Condition<? super C> var1, long var2, long var4, long var6);
    }
}

