/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.liveontologies.puli.collections.Condition;
import org.liveontologies.puli.collections.DelegatingIterator;

public class FilteredIterator<E>
extends DelegatingIterator<E> {
    private final Condition<? super E> condition_;
    private E next_ = null;
    boolean nextInSync = true;

    FilteredIterator(Iterator<E> delegate, Condition<? super E> condition) {
        super(delegate);
        this.condition_ = condition;
        this.advance();
    }

    void advance() {
        Iterator delegate = this.getDelegate();
        while (delegate.hasNext()) {
            this.next_ = delegate.next();
            this.nextInSync = false;
            if (!this.condition_.holds(this.next_)) continue;
            return;
        }
        this.next_ = null;
    }

    @Override
    public void remove() {
        if (!this.nextInSync) {
            throw new UnsupportedOperationException("remove");
        }
        this.getDelegate().remove();
    }

    @Override
    public boolean hasNext() {
        if (this.nextInSync) {
            this.advance();
        }
        return this.next_ != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextInSync = true;
        return this.next_;
    }
}

