/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceJustifier;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.pinpointing.AbstractMinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.InterruptMonitor;
import org.liveontologies.puli.pinpointing.MinimalSubsetCollector;
import org.liveontologies.puli.pinpointing.MinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.MinimalSubsetsFromProofs;
import org.liveontologies.puli.pinpointing.PriorityComparator;
import org.liveontologies.puli.pinpointing.TopDownRepairComputation;

public class MinimalHittingSetEnumerator<E>
implements MinimalSubsetEnumerator.Factory<Collection<? extends Set<? extends E>>, E> {
    private static final Object CONCLUSION_ = new Object();
    private final MinimalSubsetsFromProofs.Factory<Object, SetWrapperInference, E> repairComputationFactory_;
    private final InterruptMonitor monitor_;
    private final InferenceJustifier<SetWrapperInference, Set<? extends E>> setWrapperJustifier_ = new InferenceJustifier<SetWrapperInference, Set<? extends E>>(){

        @Override
        public Set<? extends E> getJustification(SetWrapperInference inference) {
            return inference.originalSet_;
        }
    };

    public MinimalHittingSetEnumerator(MinimalSubsetsFromProofs.Factory<Object, SetWrapperInference, E> repairComputationFactory, InterruptMonitor monitor) {
        this.repairComputationFactory_ = repairComputationFactory;
        this.monitor_ = monitor;
    }

    @Override
    public MinimalSubsetEnumerator<E> newEnumerator(Collection<? extends Set<? extends E>> query) {
        return new Enumerator(query);
    }

    public static <E> Collection<? extends Set<? extends E>> compute(Collection<? extends Set<? extends E>> sets) {
        ArrayList result = new ArrayList();
        MinimalHittingSetEnumerator computation = new MinimalHittingSetEnumerator(TopDownRepairComputation.getFactory(), InterruptMonitor.DUMMY);
        computation.newEnumerator(sets).enumerate(new MinimalSubsetCollector(result));
        return result;
    }

    private class SetWrapperInference
    implements Inference<Object> {
        private final Set<? extends E> originalSet_;

        private SetWrapperInference(Set<? extends E> originalSet) {
            this.originalSet_ = originalSet;
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName();
        }

        @Override
        public Object getConclusion() {
            return CONCLUSION_;
        }

        @Override
        public List<? extends Object> getPremises() {
            return Collections.emptyList();
        }
    }

    private class SetWrapperProof
    implements Proof<SetWrapperInference> {
        private final Collection<? extends Set<? extends E>> originalSets_;

        private SetWrapperProof(Collection<? extends Set<? extends E>> originalSets) {
            this.originalSets_ = originalSets;
        }

        @Override
        public Collection<? extends SetWrapperInference> getInferences(Object conclusion) {
            if (conclusion == CONCLUSION_) {
                return Collections2.transform(this.originalSets_, (Function)new Function<Set<? extends E>, SetWrapperInference>(){

                    public SetWrapperInference apply(Set<? extends E> originalSet) {
                        return new SetWrapperInference(originalSet);
                    }
                });
            }
            return Collections.emptySet();
        }
    }

    private class Enumerator
    extends AbstractMinimalSubsetEnumerator<E> {
        private final Collection<? extends Set<? extends E>> originalSets_;

        private Enumerator(Collection<? extends Set<? extends E>> originalSets) {
            this.originalSets_ = originalSets;
        }

        @Override
        public void enumerate(MinimalSubsetEnumerator.Listener<E> listener, PriorityComparator<? super Set<E>, ?> priorityComparator) {
            SetWrapperProof proof = new SetWrapperProof(this.originalSets_);
            MinimalSubsetEnumerator.Factory computation = MinimalHittingSetEnumerator.this.repairComputationFactory_.create(proof, MinimalHittingSetEnumerator.this.setWrapperJustifier_, MinimalHittingSetEnumerator.this.monitor_);
            MinimalSubsetEnumerator enumerator = computation.newEnumerator(CONCLUSION_);
            enumerator.enumerate(listener, priorityComparator);
        }
    }
}

