/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceJustifier;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.pinpointing.InterruptMonitor;
import org.liveontologies.puli.pinpointing.MinimalSubsetEnumerator;

public abstract class MinimalSubsetsFromProofs<C, I extends Inference<? extends C>, A>
implements MinimalSubsetEnumerator.Factory<C, A> {
    private final Proof<? extends I> proof_;
    private final InferenceJustifier<? super I, ? extends Set<? extends A>> justifier_;
    private final InterruptMonitor monitor_;

    public MinimalSubsetsFromProofs(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor) {
        Preconditions.checkNotNull(proof);
        Preconditions.checkNotNull(justifier);
        Preconditions.checkNotNull((Object)monitor);
        this.proof_ = proof;
        this.justifier_ = justifier;
        this.monitor_ = monitor;
    }

    public Proof<? extends I> getProof() {
        return this.proof_;
    }

    public InferenceJustifier<? super I, ? extends Set<? extends A>> getInferenceJustifier() {
        return this.justifier_;
    }

    public Collection<? extends I> getInferences(C conclusion) {
        return this.proof_.getInferences(conclusion);
    }

    public Set<? extends A> getJustification(I inference) {
        return this.justifier_.getJustification(inference);
    }

    protected boolean isInterrupted() {
        return this.monitor_.isInterrupted();
    }

    public static interface Factory<C, I extends Inference<? extends C>, A> {
        public MinimalSubsetEnumerator.Factory<C, A> create(Proof<? extends I> var1, InferenceJustifier<? super I, ? extends Set<? extends A>> var2, InterruptMonitor var3);
    }
}

