/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.Delegator;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceJustifier;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.collections.BloomTrieCollection2;
import org.liveontologies.puli.collections.Collection2;
import org.liveontologies.puli.pinpointing.AbstractMinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.HashIdMap;
import org.liveontologies.puli.pinpointing.IdMap;
import org.liveontologies.puli.pinpointing.InterruptMonitor;
import org.liveontologies.puli.pinpointing.MinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.MinimalSubsetsFromProofs;
import org.liveontologies.puli.pinpointing.PriorityComparator;
import org.liveontologies.puli.pinpointing.SortedIdSet;
import org.liveontologies.puli.pinpointing.SortedIntSet;
import org.liveontologies.puli.statistics.NestedStats;
import org.liveontologies.puli.statistics.ResetStats;
import org.liveontologies.puli.statistics.Stat;

public class ResolutionJustificationComputation<C, I extends Inference<? extends C>, A>
extends MinimalSubsetsFromProofs<C, I, A> {
    private static final Factory<?, ?, ?> FACTORY_ = new Factory();
    private final SelectionType selectionType_;
    private final Set<C> initialized_ = new HashSet<C>();
    private final IdMap<C> conclusionIds_ = HashIdMap.create();
    private final IdMap<A> axiomIds_ = HashIdMap.create();
    private final Map<Integer, Collection2<DerivedInference>> minimalInferencesByConclusionIds_ = new HashMap<Integer, Collection2<DerivedInference>>();
    private final ListMultimap<Integer, DerivedInference> inferencesBySelectedConclusionIds_ = ArrayListMultimap.create();
    private final ListMultimap<Integer, DerivedInference> inferencesBySelectedPremiseIds_ = ArrayListMultimap.create();
    private Queue<DerivedInference> blockedInferences_ = new ArrayDeque<DerivedInference>();
    private int producedInferenceCount_ = 0;
    private int minimalInferenceCount_ = 0;

    public static <C, I extends Inference<? extends C>, A> Factory<C, I, A> getFactory() {
        return FACTORY_;
    }

    private ResolutionJustificationComputation(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor, SelectionType selectionType) {
        super(proof, justifier, monitor);
        this.selectionType_ = selectionType;
    }

    private Collection2<DerivedInference> getMinimalInferences(Integer conclusionId) {
        Collection2<DerivedInference> result = this.minimalInferencesByConclusionIds_.get(conclusionId);
        if (result == null) {
            result = new BloomTrieCollection2<DerivedInference>();
            this.minimalInferencesByConclusionIds_.put(conclusionId, result);
        }
        return result;
    }

    @Override
    public MinimalSubsetEnumerator<A> newEnumerator(C query) {
        return new JustificationEnumerator(query);
    }

    @Stat
    public int nProducedInferences() {
        return this.producedInferenceCount_;
    }

    @Stat
    public int nMinimalInferences() {
        return this.minimalInferenceCount_;
    }

    @ResetStats
    public void resetStats() {
        this.producedInferenceCount_ = 0;
        this.minimalInferenceCount_ = 0;
    }

    @NestedStats
    public static Class<?> getNestedStats() {
        return BloomTrieCollection2.class;
    }

    static int[] getIds(Collection<? extends Integer> set) {
        return SortedIdSet.getIds(set);
    }

    @Override
    Set<A> getJustification(int[] ids) {
        return new SortedIdSet<A>(ids, this.axiomIds_);
    }

    public static class Factory<C, I extends Inference<? extends C>, A>
    implements MinimalSubsetsFromProofs.Factory<C, I, A> {
        @Override
        public MinimalSubsetEnumerator.Factory<C, A> create(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor) {
            return this.create(proof, justifier, monitor, SelectionType.THRESHOLD);
        }

        public MinimalSubsetEnumerator.Factory<C, A> create(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor, SelectionType selection) {
            return new ResolutionJustificationComputation(proof, justifier, monitor, selection);
        }
    }

    public static interface SelectionFunction {
        public Integer getResolvingAtomId(DerivedInference var1);
    }

    class InferenceProcessor<P>
    implements UnprocessedInference.Visitor<P, DerivedInference> {
        private final PriorityComparator<? super Set<A>, P> priorityComparator_;

        InferenceProcessor(PriorityComparator<? super Set<A>, P> priorityComparator) {
            this.priorityComparator_ = priorityComparator;
        }

        @Override
        public DerivedInference visit(InitialInference<P> inference) {
            return inference;
        }

        @Override
        public DerivedInference visit(Resolvent<P> inference) {
            DerivedInference first = ((Resolvent)inference).firstInference_;
            DerivedInference second = ((Resolvent)inference).secondInference_;
            int[] newPremiseIds = second.getPremises().size() == 1 ? first.premiseIds_ : ResolutionJustificationComputation.getIds((Collection<? extends Integer>)Sets.union(first.getPremises(), (Set)Sets.difference(second.getPremises(), Collections.singleton(first.conclusionId_))));
            int[] newJustificationIds = SortedIdSet.union(first.justificationIds_, second.justificationIds_);
            return new InitialInference(second.conclusionId_, newPremiseIds, newJustificationIds, this.priorityComparator_.getPriority(ResolutionJustificationComputation.this.getJustification(newJustificationIds)));
        }
    }

    static class UnprocessedInferenceCompatator<P>
    implements Comparator<UnprocessedInference<P>> {
        private final Comparator<P> priorityComparator_;

        UnprocessedInferenceCompatator(Comparator<P> priorityComparator) {
            this.priorityComparator_ = priorityComparator;
        }

        @Override
        public int compare(UnprocessedInference<P> first, UnprocessedInference<P> second) {
            int secondPremiseCount;
            int result = this.priorityComparator_.compare(first.getPriority(), second.getPriority());
            if (result != 0) {
                return result;
            }
            int firstPremiseCount = first.getPremiseCount();
            return firstPremiseCount < (secondPremiseCount = second.getPremiseCount()) ? -1 : (firstPremiseCount == secondPremiseCount ? 0 : 1);
        }
    }

    static class Resolvent<P>
    implements UnprocessedInference<P> {
        private final DerivedInference firstInference_;
        private final DerivedInference secondInference_;
        private final P priority_;
        private final int premiseCount_;

        Resolvent(DerivedInference firstInference, DerivedInference secondInference, P priority) {
            if (firstInference.isATautology() || secondInference.isATautology()) {
                throw new IllegalArgumentException("Cannot resolve on tautologies!");
            }
            this.firstInference_ = firstInference;
            this.secondInference_ = secondInference;
            this.priority_ = priority;
            this.premiseCount_ = Sets.union(this.firstInference_.getPremises(), this.secondInference_.getPremises()).size() - 1;
        }

        @Override
        public int getPremiseCount() {
            return this.premiseCount_;
        }

        @Override
        public boolean isATautology() {
            return Arrays.binarySearch(this.firstInference_.premiseIds_, this.secondInference_.conclusionId_) >= 0;
        }

        @Override
        public P getPriority() {
            return this.priority_;
        }

        @Override
        public <O> O accept(UnprocessedInference.Visitor<P, O> visitor) {
            return visitor.visit(this);
        }
    }

    static class InitialInference<P>
    extends DerivedInference
    implements UnprocessedInference<P> {
        private final P priority_;

        private InitialInference(int conclusionId, int[] premiseIds, int[] justificationIds, P priority) {
            super(conclusionId, premiseIds, justificationIds);
            this.priority_ = priority;
        }

        private InitialInference(int conclusionId, int[] premiseIds, int[] justificationIds, P priority, boolean isMinimal) {
            this(conclusionId, premiseIds, justificationIds, priority);
            this.isMinimal_ = isMinimal;
        }

        @Override
        public int getPremiseCount() {
            return this.getPremises().size();
        }

        @Override
        public P getPriority() {
            return this.priority_;
        }

        @Override
        public <O> O accept(UnprocessedInference.Visitor<P, O> visitor) {
            return visitor.visit(this);
        }
    }

    static interface UnprocessedInference<P> {
        public P getPriority();

        public int getPremiseCount();

        public boolean isATautology();

        public <O> O accept(Visitor<P, O> var1);

        public static interface Visitor<P, O> {
            public O visit(InitialInference<P> var1);

            public O visit(Resolvent<P> var1);
        }
    }

    class JustificationProcessor<P> {
        private final C query_;
        private final int queryId_;
        private final SelectionFunction selectionFunction_;
        private final Collection2<Set<Integer>> minimalJustifications_ = new BloomTrieCollection2<Set<Integer>>();
        private final Queue<C> toInitialize_ = new ArrayDeque();
        private MinimalSubsetEnumerator.Listener<A> listener_;
        private final PriorityComparator<? super Set<A>, P> priorityComparator_;
        private final Queue<UnprocessedInference<P>> unprocessedInferences_;
        private final InferenceProcessor<P> resolver_;

        JustificationProcessor(C query, MinimalSubsetEnumerator.Listener<A> listener, PriorityComparator<? super Set<A>, P> priorityComparator) {
            this.query_ = query;
            this.queryId_ = ResolutionJustificationComputation.this.conclusionIds_.getId(query);
            this.priorityComparator_ = priorityComparator;
            this.selectionFunction_ = this.getSelectionFunction(ResolutionJustificationComputation.this.selectionType_);
            this.listener_ = listener;
            this.resolver_ = new InferenceProcessor<P>(priorityComparator);
            this.unprocessedInferences_ = new PriorityQueue(256, new UnprocessedInferenceCompatator(priorityComparator));
        }

        Proof<? extends I> getProof() {
            return ResolutionJustificationComputation.this.getProof();
        }

        IdMap<C> getConclusionIds() {
            return ResolutionJustificationComputation.this.conclusionIds_;
        }

        private void toInitialize(C conclusion) {
            if (ResolutionJustificationComputation.this.initialized_.add(conclusion)) {
                this.toInitialize_.add(conclusion);
            }
        }

        private void block(DerivedInference inf) {
            ResolutionJustificationComputation.this.blockedInferences_.add(inf);
        }

        /*
         * Exception decompiling
         */
        private void initialize() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void unblockJobs() {
            DerivedInference inf;
            while ((inf = (DerivedInference)ResolutionJustificationComputation.this.blockedInferences_.poll()) != null) {
                this.produce(this.newDerivedInference(inf));
            }
            return;
        }

        private void changeSelection() {
            for (DerivedInference inf : ResolutionJustificationComputation.this.inferencesBySelectedConclusionIds_.removeAll((Object)this.queryId_)) {
                this.produce(this.newDerivedInference(inf));
            }
        }

        private void process() {
            UnprocessedInference<P> next;
            while (!ResolutionJustificationComputation.this.isInterrupted() && (next = this.unprocessedInferences_.poll()) != null) {
                Integer selected;
                DerivedInference inf = (DerivedInference)next.accept(this.resolver_);
                if (!this.minimalJustifications_.isMinimal(inf.getJustification())) {
                    this.block(inf);
                    continue;
                }
                if (inf.premiseIds_.length == 0 && this.queryId_ == inf.conclusionId_) {
                    this.minimalJustifications_.add(inf.getJustification());
                    this.listener_.newMinimalSubset(ResolutionJustificationComputation.this.getJustification(inf.justificationIds_));
                    this.block(inf);
                    continue;
                }
                if (!inf.isMinimal_) {
                    Collection2 minimalInferences = ResolutionJustificationComputation.this.getMinimalInferences(inf.conclusionId_);
                    if (!minimalInferences.isMinimal(inf)) continue;
                    inf.isMinimal_ = true;
                    minimalInferences.add(inf);
                    ResolutionJustificationComputation.this.minimalInferenceCount_++;
                }
                if ((selected = this.selectionFunction_.getResolvingAtomId(inf)) == null) {
                    selected = inf.conclusionId_;
                    if (this.queryId_ == selected) {
                        throw new RuntimeException("Goal conclusion cannot be selected if the inference has premises: " + inf);
                    }
                    ResolutionJustificationComputation.this.inferencesBySelectedConclusionIds_.put((Object)selected, (Object)inf);
                    for (DerivedInference other : ResolutionJustificationComputation.this.inferencesBySelectedPremiseIds_.get((Object)selected)) {
                        this.produce(this.newResolvent(inf, other));
                    }
                    continue;
                }
                ResolutionJustificationComputation.this.inferencesBySelectedPremiseIds_.put((Object)selected, (Object)inf);
                for (DerivedInference other : ResolutionJustificationComputation.this.inferencesBySelectedConclusionIds_.get((Object)selected)) {
                    this.produce(this.newResolvent(other, inf));
                }
            }
        }

        private void produce(UnprocessedInference<P> resolvent) {
            if (resolvent.isATautology()) {
                return;
            }
            ResolutionJustificationComputation.this.producedInferenceCount_++;
            this.unprocessedInferences_.add(resolvent);
        }

        UnprocessedInference<P> newDerivedInference(DerivedInference inference) {
            return new InitialInference(inference.conclusionId_, inference.premiseIds_, inference.justificationIds_, this.priorityComparator_.getPriority(ResolutionJustificationComputation.this.getJustification(inference.justificationIds_)), inference.isMinimal_);
        }

        UnprocessedInference<P> newDerivedInference(I inference, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier) {
            int[] justificationIds = this.getAxiomIds(justifier.getJustification(inference));
            return new InitialInference(ResolutionJustificationComputation.this.conclusionIds_.getId(inference.getConclusion()), this.getConclusionIds(inference.getPremises()), justificationIds, this.priorityComparator_.getPriority(ResolutionJustificationComputation.this.getJustification(justificationIds)));
        }

        UnprocessedInference<P> newResolvent(DerivedInference firstInference, DerivedInference secondInference) {
            return new Resolvent<P>(firstInference, secondInference, this.priorityComparator_.getPriority(ResolutionJustificationComputation.this.getJustification(SortedIdSet.union(firstInference.justificationIds_, secondInference.justificationIds_))));
        }

        int[] getConclusionIds(Collection<? extends C> conclusions) {
            return SortedIdSet.getIds(conclusions, ResolutionJustificationComputation.this.conclusionIds_);
        }

        int[] getAxiomIds(Collection<? extends A> axioms) {
            return SortedIdSet.getIds(axioms, ResolutionJustificationComputation.this.axiomIds_);
        }

        SelectionFunction getSelectionFunction(SelectionType type) {
            switch (type) {
                case BOTTOM_UP: {
                    return new SelectionFunction(){

                        @Override
                        public Integer getResolvingAtomId(DerivedInference inference) {
                            Integer result = null;
                            int minInferenceCount = Integer.MAX_VALUE;
                            for (int premiseId : inference.premiseIds_) {
                                int inferenceCount = JustificationProcessor.this.getProof().getInferences(ResolutionJustificationComputation.this.conclusionIds_.getElement(premiseId)).size();
                                if (inferenceCount >= minInferenceCount) continue;
                                result = premiseId;
                                minInferenceCount = inferenceCount;
                            }
                            return result;
                        }
                    };
                }
                case THRESHOLD: {
                    return new SelectionFunction(){
                        static final int THRESHOLD_ = 2;

                        @Override
                        public Integer getResolvingAtomId(DerivedInference inference) {
                            int minInferenceCount = Integer.MAX_VALUE;
                            Integer result = null;
                            for (int premiseId : inference.premiseIds_) {
                                int inferenceCount = JustificationProcessor.this.getProof().getInferences(ResolutionJustificationComputation.this.conclusionIds_.getElement(premiseId)).size();
                                if (inferenceCount >= minInferenceCount) continue;
                                result = premiseId;
                                minInferenceCount = inferenceCount;
                            }
                            if (minInferenceCount > 2 && JustificationProcessor.this.queryId_ != inference.conclusionId_) {
                                result = null;
                            }
                            return result;
                        }
                    };
                }
                case TOP_DOWN: {
                    return new SelectionFunction(){

                        @Override
                        public Integer getResolvingAtomId(DerivedInference inference) {
                            Integer result = null;
                            if (JustificationProcessor.this.queryId_ == inference.conclusionId_) {
                                int minInferenceCount = Integer.MAX_VALUE;
                                for (int premiseId : inference.premiseIds_) {
                                    int inferenceCount = JustificationProcessor.this.getProof().getInferences(ResolutionJustificationComputation.this.conclusionIds_.getElement(premiseId)).size();
                                    if (inferenceCount >= minInferenceCount) continue;
                                    result = premiseId;
                                    minInferenceCount = inferenceCount;
                                }
                            }
                            return result;
                        }
                    };
                }
            }
            throw new RuntimeException("Unsupported selection type: " + (Object)((Object)type));
        }
    }

    class JustificationEnumerator
    extends AbstractMinimalSubsetEnumerator<A> {
        private final C query_;

        public JustificationEnumerator(C query) {
            this.query_ = query;
        }

        @Override
        public void enumerate(MinimalSubsetEnumerator.Listener<A> listener, PriorityComparator<? super Set<A>, ?> priorityComparator) {
            Preconditions.checkNotNull(listener);
            if (priorityComparator == null) {
                this.enumerate(listener);
                return;
            }
            JustificationProcessor<?> p = this.createProcessor(listener, priorityComparator);
            ((JustificationProcessor)p).initialize();
            ((JustificationProcessor)p).unblockJobs();
            ((JustificationProcessor)p).changeSelection();
            ((JustificationProcessor)p).process();
        }

        <P> JustificationProcessor<P> createProcessor(MinimalSubsetEnumerator.Listener<A> listener, PriorityComparator<? super Set<A>, P> priorityComparator) {
            return new JustificationProcessor<P>(this.query_, listener, priorityComparator);
        }
    }

    static final class Premise
    extends Delegator<Integer>
    implements DerivedInferenceMember {
        public Premise(Integer id) {
            super(id);
        }

        @Override
        public <O> O accept(DerivedInferenceMember.Visitor<O> visitor) {
            return visitor.visit(this);
        }
    }

    static final class Conclusion
    extends Delegator<Integer>
    implements DerivedInferenceMember {
        public Conclusion(Integer id) {
            super(id);
        }

        @Override
        public <O> O accept(DerivedInferenceMember.Visitor<O> visitor) {
            return visitor.visit(this);
        }
    }

    static final class Axiom
    extends Delegator<Integer>
    implements DerivedInferenceMember {
        public Axiom(Integer id) {
            super(id);
        }

        @Override
        public <O> O accept(DerivedInferenceMember.Visitor<O> visitor) {
            return visitor.visit(this);
        }
    }

    static interface DerivedInferenceMember {
        public <O> O accept(Visitor<O> var1);

        public static interface Visitor<O> {
            public O visit(Axiom var1);

            public O visit(Conclusion var1);

            public O visit(Premise var1);
        }
    }

    static class DerivedInference
    extends AbstractSet<DerivedInferenceMember> {
        private final int conclusionId_;
        private final int[] premiseIds_;
        private final int[] justificationIds_;
        boolean isMinimal_ = false;

        protected DerivedInference(int conclusionId, int[] premiseIds, int[] justificationIds) {
            this.conclusionId_ = conclusionId;
            this.premiseIds_ = premiseIds;
            this.justificationIds_ = justificationIds;
        }

        public Set<Integer> getPremises() {
            return new SortedIntSet(this.premiseIds_);
        }

        public Set<Integer> getJustification() {
            return new SortedIntSet(this.justificationIds_);
        }

        public boolean isATautology() {
            return Arrays.binarySearch(this.premiseIds_, this.conclusionId_) >= 0;
        }

        @Override
        public Iterator<DerivedInferenceMember> iterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)new Conclusion(this.conclusionId_)), (Iterator)Iterators.transform(Ints.asList((int[])this.premiseIds_).iterator(), (Function)new Function<Integer, Premise>(){

                public Premise apply(Integer id) {
                    return new Premise(id);
                }
            }), (Iterator)Iterators.transform(Ints.asList((int[])this.justificationIds_).iterator(), (Function)new Function<Integer, Axiom>(){

                public Axiom apply(Integer id) {
                    return new Axiom(id);
                }
            }));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c instanceof DerivedInference) {
                DerivedInference other = (DerivedInference)c;
                return this.conclusionId_ == other.conclusionId_ && SortedIdSet.containsAll(this.premiseIds_, other.premiseIds_) && SortedIdSet.containsAll(this.justificationIds_, other.justificationIds_);
            }
            return super.containsAll(c);
        }

        private boolean contains(DerivedInferenceMember other) {
            return other.accept(new DerivedInferenceMember.Visitor<Boolean>(){

                @Override
                public Boolean visit(Axiom axiom) {
                    return Arrays.binarySearch(DerivedInference.this.justificationIds_, (Integer)axiom.getDelegate()) >= 0;
                }

                @Override
                public Boolean visit(Conclusion conclusion) {
                    return DerivedInference.this.conclusionId_ == (Integer)conclusion.getDelegate();
                }

                @Override
                public Boolean visit(Premise premise) {
                    return Arrays.binarySearch(DerivedInference.this.premiseIds_, (Integer)premise.getDelegate()) >= 0;
                }
            });
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof DerivedInferenceMember) {
                return this.contains((DerivedInferenceMember)o);
            }
            return false;
        }

        @Override
        public int size() {
            return this.getPremises().size() + this.getJustification().size() + 1;
        }

        @Override
        public String toString() {
            return String.valueOf(this.conclusionId_) + " -| " + Arrays.toString(this.premiseIds_) + ": " + Arrays.toString(this.justificationIds_);
        }
    }

    public static enum SelectionType {
        TOP_DOWN,
        BOTTOM_UP,
        THRESHOLD;

    }
}

