/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.liveontologies.puli.pinpointing.IdMap;

public class SortedIdSet<E>
extends AbstractSet<E>
implements Function<Integer, E> {
    private final int[] elementIds_;
    private final IdMap<E> idMap_;

    SortedIdSet(int[] elementIds, IdMap<E> idMap) {
        this.elementIds_ = elementIds;
        this.idMap_ = idMap;
    }

    int[] getElementIds() {
        return this.elementIds_;
    }

    IdMap<E> getIdMap() {
        return this.idMap_;
    }

    @Override
    public boolean contains(Object o) {
        Integer id = this.idMap_.contains(o);
        if (id == null) {
            return false;
        }
        return Arrays.binarySearch(this.elementIds_, id) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof SortedIdSet) {
            SortedIdSet other = (SortedIdSet)c;
            if (this.idMap_.equals(other.idMap_)) {
                return SortedIdSet.containsAll(this.elementIds_, other.elementIds_);
            }
        }
        return super.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(Ints.asList((int[])this.elementIds_).iterator(), (Function)this);
    }

    @Override
    public int size() {
        return this.elementIds_.length;
    }

    public E apply(Integer id) {
        return this.idMap_.getElement(id);
    }

    static int[] getIds(Collection<? extends Integer> set) {
        int[] ids = new int[set.size()];
        int pos = 0;
        Iterator<? extends Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            int e = iterator.next();
            ids[pos++] = e;
        }
        Arrays.sort(ids);
        return ids;
    }

    static <E> int[] getIds(Collection<? extends E> set, IdMap<E> idMap) {
        int[] ids = new int[set.size()];
        int pos = 0;
        for (E e : set) {
            ids[pos++] = idMap.getId(e);
        }
        Arrays.sort(ids);
        return ids;
    }

    static <E> SortedIdSet<E> copyOf(Set<E> set, IdMap<E> idMap) {
        return new SortedIdSet<E>(SortedIdSet.getIds(set, idMap), idMap);
    }

    static boolean containsAll(int[] first, int[] second) {
        if (second.length > first.length) {
            return false;
        }
        int i = 0;
        block0: for (int j = 0; j < second.length; ++j) {
            int y = second[j];
            while (i != first.length) {
                int x = first[i];
                if (x > y) {
                    return false;
                }
                if (x == y) continue block0;
                ++i;
            }
            return false;
        }
        return true;
    }

    static int[] union(int[] first, int[] second) {
        int[] tmp = new int[first.length + second.length];
        int i = 0;
        int j = 0;
        int pos = 0;
        while (true) {
            int copied;
            if (i == first.length) {
                copied = second.length - j;
                System.arraycopy(second, j, tmp, pos, copied);
                pos += copied;
                break;
            }
            if (j == second.length) {
                copied = first.length - i;
                System.arraycopy(first, i, tmp, pos, copied);
                pos += copied;
                break;
            }
            int x = first[i];
            int y = second[j];
            if (x < y) {
                tmp[pos] = x;
                ++i;
            } else {
                tmp[pos] = y;
                ++j;
                if (x == y) {
                    ++i;
                }
            }
            ++pos;
        }
        if (pos == first.length) {
            return first;
        }
        if (pos == second.length) {
            return second;
        }
        if (pos == tmp.length) {
            return tmp;
        }
        return Arrays.copyOf(tmp, pos);
    }
}

