/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.liveontologies.puli.pinpointing.SortedIdSet;

public class SortedIntSet
extends AbstractSet<Integer> {
    private final int[] elements_;

    SortedIntSet(int[] elements) {
        this.elements_ = elements;
    }

    int[] getElements() {
        return this.elements_;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return Arrays.binarySearch(this.elements_, (Integer)o) >= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof SortedIntSet) {
            SortedIntSet other = (SortedIntSet)c;
            return SortedIdSet.containsAll(this.elements_, other.elements_);
        }
        return super.containsAll(c);
    }

    @Override
    public Iterator<Integer> iterator() {
        return Ints.asList((int[])this.elements_).iterator();
    }

    @Override
    public int size() {
        return this.elements_.length;
    }
}

