/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli.pinpointing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.Delegator;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceJustifier;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.collections.BloomTrieCollection2;
import org.liveontologies.puli.collections.Collection2;
import org.liveontologies.puli.pinpointing.AbstractMinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.InterruptMonitor;
import org.liveontologies.puli.pinpointing.MinimalSubsetEnumerator;
import org.liveontologies.puli.pinpointing.MinimalSubsetsFromProofs;
import org.liveontologies.puli.pinpointing.PriorityComparator;
import org.liveontologies.puli.statistics.NestedStats;
import org.liveontologies.puli.statistics.ResetStats;
import org.liveontologies.puli.statistics.Stat;

public class TopDownRepairComputation<C, I extends Inference<? extends C>, A>
extends MinimalSubsetsFromProofs<C, I, A> {
    private static final Factory<?, ?, ?> FACTORY_ = new Factory();
    private int producedJobsCount_ = 0;
    private final Comparator<I> inferenceComparator = new Comparator<I>(){

        @Override
        public int compare(I inf1, I inf2) {
            return inf1.getPremises().size() + TopDownRepairComputation.this.getJustification(inf1).size() - inf2.getPremises().size() - TopDownRepairComputation.this.getJustification(inf2).size();
        }
    };

    public static <C, I extends Inference<? extends C>, A> MinimalSubsetsFromProofs.Factory<C, I, A> getFactory() {
        return FACTORY_;
    }

    private TopDownRepairComputation(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor) {
        super(proof, justifier, monitor);
    }

    @Override
    public MinimalSubsetEnumerator<A> newEnumerator(Object query) {
        return new Enumerator(query);
    }

    @Stat
    public int nProducedJobs() {
        return this.producedJobsCount_;
    }

    @ResetStats
    public void resetStats() {
        this.producedJobsCount_ = 0;
    }

    @NestedStats
    public static Class<?> getNestedStats() {
        return BloomTrieCollection2.class;
    }

    private static class Factory<C, I extends Inference<? extends C>, A>
    implements MinimalSubsetsFromProofs.Factory<C, I, A> {
        private Factory() {
        }

        @Override
        public MinimalSubsetEnumerator.Factory<C, A> create(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, InterruptMonitor monitor) {
            return new TopDownRepairComputation(proof, justifier, monitor);
        }
    }

    private static final class Axiom<C, A>
    extends Delegator<A>
    implements JobMember<C, A> {
        public Axiom(A delegate) {
            super(delegate);
        }
    }

    private static final class Inf<I extends Inference<?>, A>
    extends Delegator<I>
    implements JobMember<I, A> {
        public Inf(I delegate) {
            super(delegate);
        }
    }

    private static interface JobMember<C, A> {
    }

    private static class JobFactory<I extends Inference<?>, A, P> {
        private final Proof<? extends I> proof_;
        private final InferenceJustifier<? super I, ? extends Set<? extends A>> justifier_;
        private final PriorityComparator<? super Set<A>, P> priorityComparator_;

        public JobFactory(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, PriorityComparator<? super Set<A>, P> priorityComparator) {
            this.proof_ = proof;
            this.justifier_ = justifier;
            this.priorityComparator_ = priorityComparator;
        }

        public static <I extends Inference<?>, A, P> JobFactory<I, A, P> create(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, PriorityComparator<? super Set<A>, P> priorityComparator) {
            return new JobFactory<I, A, P>(proof, justifier, priorityComparator);
        }

        public Job newJob(Object conclusion) {
            return this.doBreak(Collections.emptySet(), Collections.emptySet(), Collections.<Object>emptySet(), conclusion);
        }

        public Job doBreak(Set<A> repair, Collection<I> toBreak, Set<Object> broken, Object conclusion) {
            HashSet newRepair = repair.isEmpty() ? new HashSet(1) : new HashSet<A>(repair);
            HashSet<Inference> newToBreak = toBreak.isEmpty() ? new HashSet<Inference>(3) : new HashSet(toBreak.size());
            HashSet<Object> newBroken = broken.isEmpty() ? new HashSet<Object>(1) : new HashSet<Object>(broken);
            newBroken.add(conclusion);
            for (Inference inf : toBreak) {
                if (inf.getPremises().contains(conclusion)) continue;
                newToBreak.add(inf);
            }
            block1: for (Inference inf : this.proof_.getInferences(conclusion)) {
                for (Object premise : inf.getPremises()) {
                    if (!broken.contains(premise)) continue;
                    continue block1;
                }
                for (Object axiom : this.justifier_.getJustification(inf)) {
                    if (!repair.contains(axiom)) continue;
                    continue block1;
                }
                newToBreak.add(inf);
            }
            return new Job(newRepair, newToBreak, newBroken, this.priorityComparator_.getPriority(newRepair));
        }

        public Job repair(Set<A> repair, Collection<I> toBreak, Set<Object> broken, A axiom) {
            HashSet<A> newRepair = new HashSet<A>(repair);
            HashSet<Inference> newToBreak = new HashSet<Inference>(toBreak.size());
            HashSet<Object> newBroken = new HashSet<Object>(broken);
            newRepair.add(axiom);
            for (Inference inf : toBreak) {
                if (this.justifier_.getJustification(inf).contains(axiom)) continue;
                newToBreak.add(inf);
            }
            return new Job(newRepair, newToBreak, newBroken, this.priorityComparator_.getPriority(newRepair));
        }

        public class Job
        extends AbstractSet<JobMember<I, A>>
        implements Comparable<Job> {
            private final Set<A> repair_;
            private final Set<I> toBreak_;
            private final Set<Object> broken_;
            private final P priority_;

            private Job(Set<A> repair, Set<I> toBreak, Set<Object> broken, P priority) {
                this.repair_ = repair;
                this.toBreak_ = toBreak;
                this.broken_ = broken;
                this.priority_ = priority;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                if (c instanceof Job) {
                    Job other = (Job)c;
                    return this.repair_.containsAll(other.repair_) && this.toBreak_.containsAll(other.toBreak_);
                }
                return super.containsAll(c);
            }

            @Override
            public String toString() {
                return this.repair_.toString() + "; " + this.broken_.toString() + "; " + this.toBreak_.toString();
            }

            @Override
            public Iterator<JobMember<I, A>> iterator() {
                return Iterators.concat((Iterator)Iterators.transform(this.repair_.iterator(), (Function)new Function<A, Axiom<I, A>>(){

                    public Axiom<I, A> apply(A axiom) {
                        return new Axiom(axiom);
                    }
                }), (Iterator)Iterators.transform(this.toBreak_.iterator(), (Function)new Function<I, Inf<I, A>>(){

                    public Inf<I, A> apply(I inf) {
                        return new Inf(inf);
                    }
                }));
            }

            @Override
            public int size() {
                return this.repair_.size() + this.toBreak_.size();
            }

            @Override
            public int compareTo(Job other) {
                int result = JobFactory.this.priorityComparator_.compare(this.priority_, other.priority_);
                if (result != 0) {
                    return result;
                }
                return this.toBreak_.size() - other.toBreak_.size();
            }
        }
    }

    private class Enumerator
    extends AbstractMinimalSubsetEnumerator<A> {
        private final Object query_;
        private Queue<JobFactory.Job> toDoJobs_;
        private final Collection2<Set<A>> minimalRepairs_ = new BloomTrieCollection2();
        private final Collection2<JobFactory.Job> minimalJobs_ = new BloomTrieCollection2<JobFactory.Job>();
        private MinimalSubsetEnumerator.Listener<A> listener_ = null;
        private JobFactory<I, A, ?> jobFactory_ = null;

        Enumerator(Object query) {
            this.query_ = query;
        }

        @Override
        public void enumerate(MinimalSubsetEnumerator.Listener<A> listener, PriorityComparator<? super Set<A>, ?> priorityComparator) {
            Preconditions.checkNotNull(listener);
            if (priorityComparator == null) {
                this.enumerate(listener);
                return;
            }
            this.listener_ = listener;
            this.jobFactory_ = JobFactory.create(TopDownRepairComputation.this.getProof(), TopDownRepairComputation.this.getInferenceJustifier(), priorityComparator);
            this.toDoJobs_ = new PriorityQueue<JobFactory.Job>();
            this.minimalRepairs_.clear();
            this.initialize(this.query_);
            this.process();
            this.listener_ = null;
        }

        private void initialize(Object goal) {
            this.produce(this.jobFactory_.newJob(goal));
        }

        private void process() {
            JobFactory.Job job;
            while (!TopDownRepairComputation.this.isInterrupted() && (job = this.toDoJobs_.poll()) != null) {
                if (!this.minimalRepairs_.isMinimal(job.repair_) || !this.minimalJobs_.isMinimal(job)) continue;
                this.minimalJobs_.add(job);
                Object nextToBreak = this.chooseToBreak(job.toBreak_);
                if (nextToBreak == null) {
                    this.minimalRepairs_.add(job.repair_);
                    if (this.listener_ == null) continue;
                    this.listener_.newMinimalSubset(job.repair_);
                    continue;
                }
                for (Object premise : nextToBreak.getPremises()) {
                    this.produce(this.jobFactory_.doBreak(job.repair_, job.toBreak_, job.broken_, premise));
                }
                for (Object axiom : TopDownRepairComputation.this.getJustification(nextToBreak)) {
                    this.produce(this.jobFactory_.repair(job.repair_, job.toBreak_, job.broken_, axiom));
                }
            }
        }

        private I chooseToBreak(Collection<I> inferences) {
            Inference result = null;
            for (Inference inf : inferences) {
                if (result != null && TopDownRepairComputation.this.inferenceComparator.compare(inf, result) >= 0) continue;
                result = inf;
            }
            return result;
        }

        private void produce(JobFactory.Job job) {
            TopDownRepairComputation.this.producedJobsCount_++;
            this.toDoJobs_.add(job);
        }
    }
}

