/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import org.cactoos.Scalar;
import org.cactoos.scalar.UncheckedScalar;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class Assertion<T> {
    private final String reason;
    private final Scalar<T> test;
    private final Matcher<T> matcher;

    public Assertion(String reason, Scalar<T> test, Matcher<T> matcher) {
        this.reason = reason;
        this.test = test;
        this.matcher = matcher;
    }

    public void affirm() throws AssertionError {
        block3: {
            try {
                if (!this.matcher.matches(this.test.value())) {
                    throw new AssertionError((Object)this.description().toString());
                }
            }
            catch (Exception ex) {
                if (this.matcher.matches(this.test)) break block3;
                throw new AssertionError("Unexpected error during test", ex);
            }
        }
    }

    private Description description() {
        StringDescription description = new StringDescription();
        description.appendText(this.reason).appendText(String.format("%nExpected: ", new Object[0])).appendDescriptionOf(this.matcher).appendText(String.format("%n but was: ", new Object[0]));
        this.matcher.describeMismatch(new UncheckedScalar(this.test).value(), (Description)description);
        return description;
    }
}

