/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.scalar.And;
import org.cactoos.scalar.Unchecked;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class RunsInThreads<T>
extends TypeSafeMatcher<Func<T, Boolean>> {
    private final T input;
    private final int total;

    public RunsInThreads() {
        this(null);
    }

    public RunsInThreads(T object) {
        this(object, Runtime.getRuntime().availableProcessors() << 4);
    }

    public RunsInThreads(T object, int threads) {
        this.input = object;
        this.total = threads;
    }

    public boolean matchesSafely(Func<T, Boolean> func) {
        ExecutorService service = Executors.newFixedThreadPool(this.total);
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(this.total);
        Callable<Boolean> task = () -> {
            latch.await();
            return (Boolean)func.apply(this.input);
        };
        for (int thread = 0; thread < this.total; ++thread) {
            futures.add(service.submit(task));
        }
        latch.countDown();
        boolean matches = (Boolean)new Unchecked((Scalar)new And(Future::get, futures)).value();
        service.shutdown();
        return matches;
    }

    public void describeTo(Description description) {
        description.appendText("failed");
    }
}

