/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import org.cactoos.Text;
import org.cactoos.text.FormattedText;
import org.cactoos.text.Joined;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.llorllale.cactoos.matchers.Assertion;

public final class Mismatches<X, M extends Matcher<X>>
extends TypeSafeDiagnosingMatcher<M> {
    private final X args;
    private final Text message;

    public Mismatches(X args, String expected, String actual) {
        this(args, (Text)new TextOf(expected), (Text)new TextOf(actual));
    }

    public Mismatches(X args, Text expected, Text actual) {
        this(args, (Text)new Joined((Text)new FormattedText("%n", new Object[0]), new Text[]{new TextOf(""), new Joined((Text)new TextOf(""), new Text[]{new TextOf("Expected: "), expected}), new Joined((Text)new TextOf(""), new Text[]{new TextOf(" but was: "), actual})}));
    }

    public Mismatches(X args, Text message) {
        this.args = args;
        this.message = message;
    }

    public void describeTo(Description desc) {
        desc.appendText("Mismatches ").appendValue(this.args).appendText(" with message ").appendValue((Object)this.message);
    }

    protected boolean matchesSafely(M matcher, Description dsc) {
        boolean mismatch;
        try {
            new Assertion<X>("", this.args, matcher).affirm();
            mismatch = false;
        }
        catch (AssertionError err) {
            mismatch = ((Throwable)((Object)err)).getMessage().equals(new UncheckedText(this.message).asString());
        }
        return mismatch;
    }
}

