/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.IsEqual;
import org.llorllale.cactoos.matchers.MatcherEnvelope;
import org.llorllale.cactoos.matchers.MatcherOf;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.And;

public final class IsEntry<K, V>
extends MatcherEnvelope<Map.Entry<K, V>> {
    public IsEntry(K key, V value) {
        this((Matcher<K>)new IsEqual(key), (Matcher<V>)new IsEqual(value));
    }

    public IsEntry(Matcher<K> key, Matcher<V> value) {
        super(new MatcherOf<Map.Entry>(entry -> new And(() -> key.matches(entry.getKey()), () -> value.matches(entry.getValue())).value(), desc -> {
            IsEntry.descriptionOfKey(desc).appendDescriptionOf((SelfDescribing)key);
            IsEntry.descriptionOfValue(desc).appendDescriptionOf((SelfDescribing)value);
        }, (entry, desc) -> {
            IsEntry.descriptionOfKey(desc);
            key.describeMismatch(entry.getKey(), desc);
            IsEntry.descriptionOfValue(desc);
            value.describeMismatch(entry.getValue(), desc);
        }));
    }

    private static Description descriptionOfValue(Description desc) {
        return desc.appendText(", value ");
    }

    private static Description descriptionOfKey(Description desc) {
        return desc.appendText("key ");
    }
}

