/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.text;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.llorllale.cactoos.shaded.org.cactoos.bytes.BytesOf;
import org.llorllale.cactoos.shaded.org.cactoos.io.InputOf;
import org.llorllale.cactoos.shaded.org.cactoos.iterable.Mapped;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.And;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Or;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Unchecked;
import org.llorllale.cactoos.shaded.org.cactoos.text.Joined;
import org.llorllale.cactoos.shaded.org.cactoos.text.UncheckedText;
import org.llorllale.cactoos.shaded.org.cactoos.time.Iso;

public final class TextOf
implements Text {
    private final Scalar<String> origin;

    public TextOf(Input input) {
        this(new BytesOf(input));
    }

    public TextOf(URL url) {
        this(new InputOf(url));
    }

    public TextOf(URI uri) {
        this(new InputOf(uri));
    }

    public TextOf(Path path) {
        this(new InputOf(path));
    }

    public TextOf(File file) {
        this(new InputOf(file));
    }

    public TextOf(Input input, int max) {
        this(input, max, StandardCharsets.UTF_8);
    }

    public TextOf(Input input, Charset cset) {
        this((Bytes)new BytesOf(input), cset);
    }

    public TextOf(Input input, String cset) {
        this((Bytes)new BytesOf(input), cset);
    }

    public TextOf(Input input, int max, Charset cset) {
        this((Bytes)new BytesOf(input, max), cset);
    }

    public TextOf(Reader rdr) {
        this(new BytesOf(rdr));
    }

    public TextOf(Reader rdr, Charset cset) {
        this(new BytesOf(rdr, cset));
    }

    public TextOf(Reader rdr, int max, Charset cset) {
        this(new BytesOf(rdr, cset, max));
    }

    public TextOf(CharSequence builder) {
        this(new BytesOf(builder));
    }

    public TextOf(CharSequence builder, Charset cset) {
        this((Bytes)new BytesOf(builder, cset), cset);
    }

    public TextOf(char ... chars) {
        this(new BytesOf(chars));
    }

    public TextOf(char[] chars, Charset cset) {
        this(new BytesOf(chars, cset));
    }

    public TextOf(Throwable error) {
        this(new BytesOf(error));
    }

    public TextOf(Throwable error, Charset charset) {
        this(new BytesOf(error, charset));
    }

    public TextOf(Throwable error, CharSequence charset) {
        this(new BytesOf(error, charset));
    }

    public TextOf(StackTraceElement ... strace) {
        this(new BytesOf(strace));
    }

    public TextOf(StackTraceElement[] strace, Charset charset) {
        this(new BytesOf(strace, charset));
    }

    public TextOf(StackTraceElement[] strace, CharSequence charset) {
        this(new BytesOf(strace, charset));
    }

    public TextOf(byte ... bytes) {
        this(new BytesOf(bytes));
    }

    public TextOf(Bytes bytes) {
        this(bytes, StandardCharsets.UTF_8);
    }

    public TextOf(Bytes bytes, Charset cset) {
        this(() -> new String(bytes.asBytes(), cset));
    }

    public TextOf(Bytes bytes, String cset) {
        this(() -> new String(bytes.asBytes(), cset));
    }

    public TextOf(String input) {
        this(input, StandardCharsets.UTF_8);
    }

    public TextOf(String input, Charset cset) {
        this(() -> new String(input.getBytes(cset), cset));
    }

    public TextOf(Iterable<?> iterable) {
        this(() -> new Joined(", ", new Mapped<String>(Object::toString, iterable)).asString());
    }

    public TextOf(Iterator<Character> iterator) {
        this(() -> {
            StringBuilder buf = new StringBuilder();
            iterator.forEachRemaining(buf::append);
            return buf.toString();
        });
    }

    public TextOf(InputStream input) {
        this(new InputOf(new InputStreamReader(input, StandardCharsets.UTF_8)));
    }

    public TextOf(LocalDate date) {
        this(date, new Iso().value());
    }

    public TextOf(LocalDate date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOf(LocalDate date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public TextOf(LocalDate date, DateTimeFormatter formatter) {
        this(() -> formatter.format(ZonedDateTime.of(date, LocalTime.MIN, ZoneId.systemDefault())));
    }

    public TextOf(LocalDateTime date, DateTimeFormatter formatter) {
        this(() -> formatter.format(date.atZone(ZoneId.systemDefault())));
    }

    public TextOf(LocalDateTime date) {
        this(date, new Iso().value());
    }

    public TextOf(LocalDateTime date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOf(LocalDateTime date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public TextOf(Date date) {
        this(date, new Iso().value());
    }

    public TextOf(Date date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOf(Date date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public TextOf(Date date, DateTimeFormatter formatter) {
        this(() -> formatter.format(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())));
    }

    public TextOf(OffsetDateTime date) {
        this(date, new Iso().value());
    }

    public TextOf(OffsetDateTime date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOf(OffsetDateTime date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public TextOf(OffsetDateTime date, DateTimeFormatter formatter) {
        this(() -> formatter.format(date));
    }

    public TextOf(ZonedDateTime date) {
        this(date, new Iso().value());
    }

    public TextOf(ZonedDateTime date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOf(ZonedDateTime date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public TextOf(ZonedDateTime date, DateTimeFormatter formatter) {
        this(() -> formatter.format(date));
    }

    public TextOf(Scalar<String> scalar) {
        this.origin = scalar;
    }

    @Override
    public String asString() throws Exception {
        return this.origin.value();
    }

    public String toString() {
        return new UncheckedText(this).asString();
    }

    public int hashCode() {
        return new Unchecked<String>(this.origin).value().hashCode();
    }

    @SuppressFBWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object obj) {
        return new Unchecked<Boolean>(new Or(() -> this == obj, new And(() -> obj instanceof Text, () -> new UncheckedText(this).asString().equals(new UncheckedText((Text)obj).asString())))).value();
    }
}

