/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import java.util.concurrent.TimeoutException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.llorllale.cactoos.shaded.org.cactoos.func.Timed;

public final class MatchesBefore<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final String TIME_UNIT = "milliseconds";
    private final long millisec;
    private final Matcher<? super T> matcher;

    public MatchesBefore(long mllsc, Matcher<? super T> mtchr) {
        this.millisec = mllsc;
        this.matcher = mtchr;
    }

    public void describeTo(Description desc) {
        desc.appendDescriptionOf(this.matcher).appendText(" runs in less than ").appendValue((Object)this.millisec).appendText(" ").appendText(TIME_UNIT);
    }

    protected boolean matchesSafely(T item, Description desc) {
        boolean matches = false;
        try {
            matches = new Timed<Object, Boolean>(arg_0 -> this.matcher.matches(arg_0), this.millisec).apply(item);
            if (!matches) {
                this.matcher.describeMismatch(item, desc);
            }
        }
        catch (TimeoutException texc) {
            desc.appendText("Timeout after ").appendValue((Object)this.millisec).appendText(" ").appendText(TIME_UNIT);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return matches;
    }
}

