/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.func;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cactoos.Func;
import org.llorllale.cactoos.shaded.org.cactoos.func.Async;

public final class Timed<X, Y>
implements Func<X, Y> {
    private final Func<X, Future<Y>> func;
    private final long time;

    public Timed(Func<X, Y> function, long milliseconds) {
        this(milliseconds, new Async<X, Y>(function));
    }

    public Timed(long milliseconds, Func<X, Future<Y>> async) {
        this.func = async;
        this.time = milliseconds;
    }

    @Override
    public Y apply(X input) throws Exception {
        Future<Y> future = this.func.apply(input);
        try {
            return future.get(this.time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exp) {
            future.cancel(true);
            throw exp;
        }
    }
}

