/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class TeeInputStream
extends InputStream {
    private final InputStream input;
    private final OutputStream output;

    public TeeInputStream(InputStream src, OutputStream tgt) {
        this.input = src;
        this.output = tgt;
    }

    @Override
    public int read() throws IOException {
        int data = this.input.read();
        if (data >= 0) {
            this.output.write(data);
        }
        return data;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        int max = this.input.read(buf, offset, len);
        if (max > 0) {
            this.output.write(buf, offset, max);
        }
        return max;
    }

    @Override
    public long skip(long num) throws IOException {
        return this.input.skip(num);
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.output.close();
    }

    @Override
    public void mark(int limit) {
        this.input.mark(limit);
    }

    @Override
    public void reset() throws IOException {
        this.input.reset();
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }
}

