/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.llorllale.cactoos.shaded.org.cactoos.func.UncheckedFunc;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Unchecked;

public final class Filtered<X>
implements Iterator<X> {
    private final Iterator<? extends X> iterator;
    private final Func<? super X, Scalar<Boolean>> func;
    private final Queue<X> buffer;

    public Filtered(Func<? super X, Boolean> fnc, Iterator<? extends X> src) {
        this(src, (? super X input) -> () -> (Boolean)fnc.apply(input));
    }

    public Filtered(Iterator<? extends X> src, Func<? super X, Scalar<Boolean>> fnc) {
        this.iterator = src;
        this.func = fnc;
        this.buffer = new LinkedList<X>();
    }

    @Override
    public boolean hasNext() {
        UncheckedFunc<X, Scalar<Boolean>> fnc = new UncheckedFunc<X, Scalar<Boolean>>(this.func);
        if (this.buffer.isEmpty()) {
            while (this.iterator.hasNext()) {
                X object = this.iterator.next();
                if (!new Unchecked<Boolean>(fnc.apply(object)).value().booleanValue()) continue;
                this.buffer.add(object);
                break;
            }
        }
        return !this.buffer.isEmpty();
    }

    @Override
    public X next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements that fit the condition");
        }
        return this.buffer.poll();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("#remove() is not supported");
    }
}

