/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.scalar;

import org.cactoos.Scalar;

public final class InheritanceLevel
implements Scalar<Integer> {
    private final Class<?> base;
    private final Class<?> derived;

    public InheritanceLevel(Class<?> cderived, Class<?> cbase) {
        this.derived = cderived;
        this.base = cbase;
    }

    @Override
    public Integer value() {
        int level = this.base.equals(this.derived) ? 0 : this.calculateLevel();
        return level;
    }

    private int calculateLevel() {
        int level = Integer.MIN_VALUE;
        Class<?> sclass = this.derived.getSuperclass();
        int idx = 0;
        while (!sclass.equals(Object.class)) {
            ++idx;
            if (sclass.equals(this.base)) {
                level = idx;
                break;
            }
            sclass = sclass.getSuperclass();
        }
        return level;
    }
}

