/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.controls;

import javafx.scene.control.ListView;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.loadui.testfx.GuiTest;
import org.loadui.testfx.exceptions.NoNodesFoundException;

public class ListViews {
    public static int numberOfRowsIn(ListView<?> list) {
        return list.getItems().size();
    }

    public static int numberOfRowsIn(String listQuery) {
        ListView table = (ListView)GuiTest.find(listQuery);
        return table.getItems().size();
    }

    @Factory
    public static <S> Matcher<S> containsRow(Object rowValue) {
        return new ListContainsMatcher(rowValue);
    }

    static boolean containsRow(ListView<?> list, Object rowValue) {
        for (int i = 0; i < list.getItems().size(); ++i) {
            Object rowData = list.getItems().get(i);
            if (!rowValue.equals(rowData) && !rowValue.equals(rowData.toString())) continue;
            return true;
        }
        return false;
    }

    static ListView<?> getListView(String listSelector) {
        Object node = GuiTest.find(listSelector);
        if (!(node instanceof ListView)) {
            throw new NoNodesFoundException(listSelector + " selected " + node + " which is not a ListView!");
        }
        return (ListView)node;
    }

    private static class ListContainsMatcher
    extends BaseMatcher {
        private Object valueToMatch;

        public ListContainsMatcher(Object valueToMatch) {
            this.valueToMatch = valueToMatch;
        }

        public boolean matches(Object o) {
            if (o instanceof String) {
                String query = (String)o;
                return ListViews.containsRow(ListViews.getListView(query), this.valueToMatch);
            }
            if (o instanceof ListView) {
                ListView tableView = (ListView)o;
                return ListViews.containsRow(tableView, this.valueToMatch);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("The list does not contain a row with value '" + this.valueToMatch + "'");
        }
    }
}

