package org.loadui.testfx.utils;

import com.google.common.base.Predicate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class Matchers {

    public static Matcher<Object> fromPredicate(final Predicate predicate)
    {
        return new TypeSafeMatcher<Object>() {
            @Override
            protected boolean matchesSafely(Object item) {
                try
                {
                    return predicate.apply(item);
                }
                catch (ClassCastException e)
                {
                    return false;
                }
            }

            @Override
            public void describeTo(Description description) {
            }
        };
    }
}
