/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.index;

import com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.hadoop.mapreduce.AccumuloOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.data.AccumuloWritableFeature$;
import org.locationtech.geomesa.accumulo.data.writer.ColumnFamilyMapper$;
import org.locationtech.geomesa.accumulo.index.JoinIndex$;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.GeoMesaArgs;
import org.locationtech.geomesa.accumulo.jobs.InputDataStoreArgs;
import org.locationtech.geomesa.accumulo.jobs.InputFeatureArgs;
import org.locationtech.geomesa.accumulo.jobs.index.AttributeIndexJob$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.locationtech.geomesa.utils.stats.IndexCoverage$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rer!\u0002\u001e<\u0011\u0003Ae!\u0002&<\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006b\u0002+\u0002\u0005\u0004%)!\u0016\u0005\u00073\u0006\u0001\u000bQ\u0002,\t\u000fi\u000b!\u0019!C\u00037\"1q,\u0001Q\u0001\u000eqCq\u0001Y\u0001C\u0002\u0013%\u0011\r\u0003\u0004k\u0003\u0001\u0006IA\u0019\u0005\bW\u0006\u0011\r\u0011\"\u0003b\u0011\u0019a\u0017\u0001)A\u0005E\")Q.\u0001C\u0001]\"9\u00111A\u0001\u0005\n\u0005\u0015\u0001bBA\u001a\u0003\u0011%\u0011Q\u0007\u0005\b\u0003s\tA\u0011BA\u001e\u0011\u001d\t\u0019%\u0001C\u0005\u0003\u000b2a!!\u0013\u0002\u0001\u0005-\u0003BC:\u0011\u0005\u0003\u0005\u000b\u0011\u0002;\u0002b!1!\u000b\u0005C\u0001\u0003GB\u0011\"a\b\u0011\u0001\u0004%\t!a\u001b\t\u0013\u0005e\u0004\u00031A\u0005\u0002\u0005m\u0004\u0002CAA!\u0001\u0006K!!\u001c\t\u0017\u0005%\u0006\u00031AA\u0002\u0013\u0005\u00111\u0016\u0005\f\u0003[\u0003\u0002\u0019!a\u0001\n\u0003\ty\u000b\u0003\u0006\u00024B\u0001\r\u0011!Q!\n]Dq!!0\u0011\t\u0003\nyL\u0002\u0004\u0002B\u0006\u0001\u00111\u0019\u0005\u0007%j!\tAa\u0002\u0006\r\t-!\u0004\u0001B\u0007\u0011-\u0011\tB\u0007a\u0001\u0002\u0004%IAa\u0005\t\u0017\tm!\u00041AA\u0002\u0013%!Q\u0004\u0005\f\u0005CQ\u0002\u0019!A!B\u0013\u0011)\u0002C\u0006\u0003$i\u0001\r\u00111A\u0005\n\t\u0015\u0002b\u0003B+5\u0001\u0007\t\u0019!C\u0005\u0005/B1Ba\u0017\u001b\u0001\u0004\u0005\t\u0015)\u0003\u0003(!Y!Q\f\u000eA\u0002\u0003\u0007I\u0011\u0002B0\u0011-\u0011yI\u0007a\u0001\u0002\u0004%IA!%\t\u0017\te$\u00041A\u0001B\u0003&!\u0011\r\u0005\f\u0005CS\u0002\u0019!a\u0001\n\u0013\u0011\u0019\u000bC\u0006\u0003:j\u0001\r\u00111A\u0005\n\tm\u0006b\u0003B`5\u0001\u0007\t\u0011)Q\u0005\u0005KC1B!1\u001b\u0001\u0004\u0005\r\u0011\"\u0003\u0003D\"Y!\u0011\u001b\u000eA\u0002\u0003\u0007I\u0011\u0002Bj\u0011-\u00119N\u0007a\u0001\u0002\u0003\u0006KA!2\t\u0017\te'\u00041AA\u0002\u0013%!1\u001c\u0005\f\u0005CT\u0002\u0019!a\u0001\n\u0013\u0011\u0019\u000fC\u0006\u0003hj\u0001\r\u0011!Q!\n\tu\u0007b\u0002Bu5\u0011E#1\u001e\u0005\b\u0005kTB\u0011\u000bB|\u0011\u001d\u0011YP\u0007C!\u0005{4QAS\u001e\u0001\u0007\u0013AaA\u0015\u001a\u0005\u0002\rm\u0001\"CA\u0005e\u0001\u0007I\u0011BB\u0010\u0011%\u0019\tC\ra\u0001\n\u0013\u0019\u0019\u0003\u0003\u0005\u0004(I\u0002\u000b\u0015BA\u0006\u0011\u001d\u0019IC\rC!\u0007WAqaa\f3\t\u0003\u001a\t\u0004C\u0004\u00044I\"\te!\u000e\u0002#\u0005#HO]5ckR,\u0017J\u001c3fq*{'M\u0003\u0002={\u0005)\u0011N\u001c3fq*\u0011ahP\u0001\u0005U>\u00147O\u0003\u0002A\u0003\u0006A\u0011mY2v[VdwN\u0003\u0002C\u0007\u00069q-Z8nKN\f'B\u0001#F\u00031awnY1uS>tG/Z2i\u0015\u00051\u0015aA8sO\u000e\u0001\u0001CA%\u0002\u001b\u0005Y$!E!uiJL'-\u001e;f\u0013:$W\r\u001f&pEN\u0011\u0011\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0015aD%oI\u0016D\u0018\t\u001e;sS\n,H/Z:\u0016\u0003Y{\u0011aV\u0011\u00021\u0006QR&L4f_6,7/\u0019\u0018j]\u0012,\u0007PL1uiJL'-\u001e;fg\u0006\u0001\u0012J\u001c3fq\u0006#HO]5ckR,7\u000fI\u0001\u000e\u0013:$W\r_\"pm\u0016\u0014\u0018mZ3\u0016\u0003q{\u0011!X\u0011\u0002=\u0006AR&L4f_6,7/\u0019\u0018j]\u0012,\u0007PL2pm\u0016\u0014\u0018mZ3\u0002\u001d%sG-\u001a=D_Z,'/Y4fA\u0005i\u0011\t\u001e;sS\n,H/Z:LKf,\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fA\u0001\\1oO*\tq-\u0001\u0003kCZ\f\u0017BA5e\u0005\u0019\u0019FO]5oO\u0006q\u0011\t\u001e;sS\n,H/Z:LKf\u0004\u0013a\u0003+za\u0016t\u0015-\\3LKf\fA\u0002V=qK:\u000bW.Z&fs\u0002\nA!\\1j]R\u0011qN\u001d\t\u0003\u001bBL!!\u001d(\u0003\tUs\u0017\u000e\u001e\u0005\u0006g.\u0001\r\u0001^\u0001\u0005CJ<7\u000fE\u0002Nk^L!A\u001e(\u0003\u000b\u0005\u0013(/Y=\u0011\u0005a|hBA=~!\tQh*D\u0001|\u0015\tax)\u0001\u0004=e>|GOP\u0005\u0003}:\u000ba\u0001\u0015:fI\u00164\u0017bA5\u0002\u0002)\u0011aPT\u0001\u000eg\u0016$\u0018\t\u001e;sS\n,H/Z:\u0015\u000b=\f9!!\b\t\u000f\u0005%A\u00021\u0001\u0002\f\u0005!1m\u001c8g!\u0011\ti!!\u0007\u000e\u0005\u0005=!\u0002BA\u0005\u0003#QA!a\u0005\u0002\u0016\u00051\u0001.\u00193p_BT1!a\u0006F\u0003\u0019\t\u0007/Y2iK&!\u00111DA\b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011q\u0004\u0007A\u0002\u0005\u0005\u0012AC1uiJL'-\u001e;fgB)\u00111EA\u0017o:!\u0011QEA\u0015\u001d\rQ\u0018qE\u0005\u0002\u001f&\u0019\u00111\u0006(\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0003Wq\u0015!D4fi\u0006#HO]5ckR,7\u000f\u0006\u0003\u0002\"\u0005]\u0002bBA\u0005\u001b\u0001\u0007\u00111B\u0001\fg\u0016$H+\u001f9f\u001d\u0006lW\rF\u0003p\u0003{\ty\u0004C\u0004\u0002\n9\u0001\r!a\u0003\t\r\u0005\u0005c\u00021\u0001x\u0003!!\u0018\u0010]3OC6,\u0017aC4fiRK\b/\u001a(b[\u0016$2a^A$\u0011\u001d\tIa\u0004a\u0001\u0003\u0017\u0011!#\u0011;ue&\u0014W\u000f^3J]\u0012,\u00070\u0011:hgN9\u0001#!\u0014\u0002V\u0005m\u0003\u0003BA(\u0003#j\u0011!P\u0005\u0004\u0003'j$aC$f_6+7/Y!sON\u0004B!a\u0014\u0002X%\u0019\u0011\u0011L\u001f\u0003!%s\u0007/\u001e;GK\u0006$XO]3Be\u001e\u001c\b\u0003BA(\u0003;J1!a\u0018>\u0005IIe\u000e];u\t\u0006$\u0018m\u0015;pe\u0016\f%oZ:\n\u0007M\f\t\u0006\u0006\u0003\u0002f\u0005%\u0004cAA4!5\t\u0011\u0001C\u0003t%\u0001\u0007A/\u0006\u0002\u0002nA)\u0011qNA;o6\u0011\u0011\u0011\u000f\u0006\u0004\u0003g2\u0017\u0001B;uS2LA!a\u001e\u0002r\t!A*[:u\u00039\tG\u000f\u001e:jEV$Xm]0%KF$2a\\A?\u0011%\ty\bFA\u0001\u0002\u0004\ti'A\u0002yIE\n1\"\u0019;ue&\u0014W\u000f^3tA!\u001aR#!\"\u0002\u001a\u0006m\u0015QTAP\u0003G\u000b)+a*\u0002&B!\u0011qQAK\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015A\u00036d_6l\u0017M\u001c3fe*!\u0011qRAI\u0003\u0015\u0011W-^:u\u0015\t\t\u0019*A\u0002d_6LA!a&\u0002\n\nI\u0001+\u0019:b[\u0016$XM]\u0001\u0006]\u0006lWm\u001d\u0017\u0002/\u0006YA-Z:de&\u0004H/[8oC\t\t\t+A\nBiR\u0014\u0018NY;uKN\u0004Co\u001c\u0011j]\u0012,\u00070A\u0007wCJL\u0017M\u00197f\u0003JLG/_\r\u0002\u0003\u0005A!/Z9vSJ,G-\u0001\u0005d_Z,'/Y4f+\u00059\u0018\u0001D2pm\u0016\u0014\u0018mZ3`I\u0015\fHcA8\u00022\"A\u0011qP\f\u0002\u0002\u0003\u0007q/A\u0005d_Z,'/Y4fA!Z\u0001$!\"\u0002\u001a\u0006]\u0016QTA]Y\u0005i\u0016EAA^\u0003q!\u0016\u0010]3!_\u001a\u0004\u0013N\u001c3fq\u0002B#n\\5oA=\u0014\bEZ;mY&\nq!\u001e8qCJ\u001cX\rF\u0001u\u0005=\tE\u000f\u001e:jEV$X-T1qa\u0016\u00148c\u0001\u000e\u0002FBa\u0011qYAg\u0003#\fi.!5\u0002v6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\f\t\"A\u0005nCB\u0014X\rZ;dK&!\u0011qZAe\u0005\u0019i\u0015\r\u001d9feB!\u00111[Am\u001b\t\t)N\u0003\u0003\u0002X\u0006E\u0011AA5p\u0013\u0011\tY.!6\u0003\tQ+\u0007\u0010\u001e\t\u0005\u0003?\f\t0\u0004\u0002\u0002b*!\u00111]As\u0003\u0019\u0019\u0018.\u001c9mK*!\u0011q]Au\u0003\u001d1W-\u0019;ve\u0016TA!a;\u0002n\u0006\u0019\u0011\r]5\u000b\u0007\u0005=X)\u0001\u0005hK>$xn\u001c7t\u0013\u0011\t\u00190!9\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f!\u0011\t9Pa\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\fA\u0001Z1uC*!\u0011q B\u0001\u0003\u0011\u0019wN]3\u000b\u0007\u0001\u000b)\"\u0003\u0003\u0003\u0006\u0005e(\u0001C'vi\u0006$\u0018n\u001c8\u0015\u0005\t%\u0001cAA45\t91i\u001c8uKb$\b\u0003BAc\u0005\u001fIAAa\u0003\u0002N\u000691m\\;oi\u0016\u0014XC\u0001B\u000b!\u0011\t9Ma\u0006\n\t\te\u0011\u0011\u001a\u0002\b\u0007>,h\u000e^3s\u0003-\u0019w.\u001e8uKJ|F%Z9\u0015\u0007=\u0014y\u0002C\u0005\u0002\u0000y\t\t\u00111\u0001\u0003\u0016\u0005A1m\\;oi\u0016\u0014\b%A\u0004xe\u0006\u0004\b/\u001a:\u0016\u0005\t\u001d\u0002C\u0002B\u0015\u0005\u000f\u0012iE\u0004\u0003\u0003,\t\u0005c\u0002\u0002B\u0017\u0005{qAAa\f\u0003<9!!\u0011\u0007B\u001d\u001d\u0011\u0011\u0019Da\u000e\u000f\u0007i\u0014)$C\u0001G\u0013\t!U)\u0003\u0002C\u0007&\u0011A(Q\u0005\u0005\u0003W\u0014yD\u0003\u0002=\u0003&!!1\tB#\u0003=9&/\u001b;bE2,g)Z1ukJ,'\u0002BAv\u0005\u007fIAA!\u0013\u0003L\tqa)Z1ukJ,wK]1qa\u0016\u0014(\u0002\u0002B\"\u0005\u000b\u0002BAa\u0014\u0003R5\u0011!QI\u0005\u0005\u0005'\u0012)EA\bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0003-9(/\u00199qKJ|F%Z9\u0015\u0007=\u0014I\u0006C\u0005\u0002\u0000\u0005\n\t\u00111\u0001\u0003(\u0005AqO]1qa\u0016\u0014\b%\u0001\u0006d_:4XM\u001d;feN,\"A!\u0019\u0011\r\u0005\r\u0012Q\u0006B2!\u001di%Q\rB5\u0005\u0013K1Aa\u001aO\u0005\u0019!V\u000f\u001d7feA\"!1\u000eB;!\u0019\u0011yE!\u001c\u0003r%!!q\u000eB#\u000599&/\u001b;f\u0007>tg/\u001a:uKJ\u0004BAa\u001d\u0003v1\u0001Aa\u0003B<K\u0005\u0005\t\u0011!B\u0001\u0005w\u00121a\u0018\u00132\u0003-\u0019wN\u001c<feR,'o\u001d\u0011\u0012\t\tu$1\u0011\t\u0004\u001b\n}\u0014b\u0001BA\u001d\n9aj\u001c;iS:<\u0007cA'\u0003\u0006&\u0019!q\u0011(\u0003\u0007\u0005s\u0017\u0010E\u0002N\u0005\u0017K1A!$O\u0005\rIe\u000e^\u0001\u000fG>tg/\u001a:uKJ\u001cx\fJ3r)\ry'1\u0013\u0005\n\u0003\u007f\"\u0013\u0011!a\u0001\u0005+\u0003b!a\t\u0002.\t]\u0005cB'\u0003f\te%\u0011\u0012\u0019\u0005\u00057\u0013y\n\u0005\u0004\u0003P\t5$Q\u0014\t\u0005\u0005g\u0012y\n\u0002\u0007\u0003x\tM\u0015\u0011!A\u0001\u0006\u0003\u0011Y(A\td_24\u0015-\\5ms6\u000b\u0007\u000f]5oON,\"A!*\u0011\r\u0005\r\"q\u0015BV\u0013\u0011\u0011I+!\r\u0003\u0015%sG-\u001a=fIN+\u0017\u000fE\u0004N\u0005[\u0013\tL!-\n\u0007\t=fJA\u0005Gk:\u001cG/[8ocA!Q*\u001eBZ!\ri%QW\u0005\u0004\u0005os%\u0001\u0002\"zi\u0016\fQcY8m\r\u0006l\u0017\u000e\\=NCB\u0004\u0018N\\4t?\u0012*\u0017\u000fF\u0002p\u0005{C\u0011\"a (\u0003\u0003\u0005\rA!*\u0002%\r|GNR1nS2LX*\u00199qS:<7\u000fI\u0001\u000bI\u00164\u0017-\u001e7u-&\u001cXC\u0001Bc!\u0011\u00119M!4\u000e\u0005\t%'\u0002\u0002Bf\u0003{\f\u0001b]3dkJLG/_\u0005\u0005\u0005\u001f\u0014IM\u0001\tD_2,XN\u001c,jg&\u0014\u0017\u000e\\5us\u0006qA-\u001a4bk2$h+[:`I\u0015\fHcA8\u0003V\"I\u0011q\u0010\u0016\u0002\u0002\u0003\u0007!QY\u0001\fI\u00164\u0017-\u001e7u-&\u001c\b%\u0001\u0004uC\ndWm]\u000b\u0003\u0005;\u0004r!\u0014BW\u0003;\u0014y\u000e\u0005\u0004\u0002$\t\u001d\u0016\u0011[\u0001\u000bi\u0006\u0014G.Z:`I\u0015\fHcA8\u0003f\"I\u0011qP\u0017\u0002\u0002\u0003\u0007!Q\\\u0001\bi\u0006\u0014G.Z:!\u0003\u0015\u0019X\r^;q)\ry'Q\u001e\u0005\b\u0005_|\u0003\u0019\u0001By\u0003\u001d\u0019wN\u001c;fqR\u00042Aa=\u001d\u001b\u0005Q\u0012aB2mK\u0006tW\u000f\u001d\u000b\u0004_\ne\bb\u0002Bxa\u0001\u0007!\u0011_\u0001\u0004[\u0006\u0004HcB8\u0003\u0000\u000e\r1q\u0001\u0005\b\u0007\u0003\t\u0004\u0019AAi\u0003\rYW-\u001f\u0005\b\u0007\u000b\t\u0004\u0019AAo\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011y/\ra\u0001\u0005c\u001cRAMB\u0006\u0007#\u00012aYB\u0007\u0013\r\u0019y\u0001\u001a\u0002\u0007\u001f\nTWm\u0019;\u0011\t\rM1qC\u0007\u0003\u0007+QA!a\u001d\u0002\u0012%!1\u0011DB\u000b\u0005\u0011!vn\u001c7\u0015\u0005\ru\u0001CA%3+\t\tY!\u0001\u0005d_:4w\fJ3r)\ry7Q\u0005\u0005\n\u0003\u007f*\u0014\u0011!a\u0001\u0003\u0017\tQaY8oM\u0002\n1A];o)\u0011\u0011Ii!\f\t\u000bM<\u0004\u0019\u0001;\u0002\u000f\u001d,GoQ8oMR\u0011\u00111B\u0001\bg\u0016$8i\u001c8g)\ry7q\u0007\u0005\b\u0003\u0013I\u0004\u0019AA\u0006\u0001")
public class AttributeIndexJob
implements Tool {
    private Configuration conf = new Configuration();

    public static void main(String[] stringArray) {
        AttributeIndexJob$.MODULE$.main(stringArray);
    }

    public static String IndexCoverage() {
        return AttributeIndexJob$.MODULE$.IndexCoverage();
    }

    public static String IndexAttributes() {
        return AttributeIndexJob$.MODULE$.IndexAttributes();
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    public int run(String[] args) {
        AttributeIndexArgs parsedArgs = new AttributeIndexArgs(args);
        parsedArgs.parse();
        String typeName = parsedArgs.inFeature();
        scala.collection.immutable.Map<String, String> dsInParams = parsedArgs.inDataStore();
        Buffer attributes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(parsedArgs.attributes()).asScala();
        Enumeration.Value coverage = (Enumeration.Value)Option$.MODULE$.apply((Object)parsedArgs.coverage()).map((Function1 & Serializable & scala.Serializable)c -> {
            Enumeration.Value value;
            try {
                value = IndexCoverage$.MODULE$.withName(c);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Invalid coverage value ").append((String)c).toString());
                }
                throw throwable;
            }
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> IndexCoverage$.MODULE$.FULL());
        return BoxesRunTime.unboxToInt((Object)WithStore$.MODULE$.apply(dsInParams).apply((Function1 & Serializable & scala.Serializable)ds -> BoxesRunTime.boxToInteger((int)AttributeIndexJob.$anonfun$run$3(this, typeName, attributes, coverage, dsInParams, parsedArgs, ds))));
    }

    public Configuration getConf() {
        return this.conf();
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(conf);
    }

    public static final /* synthetic */ int $anonfun$run$3(AttributeIndexJob $this, String typeName$1, Buffer attributes$2, Enumeration.Value coverage$1, scala.collection.immutable.Map dsInParams$1, AttributeIndexArgs parsedArgs$1, AccumuloDataStore ds) {
        Predef$.MODULE$.require(ds != null, (Function0 & Serializable & scala.Serializable)() -> "The specified input data store could not be created - check your job parameters");
        ObjectRef sft2 = ObjectRef.create((Object)((SimpleFeatureType)Option$.MODULE$.apply((Object)ds.getSchema(typeName$1)).map((Function1 & Serializable & scala.Serializable)sft -> SimpleFeatureTypes$.MODULE$.mutable(sft)).orNull(Predef$.MODULE$.$conforms())));
        Predef$.MODULE$.require((SimpleFeatureType)sft2.elem != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("The schema '").append(typeName$1).append("' does not exist in the input data store").toString());
        attributes$2.foreach((Function1 & Serializable & scala.Serializable)a -> {
            AttributeDescriptor descriptor = ((SimpleFeatureType)sft$1.elem).getDescriptor(a);
            Predef$.MODULE$.require(descriptor != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Attribute '").append((String)a).append("' does not exist in schema '").append(typeName$1).append("'").toString());
            return descriptor.getUserData().put(SimpleFeatureTypes.AttributeOptions$.MODULE$.OptIndex(), coverage$1.toString());
        });
        ds.updateSchema(((SimpleFeatureType)sft2.elem).getTypeName(), (SimpleFeatureType)sft2.elem);
        sft2.elem = ds.getSchema(((SimpleFeatureType)sft2.elem).getTypeName());
        Job job = Job.getInstance((Configuration)$this.conf(), (String)new StringBuilder(35).append("GeoMesa Attribute Index Job '").append(((SimpleFeatureType)sft2.elem).getTypeName()).append("' - '").append(attributes$2.mkString(", ")).append("'").toString());
        AccumuloJobUtils$.MODULE$.setLibJars(job.getConfiguration(), AccumuloJobUtils$.MODULE$.setLibJars$default$2(), AccumuloJobUtils$.MODULE$.setLibJars$default$3());
        job.setJarByClass(AttributeIndexJob$.MODULE$.getClass());
        job.setMapperClass(AttributeMapper.class);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        AccumuloQueryPlan plan = AccumuloJobUtils$.MODULE$.getSingleQueryPlan(ds, new Query(((SimpleFeatureType)sft2.elem).getTypeName(), (Filter)Filter.INCLUDE));
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job.getConfiguration(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsInParams$1).asJava(), plan);
        GeoMesaConfigurator$.MODULE$.setDataStoreOutParams(job.getConfiguration(), dsInParams$1);
        AttributeIndexJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$AttributeIndexJob$$setAttributes(job.getConfiguration(), (Seq<String>)attributes$2.toSeq());
        AttributeIndexJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$AttributeIndexJob$$setTypeName(job.getConfiguration(), ((SimpleFeatureType)sft2.elem).getTypeName());
        Properties config = new Properties();
        config.put(ClientProperty.INSTANCE_NAME.getKey(), parsedArgs$1.inInstanceId());
        config.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), parsedArgs$1.inZookeepers());
        config.put(ClientProperty.AUTH_PRINCIPAL.getKey(), parsedArgs$1.inUser());
        config.put(ClientProperty.AUTH_TOKEN.getKey(), parsedArgs$1.inPassword());
        AccumuloOutputFormat.configure().clientProperties(config).createTables(true).store((Object)job);
        boolean result = job.waitForCompletion(true);
        if (result) {
            return 0;
        }
        return 1;
    }

    public static class AttributeIndexArgs
    extends GeoMesaArgs
    implements InputFeatureArgs,
    InputDataStoreArgs {
        @Parameter(names={"--geomesa.index.attributes"}, description="Attributes to index", variableArity=true, required=true)
        private java.util.List<String> attributes;
        @Parameter(names={"--geomesa.index.coverage"}, description="Type of index (join or full)")
        private String coverage;
        @Parameter(names={"--geomesa.input.user"}, description="Accumulo user name", required=true)
        private String inUser;
        @Parameter(names={"--geomesa.input.password"}, description="Accumulo password")
        private String inPassword;
        @Parameter(names={"--geomesa.input.keytabPath"}, description="Accumulo Kerberos keytab path")
        private String inKeytabPath;
        @Parameter(names={"--geomesa.input.instanceId"}, description="Accumulo instance name", required=true)
        private String inInstanceId;
        @Parameter(names={"--geomesa.input.zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String inZookeepers;
        @Parameter(names={"--geomesa.input.tableName"}, description="Accumulo catalog table name", required=true)
        private String inTableName;
        @Parameter(names={"--geomesa.input.feature"}, description="Simple feature type name", required=true)
        private String inFeature;

        @Override
        public scala.collection.immutable.Map<String, String> inDataStore() {
            return InputDataStoreArgs.inDataStore$(this);
        }

        @Override
        public String inUser() {
            return this.inUser;
        }

        @Override
        public void inUser_$eq(String x$1) {
            this.inUser = x$1;
        }

        @Override
        public String inPassword() {
            return this.inPassword;
        }

        @Override
        public void inPassword_$eq(String x$1) {
            this.inPassword = x$1;
        }

        @Override
        public String inKeytabPath() {
            return this.inKeytabPath;
        }

        @Override
        public void inKeytabPath_$eq(String x$1) {
            this.inKeytabPath = x$1;
        }

        @Override
        public String inInstanceId() {
            return this.inInstanceId;
        }

        @Override
        public void inInstanceId_$eq(String x$1) {
            this.inInstanceId = x$1;
        }

        @Override
        public String inZookeepers() {
            return this.inZookeepers;
        }

        @Override
        public void inZookeepers_$eq(String x$1) {
            this.inZookeepers = x$1;
        }

        @Override
        public String inTableName() {
            return this.inTableName;
        }

        @Override
        public void inTableName_$eq(String x$1) {
            this.inTableName = x$1;
        }

        @Override
        public String inFeature() {
            return this.inFeature;
        }

        @Override
        public void inFeature_$eq(String x$1) {
            this.inFeature = x$1;
        }

        public java.util.List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(java.util.List<String> x$1) {
            this.attributes = x$1;
        }

        public String coverage() {
            return this.coverage;
        }

        public void coverage_$eq(String x$1) {
            this.coverage = x$1;
        }

        @Override
        public String[] unparse() {
            String[] attrs = this.attributes() == null || this.attributes().isEmpty() ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.attributes()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)n -> (Seq)new .colon.colon((Object)"--geomesa.index.attributes", (List)new .colon.colon(n, (List)Nil$.MODULE$)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            String[] cov = this.coverage() == null ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])((Object[])new String[]{"--geomesa.index.coverage", this.coverage()});
            return (String[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{InputFeatureArgs.unparse$(this), InputDataStoreArgs.unparse$(this), attrs, cov}), ClassTag$.MODULE$.apply(String.class));
        }

        public AttributeIndexArgs(String[] args) {
            super(args);
            InputFeatureArgs.$init$(this);
            InputDataStoreArgs.$init$(this);
            this.attributes = new ArrayList<String>();
        }
    }

    public static class AttributeMapper
    extends Mapper<Text, SimpleFeature, Text, Mutation> {
        private Counter counter;
        private WritableFeature.FeatureWrapper<WritableFeature> wrapper;
        private Seq<Tuple2<WriteConverter<?>, Object>> converters;
        private IndexedSeq<Function1<byte[], byte[]>> colFamilyMappings;
        private ColumnVisibility defaultVis;
        private Function1<SimpleFeature, IndexedSeq<Text>> tables;

        private Counter counter() {
            return this.counter;
        }

        private void counter_$eq(Counter x$1) {
            this.counter = x$1;
        }

        private WritableFeature.FeatureWrapper<WritableFeature> wrapper() {
            return this.wrapper;
        }

        private void wrapper_$eq(WritableFeature.FeatureWrapper<WritableFeature> x$1) {
            this.wrapper = x$1;
        }

        private Seq<Tuple2<WriteConverter<?>, Object>> converters() {
            return this.converters;
        }

        private void converters_$eq(Seq<Tuple2<WriteConverter<?>, Object>> x$1) {
            this.converters = x$1;
        }

        private IndexedSeq<Function1<byte[], byte[]>> colFamilyMappings() {
            return this.colFamilyMappings;
        }

        private void colFamilyMappings_$eq(IndexedSeq<Function1<byte[], byte[]>> x$1) {
            this.colFamilyMappings = x$1;
        }

        private ColumnVisibility defaultVis() {
            return this.defaultVis;
        }

        private void defaultVis_$eq(ColumnVisibility x$1) {
            this.defaultVis = x$1;
        }

        private Function1<SimpleFeature, IndexedSeq<Text>> tables() {
            return this.tables;
        }

        private void tables_$eq(Function1<SimpleFeature, IndexedSeq<Text>> x$1) {
            this.tables = x$1;
        }

        public void setup(Mapper.Context context) {
            this.counter_$eq(context.getCounter("org.locationtech.geomesa", "attributes-written"));
            WithStore$.MODULE$.apply(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).apply((Function1 & Serializable & scala.Serializable)ds -> {
                AttributeMapper.$anonfun$setup$1(this, context, ds);
                return BoxedUnit.UNIT;
            });
        }

        public void cleanup(Mapper.Context context) {
        }

        public void map(Text key, SimpleFeature value, Mapper.Context context) {
            WritableFeature.FeatureWrapper<WritableFeature> qual$1 = this.wrapper();
            SimpleFeature x$1 = value;
            boolean x$2 = qual$1.wrap$default$2();
            WritableFeature writable = qual$1.wrap(x$1, x$2);
            IndexedSeq out = (IndexedSeq)this.tables().apply((Object)value);
            this.converters().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AttributeMapper.$anonfun$map$1(this, writable, context, out, x0$1);
                return BoxedUnit.UNIT;
            });
            this.counter().increment((long)this.converters().length());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ boolean $anonfun$setup$2(Set attributes$1, GeoMesaFeatureIndex i) {
            String string = i.name();
            String string2 = AttributeIndex$.MODULE$.name();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = i.name();
                String string4 = JoinIndex$.MODULE$.name();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
            }
            if (!i.attributes().headOption().exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)attributes$1.contains((Object)elem)))) return false;
            return true;
        }

        public static final /* synthetic */ void $anonfun$setup$1(AttributeMapper $this, Mapper.Context context$1, AccumuloDataStore ds) {
            Function1 & Serializable & scala.Serializable intersect;
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(ds.getSchema(AttributeIndexJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$AttributeIndexJob$$getTypeName(context$1.getConfiguration())));
            Set attributes = AttributeIndexJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$AttributeIndexJob$$getAttributes(context$1.getConfiguration()).toSet();
            Seq indices = (Seq)ds.manager().indices(sft, IndexMode$.MODULE$.Write()).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)AttributeMapper.$anonfun$setup$2(attributes, i)));
            $this.wrapper_$eq((WritableFeature.FeatureWrapper<WritableFeature>)AccumuloWritableFeature$.MODULE$.wrapper(sft, ds.adapter().groups(), indices));
            $this.converters_$eq((Seq)((IterableLike)indices.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.createConverter(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom()));
            $this.colFamilyMappings_$eq((IndexedSeq<Function1<byte[], byte[]>>)((TraversableOnce)indices.map((Function1 & Serializable & scala.Serializable)index -> ColumnFamilyMapper$.MODULE$.apply(index), Seq$.MODULE$.canBuildFrom())).toIndexedSeq());
            $this.defaultVis_$eq(new ColumnVisibility());
            Option option = TablePartition$.MODULE$.apply((package.HasGeoMesaMetadata)ds, sft);
            if (option instanceof Some) {
                Some some = (Some)option;
                TablePartition tp = (TablePartition)some.value();
                scala.collection.mutable.Map tables = Map$.MODULE$.empty();
                intersect = (Function1 & Serializable & scala.Serializable)f -> {
                    String partition = tp.partition(f);
                    return (IndexedSeq)tables.getOrElseUpdate((Object)partition, (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)indices.map((Function1 & Serializable & scala.Serializable)i -> new Text(i.configureTableName((Option)new Some((Object)partition), i.configureTableName$default$2())), Seq$.MODULE$.canBuildFrom())).toIndexedSeq());
                };
            } else if (None$.MODULE$.equals(option)) {
                scala.collection.immutable.IndexedSeq names = ((TraversableOnce)indices.map((Function1 & Serializable & scala.Serializable)i -> new Text((String)i.getTableNames((Option)None$.MODULE$).head()), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
                intersect = (Function1 & Serializable & scala.Serializable)x$2 -> names;
            } else {
                throw new MatchError((Object)option);
            }
            $this.tables_$eq((Function1<SimpleFeature, IndexedSeq<Text>>)intersect);
        }

        public static final /* synthetic */ void $anonfun$map$2(AttributeMapper $this, Mutation mutation$1, int i$1, package.KeyValue v) {
            ColumnVisibility vis = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(v.vis())).isEmpty() ? $this.defaultVis() : new ColumnVisibility(v.vis());
            mutation$1.put((byte[])((Function1)$this.colFamilyMappings().apply(i$1)).apply((Object)v.cf()), v.cq(), vis, v.value());
        }

        public static final /* synthetic */ void $anonfun$map$4(AttributeMapper $this, Mutation mutation$2, int i$1, package.KeyValue v) {
            ColumnVisibility vis = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(v.vis())).isEmpty() ? $this.defaultVis() : new ColumnVisibility(v.vis());
            mutation$2.put((byte[])((Function1)$this.colFamilyMappings().apply(i$1)).apply((Object)v.cf()), v.cq(), vis, v.value());
        }

        public static final /* synthetic */ void $anonfun$map$3(AttributeMapper $this, Seq vals$1, int i$1, Mapper.Context context$2, IndexedSeq out$1, byte[] row) {
            Mutation mutation = new Mutation(row);
            vals$1.foreach((Function1 & Serializable & scala.Serializable)v -> {
                AttributeMapper.$anonfun$map$4($this, mutation, i$1, v);
                return BoxedUnit.UNIT;
            });
            context$2.write(out$1.apply(i$1), (Object)mutation);
        }

        public static final /* synthetic */ void $anonfun$map$1(AttributeMapper $this, WritableFeature writable$1, Mapper.Context context$2, IndexedSeq out$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WriteConverter converter = (WriteConverter)tuple2._1();
                int i = tuple2._2$mcI$sp();
                package.RowKeyValue rowKeyValue = converter.convert(writable$1, converter.convert$default$2());
                if (rowKeyValue instanceof package.SingleRowKeyValue) {
                    package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                    byte[] row2 = singleRowKeyValue.row();
                    Seq vals = singleRowKeyValue.values();
                    Mutation mutation = new Mutation(row2);
                    vals.foreach((Function1 & Serializable & scala.Serializable)v -> {
                        AttributeMapper.$anonfun$map$2($this, mutation, i, v);
                        return BoxedUnit.UNIT;
                    });
                    context$2.write(out$1.apply(i), (Object)mutation);
                } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                    package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                    Seq rows = multiRowKeyValue.rows();
                    Seq vals = multiRowKeyValue.values();
                    rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
                        AttributeMapper.$anonfun$map$3($this, vals, i, context$2, out$1, row);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError((Object)rowKeyValue);
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

