/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.index;

import com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.GeoMesaArgs;
import org.locationtech.geomesa.accumulo.jobs.InputCqlArgs;
import org.locationtech.geomesa.accumulo.jobs.InputDataStoreArgs;
import org.locationtech.geomesa.accumulo.jobs.InputFeatureArgs;
import org.locationtech.geomesa.accumulo.jobs.OutputDataStoreArgs;
import org.locationtech.geomesa.accumulo.jobs.OutputFeatureOptionalArgs;
import org.locationtech.geomesa.accumulo.jobs.index.SchemaCopyJob$;
import org.locationtech.geomesa.accumulo.jobs.index.WriteIndexJob;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.WithStore$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uw!\u0002\u0013&\u0011\u0003\u0011d!\u0002\u001b&\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%Ia\u0010\u0005\u0007\u0011\u0006\u0001\u000b\u0011\u0002!\t\u000f%\u000b!\u0019!C\u0005\u007f!1!*\u0001Q\u0001\n\u0001CQaS\u0001\u0005\u00021CQaX\u0001\u0005\n\u0001DQA_\u0001\u0005\nm4A!`\u0001\u0001}\"Q\u0011K\u0003B\u0001B\u0003%!+!\n\t\rqRA\u0011AA\u0014\u0011\u001d\tyC\u0003C!\u0003c1a!a\r\u0002\u0001\u0005U\u0002B\u0002\u001f\u000f\t\u0003\t)&\u0002\u0004\u0002Z9\u0001\u00111\f\u0005\n\u0003?r!\u0019!C\u0005\u0003CB\u0001\"a\u0019\u000fA\u0003%\u00111\t\u0005\f\u0003Kr\u0001\u0019!a\u0001\n\u0013\t9\u0007C\u0006\u0002p9\u0001\r\u00111A\u0005\n\u0005E\u0004bCA<\u001d\u0001\u0007\t\u0011)Q\u0005\u0003SB1\"!\u001f\u000f\u0001\u0004\u0005\r\u0011\"\u0003\u0002|!Y\u0011Q\u0010\bA\u0002\u0003\u0007I\u0011BA@\u0011)\t\u0019I\u0004a\u0001\u0002\u0003\u0006KA\u001c\u0005\b\u0003\u000bsA\u0011KAD\u0011\u001d\t\tJ\u0004C)\u0003'Cq!a&\u000f\t\u0003\nIJB\u00035K\u0001\t)\u000b\u0003\u0004=9\u0011\u0005\u0011\u0011\u0018\u0005\tEr\u0001\r\u0011\"\u0003\u0002>\"I\u0011q\u0018\u000fA\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0003\u000bd\u0002\u0015)\u0003d\u0011\u001d\t9\r\bC!\u0003\u0013Dq!a5\u001d\t\u0003\n)\u000eC\u0004\u0002Xr!\t%!7\u0002\u001bM\u001b\u0007.Z7b\u0007>\u0004\u0018PS8c\u0015\t1s%A\u0003j]\u0012,\u0007P\u0003\u0002)S\u0005!!n\u001c2t\u0015\tQ3&\u0001\u0005bG\u000e,X.\u001e7p\u0015\taS&A\u0004hK>lWm]1\u000b\u00059z\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005M\nQ\"A\u0013\u0003\u001bM\u001b\u0007.Z7b\u0007>\u0004\u0018PS8c'\t\ta\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\n\u0011cQ8qsN\u001b\u0007.Z7b\u001d\u0006lWmS3z+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002%\r{\u0007/_*dQ\u0016l\u0017MT1nK.+\u0017\u0010I\u0001\u0012\u0007>\u0004\u0018pU2iK6\f7\u000b]3d\u0017\u0016L\u0018AE\"paf\u001c6\r[3nCN\u0003XmY&fs\u0002\nA!\\1j]R\u0011Q\n\u0015\t\u0003o9K!a\u0014\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006#\u001e\u0001\rAU\u0001\u0005CJ<7\u000fE\u00028'VK!\u0001\u0016\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YkfBA,\\!\tA\u0006(D\u0001Z\u0015\tQ\u0016'\u0001\u0004=e>|GOP\u0005\u00039b\na\u0001\u0015:fI\u00164\u0017BA$_\u0015\ta\u0006(A\u0007tKR\u001cu\u000e]=TG\",W.\u0019\u000b\u0004\u001b\u0006d\u0007\"\u00022\t\u0001\u0004\u0019\u0017\u0001B2p]\u001a\u0004\"\u0001\u001a6\u000e\u0003\u0015T!A\u00194\u000b\u0005\u001dD\u0017A\u00025bI>|\u0007O\u0003\u0002j_\u00051\u0011\r]1dQ\u0016L!a[3\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015i\u0007\u00021\u0001o\u0003\r\u0019h\r\u001e\t\u0003_bl\u0011\u0001\u001d\u0006\u0003cJ\faa]5na2,'BA:u\u0003\u001d1W-\u0019;ve\u0016T!!\u001e<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002x_\u0005Aq-Z8u_>d7/\u0003\u0002za\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\u001b\u001d,GoQ8qsN\u001b\u0007.Z7b)\tqG\u0010C\u0003c\u0013\u0001\u00071M\u0001\bTG\",W.Y\"paf\f%oZ:\u0014\u0019)y\u0018qAA\u0007\u0003'\tI\"a\b\u0011\t\u0005\u0005\u00111A\u0007\u0002O%\u0019\u0011QA\u0014\u0003\u0017\u001d+w.T3tC\u0006\u0013xm\u001d\t\u0005\u0003\u0003\tI!C\u0002\u0002\f\u001d\u0012\u0001#\u00138qkR4U-\u0019;ve\u0016\f%oZ:\u0011\t\u0005\u0005\u0011qB\u0005\u0004\u0003#9#AE%oaV$H)\u0019;b'R|'/Z!sON\u0004B!!\u0001\u0002\u0016%\u0019\u0011qC\u0014\u0003\u0019%s\u0007/\u001e;Dc2\f%oZ:\u0011\t\u0005\u0005\u00111D\u0005\u0004\u0003;9#!G(viB,HOR3biV\u0014Xm\u00149uS>t\u0017\r\\!sON\u0004B!!\u0001\u0002\"%\u0019\u00111E\u0014\u0003'=+H\u000f];u\t\u0006$\u0018m\u0015;pe\u0016\f%oZ:\n\u0007E\u000b\u0019\u0001\u0006\u0003\u0002*\u00055\u0002cAA\u0016\u00155\t\u0011\u0001C\u0003R\u0019\u0001\u0007!+A\u0004v]B\f'o]3\u0015\u0003I\u0013!bQ8qs6\u000b\u0007\u000f]3s'\rq\u0011q\u0007\t\r\u0003s\ty$a\u0011\u0002P\u0005\r\u0013qJ\u0007\u0003\u0003wQ1!!\u0010g\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0003\u0002B\u0005m\"AB'baB,'\u000f\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tIEZ\u0001\u0003S>LA!!\u0014\u0002H\t!A+\u001a=u!\ry\u0017\u0011K\u0005\u0004\u0003'\u0002(!D*j[BdWMR3biV\u0014X\r\u0006\u0002\u0002XA\u0019\u00111\u0006\b\u0003\u000f\r{g\u000e^3yiB!\u0011qGA/\u0013\u0011\tI&a\u0010\u0002\tQ,\u0007\u0010^\u000b\u0003\u0003\u0007\nQ\u0001^3yi\u0002\nqaY8v]R,'/\u0006\u0002\u0002jA!\u0011\u0011HA6\u0013\u0011\ti'a\u000f\u0003\u000f\r{WO\u001c;fe\u0006Y1m\\;oi\u0016\u0014x\fJ3r)\ri\u00151\u000f\u0005\n\u0003k\"\u0012\u0011!a\u0001\u0003S\n1\u0001\u001f\u00132\u0003!\u0019w.\u001e8uKJ\u0004\u0013AB:gi>+H/F\u0001o\u0003)\u0019h\r^(vi~#S-\u001d\u000b\u0004\u001b\u0006\u0005\u0005\u0002CA;/\u0005\u0005\t\u0019\u00018\u0002\u000fM4GoT;uA\u0005)1/\u001a;vaR\u0019Q*!#\t\u000f\u0005-\u0015\u00041\u0001\u0002\u000e\u000691m\u001c8uKb$\bcAAH!5\ta\"A\u0004dY\u0016\fg.\u001e9\u0015\u00075\u000b)\nC\u0004\u0002\fj\u0001\r!!$\u0002\u00075\f\u0007\u000fF\u0004N\u00037\u000by*a)\t\u000f\u0005u5\u00041\u0001\u0002D\u0005\u00191.Z=\t\u000f\u0005\u00056\u00041\u0001\u0002P\u0005)a/\u00197vK\"9\u00111R\u000eA\u0002\u000555#\u0002\u000f\u0002(\u00065\u0006cA!\u0002*&\u0019\u00111\u0016\"\u0003\r=\u0013'.Z2u!\u0011\ty+!.\u000e\u0005\u0005E&bAAZM\u0006!Q\u000f^5m\u0013\u0011\t9,!-\u0003\tQ{w\u000e\u001c\u000b\u0003\u0003w\u0003\"a\r\u000f\u0016\u0003\r\f\u0001bY8oM~#S-\u001d\u000b\u0004\u001b\u0006\r\u0007\u0002CA;?\u0005\u0005\t\u0019A2\u0002\u000b\r|gN\u001a\u0011\u0002\u0007I,h\u000e\u0006\u0003\u0002L\u0006E\u0007cA\u001c\u0002N&\u0019\u0011q\u001a\u001d\u0003\u0007%sG\u000fC\u0003RC\u0001\u0007!+A\u0004hKR\u001cuN\u001c4\u0015\u0003\r\fqa]3u\u0007>tg\rF\u0002N\u00037DQAY\u0012A\u0002\r\u0004")
public class SchemaCopyJob
implements Tool {
    private Configuration conf = new Configuration();

    public static void main(String[] stringArray) {
        SchemaCopyJob$.MODULE$.main(stringArray);
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    public int run(String[] args) {
        SchemaCopyArgs parsedArgs = new SchemaCopyArgs(args);
        parsedArgs.parse();
        String featureIn = parsedArgs.inFeature();
        String featureOut = (String)Option$.MODULE$.apply((Object)parsedArgs.outFeature()).getOrElse((Function0 & Serializable & scala.Serializable)() -> featureIn);
        scala.collection.immutable.Map<String, String> dsInParams = parsedArgs.inDataStore();
        scala.collection.immutable.Map<String, String> dsOutParams = parsedArgs.outDataStore();
        String filter = (String)Option$.MODULE$.apply((Object)parsedArgs.inCql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "INCLUDE");
        Tuple2 tuple2 = (Tuple2)WithStore$.MODULE$.apply(dsOutParams).apply((Function1 & Serializable & scala.Serializable)dsIn -> {
            Predef$.MODULE$.require(dsIn != null, (Function0 & Serializable & scala.Serializable)() -> "The specified input data store could not be created - check your job parameters");
            SimpleFeatureType sft = dsIn.getSchema(featureIn);
            Predef$.MODULE$.require(sft != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("The feature '").append(featureIn).append("' does not exist in the input data store").toString());
            AccumuloQueryPlan plan = AccumuloJobUtils$.MODULE$.getSingleQueryPlan((AccumuloDataStore)dsIn, new Query(sft.getTypeName(), ECQL.toFilter((String)filter)));
            return new Tuple2((Object)sft, (Object)plan);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SimpleFeatureType sftIn = (SimpleFeatureType)tuple2._1();
        AccumuloQueryPlan plan = (AccumuloQueryPlan)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sftIn, (Object)plan);
        SimpleFeatureType sftIn2 = (SimpleFeatureType)tuple22._1();
        AccumuloQueryPlan plan2 = (AccumuloQueryPlan)tuple22._2();
        SimpleFeatureType sftOut = (SimpleFeatureType)WithStore$.MODULE$.apply(dsOutParams).apply((Function1 & Serializable & scala.Serializable)dsOut -> {
            Predef$.MODULE$.require(dsOut != null, (Function0 & Serializable & scala.Serializable)() -> "The specified output data store could not be created - check your job parameters");
            SimpleFeatureType sft = dsOut.getSchema(featureOut);
            if (sft != null) {
                return sft;
            }
            String string = featureOut;
            String string2 = featureIn;
            sft = !(string != null ? !string.equals(string2) : string2 != null) ? sftIn2 : SimpleFeatureTypes$.MODULE$.createType(featureOut, SimpleFeatureTypes$.MODULE$.encodeType(sftIn2));
            dsOut.createSchema(sft);
            return dsOut.getSchema(featureOut);
        });
        Predef$.MODULE$.require(sftOut != null, (Function0 & Serializable & scala.Serializable)() -> "Could not create output type - check your job parameters");
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)new StringBuilder(28).append("GeoMesa Schema Copy '").append(sftIn2.getTypeName()).append("' to '").append(sftOut.getTypeName()).append("'").toString());
        job.setJarByClass(SchemaCopyJob$.MODULE$.getClass());
        job.setMapperClass(WriteIndexJob.PassThroughMapper.class);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        job.setOutputFormatClass(GeoMesaOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(ScalaSimpleFeature.class);
        job.setNumReduceTasks(0);
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job.getConfiguration(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(dsInParams).asJava(), plan2);
        GeoMesaOutputFormat$.MODULE$.setOutput(job.getConfiguration(), dsOutParams, sftOut, GeoMesaOutputFormat$.MODULE$.setOutput$default$4());
        SchemaCopyJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$SchemaCopyJob$$setCopySchema(job.getConfiguration(), sftOut);
        boolean result = job.waitForCompletion(true);
        if (result) {
            return 0;
        }
        return 1;
    }

    public Configuration getConf() {
        return this.conf();
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(conf);
    }

    public static class CopyMapper
    extends Mapper<Text, SimpleFeature, Text, SimpleFeature> {
        private final Text text = new Text();
        private Counter counter;
        private SimpleFeatureType sftOut;

        private Text text() {
            return this.text;
        }

        private Counter counter() {
            return this.counter;
        }

        private void counter_$eq(Counter x$1) {
            this.counter = x$1;
        }

        private SimpleFeatureType sftOut() {
            return this.sftOut;
        }

        private void sftOut_$eq(SimpleFeatureType x$1) {
            this.sftOut = x$1;
        }

        public void setup(Mapper.Context context) {
            this.counter_$eq(context.getCounter("org.locationtech.geomesa", "features-written"));
            this.sftOut_$eq(SchemaCopyJob$.MODULE$.org$locationtech$geomesa$accumulo$jobs$index$SchemaCopyJob$$getCopySchema(context.getConfiguration()));
        }

        public void cleanup(Mapper.Context context) {
        }

        public void map(Text key, SimpleFeature value, Mapper.Context context) {
            context.write((Object)this.text(), (Object)ScalaSimpleFeature$.MODULE$.copy(this.sftOut(), value));
            this.counter().increment(1L);
        }
    }

    public static class SchemaCopyArgs
    extends GeoMesaArgs
    implements InputFeatureArgs,
    InputDataStoreArgs,
    InputCqlArgs,
    OutputFeatureOptionalArgs,
    OutputDataStoreArgs {
        @Parameter(names={"--geomesa.output.user"}, description="Accumulo user name", required=true)
        private String outUser;
        @Parameter(names={"--geomesa.output.password"}, description="Accumulo password", required=true)
        private String outPassword;
        @Parameter(names={"--geomesa.output.instanceId"}, description="Accumulo instance name", required=true)
        private String outInstanceId;
        @Parameter(names={"--geomesa.output.zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String outZookeepers;
        @Parameter(names={"--geomesa.output.tableName"}, description="Accumulo catalog table name", required=true)
        private String outTableName;
        @Parameter(names={"--geomesa.output.feature"}, description="Simple feature type name")
        private String outFeature;
        @Parameter(names={"--geomesa.input.cql"}, description="CQL query filter")
        private String inCql;
        @Parameter(names={"--geomesa.input.user"}, description="Accumulo user name", required=true)
        private String inUser;
        @Parameter(names={"--geomesa.input.password"}, description="Accumulo password")
        private String inPassword;
        @Parameter(names={"--geomesa.input.keytabPath"}, description="Accumulo Kerberos keytab path")
        private String inKeytabPath;
        @Parameter(names={"--geomesa.input.instanceId"}, description="Accumulo instance name", required=true)
        private String inInstanceId;
        @Parameter(names={"--geomesa.input.zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String inZookeepers;
        @Parameter(names={"--geomesa.input.tableName"}, description="Accumulo catalog table name", required=true)
        private String inTableName;
        @Parameter(names={"--geomesa.input.feature"}, description="Simple feature type name", required=true)
        private String inFeature;

        @Override
        public scala.collection.immutable.Map<String, String> outDataStore() {
            return OutputDataStoreArgs.outDataStore$(this);
        }

        @Override
        public scala.collection.immutable.Map<String, String> inDataStore() {
            return InputDataStoreArgs.inDataStore$(this);
        }

        @Override
        public String outUser() {
            return this.outUser;
        }

        @Override
        public void outUser_$eq(String x$1) {
            this.outUser = x$1;
        }

        @Override
        public String outPassword() {
            return this.outPassword;
        }

        @Override
        public void outPassword_$eq(String x$1) {
            this.outPassword = x$1;
        }

        @Override
        public String outInstanceId() {
            return this.outInstanceId;
        }

        @Override
        public void outInstanceId_$eq(String x$1) {
            this.outInstanceId = x$1;
        }

        @Override
        public String outZookeepers() {
            return this.outZookeepers;
        }

        @Override
        public void outZookeepers_$eq(String x$1) {
            this.outZookeepers = x$1;
        }

        @Override
        public String outTableName() {
            return this.outTableName;
        }

        @Override
        public void outTableName_$eq(String x$1) {
            this.outTableName = x$1;
        }

        @Override
        public String outFeature() {
            return this.outFeature;
        }

        @Override
        public void outFeature_$eq(String x$1) {
            this.outFeature = x$1;
        }

        @Override
        public String inCql() {
            return this.inCql;
        }

        @Override
        public void inCql_$eq(String x$1) {
            this.inCql = x$1;
        }

        @Override
        public String inUser() {
            return this.inUser;
        }

        @Override
        public void inUser_$eq(String x$1) {
            this.inUser = x$1;
        }

        @Override
        public String inPassword() {
            return this.inPassword;
        }

        @Override
        public void inPassword_$eq(String x$1) {
            this.inPassword = x$1;
        }

        @Override
        public String inKeytabPath() {
            return this.inKeytabPath;
        }

        @Override
        public void inKeytabPath_$eq(String x$1) {
            this.inKeytabPath = x$1;
        }

        @Override
        public String inInstanceId() {
            return this.inInstanceId;
        }

        @Override
        public void inInstanceId_$eq(String x$1) {
            this.inInstanceId = x$1;
        }

        @Override
        public String inZookeepers() {
            return this.inZookeepers;
        }

        @Override
        public void inZookeepers_$eq(String x$1) {
            this.inZookeepers = x$1;
        }

        @Override
        public String inTableName() {
            return this.inTableName;
        }

        @Override
        public void inTableName_$eq(String x$1) {
            this.inTableName = x$1;
        }

        @Override
        public String inFeature() {
            return this.inFeature;
        }

        @Override
        public void inFeature_$eq(String x$1) {
            this.inFeature = x$1;
        }

        @Override
        public String[] unparse() {
            return (String[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{InputFeatureArgs.unparse$(this), InputDataStoreArgs.unparse$(this), InputCqlArgs.unparse$(this), OutputFeatureOptionalArgs.unparse$(this), OutputDataStoreArgs.unparse$(this)}), ClassTag$.MODULE$.apply(String.class));
        }

        public SchemaCopyArgs(String[] args) {
            super(args);
            InputFeatureArgs.$init$(this);
            InputDataStoreArgs.$init$(this);
            InputCqlArgs.$init$(this);
            OutputFeatureOptionalArgs.$init$(this);
            OutputDataStoreArgs.$init$(this);
        }
    }
}

