/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.hadoop.mapreduce.AccumuloFileOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloFileOutputFormat;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package$Configurator$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package$TableRangePartitioner$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class GeoMesaAccumuloFileOutputFormat$
implements LazyLogging {
    public static GeoMesaAccumuloFileOutputFormat$ MODULE$;
    private final String FilesPath;
    private final String SplitsPath;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GeoMesaAccumuloFileOutputFormat$();
    }

    private Logger logger$lzycompute() {
        GeoMesaAccumuloFileOutputFormat$ geoMesaAccumuloFileOutputFormat$ = this;
        synchronized (geoMesaAccumuloFileOutputFormat$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String FilesPath() {
        return this.FilesPath;
    }

    public String SplitsPath() {
        return this.SplitsPath;
    }

    public void configure(Job job, AccumuloDataStore ds, Map<String, String> params, SimpleFeatureType sft, Path output, Option<String> index, Option<Seq<String>> partitions) {
        Seq seq;
        Seq seq2;
        Option<String> option = index;
        if (None$.MODULE$.equals(option)) {
            seq2 = ds.manager().indices(sft, IndexMode$.MODULE$.Write());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String i = (String)some.value();
            seq2 = (Seq)new .colon.colon((Object)ds.manager().index(sft, i, IndexMode$.MODULE$.Write()), (List)Nil$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        Seq indices = seq2;
        Option<Seq<String>> option2 = partitions;
        if (None$.MODULE$.equals(option2)) {
            seq = (Seq)indices.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTableNames((Option)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
        } else if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            Seq parts = (Seq)some.value();
            package$Configurator$.MODULE$.setPartitions(job.getConfiguration(), (Seq<String>)parts);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Creating index tables for {} partitions", new Object[]{BoxesRunTime.boxToInteger((int)parts.length())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)parts.flatMap((Function1 & Serializable & scala.Serializable)p -> {
                ((List)indices.toList().map((Function1 & Serializable & scala.Serializable)index -> CachedThreadPool$.MODULE$.submit(() -> GeoMesaAccumuloFileOutputFormat$.createOne$1(index, ds, p)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get());
                return (Seq)indices.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTableNames((Option)new Some(p)), Seq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(option2);
        }
        Seq tables = seq;
        if (tables.isEmpty()) {
            throw new IllegalArgumentException("No tables found for output");
        }
        GeoMesaConfigurator$.MODULE$.setDataStoreOutParams(job.getConfiguration(), params);
        GeoMesaConfigurator$.MODULE$.setIndicesOut(job.getConfiguration(), (Seq)indices.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.identifier(), Seq$.MODULE$.canBuildFrom()));
        GeoMesaConfigurator$.MODULE$.setSerialization(job.getConfiguration(), sft);
        package$Configurator$.MODULE$.setTypeName(job.getConfiguration(), sft.getTypeName());
        LazyOutputFormat.setOutputFormatClass((Job)job, AccumuloFileOutputFormat.class);
        AccumuloFileOutputFormat.configure().outputPath(new Path(output, this.FilesPath())).store((Object)job);
        job.setPartitionerClass(package.TableRangePartitioner.class);
        package$TableRangePartitioner$.MODULE$.setSplitsPath(job.getConfiguration(), new Path(output, this.SplitsPath()).toString());
        IntRef numReducers = IntRef.create((int)0);
        tables.foreach((Function1 & Serializable & scala.Serializable)table -> {
            GeoMesaAccumuloFileOutputFormat$.$anonfun$configure$9(ds, job, numReducers, table);
            return BoxedUnit.UNIT;
        });
        job.setMapperClass(GeoMesaAccumuloFileOutputFormat.AccumuloFileMapper.class);
        job.setMapOutputKeyClass(package.TableAndKey.class);
        job.setMapOutputValueClass(Value.class);
        job.setReducerClass(GeoMesaAccumuloFileOutputFormat.AccumuloFileReducer.class);
        job.setOutputKeyClass(Key.class);
        job.setOutputValueClass(Value.class);
        job.setNumReduceTasks(numReducers.elem);
    }

    private static final void createOne$1(GeoMesaFeatureIndex index, AccumuloDataStore ds$1, String p$1) {
        ds$1.adapter().createTable(index, (Option)new Some((Object)p$1), (Function0 & Serializable & scala.Serializable)() -> index.getSplits((Option)new Some((Object)p$1)));
    }

    public static final /* synthetic */ void $anonfun$configure$9(AccumuloDataStore ds$1, Job job$1, IntRef numReducers$1, String table) {
        Iterable splits = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ds$1.connector().tableOperations().listSplits(table)).asScala();
        package$TableRangePartitioner$.MODULE$.setTableOffset(job$1.getConfiguration(), table, numReducers$1.elem);
        package$TableRangePartitioner$.MODULE$.setTableSplits(job$1, table, (Iterable<Text>)splits);
        numReducers$1.elem += splits.size() + 1;
    }

    private GeoMesaAccumuloFileOutputFormat$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.FilesPath = "files";
        this.SplitsPath = "splits";
    }
}

