/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloWritableFeature$;
import org.locationtech.geomesa.accumulo.data.writer.package;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloFileOutputFormat$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package$Configurator$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.utils.index.IndexMode$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r%s!\u0002\u001c8\u0011\u0003!e!\u0002$8\u0011\u00039\u0005\"\u0002-\u0002\t\u0003I\u0006b\u0002.\u0002\u0005\u0004%\ta\u0017\u0005\u0007I\u0006\u0001\u000b\u0011\u0002/\t\u000f\u0015\f!\u0019!C\u00017\"1a-\u0001Q\u0001\nqCQaZ\u0001\u0005\u0002!4a!a\u001b\u0002\u0001\u00055\u0004B\u0002-\t\t\u0003\t\u0019+\u0002\u0004\u0002*\"\u0001\u00111\u0016\u0005\u000bq\"\u0001\r\u00111A\u0005\n\u0005E\u0006bCAZ\u0011\u0001\u0007\t\u0019!C\u0005\u0003kC!\"a/\t\u0001\u0004\u0005\t\u0015)\u0003z\u0011-\ty\u0002\u0003a\u0001\u0002\u0004%I!!0\t\u0017\u0005}\u0006\u00021AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u000bD\u0001\u0019!A!B\u0013\t\t\u0003C\u0006\u0002H\"\u0001\r\u00111A\u0005\n\u0005%\u0007bCA}\u0011\u0001\u0007\t\u0019!C\u0005\u0003wD1\"a@\t\u0001\u0004\u0005\t\u0015)\u0003\u0002L\"Y!\u0011\u0001\u0005A\u0002\u0003\u0007I\u0011\u0002B\u0002\u0011-\u00119\u0002\u0003a\u0001\u0002\u0004%IA!\u0007\t\u0017\tu\u0001\u00021A\u0001B\u0003&!Q\u0001\u0005\f\u0005?A\u0001\u0019!a\u0001\n\u0013\u0011\t\u0003C\u0006\u0003`!\u0001\r\u00111A\u0005\n\t\u0005\u0004b\u0003B\u001e\u0011\u0001\u0007\t\u0011)Q\u0005\u0005GA\u0011B! \t\u0005\u0004%IAa \t\u0011\tu\u0005\u0002)A\u0005\u0005\u0003C\u0011Ba(\t\u0005\u0004%IA!)\t\u0011\t\r\u0006\u0002)A\u0005\u0003\u000fC1B!*\t\u0001\u0004\u0005\r\u0011\"\u0003\u0003(\"Y!q\u0016\u0005A\u0002\u0003\u0007I\u0011\u0002BY\u0011-\u0011)\f\u0003a\u0001\u0002\u0003\u0006KA!+\t\u0017\t]\u0006\u00021AA\u0002\u0013%!q\u0015\u0005\f\u0005sC\u0001\u0019!a\u0001\n\u0013\u0011Y\fC\u0006\u0003@\"\u0001\r\u0011!Q!\n\t%\u0006b\u0003Ba\u0011\u0001\u0007\t\u0019!C\u0005\u0005OC1Ba1\t\u0001\u0004\u0005\r\u0011\"\u0003\u0003F\"Y!\u0011\u001a\u0005A\u0002\u0003\u0005\u000b\u0015\u0002BU\u0011\u001d\u0011Y\r\u0003C!\u0005\u001bDqAa6\t\t\u0003\u0012I\u000eC\u0004\u0003^\"!\tEa8\u0007\r\t-\u0018\u0001\u0001Bw\u0011\u0019A&\u0006\"\u0001\u0003|\u00161!q \u0016\u0001\u0007\u0003A1b!\u0002+\u0001\u0004\u0005\r\u0011\"\u0003\u0004\b!Y1\u0011\u0002\u0016A\u0002\u0003\u0007I\u0011BB\u0006\u0011-\u0019yA\u000ba\u0001\u0002\u0003\u0006K!!\u0007\t\u0017\rE!\u00061AA\u0002\u0013%11\u0003\u0005\f\u0007GQ\u0003\u0019!a\u0001\n\u0013\u0019)\u0003C\u0006\u0004*)\u0002\r\u0011!Q!\n\rU\u0001b\u0002BfU\u0011\u000531\u0006\u0005\b\u0005/TC\u0011IB\u001a\u0011\u001d\u00199D\u000bC!\u0007s\tqdR3p\u001b\u0016\u001c\u0018-Q2dk6,Hn\u001c$jY\u0016|U\u000f\u001e9vi\u001a{'/\\1u\u0015\tA\u0014(A\u0005nCB\u0014X\rZ;dK*\u0011!hO\u0001\u0005U>\u00147O\u0003\u0002={\u0005A\u0011mY2v[VdwN\u0003\u0002?\u007f\u00059q-Z8nKN\f'B\u0001!B\u00031awnY1uS>tG/Z2i\u0015\u0005\u0011\u0015aA8sO\u000e\u0001\u0001CA#\u0002\u001b\u00059$aH$f_6+7/Y!dGVlW\u000f\\8GS2,w*\u001e;qkR4uN]7biN\u0019\u0011\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\r\u0005s\u0017PU3g!\tye+D\u0001Q\u0015\t\t&+\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002T)\u0006AA/\u001f9fg\u00064WMC\u0001V\u0003\r\u0019w.\\\u0005\u0003/B\u00131\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001R\u0001\n\r&dWm\u001d)bi\",\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fA\u0001\\1oO*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u0005\u0019\u0019FO]5oO\u0006Qa)\u001b7fgB\u000bG\u000f\u001b\u0011\u0002\u0015M\u0003H.\u001b;t!\u0006$\b.A\u0006Ta2LGo\u001d)bi\"\u0004\u0013!C2p]\u001aLw-\u001e:f)1IGn^@\u0002\u001e\u0005e\u0012\u0011JA*!\tI%.\u0003\u0002l\u0015\n!QK\\5u\u0011\u0015iw\u00011\u0001o\u0003\rQwN\u0019\t\u0003_Vl\u0011\u0001\u001d\u0006\u0003qET!A]:\u0002\r!\fGm\\8q\u0015\t!\u0018)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003mB\u00141AS8c\u0011\u0015Ax\u00011\u0001z\u0003\t!7\u000f\u0005\u0002{{6\t1P\u0003\u0002}w\u0005!A-\u0019;b\u0013\tq8PA\tBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016Dq!!\u0001\b\u0001\u0004\t\u0019!\u0001\u0004qCJ\fWn\u001d\t\t\u0003\u000b\t\u0019\"!\u0007\u0002\u001a9!\u0011qAA\b!\r\tIAS\u0007\u0003\u0003\u0017Q1!!\u0004D\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0003&\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\u00075\u000b\u0007OC\u0002\u0002\u0012)\u0003B!!\u0002\u0002\u001c%\u00191-a\u0006\t\u000f\u0005}q\u00011\u0001\u0002\"\u0005\u00191O\u001a;\u0011\t\u0005\r\u0012QG\u0007\u0003\u0003KQA!a\n\u0002*\u000511/[7qY\u0016TA!a\u000b\u0002.\u00059a-Z1ukJ,'\u0002BA\u0018\u0003c\t1!\u00199j\u0015\r\t\u0019$Q\u0001\tO\u0016|Go\\8mg&!\u0011qGA\u0013\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\b\u0003w9\u0001\u0019AA\u001f\u0003\u0019yW\u000f\u001e9viB!\u0011qHA#\u001b\t\t\tEC\u0002\u0002DE\f!AZ:\n\t\u0005\u001d\u0013\u0011\t\u0002\u0005!\u0006$\b\u000eC\u0004\u0002L\u001d\u0001\r!!\u0014\u0002\u000b%tG-\u001a=\u0011\u000b%\u000by%!\u0007\n\u0007\u0005E#J\u0001\u0004PaRLwN\u001c\u0005\b\u0003+:\u0001\u0019AA,\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0013\u0006=\u0013\u0011\f\t\u0007\u00037\n)'!\u0007\u000f\t\u0005u\u0013\u0011\r\b\u0005\u0003\u0013\ty&C\u0001L\u0013\r\t\u0019GS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9'!\u001b\u0003\u0007M+\u0017OC\u0002\u0002d)\u0013!#Q2dk6,Hn\u001c$jY\u0016l\u0015\r\u001d9feN!\u0001\"a\u001cO!-y\u0017\u0011OA;\u0003\u0003\u000b9)a%\n\u0007\u0005M\u0004O\u0001\u0004NCB\u0004XM\u001d\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P9\u0002\u0005%|\u0017\u0002BA@\u0003s\u0012\u0001b\u0016:ji\u0006\u0014G.\u001a\t\u0005\u0003G\t\u0019)\u0003\u0003\u0002\u0006\u0006\u0015\"!D*j[BdWMR3biV\u0014X\r\u0005\u0003\u0002\n\u00065ebA#\u0002\f&\u0019\u00111M\u001c\n\t\u0005=\u0015\u0011\u0013\u0002\f)\u0006\u0014G.Z!oI.+\u0017PC\u0002\u0002d]\u0002B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0004y\u0006e%\u0002BAN\u0003;\u000bAaY8sK*\u0011Ah]\u0005\u0005\u0003C\u000b9JA\u0003WC2,X\r\u0006\u0002\u0002&B\u0019\u0011q\u0015\u0005\u000e\u0003\u0005\u0011!\"T1q\u0007>tG/\u001a=u!\u0011\ty'!,\n\t\u0005=\u0016\u0011\u000f\u0002\b\u0007>tG/\u001a=u+\u0005I\u0018A\u00023t?\u0012*\u0017\u000fF\u0002j\u0003oC\u0001\"!/\r\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014a\u00013tAU\u0011\u0011\u0011E\u0001\bg\u001a$x\fJ3r)\rI\u00171\u0019\u0005\n\u0003s{\u0011\u0011!a\u0001\u0003C\tAa\u001d4uA\u00059qO]1qa\u0016\u0014XCAAf!\u0019\ti-a;\u0002r:!\u0011qZAs\u001d\u0011\t\t.!9\u000f\t\u0005M\u0017q\u001c\b\u0005\u0003+\fiN\u0004\u0003\u0002X\u0006mg\u0002BA\u0005\u00033L\u0011AQ\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005-S(\u0003\u0003\u00020\u0005\r(bAA&{%!\u0011q]Au\u0003=9&/\u001b;bE2,g)Z1ukJ,'\u0002BA\u0018\u0003GLA!!<\u0002p\nqa)Z1ukJ,wK]1qa\u0016\u0014(\u0002BAt\u0003S\u0004B!a=\u0002v6\u0011\u0011\u0011^\u0005\u0005\u0003o\fIOA\bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0003-9(/\u00199qKJ|F%Z9\u0015\u0007%\fi\u0010C\u0005\u0002:J\t\t\u00111\u0001\u0002L\u0006AqO]1qa\u0016\u0014\b%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014XC\u0001B\u0003!\u0015I\u0015q\nB\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t\u0011\u0002]1si&$\u0018n\u001c8\u000b\t\tE\u00111]\u0001\u0005G>tg-\u0003\u0003\u0003\u0016\t-!A\u0004+bE2,\u0007+\u0019:uSRLwN\\\u0001\u0010a\u0006\u0014H/\u001b;j_:,'o\u0018\u0013fcR\u0019\u0011Na\u0007\t\u0013\u0005eV#!AA\u0002\t\u0015\u0011\u0001\u00049beRLG/[8oKJ\u0004\u0013aB<sSR,'o]\u000b\u0003\u0005G\u0001b!a\u0017\u0002f\t\u0015\u0002cB%\u0003(\t-\"\u0011K\u0005\u0004\u0005SQ%A\u0002+va2,'\u0007\r\u0004\u0003.\t]\"Q\n\t\t\u0003g\u0014yCa\r\u0003L%!!\u0011GAu\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016Le\u000eZ3y!\u0011\u0011)Da\u000e\r\u0001\u0011Y!\u0011H\r\u0002\u0002\u0003\u0005)\u0011\u0001B\u001f\u0005\ryFeM\u0001\toJLG/\u001a:tAE!!q\bB#!\rI%\u0011I\u0005\u0004\u0005\u0007R%a\u0002(pi\"Lgn\u001a\t\u0004\u0013\n\u001d\u0013b\u0001B%\u0015\n\u0019\u0011I\\=\u0011\t\tU\"Q\n\u0003\f\u0005\u001fJ\u0012\u0011!A\u0001\u0006\u0003\u0011iDA\u0002`IQ\u0002DAa\u0015\u0003\\A1\u00111\u001fB+\u00053JAAa\u0016\u0002j\nqqK]5uK\u000e{gN^3si\u0016\u0014\b\u0003\u0002B\u001b\u00057\"1B!\u0018\u001a\u0003\u0003\u0005\tQ!\u0001\u0003>\t\u0019q\fJ\u001b\u0002\u0017]\u0014\u0018\u000e^3sg~#S-\u001d\u000b\u0004S\n\r\u0004\"CA]1\u0005\u0005\t\u0019\u0001B3!\u0019\tY&!\u001a\u0003hA9\u0011Ja\n\u0003j\tU\u0004G\u0002B6\u0005_\u0012\u0019\b\u0005\u0005\u0002t\n=\"Q\u000eB9!\u0011\u0011)Da\u001c\u0005\u0019\te\"1MA\u0001\u0002\u0003\u0015\tA!\u0010\u0011\t\tU\"1\u000f\u0003\r\u0005\u001f\u0012\u0019'!A\u0001\u0002\u000b\u0005!Q\b\u0019\u0005\u0005o\u0012Y\b\u0005\u0004\u0002t\nU#\u0011\u0010\t\u0005\u0005k\u0011Y\b\u0002\u0007\u0003^\t\r\u0014\u0011!A\u0001\u0006\u0003\u0011i$\u0001\u0005wSN\u001c\u0015m\u00195f+\t\u0011\t\t\u0005\u0003\u0003\u0004\n]e\u0002\u0002BC\u0005'sAAa\"\u0003\u0010:!!\u0011\u0012BG\u001d\u0011\t\u0019Na#\n\u0005qj\u0014B\u0001?<\u0013\r\u0011\tj_\u0001\u0007oJLG/\u001a:\n\t\u0005\r$Q\u0013\u0006\u0004\u0005#[\u0018\u0002\u0002BM\u00057\u0013qBV5tS\nLG.\u001b;z\u0007\u0006\u001c\u0007.\u001a\u0006\u0005\u0003G\u0012)*A\u0005wSN\u001c\u0015m\u00195fA\u0005YA/\u00192mK\u0006sGmS3z+\t\t9)\u0001\u0007uC\ndW-\u00118e\u0017\u0016L\b%\u0001\u0005gK\u0006$XO]3t+\t\u0011I\u000bE\u0002p\u0005WK1A!,q\u0005\u001d\u0019u.\u001e8uKJ\fABZ3biV\u0014Xm]0%KF$2!\u001bBZ\u0011%\tIlHA\u0001\u0002\u0004\u0011I+A\u0005gK\u0006$XO]3tA\u00059QM\u001c;sS\u0016\u001c\u0018aC3oiJLWm]0%KF$2!\u001bB_\u0011%\tILIA\u0001\u0002\u0004\u0011I+\u0001\u0005f]R\u0014\u0018.Z:!\u0003\u00191\u0017-\u001b7fI\u0006Qa-Y5mK\u0012|F%Z9\u0015\u0007%\u00149\rC\u0005\u0002:\u0016\n\t\u00111\u0001\u0003*\u00069a-Y5mK\u0012\u0004\u0013!B:fiV\u0004HcA5\u0003P\"9!\u0011[\u0014A\u0002\tM\u0017aB2p]R,\u0007\u0010\u001e\t\u0004\u0005+TQ\"\u0001\u0005\u0002\u000f\rdW-\u00198vaR\u0019\u0011Na7\t\u000f\tE\u0007\u00061\u0001\u0003T\u0006\u0019Q.\u00199\u0015\u000f%\u0014\tO!:\u0003j\"9!1]\u0015A\u0002\u0005U\u0014aA6fs\"9!q]\u0015A\u0002\u0005\u0005\u0015!\u0002<bYV,\u0007b\u0002BiS\u0001\u0007!1\u001b\u0002\u0014\u0003\u000e\u001cW/\\;m_\u001aKG.\u001a*fIV\u001cWM]\n\u0004U\t=\bcC8\u0003r\u0006\u001d\u00151\u0013B{\u0003'K1Aa=q\u0005\u001d\u0011V\rZ;dKJ\u0004B!!&\u0003x&!!\u0011`AL\u0005\rYU-\u001f\u000b\u0003\u0005{\u00042!a*+\u00059\u0011V\rZ;dKJ\u001cuN\u001c;fqR\u0004BAa<\u0004\u0004%!\u0011q\u0016By\u0003\tIG-\u0006\u0002\u0002\u001a\u00051\u0011\u000eZ0%KF$2![B\u0007\u0011%\tILLA\u0001\u0002\u0004\tI\"A\u0002jI\u0002\n1a\\;u+\t\u0019)\u0002\u0005\u0005\u0004\u0018\r}!Q_AJ\u001b\t\u0019IB\u0003\u0003\u0002<\rm!bAB\u000fa\u0006\u0019A.\u001b2\n\t\r\u00052\u0011\u0004\u0002\u0010\u001bVdG/\u001b9mK>+H\u000f];ug\u00069q.\u001e;`I\u0015\fHcA5\u0004(!I\u0011\u0011X\u0019\u0002\u0002\u0003\u00071QC\u0001\u0005_V$\b\u0005F\u0002j\u0007[AqA!54\u0001\u0004\u0019y\u0003E\u0002\u000421j\u0011A\u000b\u000b\u0004S\u000eU\u0002b\u0002Bii\u0001\u00071qF\u0001\u0007e\u0016$WoY3\u0015\u000f%\u001cYd!\u0010\u0004H!9!1]\u001bA\u0002\u0005\u001d\u0005bBB k\u0001\u00071\u0011I\u0001\u0007m\u0006dW/Z:\u0011\u000bu\u001b\u0019%a%\n\u0007\r\u0015cL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011\t.\u000ea\u0001\u0007_\u0001")
public final class GeoMesaAccumuloFileOutputFormat {
    public static void configure(Job job, AccumuloDataStore accumuloDataStore, scala.collection.immutable.Map<String, String> map, SimpleFeatureType simpleFeatureType, Path path, Option<String> option, Option<Seq<String>> option2) {
        GeoMesaAccumuloFileOutputFormat$.MODULE$.configure(job, accumuloDataStore, map, simpleFeatureType, path, option, option2);
    }

    public static String SplitsPath() {
        return GeoMesaAccumuloFileOutputFormat$.MODULE$.SplitsPath();
    }

    public static String FilesPath() {
        return GeoMesaAccumuloFileOutputFormat$.MODULE$.FilesPath();
    }

    public static class AccumuloFileMapper
    extends Mapper<Writable, SimpleFeature, package.TableAndKey, Value>
    implements LazyLogging {
        private AccumuloDataStore ds;
        private SimpleFeatureType sft;
        private WritableFeature.FeatureWrapper<WritableFeature> wrapper;
        private Option<TablePartition> partitioner;
        private Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> writers;
        private final package.VisibilityCache visCache;
        private final package.TableAndKey tableAndKey;
        private Counter features;
        private Counter entries;
        private Counter failed;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            AccumuloFileMapper accumuloFileMapper = this;
            synchronized (accumuloFileMapper) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private AccumuloDataStore ds() {
            return this.ds;
        }

        private void ds_$eq(AccumuloDataStore x$1) {
            this.ds = x$1;
        }

        private SimpleFeatureType sft() {
            return this.sft;
        }

        private void sft_$eq(SimpleFeatureType x$1) {
            this.sft = x$1;
        }

        private WritableFeature.FeatureWrapper<WritableFeature> wrapper() {
            return this.wrapper;
        }

        private void wrapper_$eq(WritableFeature.FeatureWrapper<WritableFeature> x$1) {
            this.wrapper = x$1;
        }

        private Option<TablePartition> partitioner() {
            return this.partitioner;
        }

        private void partitioner_$eq(Option<TablePartition> x$1) {
            this.partitioner = x$1;
        }

        private Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> writers() {
            return this.writers;
        }

        private void writers_$eq(Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> x$1) {
            this.writers = x$1;
        }

        private package.VisibilityCache visCache() {
            return this.visCache;
        }

        private package.TableAndKey tableAndKey() {
            return this.tableAndKey;
        }

        private Counter features() {
            return this.features;
        }

        private void features_$eq(Counter x$1) {
            this.features = x$1;
        }

        private Counter entries() {
            return this.entries;
        }

        private void entries_$eq(Counter x$1) {
            this.entries = x$1;
        }

        private Counter failed() {
            return this.failed;
        }

        private void failed_$eq(Counter x$1) {
            this.failed = x$1;
        }

        public void setup(Mapper.Context context) {
            java.util.Map params = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).asJava();
            this.ds_$eq((AccumuloDataStore)DataStoreFinder.getDataStore((java.util.Map)params));
            Predef$.MODULE$.require(this.ds() != null, (Function0 & Serializable & scala.Serializable)() -> "Could not find data store - check your configuration and hbase-site.xml");
            this.sft_$eq(this.ds().getSchema(package$Configurator$.MODULE$.getTypeName(context.getConfiguration())));
            Predef$.MODULE$.require(this.sft() != null, (Function0 & Serializable & scala.Serializable)() -> "Could not find schema - check your configuration");
            Seq indexIds = (Seq)GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration()).orNull(Predef$.MODULE$.$conforms());
            Predef$.MODULE$.require(indexIds != null, (Function0 & Serializable & scala.Serializable)() -> "Indices to write was not set in the job configuration");
            Seq indices = (Seq)indexIds.map((Function1 & Serializable & scala.Serializable)x$5 -> this.ds().manager().index(this.sft(), x$5, IndexMode$.MODULE$.Write()), Seq$.MODULE$.canBuildFrom());
            this.wrapper_$eq((WritableFeature.FeatureWrapper<WritableFeature>)AccumuloWritableFeature$.MODULE$.wrapper(this.sft(), this.ds().adapter().groups(), indices));
            this.partitioner_$eq((Option<TablePartition>)TablePartition$.MODULE$.apply((package.HasGeoMesaMetadata)this.ds(), this.sft()));
            this.writers_$eq((Seq)indices.map((Function1 & Serializable & scala.Serializable)i -> new Tuple2(i, (Object)i.createConverter()), Seq$.MODULE$.canBuildFrom()));
            this.features_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Written()));
            this.entries_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), "entries"));
            this.failed_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Failed()));
        }

        public void cleanup(Mapper.Context context) {
            if (this.ds() != null) {
                this.ds().dispose();
                return;
            }
        }

        public void map(Writable key, SimpleFeature value, Mapper.Context context) {
            try {
                WritableFeature.FeatureWrapper<WritableFeature> qual$1 = this.wrapper();
                SimpleFeature x$1 = value;
                boolean x$2 = qual$1.wrap$default$2();
                WritableFeature feature = qual$1.wrap(x$1, x$2);
                Option partition = this.partitioner().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.partition(value));
                this.writers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    AccumuloFileMapper.$anonfun$map$2(this, partition, feature, context, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.features().increment(1L);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(22).append("Error writing feature ").append(Option$.MODULE$.apply((Object)value).orNull(Predef$.MODULE$.$conforms())).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.failed().increment(1L);
                }
                throw throwable;
            }
        }

        public static final /* synthetic */ void $anonfun$map$5(AccumuloFileMapper $this, package.SingleRowKeyValue x2$1, Mapper.Context context$1, package.KeyValue value) {
            $this.tableAndKey().setKey(new Key(x2$1.row(), value.cf(), value.cq(), $this.visCache().apply(value.vis()), Long.MAX_VALUE));
            context$1.write((Object)$this.tableAndKey(), (Object)new Value(value.value()));
            $this.entries().increment(1L);
        }

        public static final /* synthetic */ void $anonfun$map$7(AccumuloFileMapper $this, byte[] row$1, Mapper.Context context$1, package.KeyValue value) {
            $this.tableAndKey().setKey(new Key(row$1, value.cf(), value.cq(), $this.visCache().apply(value.vis()), Long.MAX_VALUE));
            context$1.write((Object)$this.tableAndKey(), (Object)new Value(value.value()));
            $this.entries().increment(1L);
        }

        public static final /* synthetic */ void $anonfun$map$6(AccumuloFileMapper $this, package.MultiRowKeyValue x3$1, Mapper.Context context$1, byte[] row) {
            x3$1.values().foreach((Function1 & Serializable & scala.Serializable)value -> {
                AccumuloFileMapper.$anonfun$map$7($this, row, context$1, value);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$map$2(AccumuloFileMapper $this, Option partition$1, WritableFeature feature$1, Mapper.Context context$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)tuple2._1();
                WriteConverter writer = (WriteConverter)tuple2._2();
                Seq seq = index.getTableNames(partition$1);
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) {
                    String msg = seq.isEmpty() ? "No table found" : "Multiple tables found";
                    throw new IllegalStateException(new StringBuilder(0).append(msg).append(partition$1.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(15).append(" for partition ").append((String)p).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
                }
                String table = (String)((SeqLike)some.get()).apply(0);
                $this.tableAndKey().getTable().set(table);
                package.RowKeyValue rowKeyValue = writer.convert(feature$1, writer.convert$default$2());
                if (rowKeyValue instanceof package.SingleRowKeyValue) {
                    package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                    singleRowKeyValue.values().foreach((Function1 & Serializable & scala.Serializable)value -> {
                        AccumuloFileMapper.$anonfun$map$5($this, singleRowKeyValue, context$1, value);
                        return BoxedUnit.UNIT;
                    });
                } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                    package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                    multiRowKeyValue.rows().foreach((Function1 & Serializable & scala.Serializable)row -> {
                        AccumuloFileMapper.$anonfun$map$6($this, multiRowKeyValue, context$1, row);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError((Object)rowKeyValue);
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public AccumuloFileMapper() {
            LazyLogging.$init$((LazyLogging)this);
            this.visCache = new package.VisibilityCache();
            this.tableAndKey = new package.TableAndKey(new Text(), null);
        }
    }

    public static class AccumuloFileReducer
    extends Reducer<package.TableAndKey, Value, Key, Value> {
        private String id;
        private MultipleOutputs<Key, Value> out;

        private String id() {
            return this.id;
        }

        private void id_$eq(String x$1) {
            this.id = x$1;
        }

        private MultipleOutputs<Key, Value> out() {
            return this.out;
        }

        private void out_$eq(MultipleOutputs<Key, Value> x$1) {
            this.out = x$1;
        }

        public void setup(Reducer.Context context) {
            this.id_$eq(context.getJobID().appendTo(new StringBuilder("gm")).toString());
            this.out_$eq((MultipleOutputs<Key, Value>)new MultipleOutputs((TaskInputOutputContext)context));
        }

        public void cleanup(Reducer.Context context) {
            if (this.out() != null) {
                this.out().close();
                return;
            }
        }

        public void reduce(package.TableAndKey key, Iterable<Value> values, Reducer.Context context) {
            String path = new StringBuilder(1).append(key.getTable()).append("/").append(this.id()).toString();
            Iterator<Value> iter = values.iterator();
            while (iter.hasNext()) {
                this.out().write((Object)key.getKey(), (Object)iter.next(), path);
            }
        }
    }
}

