/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreFactory$;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0003\u0007\u0001EAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQ\u0001\u0016\u0001\u0005BUCQA\u001f\u0001\u0005\u0002m\u0014!$Q2dk6,Hn\\*qCRL\u0017\r\u001c*E\tB\u0013xN^5eKJT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011\u0001C1dGVlW\u000f\\8\u000b\u0005-a\u0011aB4f_6,7/\u0019\u0006\u0003\u001b9\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aD\u0001\u0004_J<7\u0001A\n\u0005\u0001IAR\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033mi\u0011A\u0007\u0006\u0003\u000f)I!\u0001\b\u000e\u0003%M\u0003\u0018\r^5bYJ#E\t\u0015:pm&$WM\u001d\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nAb]2bY\u0006dwnZ4j]\u001eT!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014 \u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u00051\u0011AC2b]B\u0013xnY3tgR\u0011Q\u0006\r\t\u0003'9J!a\f\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0011G\u0001a\u0001e\u00051\u0001/\u0019:b[N\u0004$a\r%\u0011\tQJ4HR\u0007\u0002k)\u0011agN\u0001\u0005kRLGNC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$aA'baB\u0011Ah\u0011\b\u0003{\u0005\u0003\"A\u0010\u000b\u000e\u0003}R!\u0001\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0011E#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"\u0015!\t9\u0005\n\u0004\u0001\u0005\u0013%\u0003\u0014\u0011!A\u0001\u0006\u0003Q%aA0%cE\u00111J\u0014\t\u0003'1K!!\u0014\u000b\u0003\u000f9{G\u000f[5oOB\u0011qJU\u0007\u0002!*\u0011\u0011kN\u0001\u0003S>L!a\u0015)\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007I$G\rF\u0003W3\u0012\\g\u000e\u0005\u0002\u001a/&\u0011\u0001L\u0007\u0002\u000b'B\fG/[1m%\u0012#\u0005\"\u0002.\u0004\u0001\u0004Y\u0016\u0001B2p]\u001a\u0004\"\u0001\u00182\u000e\u0003uS!A\u00170\u000b\u0005}\u0003\u0017A\u00025bI>|\u0007O\u0003\u0002b\u001d\u00051\u0011\r]1dQ\u0016L!aY/\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015)7\u00011\u0001g\u0003\t\u00198\r\u0005\u0002hS6\t\u0001N\u0003\u0002\bA&\u0011!\u000e\u001b\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006c\r\u0001\r\u0001\u001c\t\u0005y5\\4(\u0003\u0002;\u000b\")qn\u0001a\u0001a\u0006)\u0011/^3ssB\u0011\u0011\u000f_\u0007\u0002e*\u00111\u000f^\u0001\u0005I\u0006$\u0018M\u0003\u0002vm\u0006\u0019\u0011\r]5\u000b\u0005]t\u0011\u0001C4f_R|w\u000e\\:\n\u0005e\u0014(!B)vKJL\u0018\u0001B:bm\u0016$b\u0001`@\u0002\u001c\u0005u\u0001CA\n~\u0013\tqHC\u0001\u0003V]&$\bB\u0002+\u0005\u0001\u0004\t\t\u0001\u0005\u0004\u0002\u0004\u0005\u001d\u00111B\u0007\u0003\u0003\u000bQ!\u0001\u00165\n\t\u0005%\u0011Q\u0001\u0002\u0004%\u0012#\u0005\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007\u0005UA/A\u0004gK\u0006$XO]3\n\t\u0005e\u0011q\u0002\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000bE\"\u0001\u0019\u00017\t\r\u0005}A\u00011\u0001<\u0003!!\u0018\u0010]3OC6,\u0007")
public class AccumuloSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return SpatialRDDProvider.sft$((SpatialRDDProvider)this, params, (String)typeName);
    }

    private Logger logger$lzycompute() {
        AccumuloSpatialRDDProvider accumuloSpatialRDDProvider = this;
        synchronized (accumuloSpatialRDDProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return AccumuloDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        SpatialRDD spatialRDD;
        LazyRef transform$lzy = new LazyRef();
        Map paramsAsJava = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava();
        AccumuloDataStore ds = (AccumuloDataStore)DataStoreFinder.getDataStore((Map)paramsAsJava);
        try {
            RDD rDD;
            SimpleFeatureType sft = ds.getSchema(query.getTypeName());
            Seq qps = AccumuloJobUtils$.MODULE$.getMultipleQueryPlan(ds, query);
            if (qps.lengthCompare(1) == 0 && ((AccumuloQueryPlan)qps.head()).tables().lengthCompare(1) == 0) {
                rDD = AccumuloSpatialRDDProvider.queryPlanToRDD$1(sft, (AccumuloQueryPlan)qps.head(), ds, sc, conf, paramsAsJava);
            } else {
                Seq expanded = (Seq)qps.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    AccumuloQueryPlan accumuloQueryPlan = x0$1;
                    if (accumuloQueryPlan instanceof AccumuloQueryPlan.BatchScanPlan) {
                        AccumuloQueryPlan.BatchScanPlan batchScanPlan = (AccumuloQueryPlan.BatchScanPlan)accumuloQueryPlan;
                        return (Seq)batchScanPlan.tables().map((Function1 & Serializable & scala.Serializable)t -> {
                            Seq x$1 = (Seq)new .colon.colon(t, (List)Nil$.MODULE$);
                            package.FilterStrategy x$2 = batchScanPlan.copy$default$1();
                            Seq x$3 = batchScanPlan.copy$default$3();
                            Seq x$4 = batchScanPlan.copy$default$4();
                            Option x$5 = batchScanPlan.copy$default$5();
                            QueryPlan.ResultsToFeatures x$6 = batchScanPlan.copy$default$6();
                            Option x$7 = batchScanPlan.copy$default$7();
                            Option x$8 = batchScanPlan.copy$default$8();
                            Option x$9 = batchScanPlan.copy$default$9();
                            Option x$10 = batchScanPlan.copy$default$10();
                            int x$11 = batchScanPlan.copy$default$11();
                            return batchScanPlan.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    if (accumuloQueryPlan instanceof AccumuloQueryPlan.EmptyPlan) {
                        AccumuloQueryPlan.EmptyPlan emptyPlan = (AccumuloQueryPlan.EmptyPlan)accumuloQueryPlan;
                        return (Seq)new .colon.colon((Object)emptyPlan, (List)Nil$.MODULE$);
                    }
                    throw new NotImplementedError(new StringBuilder(28).append("Unexpected query plan type: ").append(accumuloQueryPlan).toString());
                }, Seq$.MODULE$.canBuildFrom());
                rDD = sc.union((Seq)expanded.map((Function1 & Serializable & scala.Serializable)x$2 -> AccumuloSpatialRDDProvider.queryPlanToRDD$1(sft, x$2, ds, sc, conf, paramsAsJava), Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            RDD sfrdd = rDD;
            spatialRDD = SpatialRDD$.MODULE$.apply(sfrdd, (SimpleFeatureType)AccumuloSpatialRDDProvider.transform$1(transform$lzy, query).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft));
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return spatialRDD;
    }

    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> params, String typeName) {
        WithStore$.MODULE$.apply(params).apply((Function1 & Serializable & scala.Serializable)ds -> {
            Predef$.MODULE$.require(ds.getSchema(typeName) != null, (Function0 & Serializable & scala.Serializable)() -> "Feature type must exist before calling save. Call createSchema on the DataStore first.");
            return BoxedUnit.UNIT;
        });
        rdd.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            AccumuloSpatialRDDProvider.$anonfun$save$3(params, typeName, iter);
            return BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ Option transform$lzycompute$1(LazyRef transform$lzy$1, Query query$1) {
        Option option;
        LazyRef lazyRef = transform$lzy$1;
        synchronized (lazyRef) {
            option = transform$lzy$1.initialized() ? (Option)transform$lzy$1.value() : (Option)transform$lzy$1.initialize((Object)QueryHints$.MODULE$.RichHints(query$1.getHints()).getTransformSchema());
        }
        return option;
    }

    private static final Option transform$1(LazyRef transform$lzy$1, Query query$1) {
        if (transform$lzy$1.initialized()) {
            return (Option)transform$lzy$1.value();
        }
        return AccumuloSpatialRDDProvider.transform$lzycompute$1(transform$lzy$1, query$1);
    }

    private static final RDD queryPlanToRDD$1(SimpleFeatureType sft, AccumuloQueryPlan qp, AccumuloDataStore ds$1, SparkContext sc$1, Configuration conf$1, Map paramsAsJava$1) {
        if (ds$1 == null || sft == null || qp instanceof AccumuloQueryPlan.EmptyPlan) {
            return sc$1.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        JobConf config = new JobConf(conf$1);
        GeoMesaAccumuloInputFormat$.MODULE$.configure((Configuration)config, paramsAsJava$1, qp, (Option)new Some((Object)ds$1.auths()));
        return sc$1.newAPIHadoopRDD((Configuration)config, GeoMesaAccumuloInputFormat.class, Text.class, SimpleFeature.class).map((Function1 & Serializable & scala.Serializable)x$1 -> (SimpleFeature)x$1._2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    public static final /* synthetic */ void $anonfun$save$3(scala.collection.immutable.Map params$1, String typeName$1, Iterator iter) {
        WithStore$.MODULE$.apply(params$1).apply((Function1 & Serializable & scala.Serializable)ds -> {
            package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(typeName$1, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                iter$1.foreach((Function1 & Serializable & scala.Serializable)x$3 -> FeatureUtils$.MODULE$.write((FeatureWriter)writer, x$3, true));
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return BoxedUnit.UNIT;
        });
    }

    public AccumuloSpatialRDDProvider() {
        SpatialRDDProvider.$init$((SpatialRDDProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

