/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.iterators.AgeOffIterator$;
import org.locationtech.geomesa.accumulo.iterators.DtgAgeOffIterator$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalDtgParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.FeatureExpiration;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001=\u0011Q#Q2dk6,Hn\\!hK>3gmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005A\u0011mY2v[VdwN\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u00111A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a55\tA!\u0003\u0002\u001c\t\tA\u0012iY2v[Vdw\u000eR1uCN#xN]3D_6l\u0017M\u001c3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001b\u0002\u0012\u0001\u0005\u0004%\teI\u0001\u0005]\u0006lW-F\u0001%!\t\tR%\u0003\u0002'%\t11\u000b\u001e:j]\u001eDa\u0001\u000b\u0001!\u0002\u0013!\u0013!\u00028b[\u0016\u0004\u0003b\u0002\u0016\u0001\u0005\u0004%\teK\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u00031\u0002\"!\f&\u000f\u00059jdBA\u0018=\u001d\t\u00014H\u0004\u00022u9\u0011!'\u000f\b\u0003gar!\u0001N\u001c\u000e\u0003UR!A\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119QA\u0010\u0002\t\u0002}\nQ#Q2dk6,Hn\\!hK>3gmQ8n[\u0006tG\r\u0005\u0002!\u0001\u001a)\u0011A\u0001E\u0001\u0003N\u0011\u0001I\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0007\u0003:L(+\u001a4\t\u000bu\u0001E\u0011A%\u0015\u0003}2Aa\u0013!\u0001\u0019\n!\u0012iY2v[Vdw.Q4f\u001f\u001a4\u0007+\u0019:b[N\u001cRA\u0013\"N!V\u0003\"!\u0007(\n\u0005=#!aF!dGVlW\u000f\\8ECR\f7\u000b^8sKB\u000b'/Y7t!\t\t6+D\u0001S\u0015\t)\u0001\"\u0003\u0002U%\n)\"+Z9vSJ,G\rV=qK:\u000bW.\u001a)be\u0006l\u0007CA)W\u0013\t9&K\u0001\tPaRLwN\\1m\tR<\u0007+\u0019:b[\")QD\u0013C\u00013R\t!\f\u0005\u0002\\\u00156\t\u0001\tC\u0005^\u0015\u0002\u0007\t\u0019!C\u0001=\u00061Q\r\u001f9jef,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003I\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0013\t1\u0017M\u0001\u0005EkJ\fG/[8o\u0011%A'\n1AA\u0002\u0013\u0005\u0011.\u0001\u0006fqBL'/_0%KF$\"A[7\u0011\u0005\r[\u0017B\u00017E\u0005\u0011)f.\u001b;\t\u000f9<\u0017\u0011!a\u0001?\u0006\u0019\u0001\u0010J\u0019\t\rAT\u0005\u0015)\u0003`\u0003\u001d)\u0007\u0010]5ss\u0002BCb\u001c:}{\u0006\u0015\u0011qAA\u0006\u0003\u001b\u0001\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002xq\u0006)!-Z;ti*\t\u00110A\u0002d_6L!a\u001f;\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cHf\u0001@\u0002\u0002\u0005\nq0\u0001\u0002.K\u0006\u0012\u00111A\u0001\t[5*\u0007\u0010]5ss\u0006YA-Z:de&\u0004H/[8oC\t\tI!A'EkJ\fG/[8oA\t,gm\u001c:fA\u0015tGO]5fg\u0002\n'/\u001a\u0011bO\u0016$Wf\u001c4gY\u0001*gf\u001a\u0018!OE\u0002C-Y=(Y\u0001:#\u0007I<fK.\u001c\b%\u00198eAE\u0002\u0003n\\;sO1\u0002S\r^2\u0002\u0013\r|gN^3si\u0016\u00148EAA\b!\u0011\t\t\"a\t\u000f\t\u0005M\u0011Q\u0004\b\u0005\u0003+\tIBD\u00022\u0003/I!!\u0002\u0005\n\u0007\u0005m!+A\u0003vi&d7/\u0003\u0003\u0002 \u0005\u0005\u0012a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c(bAA\u000e%&!\u0011QEA\u0014\u0005E!UO]1uS>t7i\u001c8wKJ$XM\u001d\u0006\u0005\u0003?\t\t\u0003C\u0006\u0002,)\u0003\r\u00111A\u0005\u0002\u00055\u0012\u0001\u00027jgR,\"!a\f\u0011\u0007\r\u000b\t$C\u0002\u00024\u0011\u0013qAQ8pY\u0016\fg\u000eC\u0006\u00028)\u0003\r\u00111A\u0005\u0002\u0005e\u0012\u0001\u00037jgR|F%Z9\u0015\u0007)\fY\u0004C\u0005o\u0003k\t\t\u00111\u0001\u00020!A\u0011q\b&!B\u0013\ty#A\u0003mSN$\b\u0005\u000b\u0006\u0002>Id\u00181IA\u0003\u0003\u001bbC!!\u0012\u0002J\u0005\u0012\u0011qI\u0001\u0003[1\f#!a\u0013\u0002\r5jC.[:uC\t\ty%A\u0018MSN$\b%\u001a=jgRLgn\u001a\u0011bO\u0016lsN\u001a4!M>\u0014\b%\u0019\u0011tS6\u0004H.\u001a\u0011gK\u0006$XO]3!if\u0004X\rC\u0006\u0002T)\u0003\r\u00111A\u0005\u0002\u00055\u0012aA:fi\"Y\u0011q\u000b&A\u0002\u0003\u0007I\u0011AA-\u0003\u001d\u0019X\r^0%KF$2A[A.\u0011%q\u0017QKA\u0001\u0002\u0004\ty\u0003\u0003\u0005\u0002`)\u0003\u000b\u0015BA\u0018\u0003\u0011\u0019X\r\u001e\u0011)\u0015\u0005u#\u000f`A2\u0003\u000b\ti\u0007\f\u0003\u0002f\u0005%\u0014EAA4\u0003\ti3/\t\u0002\u0002l\u0005)Q&L:fi\u0006\u0012\u0011qN\u0001&'\u0016$\b%Y4f[=4g\r\t4pe\u0002\n\u0007e]5na2,\u0007EZ3biV\u0014X\r\t;za\u0016D1\"a\u001dK\u0001\u0004\u0005\r\u0011\"\u0001\u0002.\u00051!/Z7pm\u0016D1\"a\u001eK\u0001\u0004\u0005\r\u0011\"\u0001\u0002z\u0005Q!/Z7pm\u0016|F%Z9\u0015\u0007)\fY\bC\u0005o\u0003k\n\t\u00111\u0001\u00020!A\u0011q\u0010&!B\u0013\ty#A\u0004sK6|g/\u001a\u0011)\u0015\u0005u$\u000f`AB\u0003\u000b\ti\t\f\u0003\u0002\u0006\u0006%\u0015EAAD\u0003\ti#/\t\u0002\u0002\f\u0006AQ&\f:f[>4X-\t\u0002\u0002\u0010\u0006\t$+Z7pm\u0016\u0004S\r_5ti&tw\rI1hK6zgM\u001a\u0011g_J\u0004\u0013\rI:j[BdW\r\t4fCR,(/\u001a\u0011usB,\u0007f\u0002&\u0002\u0014\u0006e\u00151\u0014\t\u0004g\u0006U\u0015bAALi\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0003\u0003;\u000b!\u0007T5ti>\u001aX\r^\u0018sK6|g/\u001a\u0011bO\u0016lsN\u001a4!M>\u0014\b%\u0019\u0011HK>lUm]1!M\u0016\fG/\u001e:fAQL\b/\u001a\u0005\b\u0003C\u0003\u0001\u0015!\u0003-\u0003\u001d\u0001\u0018M]1ng\u0002Bq!!*\u0001\t\u0003\n9+A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003)Dq!a+\u0001\t\u0013\ti+\u0001\u0003fq\u0016\u001cGc\u00016\u00020\"A\u0011\u0011WAU\u0001\u0004\t\u0019,\u0001\u0002egB!\u0011QWA]\u001b\t\t9L\u0003\u0002\u0004\r%!\u00111XA\\\u0005E\t5mY;nk2|G)\u0019;b'R|'/\u001a")
public class AccumuloAgeOffCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final AccumuloAgeOffParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloAgeOffParams params() {
        return this.params;
    }

    public void execute() {
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{this.params().set(), this.params().remove(), this.params().list()}))).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$1) {
                return x$1;
            }
        }) != 1) {
            throw new ParameterException("Must specify exactly one of 'list', 'set' or 'remove'");
        }
        if (this.params().set() && this.params().expiry() == null) {
            throw new ParameterException("Must specify 'expiry' when setting age-off");
        }
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloAgeOffCommand $outer;

            public final void apply(AccumuloDataStore ds) {
                this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloAgeOffCommand$$exec(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$locationtech$geomesa$accumulo$tools$data$AccumuloAgeOffCommand$$exec(AccumuloDataStore ds) {
        ObjectRef mutable$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType '", "' does not exist in the data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()})));
        }
        if (this.params().list()) {
            package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute age-off: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DtgAgeOffIterator$.MODULE$.list(ds, sft).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "None";
                }
            })})));
            package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp age-off: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AgeOffIterator$.MODULE$.list(ds, sft).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "None";
                }
            })})));
        } else if (this.params().set() && this.params().dtgField() == null) {
            Object x$4;
            List x$3;
            String x$2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuring ingest-time-based age-off for schema '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with expiry ", ". Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().expiry()}))).toString();
            if (Prompt$.MODULE$.confirm(x$2, x$3 = Prompt$.MODULE$.confirm$default$2(), x$4 = Prompt$.MODULE$.confirm$default$3(x$2, x$3))) {
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.mutable$1(sft, mutable$lzy, bitmap$0)), (FeatureExpiration)new FeatureExpiration.IngestTimeExpiration(this.params().expiry()));
                ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
            }
        } else if (this.params().set()) {
            Object x$7;
            List x$6;
            String x$5 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuring attribute-based age-off for schema '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on field '", "' with expiry ", ". Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().dtgField(), this.params().expiry()}))).toString();
            if (Prompt$.MODULE$.confirm(x$5, x$6 = Prompt$.MODULE$.confirm$default$2(), x$7 = Prompt$.MODULE$.confirm$default$3(x$5, x$6))) {
                FeatureExpiration.FeatureTimeExpiration expiry = new FeatureExpiration.FeatureTimeExpiration(this.params().dtgField(), sft.indexOf(this.params().dtgField()), this.params().expiry());
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.mutable$1(sft, mutable$lzy, bitmap$0)), (FeatureExpiration)expiry);
                ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
            }
        } else {
            Object x$10;
            List x$9;
            String x$8 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing age-off for schema '", "'. Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}));
            if (Prompt$.MODULE$.confirm(x$8, x$9 = Prompt$.MODULE$.confirm$default$2(), x$10 = Prompt$.MODULE$.confirm$default$3(x$8, x$9))) {
                if (this.mutable$1(sft, mutable$lzy, bitmap$0).getUserData().remove(SimpleFeatureTypes.Configs$.MODULE$.FeatureExpiration()) == null) {
                    AgeOffIterator$.MODULE$.clear(ds, sft);
                    DtgAgeOffIterator$.MODULE$.clear(ds, sft);
                } else {
                    ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
                }
            }
        }
    }

    private final SimpleFeatureType mutable$lzycompute$1(SimpleFeatureType sft$1, ObjectRef mutable$lzy$1, VolatileByteRef bitmap$0$1) {
        AccumuloAgeOffCommand accumuloAgeOffCommand = this;
        synchronized (accumuloAgeOffCommand) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                mutable$lzy$1.elem = SimpleFeatureTypes$.MODULE$.mutable(sft$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SimpleFeatureType)mutable$lzy$1.elem;
        }
    }

    private final SimpleFeatureType mutable$1(SimpleFeatureType sft$1, ObjectRef mutable$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.mutable$lzycompute$1(sft$1, mutable$lzy$1, bitmap$0$1) : (SimpleFeatureType)mutable$lzy$1.elem;
    }

    public AccumuloAgeOffCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.name = "configure-age-off";
        this.params = new AccumuloAgeOffParams();
    }

    @Parameters(commandDescription="List/set/remove age-off for a GeoMesa feature type")
    public static class AccumuloAgeOffParams
    implements AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalDtgParam {
        @Parameter(names={"-e", "--expiry"}, description="Duration before entries are aged-off, e.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration expiry;
        @Parameter(names={"-l", "--list"}, description="List existing age-off for a simple feature type")
        private boolean list;
        @Parameter(names={"-s", "--set"}, description="Set age-off for a simple feature type")
        private boolean set;
        @Parameter(names={"-r", "--remove"}, description="Remove existing age-off for a simple feature type")
        private boolean remove;
        @Parameter(names={"--dtg"}, description="DateTime field name to use as the default dtg")
        private String dtgField;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;

        public String dtgField() {
            return this.dtgField;
        }

        public void dtgField_$eq(String x$1) {
            this.dtgField = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        @TraitSetter
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public void expiry_$eq(Duration x$1) {
            this.expiry = x$1;
        }

        public boolean list() {
            return this.list;
        }

        public void list_$eq(boolean x$1) {
            this.list = x$1;
        }

        public boolean set() {
            return this.set;
        }

        public void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public boolean remove() {
            return this.remove;
        }

        public void remove_$eq(boolean x$1) {
            this.remove = x$1;
        }

        public AccumuloAgeOffParams() {
            ZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalDtgParam.class.$init$((OptionalDtgParam)this);
        }
    }
}

