/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.Collections;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.LineStringFloatVector;
import org.locationtech.geomesa.arrow.vector.LineStringVector;
import org.locationtech.geomesa.arrow.vector.MultiLineStringFloatVector;
import org.locationtech.geomesa.arrow.vector.MultiLineStringVector;
import org.locationtech.geomesa.arrow.vector.MultiPointFloatVector;
import org.locationtech.geomesa.arrow.vector.MultiPointVector;
import org.locationtech.geomesa.arrow.vector.MultiPolygonFloatVector;
import org.locationtech.geomesa.arrow.vector.MultiPolygonVector;
import org.locationtech.geomesa.arrow.vector.PointFloatVector;
import org.locationtech.geomesa.arrow.vector.PointVector;
import org.locationtech.geomesa.arrow.vector.PolygonFloatVector;
import org.locationtech.geomesa.arrow.vector.PolygonVector;
import org.locationtech.geomesa.arrow.vector.WKBGeometryVector;

public class GeometryFields {
    public static ArrowType FLOAT_TYPE = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
    public static ArrowType DOUBLE_TYPE = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
    public static List<Field> XY_FLOAT = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)FLOAT_TYPE), null));
    public static List<Field> XY_DOUBLE = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)DOUBLE_TYPE), null));
    public static List<Field> XY_FLOAT_LIST = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), XY_FLOAT));
    public static List<Field> XY_DOUBLE_LIST = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), XY_DOUBLE));
    public static List<Field> XY_FLOAT_LIST_2 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_FLOAT_LIST));
    public static List<Field> XY_DOUBLE_LIST_2 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_DOUBLE_LIST));
    public static List<Field> XY_FLOAT_LIST_3 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_FLOAT_LIST_2));
    public static List<Field> XY_DOUBLE_LIST_3 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_DOUBLE_LIST_2));

    private GeometryFields() {
    }

    public static GeometryVector<?, ?> wrap(FieldVector vector) {
        List fields = vector.getField().getChildren();
        if (fields.equals(PointFloatVector.fields)) {
            return new PointFloatVector((FixedSizeListVector)vector);
        }
        if (fields.equals(LineStringFloatVector.fields)) {
            return new LineStringFloatVector((ListVector)vector);
        }
        if (fields.equals(PolygonFloatVector.fields)) {
            return new PolygonFloatVector((ListVector)vector);
        }
        if (fields.equals(MultiPolygonFloatVector.fields)) {
            return new MultiPolygonFloatVector((ListVector)vector);
        }
        if (fields.equals(MultiLineStringFloatVector.fields)) {
            return new MultiLineStringFloatVector((ListVector)vector);
        }
        if (fields.equals(MultiPointFloatVector.fields)) {
            return new MultiPointFloatVector((ListVector)vector);
        }
        if (fields.equals(PointVector.fields)) {
            return new PointVector((FixedSizeListVector)vector);
        }
        if (fields.equals(LineStringVector.fields)) {
            return new LineStringVector((ListVector)vector);
        }
        if (fields.equals(PolygonVector.fields)) {
            return new PolygonVector((ListVector)vector);
        }
        if (fields.equals(MultiPolygonVector.fields)) {
            return new MultiPolygonVector((ListVector)vector);
        }
        if (fields.equals(MultiLineStringVector.fields)) {
            return new MultiLineStringVector((ListVector)vector);
        }
        if (fields.equals(MultiPointVector.fields)) {
            return new MultiPointVector((ListVector)vector);
        }
        if (fields.isEmpty()) {
            return new WKBGeometryVector((VarBinaryVector)vector);
        }
        throw new IllegalArgumentException("Vector " + vector + " does not match any geometry type");
    }

    public static FloatingPointPrecision precisionFromField(Field field) {
        Field toCheck = field;
        while (true) {
            ArrowType type;
            if ((type = toCheck.getType()) instanceof ArrowType.FloatingPoint) {
                return ((ArrowType.FloatingPoint)type).getPrecision();
            }
            if (!(type instanceof ArrowType.FixedSizeList) && !(type instanceof ArrowType.List)) break;
            toCheck = (Field)toCheck.getChildren().get(0);
        }
        return null;
    }
}

