/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.jts.impl;

import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.jts.impl.AbstractGeometryVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public abstract class AbstractLineStringVector<T extends FieldVector>
extends AbstractGeometryVector<LineString, ListVector, T> {
    private final FixedSizeListVector tuples;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractLineStringVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractLineStringVector.createFieldType(metadata), null));
    }

    protected AbstractLineStringVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractLineStringVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractLineStringVector(ListVector vector) {
        super(vector);
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.tuples = (FixedSizeListVector)vector.getChildrenFromFields().get(0);
        this.setOrdinalVector((FieldVector)this.tuples.getChildrenFromFields().get(0));
    }

    @Override
    public void set(int index, LineString geom) {
        if (((ListVector)this.vector).getLastSet() >= index) {
            ((ListVector)this.vector).setLastSet(index - 1);
        }
        int position = ((ListVector)this.vector).startNewValue(index);
        if (geom == null) {
            ((ListVector)this.vector).endValue(index, 0);
            BitVectorHelper.setValidityBit((ArrowBuf)((ListVector)this.vector).getValidityBuffer(), (int)index, (int)0);
        } else {
            for (int i = 0; i < geom.getNumPoints(); ++i) {
                Coordinate p = geom.getCoordinateN(i);
                this.tuples.setNotNull(position + i);
                this.writeOrdinal((position + i) * 2, p.y);
                this.writeOrdinal((position + i) * 2 + 1, p.x);
            }
            ((ListVector)this.vector).endValue(index, geom.getNumPoints());
        }
    }

    @Override
    public LineString get(int index) {
        if (((ListVector)this.vector).isNull(index)) {
            return null;
        }
        int offsetStart = ((ListVector)this.vector).getOffsetBuffer().getInt((long)(index * 4));
        int offsetEnd = ((ListVector)this.vector).getOffsetBuffer().getInt((long)((index + 1) * 4));
        Coordinate[] coordinates = new Coordinate[offsetEnd - offsetStart];
        for (int i = 0; i < coordinates.length; ++i) {
            double y = this.readOrdinal((offsetStart + i) * 2);
            double x = this.readOrdinal((offsetStart + i) * 2 + 1);
            coordinates[i] = new Coordinate(x, y);
        }
        return factory.createLineString(coordinates);
    }

    public int getStartOffset(int index) {
        return ((ListVector)this.vector).getOffsetBuffer().getInt((long)(index * 4));
    }

    public int getEndOffset(int index) {
        return ((ListVector)this.vector).getOffsetBuffer().getInt((long)((index + 1) * 4));
    }

    public double getCoordinateY(int offset) {
        return this.readOrdinal(offset * 2);
    }

    public double getCoordinateX(int offset) {
        return this.readOrdinal(offset * 2 + 1);
    }
}

