/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.jts.impl;

import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.jts.impl.AbstractGeometryVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public abstract class AbstractPolygonVector<T extends FieldVector>
extends AbstractGeometryVector<Polygon, ListVector, T> {
    private final ListVector innerVector;
    private final FixedSizeListVector tuples;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractPolygonVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractPolygonVector.createFieldType(metadata), null));
    }

    protected AbstractPolygonVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractPolygonVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractPolygonVector(ListVector vector) {
        super(vector);
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.innerVector = (ListVector)vector.getChildrenFromFields().get(0);
        this.tuples = (FixedSizeListVector)this.innerVector.getChildrenFromFields().get(0);
        this.setOrdinalVector((FieldVector)this.tuples.getChildrenFromFields().get(0));
    }

    @Override
    public void set(int index, Polygon geom) {
        if (((ListVector)this.vector).getLastSet() >= index) {
            ((ListVector)this.vector).setLastSet(index - 1);
            this.innerVector.setLastSet(index - 1);
        }
        int innerIndex = ((ListVector)this.vector).startNewValue(index);
        if (geom == null) {
            ((ListVector)this.vector).endValue(index, 0);
            BitVectorHelper.setValidityBit((ArrowBuf)((ListVector)this.vector).getValidityBuffer(), (int)index, (int)0);
        } else {
            for (int i = 0; i < geom.getNumInteriorRing() + 1; ++i) {
                LinearRing line = i == 0 ? geom.getExteriorRing() : geom.getInteriorRingN(i - 1);
                int position = this.innerVector.startNewValue(innerIndex + i);
                for (int j = 0; j < line.getNumPoints(); ++j) {
                    Coordinate p = line.getCoordinateN(j);
                    this.tuples.setNotNull(position + j);
                    this.writeOrdinal((position + j) * 2, p.y);
                    this.writeOrdinal((position + j) * 2 + 1, p.x);
                }
                this.innerVector.endValue(innerIndex + i, line.getNumPoints());
            }
            ((ListVector)this.vector).endValue(index, geom.getNumInteriorRing() + 1);
        }
    }

    @Override
    public Polygon get(int index) {
        if (((ListVector)this.vector).isNull(index)) {
            return null;
        }
        int outerOffsetStart = ((ListVector)this.vector).getOffsetBuffer().getInt((long)(index * 4));
        int outerOffsetEnd = ((ListVector)this.vector).getOffsetBuffer().getInt((long)((index + 1) * 4));
        LinearRing shell = null;
        LinearRing[] holes = new LinearRing[outerOffsetEnd - outerOffsetStart - 1];
        for (int j = 0; j < holes.length + 1; ++j) {
            int offsetStart = this.innerVector.getOffsetBuffer().getInt((long)((outerOffsetStart + j) * 4));
            int offsetEnd = this.innerVector.getOffsetBuffer().getInt((long)((outerOffsetStart + j + 1) * 4));
            Coordinate[] coordinates = new Coordinate[offsetEnd - offsetStart];
            for (int i = 0; i < coordinates.length; ++i) {
                double y = this.readOrdinal((offsetStart + i) * 2);
                double x = this.readOrdinal((offsetStart + i) * 2 + 1);
                coordinates[i] = new Coordinate(x, y);
            }
            LinearRing ring = factory.createLinearRing(coordinates);
            if (j == 0) {
                shell = ring;
                continue;
            }
            holes[j - 1] = ring;
        }
        return factory.createPolygon(shell, holes);
    }
}

