/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.jts;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.jts.GeometryVector;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class WKBGeometryVector
implements GeometryVector<Geometry, VarBinaryVector> {
    private VarBinaryVector vector;
    private WKBWriter writer = null;
    private WKBReader reader = null;
    public static final Field field = Field.nullablePrimitive((String)"wkb", (ArrowType.PrimitiveType)ArrowType.Binary.INSTANCE);

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.Binary.INSTANCE, null, metadata);
    }

    public WKBGeometryVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        this.vector = new VarBinaryVector(name, WKBGeometryVector.createFieldType(metadata), allocator);
    }

    public WKBGeometryVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        this.vector = (VarBinaryVector)container.addOrGet(name, WKBGeometryVector.createFieldType(metadata), VarBinaryVector.class);
    }

    public WKBGeometryVector(VarBinaryVector vector) {
        this.vector = vector;
    }

    @Override
    public void set(int i, Geometry geom) {
        if (geom == null) {
            this.vector.setNull(i);
        } else {
            if (this.writer == null) {
                this.writer = new WKBWriter();
            }
            this.vector.setSafe(i, this.writer.write(geom));
        }
    }

    @Override
    public Geometry get(int i) {
        if (this.vector.isNull(i)) {
            return null;
        }
        Geometry geometry = null;
        try {
            if (this.reader == null) {
                this.reader = new WKBReader();
            }
            geometry = this.reader.read(this.vector.get(i));
        }
        catch (ParseException exception) {
            throw new RuntimeException(exception);
        }
        return geometry;
    }

    @Override
    public VarBinaryVector getVector() {
        return this.vector;
    }

    @Override
    public void setValueCount(int count) {
        this.vector.setValueCount(count);
    }

    @Override
    public int getValueCount() {
        return this.vector.getValueCount();
    }

    @Override
    public int getNullCount() {
        int count = this.vector.getNullCount();
        return Math.max(count, 0);
    }

    @Override
    public void transfer(int fromIndex, int toIndex, GeometryVector<Geometry, VarBinaryVector> to) {
        to.set(toIndex, this.get(fromIndex));
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }
}

