/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.jts.impl;

import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.jts.GeometryVector;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractGeometryVector<T extends Geometry, U extends FieldVector, V extends FieldVector>
implements GeometryVector<T, U> {
    private V ordinal;
    protected U vector;

    protected AbstractGeometryVector(U vector) {
        this.vector = vector;
    }

    @Override
    public U getVector() {
        return this.vector;
    }

    @Override
    public void transfer(int fromIndex, int toIndex, GeometryVector<T, U> to) {
        to.set(toIndex, this.get(fromIndex));
    }

    @Override
    public void setValueCount(int count) {
        this.vector.setValueCount(count);
    }

    @Override
    public int getValueCount() {
        return this.vector.getValueCount();
    }

    @Override
    public int getNullCount() {
        int count = this.vector.getNullCount();
        return Math.max(count, 0);
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    protected void setOrdinalVector(V ordinal) {
        this.ordinal = ordinal;
    }

    protected V getOrdinalVector() {
        return this.ordinal;
    }

    protected abstract List<Field> getFields();

    protected abstract void writeOrdinal(int var1, double var2);

    protected abstract double readOrdinal(int var1);
}

