/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.locationtech.geomesa.convert.avro.AvroPath;
import org.locationtech.geomesa.utils.text.BasicParser;
import org.parboiled.errors.ParsingException;
import org.parboiled.scala.ParsingResult;
import org.parboiled.scala.package$;
import org.parboiled.scala.parserunners.BasicParseRunner$;
import org.parboiled.scala.parserunners.ReportingParseRunner;
import org.parboiled.scala.parserunners.ReportingParseRunner$;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag$;

public final class AvroPath$
extends BasicParser {
    public static AvroPath$ MODULE$;
    private final AvroPath.AvroPathParser Parser;

    static {
        new AvroPath$();
    }

    private AvroPath.AvroPathParser Parser() {
        return this.Parser;
    }

    public AvroPath apply(String path) {
        return this.parse(path, this.parse$default$2());
    }

    public AvroPath parse(String path, boolean report) throws ParsingException {
        if (path == null) {
            throw new IllegalArgumentException("Invalid path string: null");
        }
        ReportingParseRunner runner = report ? ReportingParseRunner$.MODULE$.apply(this.Parser().path()) : BasicParseRunner$.MODULE$.apply(this.Parser().path());
        ParsingResult parsing = runner.run(package$.MODULE$.string2Input(path));
        return (AvroPath)parsing.result().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ParsingException(new StringBuilder(25).append("Error parsing avro path: ").append(path).toString());
        });
    }

    public boolean parse$default$2() {
        return true;
    }

    public Object org$locationtech$geomesa$convert$avro$AvroPath$$convert(Object record) {
        Object object = record;
        if (object instanceof Utf8) {
            Utf8 utf8 = (Utf8)object;
            return utf8.toString();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            return this.convertBytes(byteBuffer);
        }
        if (object instanceof GenericFixed) {
            GenericFixed genericFixed = (GenericFixed)object;
            return genericFixed.bytes();
        }
        if (object instanceof GenericEnumSymbol) {
            GenericEnumSymbol genericEnumSymbol = (GenericEnumSymbol)object;
            return genericEnumSymbol.toString();
        }
        if (object instanceof GenericArray) {
            GenericArray genericArray = (GenericArray)object;
            return this.convertList((List<Object>)genericArray);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.convertMap(map);
        }
        return object;
    }

    private byte[] convertBytes(ByteBuffer x) {
        int start = x.position();
        int length = x.limit() - start;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
        x.get(bytes, 0, length);
        x.position(start);
        return bytes;
    }

    private List<Object> convertList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            result.add(this.org$locationtech$geomesa$convert$avro$AvroPath$$convert(iter.next()));
        }
        return result;
    }

    private Map<String, Object> convertMap(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put((String)this.org$locationtech$geomesa$convert$avro$AvroPath$$convert(entry.getKey()), this.org$locationtech$geomesa$convert$avro$AvroPath$$convert(entry.getValue()));
        }
        return result;
    }

    private AvroPath$() {
        MODULE$ = this;
        this.Parser = new AvroPath.AvroPathParser();
    }
}

