/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.convert.json.JsonConverter$;
import org.locationtech.geomesa.convert2.transforms.CollectionFunctionFactory;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u00111CS:p]\u001a+hn\u0019;j_:4\u0015m\u0019;pefT!a\u0001\u0003\u0002\t)\u001cxN\u001c\u0006\u0003\u000b\u0019\tqaY8om\u0016\u0014HO\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003)!(/\u00198tM>\u0014Xn\u001d\u0006\u00033\u0019\t\u0001bY8om\u0016\u0014HOM\u0005\u00037Y\u0011!\u0004\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:4\u0015m\u0019;pef\u0004\"!H\u0017\u000f\u0005yYcBA\u0010+\u001d\t\u0001\u0013F\u0004\u0002\"Q9\u0011!e\n\b\u0003G\u0019j\u0011\u0001\n\u0006\u0003K1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tIb!\u0003\u0002\u00181%\u0011AFF\u0001\u001a\u0007>dG.Z2uS>tg)\u001e8di&|gNR1di>\u0014\u00180\u0003\u0002/_\t\t2i\u001c7mK\u000e$\u0018n\u001c8QCJ\u001c\u0018N\\4\u000b\u000512\u0002\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u0003\u0011\u001d1\u0004A1A\u0005\n]\nAaZ:p]V\t\u0001\b\u0005\u0002:\u007f5\t!H\u0003\u00027w)\u0011A(P\u0001\u0007O>|w\r\\3\u000b\u0003y\n1aY8n\u0013\t\u0001%H\u0001\u0003Hg>t\u0007B\u0002\"\u0001A\u0003%\u0001(A\u0003hg>t\u0007\u0005C\u0003E\u0001\u0011\u0005S)A\u0005gk:\u001cG/[8ogV\ta\tE\u0002H\u0019>s!\u0001\u0013&\u000f\u0005\rJ\u0015\"A\t\n\u0005-\u0003\u0012a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0003\u0005\u0002\u0016!&\u0011\u0011K\u0006\u0002\u0014)J\fgn\u001d4pe6,'OR;oGRLwN\u001c\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u00031Q7o\u001c8U_N#(/\u001b8h+\u0005y\u0005\u0006\u0002*W3n\u0003\"aD,\n\u0005a\u0003\"A\u00033faJ,7-\u0019;fI\u0006\n!,\u0001\u0007vg\u0016\u0004Co\\*ue&tw-M\u0003$9\u000e<G\r\u0005\u0002^A:\u0011qBX\u0005\u0003?B\ta\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\fE\u0005\u0003I\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$B\u00014\u0011\u0003)!W\r\u001d:fG\u0006$X\rZ\u0019\u0006G!L'N\u001a\b\u0003\u001f%L!A\u001a\t2\t\tz\u0001c\u001b\u0002\u0006g\u000e\fG.\u0019\u0005\u0007[\u0002\u0001\u000b\u0011B(\u0002\u001b)\u001cxN\u001c+p'R\u0014\u0018N\\4!\u0011\u001dy\u0007A1A\u0005\nQ\u000b\u0001B[:p]B\u000bG\u000f\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B(\u0002\u0013)\u001cxN\u001c)bi\"\u0004\u0003bB:\u0001\u0005\u0004%I\u0001V\u0001\u000fUN|g\u000eT5tiB\u000b'o]3s\u0011\u0019)\b\u0001)A\u0005\u001f\u0006y!n]8o\u0019&\u001cH\u000fU1sg\u0016\u0014\b\u0005C\u0004x\u0001\t\u0007I\u0011\u0002+\u0002\u001b)\u001cxN\\'baB\u000b'o]3s\u0011\u0019I\b\u0001)A\u0005\u001f\u0006q!n]8o\u001b\u0006\u0004\b+\u0019:tKJ\u0004\u0003bB>\u0001\u0005\u0004%I\u0001V\u0001\n[\u0006\u0004Hk\u001c&t_:Da! \u0001!\u0002\u0013y\u0015AC7baR{'j]8oA!9q\u0010\u0001b\u0001\n\u0013!\u0016!\u00056t_:\f%O]1z)>|%M[3di\"9\u00111\u0001\u0001!\u0002\u0013y\u0015A\u00056t_:\f%O]1z)>|%M[3di\u0002B\u0001\"a\u0002\u0001\u0005\u0004%I\u0001V\u0001\u000e]\u0016<(j]8o\u001f\nTWm\u0019;\t\u000f\u0005-\u0001\u0001)A\u0005\u001f\u0006qa.Z<Kg>twJ\u00196fGR\u0004\u0003\u0002CA\b\u0001\t\u0007I\u0011\u0002+\u0002\u0017\u0015l\u0007\u000f^=U_:+H\u000e\u001c\u0005\b\u0003'\u0001\u0001\u0015!\u0003P\u00031)W\u000e\u001d;z)>tU\u000f\u001c7!\u0011\u001d\t9\u0002\u0001C\u0005\u00033\tAbZ3u!JLW.\u001b;jm\u0016$B!a\u0007\u0002\"A\u0019q\"!\b\n\u0007\u0005}\u0001CA\u0002B]fD\u0001\"a\t\u0002\u0016\u0001\u0007\u0011QE\u0001\u0002aB\u0019\u0011(a\n\n\u0007\u0005%\"HA\u0007Kg>t\u0007K]5nSRLg/\u001a")
public class JsonFunctionFactory
implements TransformerFunctionFactory,
CollectionFunctionFactory.CollectionParsing {
    private final Gson org$locationtech$geomesa$convert$json$JsonFunctionFactory$$gson;
    private final TransformerFunction jsonToString;
    private final TransformerFunction jsonPath;
    private final TransformerFunction jsonListParser;
    private final TransformerFunction jsonMapParser;
    private final TransformerFunction mapToJson;
    private final TransformerFunction jsonArrayToObject;
    private final TransformerFunction newJsonObject;
    private final TransformerFunction emptyToNull;

    public Object convert(Object value, Class<?> clazz) {
        return CollectionFunctionFactory.CollectionParsing.class.convert((CollectionFunctionFactory.CollectionParsing)this, (Object)value, clazz);
    }

    public Class<?> determineClazz(String s) {
        return CollectionFunctionFactory.CollectionParsing.class.determineClazz((CollectionFunctionFactory.CollectionParsing)this, (String)s);
    }

    public Gson org$locationtech$geomesa$convert$json$JsonFunctionFactory$$gson() {
        return this.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$gson;
    }

    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.jsonToString(), this.jsonListParser(), this.jsonMapParser(), this.mapToJson(), this.jsonPath(), this.jsonArrayToObject(), this.newJsonObject(), this.emptyToNull()}));
    }

    private TransformerFunction jsonToString() {
        return this.jsonToString;
    }

    private TransformerFunction jsonPath() {
        return this.jsonPath;
    }

    private TransformerFunction jsonListParser() {
        return this.jsonListParser;
    }

    private TransformerFunction jsonMapParser() {
        return this.jsonMapParser;
    }

    private TransformerFunction mapToJson() {
        return this.mapToJson;
    }

    private TransformerFunction jsonArrayToObject() {
        return this.jsonArrayToObject;
    }

    private TransformerFunction newJsonObject() {
        return this.newJsonObject;
    }

    private TransformerFunction emptyToNull() {
        return this.emptyToNull;
    }

    public Object org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(JsonPrimitive p) {
        return p.isBoolean() ? BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean()) : p.getAsString();
    }

    public JsonFunctionFactory() {
        CollectionFunctionFactory.CollectionParsing.class.$init$((CollectionFunctionFactory.CollectionParsing)this);
        this.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$gson = new Gson();
        this.jsonToString = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonToString", "json2string"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return args[0].toString();
            }
        });
        this.jsonPath = new TransformerFunction.NamedTransformerFunction(this){
            private final ConcurrentHashMap<Object, JsonPath> cache;

            private ConcurrentHashMap<Object, JsonPath> cache() {
                return this.cache;
            }

            public Object apply(Object[] args) {
                JsonPrimitive p;
                BoxedUnit boxedUnit;
                JsonPath path = this.cache().get(args[0]);
                if (path == null) {
                    path = JsonPath.compile((String)((String)args[0]), (Predicate[])new Predicate[0]);
                    boxedUnit = this.cache().put(args[0], path);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                JsonElement elem = (JsonElement)path.read(args[1], JsonConverter$.MODULE$.JsonConfiguration());
                Object object = elem.isJsonNull() ? null : (elem.isJsonPrimitive() ? ((p = elem.getAsJsonPrimitive()).isString() ? p.getAsString() : (p.isNumber() ? p.getAsNumber() : (p.isBoolean() ? BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean()) : p.getAsString()))) : elem);
                return object;
            }
            {
                this.cache = new ConcurrentHashMap<K, V>();
            }
        };
        this.jsonListParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonList"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionFactory $outer;

            public final Object apply(Object[] args) {
                ArrayList<Object> arrayList;
                JsonArray array = (JsonArray)args[1];
                if (array == null || array.isJsonNull()) {
                    arrayList = null;
                } else {
                    Class<?> clazz = this.$outer.determineClazz((String)args[0]);
                    ArrayList<Object> result = new ArrayList<Object>(array.size());
                    for (JsonElement e : array) {
                        Object object = e.isJsonNull() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)result.add(this.$outer.convert(this.$outer.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(e.getAsJsonPrimitive()), clazz)));
                    }
                    arrayList = result;
                }
                return arrayList;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.jsonMapParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonMap"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionFactory $outer;

            public final Object apply(Object[] args) {
                HashMap<Object, Object> hashMap;
                Class<?> kClass = this.$outer.determineClazz((String)args[0]);
                Class<?> vClass = this.$outer.determineClazz((String)args[1]);
                JsonObject map = (JsonObject)args[2];
                if (map == null || map.isJsonNull()) {
                    hashMap = null;
                } else {
                    HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
                    for (Map.Entry e : map.entrySet()) {
                        result.put(this.$outer.convert(e.getKey(), kClass), this.$outer.convert(this.$outer.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$getPrimitive(((JsonElement)e.getValue()).getAsJsonPrimitive()), vClass));
                    }
                    hashMap = result;
                }
                return hashMap;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.mapToJson = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"map2Json", "mapToJson"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                Map map = (Map)args[0];
                scala.collection.immutable.Map ast = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(Object x0$1) {
                        JsonAST.JNull$ jNull$;
                        Object object = x0$1;
                        if (object == null) {
                            jNull$ = JsonAST.JNull$.MODULE$;
                        } else if (object instanceof Integer) {
                            int n = BoxesRunTime.unboxToInt((Object)object);
                            jNull$ = package$.MODULE$.JInt().apply(BigInt$.MODULE$.int2bigInt(n));
                        } else if (object instanceof Long) {
                            long l = BoxesRunTime.unboxToLong((Object)object);
                            jNull$ = package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(l));
                        } else if (object instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)object);
                            jNull$ = package$.MODULE$.JDouble().apply(d);
                        } else if (object instanceof Float) {
                            float f = BoxesRunTime.unboxToFloat((Object)object);
                            jNull$ = package$.MODULE$.JDouble().apply((double)f);
                        } else if (object instanceof Boolean) {
                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                            jNull$ = package$.MODULE$.JBool().apply(bl);
                        } else if (object instanceof String) {
                            String string = (String)object;
                            jNull$ = package$.MODULE$.JString().apply(string);
                        } else {
                            jNull$ = package$.MODULE$.JString().apply(object.toString());
                        }
                        return jNull$;
                    }
                }).toMap(Predef$.MODULE$.$conforms());
                JsonAST.JObject x$2 = JsonDSL$.MODULE$.map2jvalue(ast, (Function1)Predef$.MODULE$.$conforms());
                Formats x$3 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$2);
                return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$2, x$3));
            }
        });
        this.jsonArrayToObject = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonArrayToObject"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Object apply(Object[] args) {
                Object v0;
                JsonArray array = (JsonArray)args[0];
                if (array == null || array.isJsonNull()) {
                    v0 = null;
                } else {
                    void var3_3;
                    JsonObject obj = new JsonObject();
                    for (int i = 0; i < array.size(); ++i) {
                        obj.add(Integer.toString(i), array.get(i));
                    }
                    v0 = var3_3;
                }
                return v0;
            }
        });
        this.newJsonObject = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"newJsonObject"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionFactory $outer;

            /*
             * WARNING - void declaration
             */
            public final JsonObject apply(Object[] args) {
                void var2_2;
                JsonObject obj = new JsonObject();
                for (int i = 1; i < args.length; i += 2) {
                    BoxedUnit boxedUnit;
                    String key = args[i - 1].toString();
                    Object object = args[i];
                    if (object == null) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (object instanceof JsonElement) {
                        JsonElement jsonElement = (JsonElement)object;
                        obj.add(key, jsonElement);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (object instanceof String) {
                        String string = (String)object;
                        obj.add(key, (JsonElement)new JsonPrimitive(string));
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (object instanceof Number) {
                        Number number = (Number)object;
                        obj.add(key, (JsonElement)new JsonPrimitive(number));
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (object instanceof Boolean) {
                        boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                        obj.add(key, (JsonElement)new JsonPrimitive(Predef$.MODULE$.boolean2Boolean(bl)));
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (object instanceof Date) {
                        Date date = (Date)object;
                        obj.add(key, (JsonElement)new JsonPrimitive(DateParsing$.MODULE$.formatDate(date, DateParsing$.MODULE$.formatDate$default$2())));
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    obj.add(key, this.$outer.org$locationtech$geomesa$convert$json$JsonFunctionFactory$$gson().toJsonTree(object));
                    boxedUnit = BoxedUnit.UNIT;
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.emptyToNull = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emptyJsonToNull"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Object[] args) {
                boolean bl = false;
                JsonObject jsonObject = null;
                Object object = args[0];
                JsonNull jsonNull = JsonNull.INSTANCE;
                Object object2 = object;
                if (jsonNull == null) {
                    if (object2 == null) return null;
                } else if (jsonNull.equals(object2)) {
                    return null;
                }
                if (object instanceof JsonObject) {
                    bl = true;
                    jsonObject = (JsonObject)object;
                    if (jsonObject.size() == 0) {
                        return null;
                    }
                }
                if (bl && ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(jsonObject.entrySet()).asScala()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Map.Entry<String, JsonElement> x$1) {
                        JsonElement jsonElement = x$1.getValue();
                        JsonNull jsonNull = JsonNull.INSTANCE;
                        return !(jsonElement != null ? !jsonElement.equals(jsonNull) : jsonNull != null);
                    }
                })) {
                    return null;
                }
                if (!(object instanceof JsonArray)) return object;
                JsonArray jsonArray = (JsonArray)object;
                if (jsonArray.size() != 0) return object;
                return null;
            }
        });
    }
}

