/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert.json.GeoJsonParsing;
import org.locationtech.geomesa.convert.json.GeoJsonParsing$;
import org.locationtech.geomesa.convert.json.JsonConverter;
import org.locationtech.geomesa.convert.json.JsonConverter$;
import org.locationtech.geomesa.convert.json.JsonConverterFactory$;
import org.locationtech.geomesa.convert.json.JsonConverterFactory$JsonConfigConvert$;
import org.locationtech.geomesa.convert.json.JsonConverterFactory$JsonFieldConvert$;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.AbstractConverterFactory;
import org.locationtech.geomesa.convert2.AbstractConverterFactory$;
import org.locationtech.geomesa.convert2.TypeInference;
import org.locationtech.geomesa.convert2.TypeInference$;
import org.locationtech.geomesa.convert2.package;
import org.locationtech.geomesa.convert2.transforms.Expression;
import org.locationtech.geomesa.convert2.transforms.Expression$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u000f\u001f\u0001%BQ\u0001\u0016\u0001\u0005\u0002UCQa\u0016\u0001\u0005BaCaa\u0016\u0001\u0005B\u0005\u0005\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\ty\t\u0001C\u0005\u0003#;q!!*\u001f\u0011\u0003\t9K\u0002\u0004\u001e=!\u0005\u0011\u0011\u0016\u0005\u0007)\"!\t!a+\t\u0013\u00055\u0006B1A\u0005\u0002\u0005=\u0006\u0002CA^\u0011\u0001\u0006I!!-\t\u0013\u0005u\u0006B1A\u0005\u0002\u0005=\u0006\u0002CA`\u0011\u0001\u0006I!!-\t\u0013\u0005\u0005\u0007B1A\u0005\n\u0005=\u0006\u0002CAb\u0011\u0001\u0006I!!-\b\u000f\u0005\u0015\u0007\u0002#\u0001\u0002H\u001a9\u00111\u001a\u0005\t\u0002\u00055\u0007B\u0002+\u0012\t\u0003\t\u0019\u000fC\u0004\u0002fF!\t&a:\t\u000f\t5\u0012\u0003\"\u0015\u00030\u001d9!Q\t\u0005\t\u0002\t\u001dca\u0002B%\u0011!\u0005!1\n\u0005\u0007)Z!\tAa\u0015\t\u000f\tUc\u0003\"\u0015\u0003X!9!Q\r\f\u0005R\t\u001ddA\u0002B8\u0011\u0011\u0011\t\b\u0003\u0004U5\u0011\u0005!\u0011\u0010\u0005\b\u0005{RB\u0011\tB@\u0005QQ5o\u001c8D_:4XM\u001d;fe\u001a\u000b7\r^8ss*\u0011q\u0004I\u0001\u0005UN|gN\u0003\u0002\"E\u000591m\u001c8wKJ$(BA\u0012%\u0003\u001d9Wm\\7fg\u0006T!!\n\u0014\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\r-r\u0003\u0007\u000e%L\u001b\u0005a#BA\u0017#\u0003!\u0019wN\u001c<feR\u0014\u0014BA\u0018-\u0005a\t%m\u001d;sC\u000e$8i\u001c8wKJ$XM\u001d$bGR|'/\u001f\t\u0003cIj\u0011AH\u0005\u0003gy\u0011QBS:p]\u000e{gN^3si\u0016\u0014\bCA\u001bF\u001d\t14I\u0004\u00028\u0005:\u0011\u0001(\u0011\b\u0003s\u0001s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005uB\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\t)c%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001J!\u0001\u0012\u0010\u0002\u001b)\u001bxN\\\"p]Z,'\u000f^3s\u0013\t1uI\u0001\u0006Kg>t7i\u001c8gS\u001eT!\u0001\u0012\u0010\u0011\u0005UJ\u0015B\u0001&H\u0005%Q5o\u001c8GS\u0016dG\r\u0005\u0002M#:\u0011Qj\u0014\b\u0003q9K!!\f\u0012\n\u0005Ac\u0013!E!cgR\u0014\u0018m\u0019;D_:4XM\u001d;fe&\u0011!k\u0015\u0002\r\u0005\u0006\u001c\u0018nY(qi&|gn\u001d\u0006\u0003!2\na\u0001P5oSRtD#\u0001,\u0011\u0005E\u0002\u0011!B5oM\u0016\u0014HCB-y\u0003\u000b\tY\u0001E\u0002[;~k\u0011a\u0017\u0006\u00029\u0006)1oY1mC&\u0011al\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ti\u0003'M\\\u0005\u0003Cn\u0013a\u0001V;qY\u0016\u0014\u0004CA2m\u001b\u0005!'BA3g\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\r[\u0001\bM\u0016\fG/\u001e:f\u0015\tI'.A\u0002ba&T!a\u001b\u0014\u0002\u0011\u001d,w\u000e^8pYNL!!\u001c3\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0005\u0002pm6\t\u0001O\u0003\u0002re\u000611m\u001c8gS\u001eT!a\u001d;\u0002\u0011QL\b/Z:bM\u0016T\u0011!^\u0001\u0004G>l\u0017BA<q\u0005\u0019\u0019uN\u001c4jO\")\u0011P\u0001a\u0001u\u0006\u0011\u0011n\u001d\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018AA5p\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0013\u0005\u001d!\u0001%AA\u0002\u0005%\u0011aA:giB\u0019!,\u00182\t\u0013\u00055!\u0001%AA\u0002\u0005=\u0011\u0001\u00029bi\"\u0004BAW/\u0002\u0012A!\u00111CA\u000e\u001d\u0011\t)\"a\u0006\u0011\u0005mZ\u0016bAA\r7\u00061\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007\\)!\t\u0019#a\f\u00022\u0005M\u0002#BA\u0013\u0003WyVBAA\u0014\u0015\r\tIcW\u0001\u0005kRLG.\u0003\u0003\u0002.\u0005\u001d\"a\u0001+ss\")\u0011p\u0001a\u0001u\"9\u0011qA\u0002A\u0002\u0005%\u0001bBA\u001b\u0007\u0001\u0007\u0011qG\u0001\u0006Q&tGo\u001d\t\t\u0003'\tI$!\u0005\u0002>%!\u00111HA\u0010\u0005\ri\u0015\r\u001d\t\u00045\u0006}\u0012bAA!7\n1\u0011I\\=SK\u001a\fA\"\u001b8gKJ<Um\u001c&t_:$\u0002\"a\t\u0002H\u0005-\u0014q\u000e\u0005\b\u0003\u0013\"\u0001\u0019AA&\u0003!1W-\u0019;ve\u0016\u001c\bCBA'\u0003/\niF\u0004\u0003\u0002P\u0005McbA\u001e\u0002R%\tA,C\u0002\u0002Vm\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#aA*fc*\u0019\u0011QK.\u0011\t\u0005}\u0013Q\r\b\u0004m\u0005\u0005\u0014bAA2=\u0005qq)Z8Kg>t\u0007+\u0019:tS:<\u0017\u0002BA4\u0003S\u0012abR3p\u0015N|gNR3biV\u0014XMC\u0002\u0002dyAq!!\u001c\u0005\u0001\u0004\ty!A\u0006gK\u0006$XO]3QCRD\u0007bBA\u0004\t\u0001\u0007\u0011\u0011B\u0001\nS:4WM\u001d&t_:$\u0002\"a\t\u0002v\u0005-\u0015Q\u0012\u0005\b\u0003o*\u0001\u0019AA=\u0003!)G.Z7f]R\u001c\bCBA'\u0003/\nY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\t\u001d\u001cxN\u001c\u0006\u0004\u0003\u000b#\u0018AB4p_\u001edW-\u0003\u0003\u0002\n\u0006}$a\u0003&t_:,E.Z7f]RDq!!\u001c\u0006\u0001\u0004\ty\u0001C\u0004\u0002\b\u0015\u0001\r!!\u0003\u0002#\r\u0014X-\u0019;f\r&,G\u000eZ\"p]\u001aLw\rF\u0002I\u0003'Cq!!&\u0007\u0001\u0004\t9*A\u0003usB,G\r\u0005\u0003\u0002\u001a\u0006}ebA'\u0002\u001c&\u0019\u0011Q\u0014\u0017\u0002\u001bQK\b/Z%oM\u0016\u0014XM\\2f\u0013\u0011\t\t+a)\u0003\u0019QK\b/Z,ji\"\u0004\u0016\r\u001e5\u000b\u0007\u0005uE&\u0001\u000bKg>t7i\u001c8wKJ$XM\u001d$bGR|'/\u001f\t\u0003c!\u00192\u0001CA\u001f)\t\t9+A\u0007UsB,Gk\u001c)s_\u000e,7o]\u000b\u0003\u0003c\u0003B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003os\u0018\u0001\u00027b]\u001eLA!!\b\u00026\u0006qA+\u001f9f)>\u0004&o\\2fgN\u0004\u0013A\u0004$fCR,(/\u001a)bi\"\\U-_\u0001\u0010\r\u0016\fG/\u001e:f!\u0006$\bnS3zA\u0005\u0019r)Z8Kg>tw)Z8nKR\u0014\u0018\u0010U1uQ\u0006!r)Z8Kg>tw)Z8nKR\u0014\u0018\u0010U1uQ\u0002\n\u0011CS:p]\u000e{gNZ5h\u0007>tg/\u001a:u!\r\tI-E\u0007\u0002\u0011\t\t\"j]8o\u0007>tg-[4D_:4XM\u001d;\u0014\u000bE\ty-!8\u0011\u000b\u0005E\u0017q\u001b\u001b\u000f\u00075\u000b\u0019.C\u0002\u0002V2\n\u0001$\u00112tiJ\f7\r^\"p]Z,'\u000f^3s\r\u0006\u001cGo\u001c:z\u0013\u0011\tI.a7\u0003-\r{gN^3si\u0016\u00148i\u001c8gS\u001e\u001cuN\u001c<feRT1!!6-!\u0011\t\t.a8\n\t\u0005\u0005\u00181\u001c\u0002\u000e\u001fB$\u0018n\u001c8D_:4XM\u001d;\u0015\u0005\u0005\u001d\u0017\u0001\u00043fG>$WmQ8oM&<G\u0003DAu\u0003\u007f\u0014YAa\u0004\u0003\"\t\u001d\u0002cBA'\u0003W\fy\u000fN\u0005\u0005\u0003[\fYF\u0001\u0004FSRDWM\u001d\t\u0005\u0003c\fY0\u0004\u0002\u0002t*!\u0011Q_A|\u0003\u0015)'O]8s\u0015\t\tI0\u0001\u0006qkJ,7m\u001c8gS\u001eLA!!@\u0002t\n!2i\u001c8gS\u001e\u0014V-\u00193fe\u001a\u000b\u0017\u000e\\;sKNDqA!\u0001\u0014\u0001\u0004\u0011\u0019!A\u0002dkJ\u0004BA!\u0002\u0003\b5\u0011\u0011q_\u0005\u0005\u0005\u0013\t9P\u0001\nD_:4\u0017nZ(cU\u0016\u001cGoQ;sg>\u0014\bb\u0002B\u0007'\u0001\u0007\u0011\u0011C\u0001\u0005if\u0004X\rC\u0004\u0003\u0012M\u0001\rAa\u0005\u0002\u000f%$g)[3mIB!!,\u0018B\u000b!\u0011\u00119B!\b\u000e\u0005\te!b\u0001B\u000eY\u0005QAO]1og\u001a|'/\\:\n\t\t}!\u0011\u0004\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007b\u0002B\u0012'\u0001\u0007!QE\u0001\u0007G\u0006\u001c\u0007.Z:\u0011\u000f\u0005M\u0011\u0011HA\t]\"9!\u0011F\nA\u0002\t-\u0012\u0001C;tKJ$\u0015\r^1\u0011\u0011\u0005M\u0011\u0011HA\t\u0005+\tA\"\u001a8d_\u0012,7i\u001c8gS\u001e$bA!\r\u00038\te\u0002c\u0001.\u00034%\u0019!QG.\u0003\tUs\u0017\u000e\u001e\u0005\u0006cR\u0001\r\u0001\u000e\u0005\b\u0005w!\u0002\u0019\u0001B\u001f\u0003\u0011\u0011\u0017m]3\u0011\u0011\t}\"1IA\t\u0003{i!A!\u0011\u000b\u0007\u0005%b0\u0003\u0003\u0002<\t\u0005\u0013\u0001\u0005&t_:4\u0015.\u001a7e\u0007>tg/\u001a:u!\r\tIM\u0006\u0002\u0011\u0015N|gNR5fY\u0012\u001cuN\u001c<feR\u001cRA\u0006B'\u0003;\u0004R!!5\u0003P!KAA!\u0015\u0002\\\naa)[3mI\u000e{gN^3siR\u0011!qI\u0001\fI\u0016\u001cw\u000eZ3GS\u0016dG\r\u0006\u0005\u0003Z\tm#Q\fB1!\u001d\ti%a;\u0002p\"CqA!\u0001\u0019\u0001\u0004\u0011\u0019\u0001C\u0004\u0003`a\u0001\r!!\u0005\u0002\t9\fW.\u001a\u0005\b\u0005GB\u0002\u0019\u0001B\n\u0003%!(/\u00198tM>\u0014X.A\u0006f]\u000e|G-\u001a$jK2$GC\u0002B\u0019\u0005S\u0012i\u0007\u0003\u0004\u0003le\u0001\r\u0001S\u0001\u0006M&,G\u000e\u001a\u0005\b\u0005wI\u0002\u0019\u0001B\u001f\u0005%\u0001&o\u001c9OC6,'oE\u0002\u001b\u0005g\u0002B!!'\u0003v%!!qOAR\u0005\u0015q\u0015-\\3s)\t\u0011Y\bE\u0002\u0002Jj\tQ!\u00199qYf$B!!\u0005\u0003\u0002\"9!1\u0011\u000fA\u0002\u0005E\u0011aA6fs\u0002")
public class JsonConverterFactory
extends AbstractConverterFactory<JsonConverter, JsonConverter.JsonConfig, JsonConverter.JsonField, AbstractConverter.BasicOptions> {
    public static String FeaturePathKey() {
        return JsonConverterFactory$.MODULE$.FeaturePathKey();
    }

    public static String TypeToProcess() {
        return JsonConverterFactory$.MODULE$.TypeToProcess();
    }

    public Option<Tuple2<SimpleFeatureType, Config>> infer(InputStream is, Option<SimpleFeatureType> sft, Option<String> path) {
        return this.infer(is, sft, (Map<String, Object>)((Map)path.map((Function1 & Serializable & scala.Serializable)file -> EvaluationContext$.MODULE$.inputFileParam(file)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))).toOption();
    }

    public Try<Tuple2<SimpleFeatureType, Config>> infer(InputStream is, Option<SimpleFeatureType> sft, Map<String, Object> hints) {
        Try tryElements = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)package.WithClose$.MODULE$.apply((Object)new JsonReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)), (Function1 & Serializable & scala.Serializable)reader -> {
            reader.setLenient(true);
            Iterator<JsonElement> iter = new Iterator<JsonElement>(null, reader){
                private final JsonReader reader$1;

                public Iterator<JsonElement> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<JsonElement> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<JsonElement> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<JsonElement> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<JsonElement> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<JsonElement, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<JsonElement, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<JsonElement> filter(Function1<JsonElement, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<JsonElement, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<JsonElement> withFilter(Function1<JsonElement, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<JsonElement> filterNot(Function1<JsonElement, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<JsonElement, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, JsonElement, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<JsonElement, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<JsonElement> takeWhile(Function1<JsonElement, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<JsonElement>, Iterator<JsonElement>> partition(Function1<JsonElement, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<JsonElement>, Iterator<JsonElement>> span(Function1<JsonElement, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<JsonElement> dropWhile(Function1<JsonElement, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<JsonElement, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<JsonElement, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<JsonElement, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<JsonElement, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<JsonElement, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<JsonElement> find(Function1<JsonElement, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<JsonElement, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<JsonElement, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<JsonElement> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<JsonElement>, Iterator<JsonElement>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<JsonElement> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<JsonElement> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<JsonElement> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<JsonElement> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<JsonElement, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<JsonElement, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, JsonElement, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<JsonElement, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, JsonElement, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<JsonElement, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, JsonElement, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<JsonElement, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, JsonElement, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<JsonElement, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, JsonElement, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<JsonElement> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<JsonElement> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<JsonElement> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<JsonElement> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<JsonElement> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, JsonElement, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef$.less.colon.less<JsonElement, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    JsonToken jsonToken = this.reader$1.peek();
                    JsonToken jsonToken2 = JsonToken.END_DOCUMENT;
                    return jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2);
                }

                public JsonElement next() {
                    return JsonParser.parseReader((JsonReader)this.reader$1);
                }
                {
                    this.reader$1 = reader$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            };
            return iter.take(AbstractConverterFactory$.MODULE$.inferSampleSize()).toList();
        }, IsCloseable$.MODULE$.closeableIsCloseable()));
        return tryElements.flatMap((Function1 & Serializable & scala.Serializable)elements -> {
            LazyRef featurePath$lzy = new LazyRef();
            if (elements.isEmpty()) {
                return new Failure((Throwable)new RuntimeException("Could not parse the input as JSON"));
            }
            if (JsonConverter$.MODULE$.isFeature((JsonElement)elements.head())) {
                return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)elements.map((Function1 & Serializable & scala.Serializable)el -> JsonConverter$.MODULE$.parseFeature((JsonElement)el), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.inferGeoJson((Seq<GeoJsonParsing.GeoJsonFeature>)x$2, (Option<String>)None$.MODULE$, sft));
            }
            if (JsonConverter$.MODULE$.isFeatureCollection((JsonElement)elements.head())) {
                return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)elements.flatMap((Function1 & Serializable & scala.Serializable)el -> JsonConverter$.MODULE$.parseFeatureCollection((JsonElement)el), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> this.inferGeoJson((Seq<GeoJsonParsing.GeoJsonFeature>)x$3, (Option<String>)new Some((Object)"$.features[*]"), sft));
            }
            if (((JsonElement)elements.head()).isJsonObject()) {
                return this.inferJson((Seq<JsonElement>)elements, (Option<String>)JsonConverterFactory.featurePath$1(featurePath$lzy, hints), sft);
            }
            if (((JsonElement)elements.head()).isJsonArray()) {
                return this.inferJson((Seq<JsonElement>)elements, (Option<String>)JsonConverterFactory.featurePath$1(featurePath$lzy, hints).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"$.[*]")), sft);
            }
            return new Failure((Throwable)new RuntimeException("Could not parse the input as a JSON object or array"));
        });
    }

    private Try<Tuple2<SimpleFeatureType, Config>> inferGeoJson(Seq<GeoJsonParsing.GeoJsonFeature> features, Option<String> featurePath, Option<SimpleFeatureType> sft) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            None$ idJsonField;
            LinkedHashMap props = LinkedHashMap$.MODULE$.empty();
            ListBuffer geoms = (ListBuffer)ListBuffer$.MODULE$.empty();
            BooleanRef hasId = BooleanRef.create((boolean)true);
            ((IterableLike)features.take(AbstractConverterFactory$.MODULE$.inferSampleSize())).foreach((Function1 & Serializable & scala.Serializable)feature -> {
                JsonConverterFactory.$anonfun$inferGeoJson$2(props, geoms, hasId, feature);
                return BoxedUnit.UNIT;
            });
            Seq pathsAndValues = (Seq)((SeqLike)props.toSeq().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    ListBuffer values = (ListBuffer)tuple2._2();
                    return new TypeInference.PathWithValues(path, (Iterable)values);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)new TypeInference.PathWithValues(JsonConverterFactory$.MODULE$.org$locationtech$geomesa$convert$json$JsonConverterFactory$$GeoJsonGeometryPath(), (Iterable)geoms), Seq$.MODULE$.canBuildFrom());
            TypeInference.InferredTypesWithPaths inferredTypes = TypeInference$.MODULE$.infer(pathsAndValues, sft.toRight((Function0 & Serializable & scala.Serializable)() -> "inferred-json"), (Function1)new PropNamer(), TypeInference$.MODULE$.infer$default$4());
            None$ none$ = idJsonField = hasId.elem ? new Some((Object)new JsonConverter.StringJsonField("id", "$.id", false, (Option<Expression>)None$.MODULE$)) : None$.MODULE$;
            if (None$.MODULE$.equals(none$)) {
                some = new Some((Object)Expression$.MODULE$.apply("md5(stringToBytes(toString($0)))"));
            } else if (none$ instanceof Some) {
                Some some2 = (Some)none$;
                JsonConverter.StringJsonField f = (JsonConverter.StringJsonField)some2.value();
                some = new Some((Object)Expression$.MODULE$.apply(new java.lang.StringBuilder(1).append("$").append(f.name()).toString()));
            } else {
                throw new MatchError((Object)none$);
            }
            Some idField = some;
            Seq fieldConfig = (Seq)Option$.MODULE$.option2Iterable((Option)idJsonField).toSeq().$plus$plus((GenTraversableOnce)inferredTypes.types().map((Function1 & Serializable & scala.Serializable)typed -> this.createFieldConfig((TypeInference.TypeWithPath)typed), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            JsonConverter.JsonConfig jsonConfig = new JsonConverter.JsonConfig(this.typeToProcess(), featurePath, (Option<Expression>)idField, (Map<String, Config>)Predef$.MODULE$.Map().empty(), (Map<String, Expression>)Predef$.MODULE$.Map().empty());
            Config config = this.configConvert().to((package.ConverterConfig)jsonConfig).withFallback((ConfigMergeable)this.fieldConvert().to(fieldConfig)).withFallback((ConfigMergeable)this.optsConvert().to((package.ConverterOptions)AbstractConverter.BasicOptions$.MODULE$.default())).toConfig();
            return new Tuple2((Object)inferredTypes.sft(), (Object)config);
        });
    }

    private Try<Tuple2<SimpleFeatureType, Config>> inferJson(Seq<JsonElement> elements, Option<String> featurePath, Option<SimpleFeatureType> sft) {
        Try tryFeatures = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            Option option = featurePath;
            if (None$.MODULE$.equals(option)) {
                seq = elements;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String p = (String)some.value();
                JsonPath path = JsonPath.compile((String)p, (Predicate[])new Predicate[0]);
                seq = (Seq)elements.flatMap((Function1 & Serializable & scala.Serializable)el -> {
                    JsonNull res;
                    JsonNull jsonNull;
                    try {
                        jsonNull = (JsonElement)path.read(el, JsonConverter$.MODULE$.JsonConfiguration());
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        jsonNull = res = JsonNull.INSTANCE;
                    }
                    if (res.isJsonArray()) {
                        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(res.getAsJsonArray().asList()).asScala();
                    }
                    return (Seq)new .colon.colon((Object)res, (List)Nil$.MODULE$);
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)option);
            }
            Seq features = seq;
            return (Seq)features.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.isJsonObject()) {
                        return (B1)A1.getAsJsonObject();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(JsonElement x1) {
                    JsonElement jsonElement = x1;
                    return jsonElement.isJsonObject();
                }
            }, Seq$.MODULE$.canBuildFrom());
        });
        return tryFeatures.flatMap((Function1 & Serializable & scala.Serializable)features -> {
            if (features.isEmpty()) {
                return new Failure((Throwable)new RuntimeException("Could not parse input as JSON"));
            }
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                LinkedHashMap props = LinkedHashMap$.MODULE$.empty();
                ((IterableLike)features.take(AbstractConverterFactory$.MODULE$.inferSampleSize())).foreach((Function1 & Serializable & scala.Serializable)feature -> {
                    JsonConverterFactory.$anonfun$inferJson$5(props, feature);
                    return BoxedUnit.UNIT;
                });
                Seq pathsAndValues = (Seq)props.toSeq().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String path = (String)tuple2._1();
                        ListBuffer values = (ListBuffer)tuple2._2();
                        return new TypeInference.PathWithValues(path, (Iterable)values);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
                TypeInference.InferredTypesWithPaths inferredTypes = TypeInference$.MODULE$.infer(pathsAndValues, sft.toRight((Function0 & Serializable & scala.Serializable)() -> "inferred-json"), TypeInference$.MODULE$.infer$default$3(), TypeInference$.MODULE$.infer$default$4());
                Some idField = new Some((Object)Expression$.MODULE$.apply("md5(stringToBytes(toString($0)))"));
                Seq fieldConfig = (Seq)inferredTypes.types().map((Function1 & Serializable & scala.Serializable)typed -> this.createFieldConfig((TypeInference.TypeWithPath)typed), Seq$.MODULE$.canBuildFrom());
                JsonConverter.JsonConfig jsonConfig = new JsonConverter.JsonConfig(this.typeToProcess(), featurePath, (Option<Expression>)idField, (Map<String, Config>)Predef$.MODULE$.Map().empty(), (Map<String, Expression>)Predef$.MODULE$.Map().empty());
                Config config = this.configConvert().to((package.ConverterConfig)jsonConfig).withFallback((ConfigMergeable)this.fieldConvert().to(fieldConfig)).withFallback((ConfigMergeable)this.optsConvert().to((package.ConverterOptions)AbstractConverter.BasicOptions$.MODULE$.default())).toConfig();
                return new Tuple2((Object)inferredTypes.sft(), (Object)config);
            });
        });
    }

    private JsonConverter.JsonField createFieldConfig(TypeInference.TypeWithPath typed) {
        None$ transform;
        TypeInference.TypeWithPath typeWithPath = typed;
        if (typeWithPath == null) {
            throw new MatchError((Object)typeWithPath);
        }
        String path = typeWithPath.path();
        TypeInference.InferredType inferredType = typeWithPath.inferredType();
        Tuple2 tuple2 = new Tuple2((Object)path, (Object)inferredType);
        String path2 = (String)tuple2._1();
        TypeInference.InferredType inferredType2 = (TypeInference.InferredType)tuple2._2();
        TypeInference.InferredTransform inferredTransform = inferredType2.transform();
        Object object = transform = TypeInference.IdentityTransform$.MODULE$.equals(inferredTransform) ? None$.MODULE$ : new Some((Object)Expression$.MODULE$.apply(new java.lang.StringBuilder(10).append("try(").append(inferredTransform.apply(0)).append(",null)").toString()));
        if (path2.isEmpty()) {
            return new JsonConverter.DerivedField(inferredType2.name(), (Option<Expression>)transform);
        }
        Enumeration.Value value = inferredType2.typed();
        Enumeration.Value value2 = ObjectType$.MODULE$.BOOLEAN();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new JsonConverter.BooleanJsonField(inferredType2.name(), path2, false, (Option<Expression>)transform);
        }
        Enumeration.Value value4 = ObjectType$.MODULE$.LIST();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new JsonConverter.ArrayJsonField(inferredType2.name(), path2, false, (Option<Expression>)new Some((Object)Expression$.MODULE$.apply("try(jsonList('string',$0),null)")));
        }
        if (transform.isEmpty()) {
            Enumeration.Value value6 = value;
            Enumeration.Value value7 = ObjectType$.MODULE$.GEOMETRY();
            if (!(value6 == null ? value7 != null : !value6.equals(value7)) || ObjectType$.MODULE$.GeometrySubtypes().contains((Object)value)) {
                return new JsonConverter.GeometryJsonField(inferredType2.name(), path2, false, (Option<Expression>)None$.MODULE$);
            }
        }
        return new JsonConverter.StringJsonField(inferredType2.name(), path2, false, (Option<Expression>)transform);
    }

    private static final /* synthetic */ Option featurePath$lzycompute$1(LazyRef featurePath$lzy$1, Map hints$1) {
        Option option;
        LazyRef lazyRef = featurePath$lzy$1;
        synchronized (lazyRef) {
            option = featurePath$lzy$1.initialized() ? (Option)featurePath$lzy$1.value() : (Option)featurePath$lzy$1.initialize((Object)hints$1.get((Object)JsonConverterFactory$.MODULE$.FeaturePathKey()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()));
        }
        return option;
    }

    private static final Option featurePath$1(LazyRef featurePath$lzy$1, Map hints$1) {
        if (featurePath$lzy$1.initialized()) {
            return (Option)featurePath$lzy$1.value();
        }
        return JsonConverterFactory.featurePath$lzycompute$1(featurePath$lzy$1, hints$1);
    }

    public static final /* synthetic */ void $anonfun$inferGeoJson$2(LinkedHashMap props$1, ListBuffer geoms$1, BooleanRef hasId$1, GeoJsonParsing.GeoJsonFeature feature) {
        feature.properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                return ((ListBuffer)props$1.getOrElseUpdate((Object)k, (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty())).$plus$eq(v);
            }
            throw new MatchError((Object)tuple2);
        });
        geoms$1.$plus$eq((Object)feature.geom());
        hasId$1.elem = hasId$1.elem && feature.id().isDefined();
    }

    public static final /* synthetic */ void $anonfun$inferJson$5(LinkedHashMap props$2, JsonObject feature) {
        GeoJsonParsing$.MODULE$.parseElement((JsonElement)feature, "").foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                return ((ListBuffer)props$2.getOrElseUpdate((Object)k, (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty())).$plus$eq(v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public JsonConverterFactory() {
        super(JsonConverterFactory$.MODULE$.TypeToProcess(), (AbstractConverterFactory.ConverterConfigConvert)JsonConverterFactory$JsonConfigConvert$.MODULE$, (AbstractConverterFactory.FieldConvert)JsonConverterFactory$JsonFieldConvert$.MODULE$, (AbstractConverterFactory.ConverterOptionsConvert)AbstractConverterFactory.BasicOptionsConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonConverter.class), ClassTag$.MODULE$.apply(JsonConverter.JsonConfig.class), ClassTag$.MODULE$.apply(JsonConverter.JsonField.class), ClassTag$.MODULE$.apply(AbstractConverter.BasicOptions.class));
    }

    private static class PropNamer
    extends TypeInference.Namer {
        public String apply(String key) {
            String string = key;
            String string2 = JsonConverterFactory$.MODULE$.org$locationtech$geomesa$convert$json$JsonConverterFactory$$GeoJsonGeometryPath();
            return super.apply(!(string != null ? !string.equals(string2) : string2 != null) ? "geom" : key.replaceFirst("properties", ""));
        }

        public PropNamer() {
            super(TypeInference.Namer$.MODULE$.$lessinit$greater$default$1());
        }
    }
}

