/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.convert.json.JsonConverter$;
import org.locationtech.geomesa.convert2.transforms.CollectionFunctionFactory;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\f\u0018\u0001\tBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004U\u0001\u0001\u0006Ia\u0013\u0005\u0006+\u0002!\tE\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019i\b\u0001)A\u0005A\"A\u0011Q\u0001\u0001C\u0002\u0013%A\rC\u0004\u0002\b\u0001\u0001\u000b\u0011\u00021\t\u0011\u0005%\u0001A1A\u0005\n\u0011Dq!a\u0003\u0001A\u0003%\u0001\r\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003e\u0011\u001d\ty\u0001\u0001Q\u0001\n\u0001D\u0001\"!\u0005\u0001\u0005\u0004%I\u0001\u001a\u0005\b\u0003'\u0001\u0001\u0015!\u0003a\u0011!\t)\u0002\u0001b\u0001\n\u0013!\u0007bBA\f\u0001\u0001\u0006I\u0001\u0019\u0005\t\u00033\u0001!\u0019!C\u0005I\"9\u00111\u0004\u0001!\u0002\u0013\u0001\u0007\u0002CA\u000f\u0001\t\u0007I\u0011\u00023\t\u000f\u0005}\u0001\u0001)A\u0005A\"9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\"a\u0005&t_:4UO\\2uS>tg)Y2u_JL(B\u0001\r\u001a\u0003\u0011Q7o\u001c8\u000b\u0005iY\u0012aB2p]Z,'\u000f\u001e\u0006\u00039u\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001f?\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0001%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001G%\n\u0004C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+_5\t1F\u0003\u0002-[\u0005QAO]1og\u001a|'/\\:\u000b\u00059Z\u0012\u0001C2p]Z,'\u000f\u001e\u001a\n\u0005AZ#A\u0007+sC:\u001chm\u001c:nKJ4UO\\2uS>tg)Y2u_JL\bC\u0001\u001aC\u001d\t\u0019\u0004I\u0004\u00025\u007f9\u0011QG\u0010\b\u0003mur!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005i\n\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011afG\u0005\u0003Y5J!!Q\u0016\u00023\r{G\u000e\\3di&|gNR;oGRLwN\u001c$bGR|'/_\u0005\u0003\u0007\u0012\u0013\u0011cQ8mY\u0016\u001cG/[8o!\u0006\u00148/\u001b8h\u0015\t\t5&\u0001\u0004=S:LGO\u0010\u000b\u0002\u000fB\u0011\u0001\nA\u0007\u0002/\u0005!qm]8o+\u0005Y\u0005C\u0001'S\u001b\u0005i%BA%O\u0015\ty\u0005+\u0001\u0004h_><G.\u001a\u0006\u0002#\u0006\u00191m\\7\n\u0005Mk%\u0001B$t_:\fQaZ:p]\u0002\n\u0011BZ;oGRLwN\\:\u0016\u0003]\u00032\u0001W/a\u001d\tI6L\u0004\u000295&\ta%\u0003\u0002]K\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u0005\r\u0019V-\u001d\u0006\u00039\u0016\u0002\"AK1\n\u0005\t\\#a\u0005+sC:\u001chm\u001c:nKJ4UO\\2uS>t\u0017\u0001\u00046t_:$vn\u0015;sS:<W#\u00011)\t\u00151\u0017n\u001b\t\u0003I\u001dL!\u0001[\u0013\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001k\u00031)8/\u001a\u0011u_N#(/\u001b8hc\u0015\u0019C\u000e\u001e=v!\ti\u0017O\u0004\u0002o_B\u0011\u0001(J\u0005\u0003a\u0016\na\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001/J\u0005\u0003kZ\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$BA<&\u0003)!W\r\u001d:fG\u0006$X\rZ\u0019\u0006GeT8p\u001e\b\u0003IiL!a^\u00132\t\t\"S\u0005 \u0002\u0006g\u000e\fG.Y\u0001\u000eUN|g\u000eV8TiJLgn\u001a\u0011)\t\u00191\u0017n`\u0019\u0007G1$\u0018\u0011A;2\r\rJ(0a\u0001xc\u0011\u0011C%\n?\u0002\u0011)\u001cxN\u001c)bi\"\f\u0011B[:p]B\u000bG\u000f\u001b\u0011\u0002\u001d)\u001cxN\u001c'jgR\u0004\u0016M]:fe\u0006y!n]8o\u0019&\u001cH\u000fU1sg\u0016\u0014\b%A\u0007kg>tW*\u00199QCJ\u001cXM]\u0001\u000fUN|g.T1q!\u0006\u00148/\u001a:!\u0003%i\u0017\r\u001d+p\u0015N|g.\u0001\u0006nCB$vNS:p]\u0002\n\u0011C[:p]\u0006\u0013(/Y=U_>\u0013'.Z2u\u0003IQ7o\u001c8BeJ\f\u0017\u0010V8PE*,7\r\u001e\u0011\u0002\u001b9,wOS:p]>\u0013'.Z2u\u00039qWm\u001e&t_:|%M[3di\u0002\n1\"Z7qif$vNT;mY\u0006aQ-\u001c9usR{g*\u001e7mA\u0005aq-\u001a;Qe&l\u0017\u000e^5wKR!\u0011QEA\u0016!\r!\u0013qE\u0005\u0004\u0003S)#aA!os\"9\u0011QF\u000bA\u0002\u0005=\u0012!\u00019\u0011\u00071\u000b\t$C\u0002\u000245\u0013QBS:p]B\u0013\u0018.\\5uSZ,\u0007")
public class JsonFunctionFactory
implements TransformerFunctionFactory,
CollectionFunctionFactory.CollectionParsing {
    private final Gson gson;
    private final TransformerFunction jsonToString;
    private final TransformerFunction jsonPath;
    private final TransformerFunction jsonListParser;
    private final TransformerFunction jsonMapParser;
    private final TransformerFunction mapToJson;
    private final TransformerFunction jsonArrayToObject;
    private final TransformerFunction newJsonObject;
    private final TransformerFunction emptyToNull;

    public Object convert(Object value, Class<?> clazz) {
        return CollectionFunctionFactory.CollectionParsing.convert$((CollectionFunctionFactory.CollectionParsing)this, (Object)value, clazz);
    }

    public Class<?> determineClazz(String s) {
        return CollectionFunctionFactory.CollectionParsing.determineClazz$((CollectionFunctionFactory.CollectionParsing)this, (String)s);
    }

    private Gson gson() {
        return this.gson;
    }

    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.jsonToString(), this.jsonListParser(), this.jsonMapParser(), this.mapToJson(), this.jsonPath(), this.jsonArrayToObject(), this.newJsonObject(), this.emptyToNull()}));
    }

    private TransformerFunction jsonToString() {
        return this.jsonToString;
    }

    private TransformerFunction jsonPath() {
        return this.jsonPath;
    }

    private TransformerFunction jsonListParser() {
        return this.jsonListParser;
    }

    private TransformerFunction jsonMapParser() {
        return this.jsonMapParser;
    }

    private TransformerFunction mapToJson() {
        return this.mapToJson;
    }

    private TransformerFunction jsonArrayToObject() {
        return this.jsonArrayToObject;
    }

    private TransformerFunction newJsonObject() {
        return this.newJsonObject;
    }

    private TransformerFunction emptyToNull() {
        return this.emptyToNull;
    }

    private Object getPrimitive(JsonPrimitive p) {
        if (p.isBoolean()) {
            return BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean());
        }
        return p.getAsString();
    }

    public static final /* synthetic */ boolean $anonfun$emptyToNull$2(Map.Entry x$1) {
        Object v = x$1.getValue();
        JsonNull jsonNull = JsonNull.INSTANCE;
        return !(v != null ? !v.equals(jsonNull) : jsonNull != null);
    }

    public JsonFunctionFactory() {
        CollectionFunctionFactory.CollectionParsing.$init$((CollectionFunctionFactory.CollectionParsing)this);
        this.gson = new Gson();
        this.jsonToString = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonToString", "json2string"}), (Function1 & Serializable & scala.Serializable)args -> args[0].toString());
        this.jsonPath = new TransformerFunction.NamedTransformerFunction(null){
            private final ConcurrentHashMap<Object, JsonPath> cache;

            private ConcurrentHashMap<Object, JsonPath> cache() {
                return this.cache;
            }

            public Object apply(Object[] args) {
                BoxedUnit boxedUnit;
                JsonPath path = this.cache().get(args[0]);
                if (path == null) {
                    path = JsonPath.compile((String)((String)args[0]), (Predicate[])new Predicate[0]);
                    boxedUnit = this.cache().put(args[0], path);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                JsonElement elem = (JsonElement)path.read(args[1], JsonConverter$.MODULE$.JsonConfiguration());
                if (elem.isJsonNull()) {
                    return null;
                }
                if (elem.isJsonPrimitive()) {
                    JsonPrimitive p = elem.getAsJsonPrimitive();
                    if (p.isString()) {
                        return p.getAsString();
                    }
                    if (p.isNumber()) {
                        return p.getAsNumber();
                    }
                    if (p.isBoolean()) {
                        return BoxesRunTime.boxToBoolean((boolean)p.getAsBoolean());
                    }
                    return p.getAsString();
                }
                return elem;
            }
            {
                this.cache = new ConcurrentHashMap<K, V>();
            }
        };
        this.jsonListParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonList"}), (Function1 & Serializable & scala.Serializable)args -> {
            JsonArray array = (JsonArray)args[1];
            if (array == null || array.isJsonNull()) {
                return null;
            }
            Class<?> clazz = this.determineClazz((String)args[0]);
            ArrayList<Object> result = new ArrayList<Object>(array.size());
            for (JsonElement e : array) {
                Object object = !e.isJsonNull() ? BoxesRunTime.boxToBoolean((boolean)result.add(this.convert(this.getPrimitive(e.getAsJsonPrimitive()), clazz))) : BoxedUnit.UNIT;
            }
            return result;
        });
        this.jsonMapParser = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonMap"}), (Function1 & Serializable & scala.Serializable)args -> {
            Class<?> kClass = this.determineClazz((String)args[0]);
            Class<?> vClass = this.determineClazz((String)args[1]);
            JsonObject map = (JsonObject)args[2];
            if (map == null || map.isJsonNull()) {
                return null;
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
            for (Map.Entry e : map.entrySet()) {
                result.put(this.convert(e.getKey(), kClass), this.convert(this.getPrimitive(((JsonElement)e.getValue()).getAsJsonPrimitive()), vClass));
            }
            return result;
        });
        this.mapToJson = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"map2Json", "mapToJson"}), (Function1 & Serializable & scala.Serializable)args -> {
            Map map = (Map)args[0];
            scala.collection.immutable.Map ast = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object object = x0$1;
                if (object == null) {
                    return JsonAST.JNull$.MODULE$;
                }
                if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    return package$.MODULE$.JInt().apply(BigInt$.MODULE$.int2bigInt(n));
                }
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    return package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(l));
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    return package$.MODULE$.JDouble().apply(d);
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    return package$.MODULE$.JDouble().apply((double)f);
                }
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    return package$.MODULE$.JBool().apply(bl);
                }
                if (object instanceof String) {
                    String string = (String)object;
                    return package$.MODULE$.JString().apply(string);
                }
                return package$.MODULE$.JString().apply(object.toString());
            }).toMap(Predef$.MODULE$.$conforms());
            JsonAST.JObject x$1 = JsonDSL$.MODULE$.map2jvalue(ast, (Function1)Predef$.MODULE$.$conforms());
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        });
        this.jsonArrayToObject = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jsonArrayToObject"}), (Function1 & Serializable & scala.Serializable)args -> {
            JsonArray array = (JsonArray)args[0];
            if (array == null || array.isJsonNull()) {
                return null;
            }
            JsonObject obj = new JsonObject();
            for (int i = 0; i < array.size(); ++i) {
                obj.add(Integer.toString(i), array.get(i));
            }
            return obj;
        });
        this.newJsonObject = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"newJsonObject"}), (Function1 & Serializable & scala.Serializable)args -> {
            JsonObject obj = new JsonObject();
            for (int i = 1; i < ((Object[])args).length; i += 2) {
                String key = args[i - 1].toString();
                Object object = args[i];
                if (object == null) {
                    continue;
                }
                if (object instanceof JsonElement) {
                    JsonElement jsonElement = (JsonElement)object;
                    obj.add(key, jsonElement);
                    continue;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    obj.add(key, (JsonElement)new JsonPrimitive(string));
                    continue;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    obj.add(key, (JsonElement)new JsonPrimitive(number));
                    continue;
                }
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    obj.add(key, (JsonElement)new JsonPrimitive(Predef$.MODULE$.boolean2Boolean(bl)));
                    continue;
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    obj.add(key, (JsonElement)new JsonPrimitive(DateParsing$.MODULE$.formatDate(date, DateParsing$.MODULE$.formatDate$default$2())));
                    continue;
                }
                obj.add(key, this.gson().toJsonTree(object));
            }
            return obj;
        });
        this.emptyToNull = TransformerFunction$.MODULE$.pure((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emptyJsonToNull"}), (Function1 & Serializable & scala.Serializable)args -> {
            JsonArray jsonArray;
            boolean bl = false;
            JsonObject jsonObject = null;
            Object object = args[0];
            JsonNull jsonNull = JsonNull.INSTANCE;
            Object object2 = object;
            if (!(jsonNull != null ? !jsonNull.equals(object2) : object2 != null)) {
                return null;
            }
            if (object instanceof JsonObject) {
                bl = true;
                jsonObject = (JsonObject)object;
                if (jsonObject.size() == 0) {
                    return null;
                }
            }
            if (bl && ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(jsonObject.entrySet()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonFunctionFactory.$anonfun$emptyToNull$2(x$1)))) {
                return null;
            }
            if (object instanceof JsonArray && (jsonArray = (JsonArray)object).size() == 0) {
                return null;
            }
            return object;
        });
    }
}

