/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.parquet;

import java.io.Serializable;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.locationtech.geomesa.convert2.TypeInference;
import org.locationtech.geomesa.convert2.TypeInference$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ParquetConverterFactory$ {
    public static ParquetConverterFactory$ MODULE$;
    private final String TypeToProcess;

    static {
        new ParquetConverterFactory$();
    }

    public String TypeToProcess() {
        return this.TypeToProcess;
    }

    public Seq<TypeInference.InferredType> schemaTypes(MessageType schema) {
        TypeInference.Namer namer = new TypeInference.Namer(TypeInference.Namer$.MODULE$.$lessinit$greater$default$1());
        ArrayBuffer types = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            ParquetConverterFactory$.mapField$1(x$7, ParquetConverterFactory$.mapField$default$2$1(), namer, types);
            return BoxedUnit.UNIT;
        });
        TypeInference$.MODULE$.deriveGeometry(types.toSeq(), (Function1)namer).foreach((Function1 & Serializable & scala.Serializable)g -> types.$plus$eq(g));
        return types.toSeq();
    }

    private static final /* synthetic */ TypeInference.InferredType int32$lzycompute$1(LazyRef int32$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        TypeInference.InferredType inferredType;
        LazyRef lazyRef = int32$lzy$1;
        synchronized (lazyRef) {
            OriginalType originalType;
            inferredType = int32$lzy$1.initialized() ? (TypeInference.InferredType)int32$lzy$1.value() : (TypeInference.InferredType)int32$lzy$1.initialize((Object)(OriginalType.DATE.equals(originalType = original$1) ? new TypeInference.InferredType(name$1, ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1) : new TypeInference.InferredType(name$1, ObjectType$.MODULE$.INT(), (TypeInference.InferredTransform)transform$1)));
        }
        return inferredType;
    }

    private static final TypeInference.InferredType int32$1(LazyRef int32$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        if (int32$lzy$1.initialized()) {
            return (TypeInference.InferredType)int32$lzy$1.value();
        }
        return ParquetConverterFactory$.int32$lzycompute$1(int32$lzy$1, original$1, name$1, transform$1);
    }

    private static final /* synthetic */ TypeInference.InferredType int64$lzycompute$1(LazyRef int64$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        TypeInference.InferredType inferredType;
        LazyRef lazyRef = int64$lzy$1;
        synchronized (lazyRef) {
            OriginalType originalType;
            inferredType = int64$lzy$1.initialized() ? (TypeInference.InferredType)int64$lzy$1.value() : (TypeInference.InferredType)int64$lzy$1.initialize((Object)(OriginalType.TIMESTAMP_MILLIS.equals(originalType = original$1) ? new TypeInference.InferredType(name$1, ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1) : (OriginalType.TIMESTAMP_MICROS.equals(originalType) ? new TypeInference.InferredType(name$1, ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1) : new TypeInference.InferredType(name$1, ObjectType$.MODULE$.LONG(), (TypeInference.InferredTransform)transform$1))));
        }
        return inferredType;
    }

    private static final TypeInference.InferredType int64$1(LazyRef int64$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        if (int64$lzy$1.initialized()) {
            return (TypeInference.InferredType)int64$lzy$1.value();
        }
        return ParquetConverterFactory$.int64$lzycompute$1(int64$lzy$1, original$1, name$1, transform$1);
    }

    private static final /* synthetic */ TypeInference.InferredType binary$lzycompute$1(LazyRef binary$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        TypeInference.InferredType inferredType;
        LazyRef lazyRef = binary$lzy$1;
        synchronized (lazyRef) {
            OriginalType originalType;
            inferredType = binary$lzy$1.initialized() ? (TypeInference.InferredType)binary$lzy$1.value() : (TypeInference.InferredType)binary$lzy$1.initialize((Object)(OriginalType.UTF8.equals(originalType = original$1) ? new TypeInference.InferredType(name$1, ObjectType$.MODULE$.STRING(), (TypeInference.InferredTransform)transform$1) : new TypeInference.InferredType(name$1, ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform$1)));
        }
        return inferredType;
    }

    private static final TypeInference.InferredType binary$1(LazyRef binary$lzy$1, OriginalType original$1, String name$1, TypeInference.FunctionTransform transform$1) {
        if (binary$lzy$1.initialized()) {
            return (TypeInference.InferredType)binary$lzy$1.value();
        }
        return ParquetConverterFactory$.binary$lzycompute$1(binary$lzy$1, original$1, name$1, transform$1);
    }

    private static final void mapField$1(Type field, String path, TypeInference.Namer namer$1, ArrayBuffer types$2) {
        String name = namer$1.apply(field.getName());
        TypeInference.FunctionTransform transform = new TypeInference.FunctionTransform("avroPath(", new StringBuilder(5).append(",'").append(path).append("/").append(field.getName()).append("')").toString());
        OriginalType original = field.getOriginalType();
        if (field.isPrimitive()) {
            LazyRef int32$lzy = new LazyRef();
            LazyRef int64$lzy = new LazyRef();
            LazyRef binary$lzy = new LazyRef();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = field.asPrimitiveType().getPrimitiveTypeName();
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)ParquetConverterFactory$.binary$1(binary$lzy, original, name, transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)ParquetConverterFactory$.int32$1(int32$lzy, original, name, transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)ParquetConverterFactory$.int64$1(int64$lzy, original, name, transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.FLOAT(), (TypeInference.InferredTransform)transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.DOUBLE(), (TypeInference.InferredTransform)transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.BOOLEAN(), (TypeInference.InferredTransform)transform));
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform));
                return;
            }
            return;
        }
        GroupType group = field.asGroupType();
        OriginalType originalType = original;
        if (OriginalType.LIST.equals(originalType)) {
            if (group.getFieldCount() == 1 && !group.getType(0).isPrimitive()) {
                GroupType list = group.getType(0).asGroupType();
                if (list.getFieldCount() == 1 && list.isRepetition(Type.Repetition.REPEATED) && list.getType(0).isPrimitive()) {
                    types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.LIST(), (TypeInference.InferredTransform)transform));
                    return;
                }
                return;
            }
            return;
        }
        if (OriginalType.MAP.equals(originalType)) {
            if (group.getFieldCount() == 1 && !group.getType(0).isPrimitive()) {
                GroupType map = group.getType(0).asGroupType();
                if (map.getFieldCount() == 2 && map.isRepetition(Type.Repetition.REPEATED) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(map.getFields()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isPrimitive()))) {
                    types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.MAP(), (TypeInference.InferredTransform)transform));
                    return;
                }
                return;
            }
            return;
        }
        if (group.getFieldCount() == 1 && group.getType(0).isPrimitive() && group.getType(0).isRepetition(Type.Repetition.REPEATED)) {
            types$2.$plus$eq((Object)new TypeInference.InferredType(name, ObjectType$.MODULE$.LIST(), (TypeInference.InferredTransform)transform));
            return;
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(group.getFields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            ParquetConverterFactory$.mapField$1(x$6, new StringBuilder(1).append(path).append("/").append(field.getName()).toString(), namer$1, types$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final String mapField$default$2$1() {
        return "";
    }

    private ParquetConverterFactory$() {
        MODULE$ = this;
        this.TypeToProcess = "parquet";
    }
}

