/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.redis;

import com.typesafe.config.Config;
import java.net.URI;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.EnrichmentCacheFactory;
import org.locationtech.geomesa.convert.redis.RedisConnectionBuilder;
import org.locationtech.geomesa.convert.redis.RedisEnrichmentCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.JedisURIHelper;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Y2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!)q\u0004\u0001C!A!)\u0001\u0007\u0001C!c\tY\"+\u001a3jg\u0016s'/[2i[\u0016tGoQ1dQ\u00164\u0015m\u0019;pefT!AB\u0004\u0002\u000bI,G-[:\u000b\u0005!I\u0011aB2p]Z,'\u000f\u001e\u0006\u0003\u0015-\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\r\u001b\u0005aAn\\2bi&|g\u000e^3dQ*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#]\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007C\u0001\r\u001a\u001b\u00059\u0011B\u0001\u000e\b\u0005Y)eN]5dQ6,g\u000e^\"bG\",g)Y2u_JL\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0006\u0003)\u0019\u0017M\u001c)s_\u000e,7o\u001d\u000b\u0003C\u0011\u0002\"A\u0005\u0012\n\u0005\r\u001a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006K\t\u0001\rAJ\u0001\u0005G>tg\r\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u000511m\u001c8gS\u001eT!a\u000b\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011!L\u0001\u0004G>l\u0017BA\u0018)\u0005\u0019\u0019uN\u001c4jO\u0006)!-^5mIR\u0011!'\u000e\t\u00031MJ!\u0001N\u0004\u0003\u001f\u0015s'/[2i[\u0016tGoQ1dQ\u0016DQ!J\u0002A\u0002\u0019\u0002")
public class RedisEnrichmentCacheFactory
implements EnrichmentCacheFactory {
    public boolean canProcess(Config conf) {
        return conf.hasPath("type") && conf.getString("type").equals("redis");
    }

    public EnrichmentCache build(Config conf) {
        String url = conf.getString("redis-url");
        String redisUrl = (String)new Some((Object)url).filter((Function1 & java.io.Serializable & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)RedisEnrichmentCacheFactory.$anonfun$build$1(u))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            if (url.indexOf(":") == -1) {
                return url;
            }
            return new StringBuilder(8).append("redis://").append(url).toString();
        });
        long timeout = conf.hasPath("expiration") ? conf.getLong("expiration") : -1L;
        RedisConnectionBuilder connBuilder = new RedisConnectionBuilder(null, redisUrl){
            private final JedisPool pool;

            private JedisPool pool() {
                return this.pool;
            }

            public Jedis getConn() {
                return this.pool().getResource();
            }

            public void close() {
                this.pool().close();
            }
            {
                this.pool = new JedisPool(redisUrl$1);
            }
        };
        boolean localCache = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> conf.getBoolean("local-cache")).getOrElse((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> true));
        return new RedisEnrichmentCache(connBuilder, timeout, localCache);
    }

    public static final /* synthetic */ boolean $anonfun$build$3(URI x$1) {
        return JedisURIHelper.isValid((URI)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$build$1(String u) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new URI(u)).toOption().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RedisEnrichmentCacheFactory.$anonfun$build$3(x$1)));
    }
}

