/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.xml;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.input.BOMInputStream;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.convert.xml.XmlConverter;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.w3c.dom.Element;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class XmlConverter$
implements StrictLogging {
    public static XmlConverter$ MODULE$;
    private final Logger logger;

    static {
        new XmlConverter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public XPath createXPath(String factory, Map<String, String> namespaces) {
        XPath xpath;
        block7: {
            XPathFactory xPathFactory;
            try {
                BoxedUnit boxedUnit;
                XPathFactory res = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", factory, this.getClass().getClassLoader());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Loaded xpath factory {}", new Object[]{res.getClass()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                xPathFactory = res;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(86).append("Unable to load xpath provider '").append(factory).append("': ").append(e.toString()).append(". ").append("Xpath queries may be slower - check your classpath").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
                }
                throw throwable;
            }
            XPathFactory fact = xPathFactory;
            xpath = fact.newXPath();
            if (!namespaces.nonEmpty()) break block7;
            xpath.setNamespaceContext(new NamespaceContext(namespaces){
                private final Map namespaces$1;

                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public java.util.Iterator<String> getPrefixes(String namespaceURI) {
                    return null;
                }

                public String getNamespaceURI(String prefix) {
                    return (String)this.namespaces$1.getOrElse((Object)prefix, (Function0 & Serializable & scala.Serializable)() -> null);
                }
                {
                    this.namespaces$1 = namespaces$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNamespaceURI$1()}, serializedLambda);
                }
            });
        }
        return xpath;
    }

    public Map<String, String> createXPath$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public CloseableIterator<Element> iterator(XmlConverter.DocParser parser, InputStream is, Charset encoding, Enumeration.Value mode, EvaluationContext ec) {
        BOMInputStream bis = new BOMInputStream(is);
        Enumeration.Value value = mode;
        Enumeration.Value value2 = Modes.LineMode$.MODULE$.Single();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            LineIterator lines = IOUtils.lineIterator((InputStream)bis, (Charset)encoding);
            Iterator elements = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)lines).asScala()).flatMap((Function1 & Serializable & scala.Serializable)line -> {
                ec.line_$eq(ec.line() + 1L);
                if (TextTools$.MODULE$.isWhitespace(line)) {
                    return package$.MODULE$.Iterator().empty();
                }
                return package$.MODULE$.Iterator().single((Object)parser.parse(new StringReader((String)line)));
            });
            return CloseableIterator$.MODULE$.apply(elements, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lines.close());
        }
        InputStreamReader reader = new InputStreamReader((InputStream)bis, encoding);
        return CloseableIterator$.MODULE$.fill(1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close(), (Function0 & Serializable & scala.Serializable)() -> {
            ec.line_$eq(ec.line() + 1L);
            return parser.parse(reader);
        });
    }

    private XmlConverter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

