/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro.serialization;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.geotools.util.factory.Hints;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class AvroUserDataSerialization$
implements LazyLogging {
    public static AvroUserDataSerialization$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new AvroUserDataSerialization$();
    }

    private Logger logger$lzycompute() {
        AvroUserDataSerialization$ avroUserDataSerialization$ = this;
        synchronized (avroUserDataSerialization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void serialize(Encoder out, Map<?, ?> map) {
        Iterable writes = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return Option$.MODULE$.option2Iterable(this.write$1(key, out).flatMap((Function1 & Serializable & scala.Serializable)k -> this.write$1(value, out).map((Function1 & Serializable & scala.Serializable)v -> (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    out.startItem();
                    k.apply$mcV$sp();
                    v.apply$mcV$sp();
                })));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        out.writeArrayStart();
        out.setItemCount((long)writes.size());
        writes.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        out.writeArrayEnd();
    }

    public Map<Object, Object> deserialize(Decoder in) {
        int size = (int)in.readArrayStart();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        this.deserializeWithSize(in, size, map);
        return map;
    }

    public void deserialize(Decoder in, Map<Object, Object> map) {
        this.deserializeWithSize(in, (int)in.readArrayStart(), map);
    }

    private void deserializeWithSize(Decoder in, int size, Map<Object, Object> map) {
        ObjectRef bb = ObjectRef.create(null);
        int remaining = size;
        while (remaining > 0) {
            Object key = AvroUserDataSerialization$.read$1(in, bb);
            Object value = AvroUserDataSerialization$.read$1(in, bb);
            map.put(key, value);
            if (--remaining != 0) continue;
            remaining = (int)in.arrayNext();
        }
    }

    private final Option write$1(Object value, Encoder out$1) {
        Object object = value;
        if (object == null) {
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(0);
                out$1.writeNull();
            });
        }
        if (object instanceof String) {
            String string = (String)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(1);
                out$1.writeString(string);
            });
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(2);
                out$1.writeInt(Predef$.MODULE$.Integer2int(n));
            });
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(3);
                out$1.writeLong(Predef$.MODULE$.Long2long(l));
            });
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(4);
                out$1.writeFloat(Predef$.MODULE$.Float2float(f));
            });
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(5);
                out$1.writeDouble(Predef$.MODULE$.Double2double(d));
            });
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(6);
                out$1.writeBoolean(Predef$.MODULE$.Boolean2boolean(bl));
            });
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return new Some((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                out$1.writeIndex(7);
                out$1.writeBytes(byArray);
            });
        }
        if (object instanceof Hints.Key) {
            Hints.Key key;
            Hints.Key key2 = key = (Hints.Key)object;
            Hints.Key key3 = Hints.USE_PROVIDED_FID;
            if (!(key2 != null ? !key2.equals(key3) : key3 != null)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Dropping USE_PROVIDED_FID hint");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return None$.MODULE$;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(45).append("Serialization not implemented for '").append(value).append("' of type ").append(value.getClass()).toString());
    }

    private static final Object read$1(Decoder in$1, ObjectRef bb$1) {
        int n = in$1.readIndex();
        switch (n) {
            case 0: {
                in$1.readNull();
                return null;
            }
            case 1: {
                return in$1.readString();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)in$1.readInt());
            }
            case 3: {
                return BoxesRunTime.boxToLong((long)in$1.readLong());
            }
            case 4: {
                return BoxesRunTime.boxToFloat((float)in$1.readFloat());
            }
            case 5: {
                return BoxesRunTime.boxToDouble((double)in$1.readDouble());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)in$1.readBoolean());
            }
            case 7: {
                bb$1.elem = in$1.readBytes((ByteBuffer)bb$1.elem);
                byte[] array = (byte[])Array$.MODULE$.ofDim(((ByteBuffer)bb$1.elem).remaining(), ClassTag$.MODULE$.Byte());
                ((ByteBuffer)bb$1.elem).get(array);
                return array;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected union type: ").append(n).toString());
    }

    private AvroUserDataSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

