/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro.serialization;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CollectionSerialization$ {
    public static CollectionSerialization$ MODULE$;

    static {
        new CollectionSerialization$();
    }

    public ByteBuffer encodeList(List<?> list, String binding) {
        Option size = Option$.MODULE$.apply(list).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()));
        boolean bl = false;
        Some some = null;
        Option option = size;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            if (s == 0) {
                return this.encodeEmptyCollection();
            }
        }
        if (bl) {
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            return this.encodeNonEmptyList(list, s, binding);
        }
        if (None$.MODULE$.equals(option)) {
            return this.encodeNullCollection();
        }
        throw new MatchError((Object)option);
    }

    public List<Object> decodeList(ByteBuffer bb) {
        int size = bb.getInt();
        if (size < 0) {
            return null;
        }
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        String label = this.getString(bb);
        Function0<Object> readMethod = this.getReadMethod(label, bb);
        for (int i = 0; i < size; ++i) {
            list.add(readMethod.apply());
        }
        return list;
    }

    public ByteBuffer encodeMap(Map<?, ?> map, String keyBinding, String valueBinding) {
        Option size = Option$.MODULE$.apply(map).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()));
        boolean bl = false;
        Some some = null;
        Option option = size;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            if (s == 0) {
                return this.encodeEmptyCollection();
            }
        }
        if (bl) {
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            return this.encodeNonEmptyMap(map, s, keyBinding, valueBinding);
        }
        if (None$.MODULE$.equals(option)) {
            return this.encodeNullCollection();
        }
        throw new MatchError((Object)option);
    }

    public Map<Object, Object> decodeMap(ByteBuffer bb) {
        int size = bb.getInt();
        if (size < 0) {
            return null;
        }
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        String keyType = this.getString(bb);
        String valueType = this.getString(bb);
        Function0<Object> keyReadMethod = this.getReadMethod(keyType, bb);
        Function0<Object> valueReadMethod = this.getReadMethod(valueType, bb);
        for (int i = 0; i < size; ++i) {
            Object key = keyReadMethod.apply();
            Object value = valueReadMethod.apply();
            map.put(key, value);
        }
        return map;
    }

    private ByteBuffer encodeNullCollection() {
        return ByteBuffer.allocate(4).putInt(-1).flip();
    }

    private ByteBuffer encodeEmptyCollection() {
        return ByteBuffer.allocate(4).putInt(0).flip();
    }

    private ByteBuffer encodeNonEmptyList(List<?> list, int size, String label) {
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(label);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesPerItem = tuple2._1$mcI$sp();
        Function2 putMethod = (Function2)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerItem), (Object)putMethod);
        int bytesPerItem2 = tuple22._1$mcI$sp();
        Function2 putMethod2 = (Function2)tuple22._2();
        int totalBytes = this.getTotalBytes(bytesPerItem2, size, (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(list.iterator()).asScala(), label);
        byte[] labelBytes = label.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(8 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(labelBytes)).size() + totalBytes);
        bb.putInt(size);
        this.putString(bb, label);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)v -> {
            putMethod2.apply((Object)bb, v);
            return BoxedUnit.UNIT;
        });
        bb.flip();
        return bb;
    }

    private ByteBuffer encodeNonEmptyMap(Map<?, ?> map, int size, String keyLabel, String valueLabel) {
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(keyLabel);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesPerKeyItem = tuple2._1$mcI$sp();
        Function2 keyPutMethod = (Function2)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerKeyItem), (Object)keyPutMethod);
        int bytesPerKeyItem2 = tuple22._1$mcI$sp();
        Function2 keyPutMethod2 = (Function2)tuple22._2();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple23 = this.getWriteMethod(valueLabel);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        int bytesPerValueItem = tuple23._1$mcI$sp();
        Function2 valuePutMethod = (Function2)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerValueItem), (Object)valuePutMethod);
        int bytesPerValueItem2 = tuple24._1$mcI$sp();
        Function2 valuePutMethod2 = (Function2)tuple24._2();
        int totalKeyBytes = this.getTotalBytes(bytesPerKeyItem2, size, ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).keysIterator(), keyLabel);
        int totalValueBytes = this.getTotalBytes(bytesPerValueItem2, size, ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).valuesIterator(), valueLabel);
        byte[] keyLabelBytes = keyLabel.getBytes(StandardCharsets.UTF_8);
        byte[] valueLabelBytes = valueLabel.getBytes(StandardCharsets.UTF_8);
        int totalBytes = 12 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(keyLabelBytes)).size() + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(valueLabelBytes)).size() + totalKeyBytes + totalValueBytes;
        ByteBuffer bb = ByteBuffer.allocate(totalBytes);
        bb.putInt(size);
        this.putString(bb, keyLabel);
        this.putString(bb, valueLabel);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CollectionSerialization$.$anonfun$encodeNonEmptyMap$1(keyPutMethod2, bb, valuePutMethod2, x0$1);
            return BoxedUnit.UNIT;
        });
        bb.flip();
        return bb;
    }

    private Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> getWriteMethod(String label) {
        String string = label.toLowerCase(Locale.US);
        if ("string".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                CollectionSerialization$.MODULE$.putString(bb, (String)v);
                return BoxedUnit.UNIT;
            });
        }
        if ("int".equals(string) ? true : "integer".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                bb.putInt(BoxesRunTime.unboxToInt((Object)v));
                return BoxedUnit.UNIT;
            });
        }
        if ("double".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                bb.putDouble(BoxesRunTime.unboxToDouble((Object)v));
                return BoxedUnit.UNIT;
            });
        }
        if ("long".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                bb.putLong(BoxesRunTime.unboxToLong((Object)v));
                return BoxedUnit.UNIT;
            });
        }
        if ("float".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                bb.putFloat(BoxesRunTime.unboxToFloat((Object)v));
                return BoxedUnit.UNIT;
            });
        }
        if ("date".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                bb.putLong(((Date)v).getTime());
                return BoxedUnit.UNIT;
            });
        }
        if ("boolean".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                CollectionSerialization$.$anonfun$getWriteMethod$7(bb, v);
                return BoxedUnit.UNIT;
            });
        }
        if ("uuid".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                CollectionSerialization$.MODULE$.putUUID(bb, (UUID)v);
                return BoxedUnit.UNIT;
            });
        }
        if ("byte[]".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                CollectionSerialization$.MODULE$.putBytes(bb, (byte[])v);
                return BoxedUnit.UNIT;
            });
        }
        String msg = new StringBuilder(69).append("Invalid collection type: '").append(label).append("'. Only primitives and Dates are supported.").toString();
        throw new IllegalArgumentException(msg);
    }

    private Function0<Object> getReadMethod(String label, ByteBuffer bb) {
        String string = label.toLowerCase(Locale.US);
        if ("string".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> MODULE$.getString(bb);
        }
        if ("int".equals(string) ? true : "integer".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToInteger((int)bb.getInt());
        }
        if ("double".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToDouble((double)bb.getDouble());
        }
        if ("long".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToLong((long)bb.getLong());
        }
        if ("float".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToFloat((float)bb.getFloat());
        }
        if ("boolean".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> bb.get() > 0;
        }
        if ("date".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> new Date(bb.getLong());
        }
        if ("uuid".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> MODULE$.getUUID(bb);
        }
        if ("byte[]".equals(string)) {
            return (Function0 & Serializable & scala.Serializable)() -> MODULE$.getBytes(bb);
        }
        String msg = new StringBuilder(69).append("Invalid collection type: '").append(label).append("'. Only primitives and Dates are supported.").toString();
        throw new IllegalArgumentException(msg);
    }

    private int getTotalBytes(int bytesPerItem, int size, Iterator<?> values, String label) {
        if (bytesPerItem == -1) {
            String string = label.toLowerCase();
            if ("string".equals(string)) {
                return BoxesRunTime.unboxToInt((Object)values.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)CollectionSerialization$.$anonfun$getTotalBytes$1(x$6))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            if ("byte[]".equals(string)) {
                return BoxesRunTime.unboxToInt((Object)values.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)CollectionSerialization$.$anonfun$getTotalBytes$2(x$7))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            throw new IllegalArgumentException("invalid type");
        }
        return bytesPerItem * size;
    }

    private String getString(ByteBuffer bb) {
        int size = bb.getInt();
        byte[] buf = new byte[size];
        bb.get(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    private ByteBuffer putString(ByteBuffer bb, String s) {
        return this.putBytes(bb, s.getBytes(StandardCharsets.UTF_8));
    }

    private ByteBuffer putBytes(ByteBuffer bb, byte[] arr) {
        return bb.putInt(arr.length).put(arr);
    }

    private byte[] getBytes(ByteBuffer bb) {
        int sz = bb.getInt();
        byte[] bytes = new byte[sz];
        bb.get(bytes, 0, sz);
        return bytes;
    }

    private ByteBuffer putUUID(ByteBuffer bb, UUID uuid) {
        return bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
    }

    private UUID getUUID(ByteBuffer bb) {
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static final /* synthetic */ void $anonfun$encodeNonEmptyMap$1(Function2 keyPutMethod$1, ByteBuffer bb$2, Function2 valuePutMethod$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object k = tuple2._1();
            Object v = tuple2._2();
            keyPutMethod$1.apply((Object)bb$2, k);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)valuePutMethod$1.apply((Object)bb$2, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getWriteMethod$7(ByteBuffer bb, Object v) {
        if (BoxesRunTime.unboxToBoolean((Object)v)) {
            bb.put((byte)1);
            return;
        }
        bb.put((byte)0);
    }

    public static final /* synthetic */ int $anonfun$getTotalBytes$1(Object x$6) {
        return ((String)x$6).getBytes(StandardCharsets.UTF_8).length + 4;
    }

    public static final /* synthetic */ int $anonfun$getTotalBytes$2(Object x$7) {
        return ((byte[])x$7).length + 4;
    }

    private CollectionSerialization$() {
        MODULE$ = this;
    }
}

