/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.serialization;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Writer;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u00015\u0011\u0011cR3p\u0015N|gnU3sS\u0006d\u0017N_3s\u0015\t\u0019A!A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u000b\u0019\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001d\u001b\u00051\"BA\f\u0019\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI\"$\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0012aA2p[&\u0011QD\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003\r\u0019h\r\u001e\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\naa]5na2,'BA\u0013'\u0003\u001d1W-\u0019;ve\u0016T!a\n\u0006\u0002\u000f=\u0004XM\\4jg&\u0011\u0011F\t\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\b\u0006\u0002._A\u0011a\u0006A\u0007\u0002\u0005!)qD\u000ba\u0001A!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014\u0001\u00053fM\u0006,H\u000e^$f_6Le\u000eZ3y+\u0005\u0019\u0004CA\b5\u0013\t)\u0004CA\u0002J]RDaa\u000e\u0001!\u0002\u0013\u0019\u0014!\u00053fM\u0006,H\u000e^$f_6Le\u000eZ3yA!9\u0011\b\u0001b\u0001\n\u0013Q\u0014AD4f_6,GO]=Xe&$XM]\u000b\u0002wA\u0019A(a\u0018\u000f\u00059jt!\u0002 \u0003\u0011\u0003y\u0014!E$f_*\u001bxN\\*fe&\fG.\u001b>feB\u0011a\u0006\u0011\u0004\u0006\u0003\tA\t!Q\n\u0004\u0001:!\u0002\"B\u0016A\t\u0003\u0019E#A \t\u000fe\u0002%\u0019!C\u0005\u000bV\ta\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u00069q-Z8kg>t'BA&M\u0003\tIwN\u0003\u0002N\u0011\u0005\u0019!\u000e^:\n\u0005=C%!D$f_*\u001bxN\\,sSR,'\u000f\u0003\u0004R\u0001\u0002\u0006IAR\u0001\u0010O\u0016|W.\u001a;ss^\u0013\u0018\u000e^3sA!)1\u000b\u0011C\u0001)\u00061qO]5uKJ$\"!V0\u0011\u0005YkV\"A,\u000b\u0005aK\u0016AB:ue\u0016\fWN\u0003\u0002[7\u0006!qm]8o\u0015\ta&$\u0001\u0004h_><G.Z\u0005\u0003=^\u0013!BS:p]^\u0013\u0018\u000e^3s\u0011\u0015\u0001'\u000b1\u0001b\u0003\u001d9(/\u00199qK\u0012\u0004\"A\u00194\u000e\u0003\rT!a\u00133\u000b\u0003\u0015\fAA[1wC&\u0011qm\u0019\u0002\u0007/JLG/\u001a:\t\u000b%\u0004E\u0011\u00026\u0002+\r\u0014X-\u0019;f\u0003R$(/\u001b2vi\u0016<&/\u001b;feR)1Na&\u0003\u001aB\u0011A.\\\u0007\u0002\u0001\u001a9a\u000e\u0011I\u0001$Sy'a\u0005&t_:\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u00148CA7\u000f\u0011\u0015\tXN\"\u0001s\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019hO\u001f\t\u0003\u001fQL!!\u001e\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006KA\u0004\ra\u001e\t\u0003CaL!!\u001f\u0012\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u0015\u0019\u0006\u000f1\u0001VSYiG0a\n\u0002D\u0005}\u00131PAL\u0003\u007f\u0014yCa\u0011\u0003`\tmd\u0001B?A\ty\u0014QBQ8pY\u0016\fgn\u0016:ji\u0016\u00148c\u0001?\u000fW\"Q\u0011\u0011\u0001?\u0003\u0002\u0003\u0006I!a\u0001\u0002\t9\fW.\u001a\t\u0005\u0003\u000b\tYAD\u0002\u0010\u0003\u000fI1!!\u0003\u0011\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0002\t\t\u0013\u0005MAP!A!\u0002\u0013\u0019\u0014!A5\t\r-bH\u0011AA\f)\u0019\tI\"a\u0007\u0002\u001eA\u0011A\u000e \u0005\t\u0003\u0003\t)\u00021\u0001\u0002\u0004!9\u00111CA\u000b\u0001\u0004\u0019\u0004BB9}\t\u0003\n\t\u0003F\u0003t\u0003G\t)\u0003\u0003\u0004&\u0003?\u0001\ra\u001e\u0005\u0007'\u0006}\u0001\u0019A+\u0007\r\u0005%\u0002\tBA\u0016\u0005-\u0011\u0015\u0010^3t/JLG/\u001a:\u0014\t\u0005\u001dbb\u001b\u0005\f\u0003\u0003\t9C!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u0014\u0005\u001d\"\u0011!Q\u0001\nMBqaKA\u0014\t\u0003\t\u0019\u0004\u0006\u0004\u00026\u0005]\u0012\u0011\b\t\u0004Y\u0006\u001d\u0002\u0002CA\u0001\u0003c\u0001\r!a\u0001\t\u000f\u0005M\u0011\u0011\u0007a\u0001g!9\u0011/a\n\u0005B\u0005uB#B:\u0002@\u0005\u0005\u0003BB\u0013\u0002<\u0001\u0007q\u000f\u0003\u0004T\u0003w\u0001\r!\u0016\u0004\u0007\u0003\u000b\u0002E!a\u0012\u0003\u0015\u0011\u000bG/Z,sSR,'o\u0005\u0003\u0002D9Y\u0007bCA\u0001\u0003\u0007\u0012\t\u0011)A\u0005\u0003\u0007A!\"a\u0005\u0002D\t\u0005\t\u0015!\u00034\u0011\u001dY\u00131\tC\u0001\u0003\u001f\"b!!\u0015\u0002T\u0005U\u0003c\u00017\u0002D!A\u0011\u0011AA'\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0014\u00055\u0003\u0019A\u001a\t\u000fE\f\u0019\u0005\"\u0011\u0002ZQ)1/a\u0017\u0002^!1Q%a\u0016A\u0002]DaaUA,\u0001\u0004)fABA1\u0001\u0012\t\u0019G\u0001\bHK>lW\r\u001e:z/JLG/\u001a:\u0014\t\u0005}cb\u001b\u0005\f\u0003\u0003\tyF!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u0014\u0005}#\u0011!Q\u0001\nMBqaKA0\t\u0003\tY\u0007\u0006\u0004\u0002n\u0005=\u0014\u0011\u000f\t\u0004Y\u0006}\u0003\u0002CA\u0001\u0003S\u0002\r!a\u0001\t\u000f\u0005M\u0011\u0011\u000ea\u0001g!9\u0011/a\u0018\u0005B\u0005UD#B:\u0002x\u0005e\u0004BB\u0013\u0002t\u0001\u0007q\u000f\u0003\u0004T\u0003g\u0002\r!\u0016\u0004\u0007\u0003{\u0002E!a \u0003!)\u001bxN\\*ue&twm\u0016:ji\u0016\u00148\u0003BA>\u001d-D1\"!\u0001\u0002|\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u00111CA>\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000f-\nY\b\"\u0001\u0002\bR1\u0011\u0011RAF\u0003\u001b\u00032\u0001\\A>\u0011!\t\t!!\"A\u0002\u0005\r\u0001bBA\n\u0003\u000b\u0003\ra\r\u0005\bc\u0006mD\u0011IAI)\u0015\u0019\u00181SAK\u0011\u0019)\u0013q\u0012a\u0001o\"11+a$A\u0002U3a!!'A\t\u0005m%A\u0003'jgR<&/\u001b;feN!\u0011q\u0013\bl\u0011-\t\t!a&\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005M\u0011q\u0013B\u0001B\u0003%1\u0007C\u0006\u0002$\u0006]%\u0011!Q\u0001\n\u0005\u0015\u0016a\u00022j]\u0012Lgn\u001a\t\u0005\u0003O\u000byM\u0004\u0003\u0002*\u0006%g\u0002BAV\u0003\u0007tA!!,\u0002@:!\u0011qVA_\u001d\u0011\t\t,a/\u000f\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003\u00034\u0011!B;uS2\u001c\u0018\u0002BAc\u0003\u000f\f\u0001bZ3pi>|Gn\u001d\u0006\u0004\u0003\u00034\u0011\u0002BAf\u0003\u001b\f!b\u00142kK\u000e$H+\u001f9f\u0015\u0011\t)-a2\n\t\u0005E\u00171\u001b\u0002\u000b\u001f\nTWm\u0019;UsB,'\u0002BAf\u0003\u001bDqaKAL\t\u0003\t9\u000e\u0006\u0005\u0002Z\u0006m\u0017Q\\Ap!\ra\u0017q\u0013\u0005\t\u0003\u0003\t)\u000e1\u0001\u0002\u0004!9\u00111CAk\u0001\u0004\u0019\u0004\u0002CAR\u0003+\u0004\r!!*\t\u0015\u0005\r\u0018q\u0013b\u0001\n\u0013\t)/A\u0007fY\u0016lWM\u001c;Xe&$XM]\u000b\u0003\u0003O\u0004raDAu+\u000658/C\u0002\u0002lB\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0007=\ty/C\u0002\u0002rB\u00111!\u00118z\u0011%\t)0a&!\u0002\u0013\t9/\u0001\bfY\u0016lWM\u001c;Xe&$XM\u001d\u0011\t\u000fE\f9\n\"\u0011\u0002zR)1/a?\u0002~\"1Q%a>A\u0002]DaaUA|\u0001\u0004)fA\u0002B\u0001\u0001\u0012\u0011\u0019AA\u0005NCB<&/\u001b;feN!\u0011q \bl\u0011-\t\t!a@\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005M\u0011q B\u0001B\u0003%1\u0007C\u0006\u0003\f\u0005}(\u0011!Q\u0001\n\u0005\u0015\u0016AC6fs\nKg\u000eZ5oO\"Y!qBA\u0000\u0005\u0003\u0005\u000b\u0011BAS\u000311\u0018\r\\;f\u0005&tG-\u001b8h\u0011\u001dY\u0013q C\u0001\u0005'!\"B!\u0006\u0003\u0018\te!1\u0004B\u000f!\ra\u0017q \u0005\t\u0003\u0003\u0011\t\u00021\u0001\u0002\u0004!9\u00111\u0003B\t\u0001\u0004\u0019\u0004\u0002\u0003B\u0006\u0005#\u0001\r!!*\t\u0011\t=!\u0011\u0003a\u0001\u0003KC!B!\t\u0002\u0000\n\u0007I\u0011BAs\u0003-1\u0018\r\\;f/JLG/\u001a:\t\u0013\t\u0015\u0012q Q\u0001\n\u0005\u001d\u0018\u0001\u0004<bYV,wK]5uKJ\u0004\u0003bB9\u0002\u0000\u0012\u0005#\u0011\u0006\u000b\u0006g\n-\"Q\u0006\u0005\u0007K\t\u001d\u0002\u0019A<\t\rM\u00139\u00031\u0001V\r\u001d\u0011\t\u0004\u0011E\u0005\u0005g\u0011!BT8pa^\u0013\u0018\u000e^3s'\u0011\u0011yCD6\t\u000f-\u0012y\u0003\"\u0001\u00038Q\u0011!\u0011\b\t\u0004Y\n=\u0002bB9\u00030\u0011\u0005#Q\b\u000b\u0006g\n}\"\u0011\t\u0005\u0007K\tm\u0002\u0019A<\t\rM\u0013Y\u00041\u0001V\r\u0019\u0011)\u0005\u0011\u0003\u0003H\taa*^7cKJ<&/\u001b;feN!!1\t\bl\u0011-\t\tAa\u0011\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005M!1\tB\u0001B\u0003%1\u0007C\u0004,\u0005\u0007\"\tAa\u0014\u0015\r\tE#1\u000bB+!\ra'1\t\u0005\t\u0003\u0003\u0011i\u00051\u0001\u0002\u0004!9\u00111\u0003B'\u0001\u0004\u0019\u0004bB9\u0003D\u0011\u0005#\u0011\f\u000b\u0006g\nm#Q\f\u0005\u0007K\t]\u0003\u0019A<\t\rM\u00139\u00061\u0001V\r\u0019\u0011\t\u0007\u0011\u0003\u0003d\ta1\u000b\u001e:j]\u001e<&/\u001b;feN!!q\f\bl\u0011-\t\tAa\u0018\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005M!q\fB\u0001B\u0003%1\u0007C\u0004,\u0005?\"\tAa\u001b\u0015\r\t5$q\u000eB9!\ra'q\f\u0005\t\u0003\u0003\u0011I\u00071\u0001\u0002\u0004!9\u00111\u0003B5\u0001\u0004\u0019\u0004bB9\u0003`\u0011\u0005#Q\u000f\u000b\u0006g\n]$\u0011\u0010\u0005\u0007K\tM\u0004\u0019A<\t\rM\u0013\u0019\b1\u0001V\r\u0019\u0011i\b\u0011\u0003\u0003\u0000\tQQ+^5e/JLG/\u001a:\u0014\t\tmdb\u001b\u0005\f\u0003\u0003\u0011YH!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u0014\tm$\u0011!Q\u0001\nMBqa\u000bB>\t\u0003\u00119\t\u0006\u0004\u0003\n\n-%Q\u0012\t\u0004Y\nm\u0004\u0002CA\u0001\u0005\u000b\u0003\r!a\u0001\t\u000f\u0005M!Q\u0011a\u0001g!9\u0011Oa\u001f\u0005B\tEE#B:\u0003\u0014\nU\u0005BB\u0013\u0003\u0010\u0002\u0007q\u000f\u0003\u0004T\u0005\u001f\u0003\r!\u0016\u0005\u0006?!\u0004\r\u0001\t\u0005\u0007\u0003'A\u0007\u0019A\u001a\b\u000f\tu\u0005\t#\u0003\u0003:\u0005Qaj\\8q/JLG/\u001a:\t\u000f\t\u0005\u0006\t\"\u0003\u0003$\u0006I1/\u001e2Xe&$XM\u001d\u000b\u0005\u0003O\u0014)\u000b\u0003\u0005\u0002$\n}\u0005\u0019AAS\u0011\u0019\t\u0006\u0001)A\u0005w!I!1\u0016\u0001C\u0002\u0013%!QV\u0001\u0011CR$(/\u001b2vi\u0016<&/\u001b;feN,\"Aa,\u0011\r\tE&q\u0017B^\u001b\t\u0011\u0019LC\u0002\u00036B\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011ILa-\u0003\u0007M+\u0017\u000f\u0005\u0002=[\"A!q\u0018\u0001!\u0002\u0013\u0011y+A\tbiR\u0014\u0018NY;uK^\u0013\u0018\u000e^3sg\u0002BqAa1\u0001\t\u0003\u0011)-\u0001\fti\u0006\u0014HOR3biV\u0014XmQ8mY\u0016\u001cG/[8o)\r\u0019(q\u0019\u0005\u0007'\n\u0005\u0007\u0019A+\t\u000f\t-\u0007\u0001\"\u0001\u0003N\u0006)qO]5uKR)1Oa4\u0003R\"11K!3A\u0002UCa!\nBe\u0001\u00049\bb\u0002Bk\u0001\u0011\u0005!q[\u0001\u0015K:$g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\u0015\u0007M\u0014I\u000e\u0003\u0004T\u0005'\u0004\r!\u0016")
public class GeoJsonSerializer
implements LazyLogging {
    public final SimpleFeatureType org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$sft;
    private final int org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex;
    private final GeometryWriter geometryWriter;
    private final Seq<JsonAttributeWriter> attributeWriters;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static JsonWriter writer(Writer writer) {
        return GeoJsonSerializer$.MODULE$.writer(writer);
    }

    private Logger logger$lzycompute() {
        GeoJsonSerializer geoJsonSerializer = this;
        synchronized (geoJsonSerializer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public int org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex() {
        return this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex;
    }

    private GeometryWriter geometryWriter() {
        return this.geometryWriter;
    }

    private Seq<JsonAttributeWriter> attributeWriters() {
        return this.attributeWriters;
    }

    public void startFeatureCollection(JsonWriter writer) {
        writer.beginObject().name("type").value("FeatureCollection").name("features").beginArray();
    }

    public void write(JsonWriter writer, SimpleFeature feature) {
        writer.beginObject();
        writer.name("type").value("Feature");
        writer.name("id").value(feature.getID());
        this.geometryWriter().apply(feature, writer);
        writer.name("properties").beginObject();
        this.attributeWriters().foreach((Function1)new Serializable(this, writer, feature){
            public static final long serialVersionUID = 0L;
            private final JsonWriter writer$1;
            private final SimpleFeature feature$1;

            public final void apply(JsonAttributeWriter x$1) {
                x$1.apply(this.feature$1, this.writer$1);
            }
            {
                this.writer$1 = writer$1;
                this.feature$1 = feature$1;
            }
        });
        writer.endObject();
        writer.endObject();
    }

    public void endFeatureCollection(JsonWriter writer) {
        writer.endArray().endObject();
    }

    public GeoJsonSerializer(SimpleFeatureType sft) {
        this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$sft = sft;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        this.geometryWriter = new GeometryWriter("geometry", this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex());
        this.attributeWriters = (Seq)Seq$.MODULE$.tabulate(sft.getAttributeCount() - 1, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoJsonSerializer $outer;

            public final JsonAttributeWriter apply(int i) {
                return GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$createAttributeWriter(this.$outer.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$sft, i < this.$outer.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$defaultGeomIndex() ? i : i + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class MapWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> org$locationtech$geomesa$features$serialization$GeoJsonSerializer$MapWriter$$valueWriter;

        public Function2<JsonWriter, Object, BoxedUnit> org$locationtech$geomesa$features$serialization$GeoJsonSerializer$MapWriter$$valueWriter() {
            return this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$MapWriter$$valueWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Map map = (Map)feature.getAttribute(this.i);
            if (map == null) {
                writer.nullValue();
            } else {
                writer.beginObject();
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1)new Serializable(this, writer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MapWriter $outer;
                    private final JsonWriter writer$3;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            this.writer$3.name(k.toString());
                            BoxedUnit boxedUnit = (BoxedUnit)this.$outer.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$MapWriter$$valueWriter().apply((Object)this.writer$3, v);
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writer$3 = writer$3;
                    }
                });
                writer.endObject();
            }
        }

        public MapWriter(String name, int i, Enumeration.Value keyBinding, Enumeration.Value valueBinding) {
            this.name = name;
            this.i = i;
            this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$MapWriter$$valueWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(valueBinding);
        }
    }

    public static class DateWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Date date = (Date)feature.getAttribute(this.i);
            if (date == null) {
                writer.nullValue();
            } else {
                writer.value(DateParsing$.MODULE$.formatDate(date, DateParsing$.MODULE$.formatDate$default$2()));
            }
        }

        public DateWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class UuidWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            UUID uuid = (UUID)feature.getAttribute(this.i);
            if (uuid == null) {
                writer.nullValue();
            } else {
                writer.value(uuid.toString());
            }
        }

        public UuidWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class ListWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> org$locationtech$geomesa$features$serialization$GeoJsonSerializer$ListWriter$$elementWriter;

        public Function2<JsonWriter, Object, BoxedUnit> org$locationtech$geomesa$features$serialization$GeoJsonSerializer$ListWriter$$elementWriter() {
            return this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$ListWriter$$elementWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            List list = (List)feature.getAttribute(this.i);
            if (list == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1)new Serializable(this, writer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ListWriter $outer;
                    private final JsonWriter writer$2;

                    public final void apply(Object x$2) {
                        this.$outer.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$ListWriter$$elementWriter().apply((Object)this.writer$2, x$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writer$2 = writer$2;
                    }
                });
                writer.endArray();
            }
        }

        public ListWriter(String name, int i, Enumeration.Value binding) {
            this.name = name;
            this.i = i;
            this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$ListWriter$$elementWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(binding);
        }
    }

    public static class BytesWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            byte[] bytes = (byte[])feature.getAttribute(this.i);
            if (bytes == null) {
                writer.nullValue();
            } else {
                writer.value(Base64.getEncoder().encodeToString(bytes));
            }
        }

        public BytesWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class StringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((String)feature.getAttribute(this.i));
        }

        public StringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class NumberWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Number)feature.getAttribute(this.i));
        }

        public NumberWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class BooleanWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Boolean)feature.getAttribute(this.i));
        }

        public BooleanWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class GeometryWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Geometry geom = (Geometry)feature.getAttribute(this.i);
            if (geom == null) {
                writer.nullValue();
            } else {
                writer.jsonValue(GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$geometryWriter().write(geom));
            }
        }

        public GeometryWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static class JsonStringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).beginObject().jsonValue((String)feature.getAttribute(this.i)).endObject();
        }

        public JsonStringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    public static interface JsonAttributeWriter {
        public void apply(SimpleFeature var1, JsonWriter var2);
    }
}

