/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.serialization;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.Writer;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Pattern;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$NoopWriter$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import scala.Enumeration;
import scala.Function2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class GeoJsonSerializer$
implements LazyLogging {
    public static GeoJsonSerializer$ MODULE$;
    private final GeoJsonWriter org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter;
    private final Pattern org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GeoJsonSerializer$();
    }

    private Logger logger$lzycompute() {
        GeoJsonSerializer$ geoJsonSerializer$ = this;
        synchronized (geoJsonSerializer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public GeoJsonWriter org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter() {
        return this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter;
    }

    public Pattern org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern() {
        return this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern;
    }

    public JsonWriter writer(Writer wrapped) {
        JsonWriter writer = new JsonWriter(wrapped);
        writer.setSerializeNulls(true);
        writer.setLenient(true);
        return writer;
    }

    public GeoJsonSerializer.JsonAttributeWriter org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$createAttributeWriter(SimpleFeatureType sft, int i) {
        BoxedUnit boxedUnit;
        AttributeDescriptor descriptor = sft.getDescriptor(i);
        String name = descriptor.getLocalName();
        Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
        boolean bl = false;
        Enumeration.Value value = null;
        Enumeration.Value value2 = (Enumeration.Value)bindings.head();
        Enumeration.Value value3 = ObjectType$.MODULE$.STRING();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            bl = true;
            value = value2;
            Object object = bindings.last();
            Enumeration.Value value5 = ObjectType$.MODULE$.JSON();
            if (!(object != null ? !object.equals(value5) : value5 != null)) {
                return new GeoJsonSerializer.JsonStringWriter(name, i);
            }
        }
        if (bl) {
            return new GeoJsonSerializer.StringWriter(name, i);
        }
        Enumeration.Value value6 = ObjectType$.MODULE$.INT();
        Enumeration.Value value7 = value2;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new GeoJsonSerializer.NumberWriter(name, i);
        }
        Enumeration.Value value8 = ObjectType$.MODULE$.LONG();
        Enumeration.Value value9 = value2;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return new GeoJsonSerializer.NumberWriter(name, i);
        }
        Enumeration.Value value10 = ObjectType$.MODULE$.FLOAT();
        Enumeration.Value value11 = value2;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return new GeoJsonSerializer.NumberWriter(name, i);
        }
        Enumeration.Value value12 = ObjectType$.MODULE$.DOUBLE();
        Enumeration.Value value13 = value2;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return new GeoJsonSerializer.NumberWriter(name, i);
        }
        Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
        Enumeration.Value value15 = value2;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return new GeoJsonSerializer.DateWriter(name, i);
        }
        Enumeration.Value value16 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value17 = value2;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            return new GeoJsonSerializer.GeometryWriter(name, i);
        }
        Enumeration.Value value18 = ObjectType$.MODULE$.UUID();
        Enumeration.Value value19 = value2;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            return new GeoJsonSerializer.UuidWriter(name, i);
        }
        Enumeration.Value value20 = ObjectType$.MODULE$.BYTES();
        Enumeration.Value value21 = value2;
        if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
            return new GeoJsonSerializer.BytesWriter(name, i);
        }
        Enumeration.Value value22 = ObjectType$.MODULE$.BOOLEAN();
        Enumeration.Value value23 = value2;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            return new GeoJsonSerializer.BooleanWriter(name, i);
        }
        Enumeration.Value value24 = ObjectType$.MODULE$.LIST();
        Enumeration.Value value25 = value2;
        if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
            return new GeoJsonSerializer.ListWriter(name, i, (Enumeration.Value)bindings.apply(1));
        }
        Enumeration.Value value26 = ObjectType$.MODULE$.MAP();
        Enumeration.Value value27 = value2;
        if (!(value26 != null ? !value26.equals(value27) : value27 != null)) {
            return new GeoJsonSerializer.MapWriter(name, i, (Enumeration.Value)bindings.apply(1), (Enumeration.Value)bindings.apply(2));
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Dropping unsupported attribute '{}'", new Object[]{SimpleFeatureTypes$.MODULE$.encodeDescriptor(sft, descriptor)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return GeoJsonSerializer$NoopWriter$.MODULE$;
    }

    public Function2<JsonWriter, Object, BoxedUnit> org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(Enumeration.Value binding) {
        Enumeration.Value value = binding;
        Enumeration.Value value2 = ObjectType$.MODULE$.INT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value((Number)elem);
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value4 = ObjectType$.MODULE$.LONG();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value((Number)elem);
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value6 = ObjectType$.MODULE$.FLOAT();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value((Number)elem);
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value8 = ObjectType$.MODULE$.DOUBLE();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value((Number)elem);
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value10 = ObjectType$.MODULE$.DATE();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value(DateParsing$.MODULE$.formatDate((Date)elem, DateParsing$.MODULE$.formatDate$default$2()));
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value12 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.jsonValue(GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter().write((Geometry)elem));
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value14 = ObjectType$.MODULE$.BYTES();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value(Base64.getEncoder().encodeToString((byte[])elem));
                return BoxedUnit.UNIT;
            };
        }
        Enumeration.Value value16 = ObjectType$.MODULE$.BOOLEAN();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
                writer.value((Boolean)elem);
                return BoxedUnit.UNIT;
            };
        }
        return (Function2 & Serializable & scala.Serializable)(writer, elem) -> {
            writer.value(elem.toString());
            return BoxedUnit.UNIT;
        };
    }

    /*
     * WARNING - void declaration
     */
    private GeoJsonSerializer$() {
        void var1_1;
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        GeoJsonWriter writer = new GeoJsonWriter();
        writer.setEncodeCRS(false);
        this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter = var1_1;
        this.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern = Pattern.compile("^\\s*[{\\[]");
    }
}

