/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.serialization;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.Writer;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.locationtech.jts.geom.Geometry;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B+W\u0001\u0005D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\n\u0001\u0001\u0006I!!\u0004\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002\u0003Bj\u0001\u0001\u0006I!!\u0007\t\u0013\tU\u0007A1A\u0005\n\t]\u0007\u0002\u0003Bt\u0001\u0001\u0006IA!7\t\u000f\t%\b\u0001\"\u0001\u0003l\"9!q\u001e\u0001\u0005\u0002\tE\bb\u0002B|\u0001\u0011\u0005!\u0011`\u0004\b\u0003;1\u0006\u0012AA\u0010\r\u0019)f\u000b#\u0001\u0002\"!1q0\u0004C\u0001\u0003GA\u0011\"!\n\u000e\u0005\u0004%I!a\n\t\u0011\u0005uR\u0002)A\u0005\u0003SA\u0011\"a\u0010\u000e\u0005\u0004%I!!\u0011\t\u0011\u0005]S\u0002)A\u0005\u0003\u0007Bq!!\u0017\u000e\t\u0003\tY\u0006C\u0004\u0002\u00005!I!!!\u0007\u0013\u0005\u001dU\u0002%A\u0012*\u0005%\u0005bBAF+\u0019\u0005\u0011QR\u0004\b\u0005\u0017l\u0001\u0012\u0002BE\r\u001d\u0011\u0019)\u0004E\u0005\u0005\u000bCaa \r\u0005\u0002\t\u001d\u0005bBAF1\u0011\u0005#1\u0012\u0004\u0007\u0005GkAA!*\t\u0015\u0005\u00156D!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>n\u0011\t\u0011)A\u0005\u0003\u001bAaa`\u000e\u0005\u0002\t\u001d\u0006bBAF7\u0011\u0005#q\u0016\u0004\u0007\u0005\u0007iAA!\u0002\t\u0015\u0005\u0015\u0006E!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>\u0002\u0012\t\u0011)A\u0005\u0003\u001bAaa \u0011\u0005\u0002\t\u001d\u0001bBAFA\u0011\u0005#q\u0002\u0004\u0007\u0005#kAAa%\t\u0015\u0005\u0015VE!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>\u0016\u0012\t\u0011)A\u0005\u0003\u001bAaa`\u0013\u0005\u0002\tU\u0005bBAFK\u0011\u0005#Q\u0014\u0004\u0007\u0003CkA!a)\t\u0015\u0005\u0015&F!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>*\u0012\t\u0011)A\u0005\u0003\u001bAaa \u0016\u0005\u0002\u0005}\u0006bBAFU\u0011\u0005\u0013q\u0019\u0004\u0007\u0003?lA!!9\t\u0015\u0005\u0015vF!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>>\u0012\t\u0011)A\u0005\u0003\u001bAaa`\u0018\u0005\u0002\u0005\r\bbBAF_\u0011\u0005\u00131\u001e\u0004\u0007\u0003clA!a=\t\u0015\u0005\u0015FG!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>R\u0012\t\u0011)A\u0005\u0003\u001bAaa \u001b\u0005\u0002\u0005U\bbBAFi\u0011\u0005\u0013Q \u0004\u0007\u0005kkAAa.\t\u0015\u0005\u0015\u0016H!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>f\u0012\t\u0011)A\u0005\u0003\u001bAaa`\u001d\u0005\u0002\te\u0006bBAFs\u0011\u0005#\u0011\u0019\u0004\u0007\u0003\u001blA!a4\t\u0015\u0005\u0015fH!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>z\u0012\t\u0011)A\u0005\u0003\u001bAaa  \u0005\u0002\u0005E\u0007bBAF}\u0011\u0005\u0013\u0011\u001c\u0004\u0007\u0005+iAAa\u0006\t\u0015\u0005\u00156I!A!\u0002\u0013\t9\u000b\u0003\u0006\u0002>\u000e\u0013\t\u0011)A\u0005\u0003\u001bA!B!\u0007D\u0005\u0003\u0005\u000b\u0011\u0002B\u000e\u0011\u0019y8\t\"\u0001\u0003D!I!QJ\"C\u0002\u0013%!q\n\u0005\t\u0005;\u001a\u0005\u0015!\u0003\u0003R!9\u00111R\"\u0005B\t}cA\u0002B3\u001b\u0011\u00119\u0007\u0003\u0006\u0002&.\u0013\t\u0011)A\u0005\u0003OC!\"!0L\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\u0011Ig\u0013B\u0001B\u0003%!1\u0004\u0005\u000b\u0005WZ%\u0011!Q\u0001\n\tm\u0001BB@L\t\u0003\u0011i\u0007C\u0005\u0003z-\u0013\r\u0011\"\u0003\u0003P!A!1P&!\u0002\u0013\u0011\t\u0006C\u0004\u0002\f.#\tE! \t\u000f\t5W\u0002\"\u0003\u0003P\n\tr)Z8Kg>t7+\u001a:jC2L'0\u001a:\u000b\u0005]C\u0016!D:fe&\fG.\u001b>bi&|gN\u0003\u0002Z5\u0006Aa-Z1ukJ,7O\u0003\u0002\\9\u00069q-Z8nKN\f'BA/_\u00031awnY1uS>tG/Z2i\u0015\u0005y\u0016aA8sO\u000e\u00011c\u0001\u0001cQB\u00111MZ\u0007\u0002I*\tQ-A\u0003tG\u0006d\u0017-\u0003\u0002hI\n1\u0011I\\=SK\u001a\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00055t\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003=\f1aY8n\u0013\t\t(NA\u0006MCjLHj\\4hS:<\u0017aA:giB\u0011A/`\u0007\u0002k*\u0011ao^\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005aL\u0018a\u00024fCR,(/\u001a\u0006\u0003un\f1!\u00199j\u0015\tah,\u0001\u0005hK>$xn\u001c7t\u0013\tqXOA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fa\u0001P5oSRtD\u0003BA\u0002\u0003\u000f\u00012!!\u0002\u0001\u001b\u00051\u0006\"\u0002:\u0003\u0001\u0004\u0019\u0018\u0001\u00053fM\u0006,H\u000e^$f_6Le\u000eZ3y+\t\ti\u0001E\u0002d\u0003\u001fI1!!\u0005e\u0005\rIe\u000e^\u0001\u0012I\u00164\u0017-\u001e7u\u000f\u0016|W.\u00138eKb\u0004\u0013AD4f_6,GO]=Xe&$XM]\u000b\u0003\u00033\u00012!a\u00075\u001d\r\t)\u0001D\u0001\u0012\u000f\u0016|'j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bcAA\u0003\u001bM\u0019QB\u00195\u0015\u0005\u0005}\u0011AD$f_6,GO]=Xe&$XM]\u000b\u0003\u0003S\u0001B!a\u000b\u0002:5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0004hK>T7o\u001c8\u000b\t\u0005M\u0012QG\u0001\u0003S>T1!a\u000e]\u0003\rQGo]\u0005\u0005\u0003w\tiCA\u0007HK>T5o\u001c8Xe&$XM]\u0001\u0010\u000f\u0016|W.\u001a;ss^\u0013\u0018\u000e^3sA\u0005\t\"j]8o\u001f\nTWm\u0019;QCR$XM\u001d8\u0016\u0005\u0005\r\u0003\u0003BA#\u0003'j!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0006e\u0016<W\r\u001f\u0006\u0005\u0003\u001b\ny%\u0001\u0003vi&d'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005U\u0013q\t\u0002\b!\u0006$H/\u001a:o\u0003IQ5o\u001c8PE*,7\r\u001e)biR,'O\u001c\u0011\u0002\r]\u0014\u0018\u000e^3s)\u0011\ti&!\u001d\u0011\t\u0005}\u0013QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u000511\u000f\u001e:fC6TA!a\u001a\u0002j\u0005!qm]8o\u0015\r\tYG\\\u0001\u0007O>|w\r\\3\n\t\u0005=\u0014\u0011\r\u0002\u000b\u0015N|gn\u0016:ji\u0016\u0014\bbBA:'\u0001\u0007\u0011QO\u0001\boJ\f\u0007\u000f]3e!\u0011\t9(a\u001f\u000e\u0005\u0005e$\u0002BA\u001a\u0003\u001fJA!! \u0002z\t1qK]5uKJ\fQc\u0019:fCR,\u0017\t\u001e;sS\n,H/Z,sSR,'\u000f\u0006\u0004\u0002\u0004\n\u001d'\u0011\u001a\t\u0004\u0003\u000b+R\"A\u0007\u0003')\u001bxN\\!uiJL'-\u001e;f/JLG/\u001a:\u0014\u0005U\u0011\u0017!B1qa2LHCBAH\u0003+\u000bi\nE\u0002d\u0003#K1!a%e\u0005\u0011)f.\u001b;\t\ra4\u0002\u0019AAL!\r!\u0018\u0011T\u0005\u0004\u00037+(!D*j[BdWMR3biV\u0014X\rC\u0004\u0002ZY\u0001\r!!\u0018*\u0019UQch\f\u001b!\u0007.CReG\u001d\u0003\u001b\t{w\u000e\\3b]^\u0013\u0018\u000e^3s'\u0011Q#-a!\u0002\t9\fW.\u001a\t\u0005\u0003S\u000b9L\u0004\u0003\u0002,\u0006M\u0006cAAWI6\u0011\u0011q\u0016\u0006\u0004\u0003c\u0003\u0017A\u0002\u001fs_>$h(C\u0002\u00026\u0012\fa\u0001\u0015:fI\u00164\u0017\u0002BA]\u0003w\u0013aa\u0015;sS:<'bAA[I\u0006\t\u0011\u000e\u0006\u0004\u0002B\u0006\r\u0017Q\u0019\t\u0004\u0003\u000bS\u0003bBAS[\u0001\u0007\u0011q\u0015\u0005\b\u0003{k\u0003\u0019AA\u0007)\u0019\ty)!3\u0002L\"1\u0001P\fa\u0001\u0003/Cq!!\u0017/\u0001\u0004\tiFA\u0006CsR,7o\u0016:ji\u0016\u00148\u0003\u0002 c\u0003\u0007#b!a5\u0002V\u0006]\u0007cAAC}!9\u0011QU!A\u0002\u0005\u001d\u0006bBA_\u0003\u0002\u0007\u0011Q\u0002\u000b\u0007\u0003\u001f\u000bY.!8\t\ra\u0014\u0005\u0019AAL\u0011\u001d\tIF\u0011a\u0001\u0003;\u0012!\u0002R1uK^\u0013\u0018\u000e^3s'\u0011y#-a!\u0015\r\u0005\u0015\u0018q]Au!\r\t)i\f\u0005\b\u0003K\u0013\u0004\u0019AAT\u0011\u001d\tiL\ra\u0001\u0003\u001b!b!a$\u0002n\u0006=\bB\u0002=4\u0001\u0004\t9\nC\u0004\u0002ZM\u0002\r!!\u0018\u0003\u001d\u001d+w.\\3uef<&/\u001b;feN!AGYAB)\u0019\t90!?\u0002|B\u0019\u0011Q\u0011\u001b\t\u000f\u0005\u0015v\u00071\u0001\u0002(\"9\u0011QX\u001cA\u0002\u00055ACBAH\u0003\u007f\u0014\t\u0001\u0003\u0004yq\u0001\u0007\u0011q\u0013\u0005\b\u00033B\u0004\u0019AA/\u0005AQ5o\u001c8TiJLgnZ,sSR,'o\u0005\u0003!E\u0006\rEC\u0002B\u0005\u0005\u0017\u0011i\u0001E\u0002\u0002\u0006\u0002Bq!!*$\u0001\u0004\t9\u000bC\u0004\u0002>\u000e\u0002\r!!\u0004\u0015\r\u0005=%\u0011\u0003B\n\u0011\u0019AH\u00051\u0001\u0002\u0018\"9\u0011\u0011\f\u0013A\u0002\u0005u#A\u0003'jgR<&/\u001b;feN!1IYAB\u0003\u001d\u0011\u0017N\u001c3j]\u001e\u0004BA!\b\u0003>9!!q\u0004B\u001c\u001d\u0011\u0011\tCa\r\u000f\t\t\r\"q\u0006\b\u0005\u0005K\u0011iC\u0004\u0003\u0003(\t-b\u0002BAW\u0005SI\u0011aX\u0005\u0003;zK!a\u0017/\n\u0007\tE\",A\u0003vi&d7/C\u0002}\u0005kQ1A!\r[\u0013\u0011\u0011IDa\u000f\u0002\u0015=\u0013'.Z2u)f\u0004XMC\u0002}\u0005kIAAa\u0010\u0003B\tQqJ\u00196fGR$\u0016\u0010]3\u000b\t\te\"1\b\u000b\t\u0005\u000b\u00129E!\u0013\u0003LA\u0019\u0011QQ\"\t\u000f\u0005\u0015v\t1\u0001\u0002(\"9\u0011QX$A\u0002\u00055\u0001b\u0002B\r\u000f\u0002\u0007!1D\u0001\u000eK2,W.\u001a8u/JLG/\u001a:\u0016\u0005\tE\u0003#C2\u0003T\u0005u#qKAH\u0013\r\u0011)\u0006\u001a\u0002\n\rVt7\r^5p]J\u00022a\u0019B-\u0013\r\u0011Y\u0006\u001a\u0002\u0004\u0003:L\u0018AD3mK6,g\u000e^,sSR,'\u000f\t\u000b\u0007\u0003\u001f\u0013\tGa\u0019\t\raT\u0005\u0019AAL\u0011\u001d\tIF\u0013a\u0001\u0003;\u0012\u0011\"T1q/JLG/\u001a:\u0014\t-\u0013\u00171Q\u0001\u000bW\u0016L()\u001b8eS:<\u0017\u0001\u0004<bYV,')\u001b8eS:<GC\u0003B8\u0005c\u0012\u0019H!\u001e\u0003xA\u0019\u0011QQ&\t\u000f\u0005\u0015\u0006\u000b1\u0001\u0002(\"9\u0011Q\u0018)A\u0002\u00055\u0001b\u0002B5!\u0002\u0007!1\u0004\u0005\b\u0005W\u0002\u0006\u0019\u0001B\u000e\u0003-1\u0018\r\\;f/JLG/\u001a:\u0002\u0019Y\fG.^3Xe&$XM\u001d\u0011\u0015\r\u0005=%q\u0010BA\u0011\u0019A8\u000b1\u0001\u0002\u0018\"9\u0011\u0011L*A\u0002\u0005u#A\u0003(p_B<&/\u001b;feN!\u0001DYAB)\t\u0011I\tE\u0002\u0002\u0006b!b!a$\u0003\u000e\n=\u0005B\u0002=\u001b\u0001\u0004\t9\nC\u0004\u0002Zi\u0001\r!!\u0018\u0003\u00199+XNY3s/JLG/\u001a:\u0014\t\u0015\u0012\u00171\u0011\u000b\u0007\u0005/\u0013IJa'\u0011\u0007\u0005\u0015U\u0005C\u0004\u0002&\"\u0002\r!a*\t\u000f\u0005u\u0006\u00061\u0001\u0002\u000eQ1\u0011q\u0012BP\u0005CCa\u0001_\u0015A\u0002\u0005]\u0005bBA-S\u0001\u0007\u0011Q\f\u0002\r'R\u0014\u0018N\\4Xe&$XM]\n\u00057\t\f\u0019\t\u0006\u0004\u0003*\n-&Q\u0016\t\u0004\u0003\u000b[\u0002bBAS=\u0001\u0007\u0011q\u0015\u0005\b\u0003{s\u0002\u0019AA\u0007)\u0019\tyI!-\u00034\"1\u0001p\ba\u0001\u0003/Cq!!\u0017 \u0001\u0004\tiF\u0001\u0006Vk&$wK]5uKJ\u001cB!\u000f2\u0002\u0004R1!1\u0018B_\u0005\u007f\u00032!!\":\u0011\u001d\t)\u000b\u0010a\u0001\u0003OCq!!0=\u0001\u0004\ti\u0001\u0006\u0004\u0002\u0010\n\r'Q\u0019\u0005\u0007qv\u0002\r!a&\t\u000f\u0005eS\b1\u0001\u0002^!)!\u000f\u0006a\u0001g\"9\u0011Q\u0018\u000bA\u0002\u00055\u0011A\u0003(p_B<&/\u001b;fe\u0006I1/\u001e2Xe&$XM\u001d\u000b\u0005\u0005#\u0012\t\u000eC\u0004\u0003\u001aQ\u0003\rAa\u0007\u0002\u001f\u001d,w.\\3uef<&/\u001b;fe\u0002\n\u0001#\u0019;ue&\u0014W\u000f^3Xe&$XM]:\u0016\u0005\te\u0007C\u0002Bn\u0005C\u0014)/\u0004\u0002\u0003^*\u0019!q\u001c3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003d\nu'aA*fcB\u0019\u00111D\u000b\u0002#\u0005$HO]5ckR,wK]5uKJ\u001c\b%\u0001\fti\u0006\u0014HOR3biV\u0014XmQ8mY\u0016\u001cG/[8o)\u0011\tyI!<\t\u000f\u0005e\u0013\u00021\u0001\u0002^\u0005)qO]5uKR1\u0011q\u0012Bz\u0005kDq!!\u0017\u000b\u0001\u0004\ti\u0006\u0003\u0004y\u0015\u0001\u0007\u0011qS\u0001\u0015K:$g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\u0015\t\u0005=%1 \u0005\b\u00033Z\u0001\u0019AA/\u0001")
public class GeoJsonSerializer
implements LazyLogging {
    private final SimpleFeatureType sft;
    private final int defaultGeomIndex;
    private final GeometryWriter geometryWriter;
    private final Seq<JsonAttributeWriter> attributeWriters;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static JsonWriter writer(Writer writer) {
        return GeoJsonSerializer$.MODULE$.writer(writer);
    }

    private Logger logger$lzycompute() {
        GeoJsonSerializer geoJsonSerializer = this;
        synchronized (geoJsonSerializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private int defaultGeomIndex() {
        return this.defaultGeomIndex;
    }

    private GeometryWriter geometryWriter() {
        return this.geometryWriter;
    }

    private Seq<JsonAttributeWriter> attributeWriters() {
        return this.attributeWriters;
    }

    public void startFeatureCollection(JsonWriter writer) {
        writer.beginObject().name("type").value("FeatureCollection").name("features").beginArray();
    }

    public void write(JsonWriter writer, SimpleFeature feature) {
        writer.beginObject();
        writer.name("type").value("Feature");
        writer.name("id").value(feature.getID());
        this.geometryWriter().apply(feature, writer);
        writer.name("properties").beginObject();
        this.attributeWriters().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply(feature, writer);
            return BoxedUnit.UNIT;
        });
        writer.endObject();
        writer.endObject();
    }

    public void endFeatureCollection(JsonWriter writer) {
        writer.endArray().endObject();
    }

    public GeoJsonSerializer(SimpleFeatureType sft) {
        this.sft = sft;
        LazyLogging.$init$((LazyLogging)this);
        this.defaultGeomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        this.geometryWriter = new GeometryWriter("geometry", this.defaultGeomIndex());
        this.attributeWriters = (Seq)Seq$.MODULE$.tabulate(sft.getAttributeCount() - 1, (Function1 & Serializable & scala.Serializable)i -> GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$createAttributeWriter(this.sft, BoxesRunTime.unboxToInt((Object)i) < this.defaultGeomIndex() ? BoxesRunTime.unboxToInt((Object)i) : BoxesRunTime.unboxToInt((Object)i) + 1));
    }

    private static class BooleanWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Boolean)feature.getAttribute(this.i));
        }

        public BooleanWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class BytesWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            byte[] bytes = (byte[])feature.getAttribute(this.i);
            if (bytes == null) {
                writer.nullValue();
                return;
            }
            writer.value(Base64.getEncoder().encodeToString(bytes));
        }

        public BytesWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class DateWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Date date = (Date)feature.getAttribute(this.i);
            if (date == null) {
                writer.nullValue();
                return;
            }
            writer.value(DateParsing$.MODULE$.formatDate(date, DateParsing$.MODULE$.formatDate$default$2()));
        }

        public DateWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class GeometryWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Geometry geom = (Geometry)feature.getAttribute(this.i);
            if (geom == null) {
                writer.nullValue();
                return;
            }
            writer.jsonValue(GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter().write(geom));
        }

        public GeometryWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static interface JsonAttributeWriter {
        public void apply(SimpleFeature var1, JsonWriter var2);
    }

    private static class JsonStringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            String string = (String)feature.getAttribute(this.i);
            if (string == null) {
                writer.nullValue();
                return;
            }
            if (GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern().matcher(string).find()) {
                writer.jsonValue(string.trim());
                return;
            }
            writer.value(string);
        }

        public JsonStringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class ListWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> elementWriter;

        private Function2<JsonWriter, Object, BoxedUnit> elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            List list = (List)feature.getAttribute(this.i);
            if (list == null) {
                writer.nullValue();
                return;
            }
            writer.beginArray();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ListWriter.$anonfun$apply$1(this, writer, x$2);
                return BoxedUnit.UNIT;
            });
            writer.endArray();
        }

        public static final /* synthetic */ void $anonfun$apply$1(ListWriter $this, JsonWriter writer$2, Object x$2) {
            $this.elementWriter().apply((Object)writer$2, x$2);
        }

        public ListWriter(String name, int i, Enumeration.Value binding) {
            this.name = name;
            this.i = i;
            this.elementWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(binding);
        }
    }

    private static class MapWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> valueWriter;

        private Function2<JsonWriter, Object, BoxedUnit> valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Map map = (Map)feature.getAttribute(this.i);
            if (map == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MapWriter.$anonfun$apply$2(this, writer, x0$1);
                return BoxedUnit.UNIT;
            });
            writer.endObject();
        }

        public static final /* synthetic */ void $anonfun$apply$2(MapWriter $this, JsonWriter writer$3, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                writer$3.name(k.toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.valueWriter().apply((Object)writer$3, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public MapWriter(String name, int i, Enumeration.Value keyBinding, Enumeration.Value valueBinding) {
            this.name = name;
            this.i = i;
            this.valueWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(valueBinding);
        }
    }

    private static class NumberWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Number)feature.getAttribute(this.i));
        }

        public NumberWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class StringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((String)feature.getAttribute(this.i));
        }

        public StringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class UuidWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            UUID uuid = (UUID)feature.getAttribute(this.i);
            if (uuid == null) {
                writer.nullValue();
                return;
            }
            writer.value(uuid.toString());
        }

        public UuidWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }
}

