/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.serialization;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.Writer;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}h\u0001B+W\u0001\u0005D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u0006{\u0002!\tA \u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001B!5\u0001A\u0003%\u0011Q\u0003\u0005\n\u0005'\u0004!\u0019!C\u0005\u0005+D\u0001B!;\u0001A\u0003%!q\u001b\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0005gDqA!?\u0001\t\u0003\u0011YpB\u0004\u0002\u001aYC\t!a\u0007\u0007\rU3\u0006\u0012AA\u000f\u0011\u0019iX\u0002\"\u0001\u0002 !I\u0011\u0011E\u0007C\u0002\u0013%\u00111\u0005\u0005\t\u0003si\u0001\u0015!\u0003\u0002&!I\u00111H\u0007C\u0002\u0013%\u0011Q\b\u0005\t\u0003'j\u0001\u0015!\u0003\u0002@!9\u0011QK\u0007\u0005\u0002\u0005]\u0003bBA>\u001b\u0011%\u0011Q\u0010\u0004\n\u0003\u0007k\u0001\u0013aI\u0015\u0003\u000bCq!a\"\u0016\r\u0003\tIiB\u0004\u0003J6AIAa\"\u0007\u000f\t\u0005U\u0002#\u0003\u0003\u0004\"1Q\u0010\u0007C\u0001\u0005\u000bCq!a\"\u0019\t\u0003\u0012II\u0002\u0004\u0003\"6!!1\u0015\u0005\u000b\u0003C[\"\u0011!Q\u0001\n\u0005\r\u0006BCA]7\t\u0005\t\u0015!\u0003\u0002\n!1Qp\u0007C\u0001\u0005KCq!a\"\u001c\t\u0003\u0012iK\u0002\u0004\u0002\u00006!!\u0011\u0001\u0005\u000b\u0003C\u0003#\u0011!Q\u0001\n\u0005\r\u0006BCA]A\t\u0005\t\u0015!\u0003\u0002\n!1Q\u0010\tC\u0001\u0005\u0007Aq!a\"!\t\u0003\u0012YA\u0002\u0004\u0003\u00106!!\u0011\u0013\u0005\u000b\u0003C+#\u0011!Q\u0001\n\u0005\r\u0006BCA]K\t\u0005\t\u0015!\u0003\u0002\n!1Q0\nC\u0001\u0005'Cq!a\"&\t\u0003\u0012YJ\u0002\u0004\u0002\u001e6!\u0011q\u0014\u0005\u000b\u0003CS#\u0011!Q\u0001\n\u0005\r\u0006BCA]U\t\u0005\t\u0015!\u0003\u0002\n!1QP\u000bC\u0001\u0003wCq!a\"+\t\u0003\n\u0019M\u0002\u0004\u0002\\6!\u0011Q\u001c\u0005\u000b\u0003C{#\u0011!Q\u0001\n\u0005\r\u0006BCA]_\t\u0005\t\u0015!\u0003\u0002\n!1Qp\fC\u0001\u0003?Dq!a\"0\t\u0003\n9O\u0002\u0004\u0002n6!\u0011q\u001e\u0005\u000b\u0003C#$\u0011!Q\u0001\n\u0005\r\u0006BCA]i\t\u0005\t\u0015!\u0003\u0002\n!1Q\u0010\u000eC\u0001\u0003cDq!a\"5\t\u0003\nIP\u0002\u0004\u000346!!Q\u0017\u0005\u000b\u0003CK$\u0011!Q\u0001\n\u0005\r\u0006BCA]s\t\u0005\t\u0015!\u0003\u0002\n!1Q0\u000fC\u0001\u0005oCq!a\":\t\u0003\u0012yL\u0002\u0004\u0002J6!\u00111\u001a\u0005\u000b\u0003Cs$\u0011!Q\u0001\n\u0005\r\u0006BCA]}\t\u0005\t\u0015!\u0003\u0002\n!1QP\u0010C\u0001\u0003\u001bDq!a\"?\t\u0003\n)N\u0002\u0004\u0003\u00125!!1\u0003\u0005\u000b\u0003C\u001b%\u0011!Q\u0001\n\u0005\r\u0006BCA]\u0007\n\u0005\t\u0015!\u0003\u0002\n!Q!QC\"\u0003\u0002\u0003\u0006IAa\u0006\t\ru\u001cE\u0011\u0001B!\u0011%\u0011Ye\u0011b\u0001\n\u0013\u0011i\u0005\u0003\u0005\u0003\\\r\u0003\u000b\u0011\u0002B(\u0011\u001d\t9i\u0011C!\u0005;2aAa\u0019\u000e\t\t\u0015\u0004BCAQ\u0017\n\u0005\t\u0015!\u0003\u0002$\"Q\u0011\u0011X&\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\t\u001d4J!A!\u0002\u0013\u00119\u0002\u0003\u0006\u0003j-\u0013\t\u0011)A\u0005\u0005/Aa!`&\u0005\u0002\t-\u0004\"\u0003B<\u0017\n\u0007I\u0011\u0002B'\u0011!\u0011Ih\u0013Q\u0001\n\t=\u0003bBAD\u0017\u0012\u0005#1\u0010\u0005\b\u0005\u0017lA\u0011\u0002Bg\u0005E9Um\u001c&t_:\u001cVM]5bY&TXM\u001d\u0006\u0003/b\u000bQb]3sS\u0006d\u0017N_1uS>t'BA-[\u0003!1W-\u0019;ve\u0016\u001c(BA.]\u0003\u001d9Wm\\7fg\u0006T!!\u00180\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003}\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u00012i!\t\u0019g-D\u0001e\u0015\u0005)\u0017!B:dC2\f\u0017BA4e\u0005\u0019\te.\u001f*fMB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[:\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002_\u0006\u00191m\\7\n\u0005ET'a\u0003'bufdunZ4j]\u001e\f1a\u001d4u!\t!80D\u0001v\u0015\t1x/\u0001\u0004tS6\u0004H.\u001a\u0006\u0003qf\fqAZ3biV\u0014XM\u0003\u0002{=\u00069q\u000e]3oO&\u001c\u0018B\u0001?v\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\f\u0019\u0001E\u0002\u0002\u0002\u0001i\u0011A\u0016\u0005\u0006e\n\u0001\ra]\u0001\u0011I\u00164\u0017-\u001e7u\u000f\u0016|W.\u00138eKb,\"!!\u0003\u0011\u0007\r\fY!C\u0002\u0002\u000e\u0011\u00141!\u00138u\u0003E!WMZ1vYR<Um\\7J]\u0012,\u0007\u0010I\u0001\u000fO\u0016|W.\u001a;ss^\u0013\u0018\u000e^3s+\t\t)\u0002E\u0002\u0002\u0018Qr1!!\u0001\r\u0003E9Um\u001c&t_:\u001cVM]5bY&TXM\u001d\t\u0004\u0003\u0003i1cA\u0007cQR\u0011\u00111D\u0001\u000f\u000f\u0016|W.\u001a;ss^\u0013\u0018\u000e^3s+\t\t)\u0003\u0005\u0003\u0002(\u0005URBAA\u0015\u0015\u0011\tY#!\f\u0002\u000f\u001d,wN[:p]*!\u0011qFA\u0019\u0003\tIwNC\u0002\u00024q\u000b1A\u001b;t\u0013\u0011\t9$!\u000b\u0003\u001b\u001d+wNS:p]^\u0013\u0018\u000e^3s\u0003=9Um\\7fiJLxK]5uKJ\u0004\u0013!\u0005&t_:|%M[3diB\u000bG\u000f^3s]V\u0011\u0011q\b\t\u0005\u0003\u0003\ny%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0015\u0011XmZ3y\u0015\u0011\tI%a\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\nAA[1wC&!\u0011\u0011KA\"\u0005\u001d\u0001\u0016\r\u001e;fe:\f!CS:p]>\u0013'.Z2u!\u0006$H/\u001a:oA\u00051qO]5uKJ$B!!\u0017\u0002nA!\u00111LA5\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014AB:ue\u0016\fWN\u0003\u0003\u0002d\u0005\u0015\u0014\u0001B4t_:T1!a\u001ao\u0003\u00199wn\\4mK&!\u00111NA/\u0005)Q5o\u001c8Xe&$XM\u001d\u0005\b\u0003_\u001a\u0002\u0019AA9\u0003\u001d9(/\u00199qK\u0012\u0004B!a\u001d\u0002x5\u0011\u0011Q\u000f\u0006\u0005\u0003_\tY%\u0003\u0003\u0002z\u0005U$AB,sSR,'/A\u000bde\u0016\fG/Z!uiJL'-\u001e;f/JLG/\u001a:\u0015\r\u0005}$Q\u0019Bd!\r\t\t)F\u0007\u0002\u001b\t\u0019\"j]8o\u0003R$(/\u001b2vi\u0016<&/\u001b;feN\u0011QCY\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u0017\u000b\t*!'\u0011\u0007\r\fi)C\u0002\u0002\u0010\u0012\u0014A!\u00168ji\"1\u0001P\u0006a\u0001\u0003'\u00032\u0001^AK\u0013\r\t9*\u001e\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005Uc\u00031\u0001\u0002Z%bQC\u000b 0i\u0001\u001a5\nG\u0013\u001cs\ti!i\\8mK\u0006twK]5uKJ\u001cBA\u000b2\u0002\u0000\u0005!a.Y7f!\u0011\t)+a-\u000f\t\u0005\u001d\u0016q\u0016\t\u0004\u0003S#WBAAV\u0015\r\ti\u000bY\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005EF-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c#\u0017!A5\u0015\r\u0005u\u0016qXAa!\r\t\tI\u000b\u0005\b\u0003Ck\u0003\u0019AAR\u0011\u001d\tI,\fa\u0001\u0003\u0013!b!a#\u0002F\u0006\u001d\u0007B\u0002=/\u0001\u0004\t\u0019\nC\u0004\u0002V9\u0002\r!!\u0017\u0003\u0017\tKH/Z:Xe&$XM]\n\u0005}\t\fy\b\u0006\u0004\u0002P\u0006E\u00171\u001b\t\u0004\u0003\u0003s\u0004bBAQ\u0003\u0002\u0007\u00111\u0015\u0005\b\u0003s\u000b\u0005\u0019AA\u0005)\u0019\tY)a6\u0002Z\"1\u0001P\u0011a\u0001\u0003'Cq!!\u0016C\u0001\u0004\tIF\u0001\u0006ECR,wK]5uKJ\u001cBa\f2\u0002\u0000Q1\u0011\u0011]Ar\u0003K\u00042!!!0\u0011\u001d\t\tK\ra\u0001\u0003GCq!!/3\u0001\u0004\tI\u0001\u0006\u0004\u0002\f\u0006%\u00181\u001e\u0005\u0007qN\u0002\r!a%\t\u000f\u0005U3\u00071\u0001\u0002Z\tqq)Z8nKR\u0014\u0018p\u0016:ji\u0016\u00148\u0003\u0002\u001bc\u0003\u007f\"b!a=\u0002v\u0006]\bcAAAi!9\u0011\u0011U\u001cA\u0002\u0005\r\u0006bBA]o\u0001\u0007\u0011\u0011\u0002\u000b\u0007\u0003\u0017\u000bY0!@\t\raD\u0004\u0019AAJ\u0011\u001d\t)\u0006\u000fa\u0001\u00033\u0012\u0001CS:p]N#(/\u001b8h/JLG/\u001a:\u0014\t\u0001\u0012\u0017q\u0010\u000b\u0007\u0005\u000b\u00119A!\u0003\u0011\u0007\u0005\u0005\u0005\u0005C\u0004\u0002\"\u000e\u0002\r!a)\t\u000f\u0005e6\u00051\u0001\u0002\nQ1\u00111\u0012B\u0007\u0005\u001fAa\u0001\u001f\u0013A\u0002\u0005M\u0005bBA+I\u0001\u0007\u0011\u0011\f\u0002\u000b\u0019&\u001cHo\u0016:ji\u0016\u00148\u0003B\"c\u0003\u007f\nqAY5oI&tw\r\u0005\u0003\u0003\u001a\tmb\u0002\u0002B\u000e\u0005kqAA!\b\u000309!!q\u0004B\u0016\u001d\u0011\u0011\tC!\u000b\u000f\t\t\r\"q\u0005\b\u0005\u0003S\u0013)#C\u0001`\u0013\tif,\u0003\u0002\\9&\u0019!Q\u0006.\u0002\u000bU$\u0018\u000e\\:\n\t\tE\"1G\u0001\tO\u0016|Go\\8mg*\u0019!Q\u0006.\n\t\t]\"\u0011H\u0001\u000b\u001f\nTWm\u0019;UsB,'\u0002\u0002B\u0019\u0005gIAA!\u0010\u0003@\tQqJ\u00196fGR$\u0016\u0010]3\u000b\t\t]\"\u0011\b\u000b\t\u0005\u0007\u0012)Ea\u0012\u0003JA\u0019\u0011\u0011Q\"\t\u000f\u0005\u0005v\t1\u0001\u0002$\"9\u0011\u0011X$A\u0002\u0005%\u0001b\u0002B\u000b\u000f\u0002\u0007!qC\u0001\u000eK2,W.\u001a8u/JLG/\u001a:\u0016\u0005\t=\u0003#C2\u0003R\u0005e#QKAF\u0013\r\u0011\u0019\u0006\u001a\u0002\n\rVt7\r^5p]J\u00022a\u0019B,\u0013\r\u0011I\u0006\u001a\u0002\u0004\u0003:L\u0018AD3mK6,g\u000e^,sSR,'\u000f\t\u000b\u0007\u0003\u0017\u0013yF!\u0019\t\raT\u0005\u0019AAJ\u0011\u001d\t)F\u0013a\u0001\u00033\u0012\u0011\"T1q/JLG/\u001a:\u0014\t-\u0013\u0017qP\u0001\u000bW\u0016L()\u001b8eS:<\u0017\u0001\u0004<bYV,')\u001b8eS:<GC\u0003B7\u0005_\u0012\tHa\u001d\u0003vA\u0019\u0011\u0011Q&\t\u000f\u0005\u0005\u0006\u000b1\u0001\u0002$\"9\u0011\u0011\u0018)A\u0002\u0005%\u0001b\u0002B4!\u0002\u0007!q\u0003\u0005\b\u0005S\u0002\u0006\u0019\u0001B\f\u0003-1\u0018\r\\;f/JLG/\u001a:\u0002\u0019Y\fG.^3Xe&$XM\u001d\u0011\u0015\r\u0005-%Q\u0010B@\u0011\u0019A8\u000b1\u0001\u0002\u0014\"9\u0011QK*A\u0002\u0005e#A\u0003(p_B<&/\u001b;feN!\u0001DYA@)\t\u00119\tE\u0002\u0002\u0002b!b!a#\u0003\f\n5\u0005B\u0002=\u001b\u0001\u0004\t\u0019\nC\u0004\u0002Vi\u0001\r!!\u0017\u0003\u00199+XNY3s/JLG/\u001a:\u0014\t\u0015\u0012\u0017q\u0010\u000b\u0007\u0005+\u00139J!'\u0011\u0007\u0005\u0005U\u0005C\u0004\u0002\"\"\u0002\r!a)\t\u000f\u0005e\u0006\u00061\u0001\u0002\nQ1\u00111\u0012BO\u0005?Ca\u0001_\u0015A\u0002\u0005M\u0005bBA+S\u0001\u0007\u0011\u0011\f\u0002\r'R\u0014\u0018N\\4Xe&$XM]\n\u00057\t\fy\b\u0006\u0004\u0003(\n%&1\u0016\t\u0004\u0003\u0003[\u0002bBAQ=\u0001\u0007\u00111\u0015\u0005\b\u0003ss\u0002\u0019AA\u0005)\u0019\tYIa,\u00032\"1\u0001p\ba\u0001\u0003'Cq!!\u0016 \u0001\u0004\tIF\u0001\u0006Vk&$wK]5uKJ\u001cB!\u000f2\u0002\u0000Q1!\u0011\u0018B^\u0005{\u00032!!!:\u0011\u001d\t\t\u000b\u0010a\u0001\u0003GCq!!/=\u0001\u0004\tI\u0001\u0006\u0004\u0002\f\n\u0005'1\u0019\u0005\u0007qv\u0002\r!a%\t\u000f\u0005US\b1\u0001\u0002Z!)!\u000f\u0006a\u0001g\"9\u0011\u0011\u0018\u000bA\u0002\u0005%\u0011A\u0003(p_B<&/\u001b;fe\u0006I1/\u001e2Xe&$XM\u001d\u000b\u0005\u0005\u001f\u0012y\rC\u0004\u0003\u0016Q\u0003\rAa\u0006\u0002\u001f\u001d,w.\\3uef<&/\u001b;fe\u0002\n\u0001#\u0019;ue&\u0014W\u000f^3Xe&$XM]:\u0016\u0005\t]\u0007C\u0002Bm\u0005G\u00149/\u0004\u0002\u0003\\*!!Q\u001cBp\u0003%IW.\\;uC\ndWMC\u0002\u0003b\u0012\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Oa7\u0003\u0007M+\u0017\u000fE\u0002\u0002\u0018U\t\u0011#\u0019;ue&\u0014W\u000f^3Xe&$XM]:!\u0003Y\u0019H/\u0019:u\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>tG\u0003BAF\u0005_Dq!!\u0016\n\u0001\u0004\tI&A\u0003xe&$X\r\u0006\u0004\u0002\f\nU(q\u001f\u0005\b\u0003+R\u0001\u0019AA-\u0011\u0019A(\u00021\u0001\u0002\u0014\u0006!RM\u001c3GK\u0006$XO]3D_2dWm\u0019;j_:$B!a#\u0003~\"9\u0011QK\u0006A\u0002\u0005e\u0003")
public class GeoJsonSerializer
implements LazyLogging {
    private final SimpleFeatureType sft;
    private final int defaultGeomIndex;
    private final GeometryWriter geometryWriter;
    private final Seq<JsonAttributeWriter> attributeWriters;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static JsonWriter writer(Writer wrapped) {
        return GeoJsonSerializer$.MODULE$.writer(wrapped);
    }

    private Logger logger$lzycompute() {
        GeoJsonSerializer geoJsonSerializer = this;
        synchronized (geoJsonSerializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private int defaultGeomIndex() {
        return this.defaultGeomIndex;
    }

    private GeometryWriter geometryWriter() {
        return this.geometryWriter;
    }

    private Seq<JsonAttributeWriter> attributeWriters() {
        return this.attributeWriters;
    }

    public void startFeatureCollection(JsonWriter writer) {
        writer.beginObject().name("type").value("FeatureCollection").name("features").beginArray();
    }

    public void write(JsonWriter writer, SimpleFeature feature) {
        writer.beginObject();
        writer.name("type").value("Feature");
        writer.name("id").value(feature.getID());
        this.geometryWriter().apply(feature, writer);
        writer.name("properties").beginObject();
        this.attributeWriters().foreach((Function1 & Serializable)x$1 -> {
            x$1.apply(feature, writer);
            return BoxedUnit.UNIT;
        });
        writer.endObject();
        writer.endObject();
    }

    public void endFeatureCollection(JsonWriter writer) {
        writer.endArray().endObject();
    }

    public GeoJsonSerializer(SimpleFeatureType sft) {
        this.sft = sft;
        LazyLogging.$init$((LazyLogging)this);
        this.defaultGeomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        this.geometryWriter = new GeometryWriter("geometry", this.defaultGeomIndex());
        this.attributeWriters = (Seq)package$.MODULE$.Seq().tabulate(sft.getAttributeCount() - 1, (Function1 & Serializable)i -> GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$createAttributeWriter(this.sft, BoxesRunTime.unboxToInt((Object)i) < this.defaultGeomIndex() ? BoxesRunTime.unboxToInt((Object)i) : BoxesRunTime.unboxToInt((Object)i) + 1));
    }

    private static class BooleanWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Boolean)feature.getAttribute(this.i));
        }

        public BooleanWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class BytesWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            byte[] bytes = (byte[])feature.getAttribute(this.i);
            if (bytes == null) {
                writer.nullValue();
                return;
            }
            writer.value(Base64.getEncoder().encodeToString(bytes));
        }

        public BytesWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class DateWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Date date = (Date)feature.getAttribute(this.i);
            if (date == null) {
                writer.nullValue();
                return;
            }
            writer.value(DateParsing$.MODULE$.formatDate(date, DateParsing$.MODULE$.formatDate$default$2()));
        }

        public DateWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class GeometryWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Geometry geom = (Geometry)feature.getAttribute(this.i);
            if (geom == null) {
                writer.nullValue();
                return;
            }
            writer.jsonValue(GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$GeometryWriter().write(geom));
        }

        public GeometryWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static interface JsonAttributeWriter {
        public void apply(SimpleFeature var1, JsonWriter var2);
    }

    private static class JsonStringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            block5: {
                writer.name(this.name);
                String string = (String)feature.getAttribute(this.i);
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string != null) break;
                        writer.nullValue();
                        break block5;
                    }
                }
                if (GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$JsonObjectPattern().matcher(string).find()) {
                    writer.jsonValue(string.trim());
                } else {
                    writer.value(string);
                }
            }
        }

        public JsonStringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class ListWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> elementWriter;

        private Function2<JsonWriter, Object, BoxedUnit> elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            List list = (List)feature.getAttribute(this.i);
            if (list == null) {
                writer.nullValue();
                return;
            }
            writer.beginArray();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable)x$2 -> {
                ListWriter.$anonfun$apply$1(this, writer, x$2);
                return BoxedUnit.UNIT;
            });
            writer.endArray();
        }

        public static final /* synthetic */ void $anonfun$apply$1(ListWriter $this, JsonWriter writer$2, Object x$2) {
            $this.elementWriter().apply((Object)writer$2, x$2);
        }

        public ListWriter(String name, int i, Enumeration.Value binding) {
            this.name = name;
            this.i = i;
            this.elementWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(binding);
        }
    }

    private static class MapWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;
        private final Function2<JsonWriter, Object, BoxedUnit> valueWriter;

        private Function2<JsonWriter, Object, BoxedUnit> valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            Map map = (Map)feature.getAttribute(this.i);
            if (map == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                MapWriter.$anonfun$apply$2(this, writer, x0$1);
                return BoxedUnit.UNIT;
            });
            writer.endObject();
        }

        public static final /* synthetic */ void $anonfun$apply$2(MapWriter $this, JsonWriter writer$3, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                writer$3.name(k.toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.valueWriter().apply((Object)writer$3, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public MapWriter(String name, int i, Enumeration.Value keyBinding, Enumeration.Value valueBinding) {
            this.name = name;
            this.i = i;
            this.valueWriter = GeoJsonSerializer$.MODULE$.org$locationtech$geomesa$features$serialization$GeoJsonSerializer$$subWriter(valueBinding);
        }
    }

    private static class NumberWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((Number)feature.getAttribute(this.i));
        }

        public NumberWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class StringWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name).value((String)feature.getAttribute(this.i));
        }

        public StringWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }

    private static class UuidWriter
    implements JsonAttributeWriter {
        private final String name;
        private final int i;

        @Override
        public void apply(SimpleFeature feature, JsonWriter writer) {
            writer.name(this.name);
            UUID uuid = (UUID)feature.getAttribute(this.i);
            if (uuid == null) {
                writer.nullValue();
                return;
            }
            writer.value(uuid.toString());
        }

        public UuidWriter(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }
}

