/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.json;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser;
import org.locationtech.geomesa.features.kryo.json.KryoJsonPath;
import org.locationtech.geomesa.features.kryo.json.KryoJsonSerialization;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

public final class KryoJsonSerialization$
implements LazyLogging {
    public static KryoJsonSerialization$ MODULE$;
    private final byte TerminalByte;
    private final byte DoubleByte;
    private final byte StringByte;
    private final byte DocByte;
    private final byte ArrayByte;
    private final byte BooleanByte;
    private final byte NullByte;
    private final byte IntByte;
    private final byte LongByte;
    private final byte BooleanFalse;
    private final byte BooleanTrue;
    private final byte NonDoc;
    private final ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new KryoJsonSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoJsonSerialization$ kryoJsonSerialization$ = this;
        synchronized (kryoJsonSerialization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public byte TerminalByte() {
        return this.TerminalByte;
    }

    public byte DoubleByte() {
        return this.DoubleByte;
    }

    public byte StringByte() {
        return this.StringByte;
    }

    public byte DocByte() {
        return this.DocByte;
    }

    public byte ArrayByte() {
        return this.ArrayByte;
    }

    public byte BooleanByte() {
        return this.BooleanByte;
    }

    public byte NullByte() {
        return this.NullByte;
    }

    public byte IntByte() {
        return this.IntByte;
    }

    public byte LongByte() {
        return this.LongByte;
    }

    public byte BooleanFalse() {
        return this.BooleanFalse;
    }

    public byte BooleanTrue() {
        return this.BooleanTrue;
    }

    public byte NonDoc() {
        return this.NonDoc;
    }

    public ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    }

    public void serialize(Output out, String json) {
        JsonAST.JValue jValue;
        if (json == null) {
            jValue = null;
        } else {
            try {
                jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(20).append("Error parsing json:\n").append(json).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    jValue = null;
                }
                throw throwable;
            }
        }
        JsonAST.JValue obj = jValue;
        this.serialize(out, obj);
    }

    public void serialize(Output out, JsonAST.JValue json) {
        JsonAST.JValue jValue = json;
        if (jValue == null ? true : JsonAST.JNull$.MODULE$.equals(jValue)) {
            out.write((int)this.BooleanFalse());
            return;
        }
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            out.write((int)this.BooleanTrue());
            this.writeDocument(out, jObject);
            return;
        }
        out.write((int)this.NonDoc());
        this.writeValue(out, "", jValue);
    }

    public String deserializeAndRender(Input in) {
        JsonAST.JValue json = this.deserialize(in);
        if (json == null) {
            return null;
        }
        JsonAST.JValue x$1 = json;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2));
    }

    public JsonAST.JValue deserialize(Input in) {
        JsonAST.JObject jObject;
        block8: {
            try {
                byte by = in.readByte();
                if (this.BooleanFalse() == by) {
                    jObject = null;
                    break block8;
                }
                if (this.BooleanTrue() == by) {
                    jObject = this.readDocument(in);
                    break block8;
                }
                if (this.NonDoc() == by) {
                    jObject = (JsonAST.JValue)this.readValue(in)._2();
                    break block8;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error reading serialized kryo json", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    jObject = null;
                }
                throw throwable;
            }
        }
        return jObject;
    }

    public Object deserialize(Input in, JsonPathParser.JsonPath path) {
        Object object;
        if (path.isEmpty()) {
            return this.deserializeAndRender(in);
        }
        try {
            object = new KryoJsonPath(in).deserialize(path);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error reading serialized kryo json", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = null;
            }
            throw throwable;
        }
        return object;
    }

    private void writeDocument(Output out, String name, JsonAST.JObject value) {
        out.writeByte(this.DocByte());
        this.RichOutput(out).writeName(name);
        this.writeDocument(out, value);
    }

    private void writeDocument(Output out, JsonAST.JObject value) {
        int start = out.position();
        out.writeInt(0);
        value.obj().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KryoJsonSerialization$.$anonfun$writeDocument$1(out, x0$1);
            return BoxedUnit.UNIT;
        });
        out.writeByte(this.TerminalByte());
        int end = out.position();
        out.setPosition(start);
        out.writeInt(end - start);
        out.setPosition(end);
    }

    private void writeValue(Output out, String name, JsonAST.JValue value) {
        JsonAST.JValue jValue = value;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            this.writeString(out, name, jString);
            return;
        }
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            this.writeDocument(out, name, jObject);
            return;
        }
        if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            this.writeArray(out, name, jArray);
            return;
        }
        if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            this.writeDouble(out, name, jDouble);
            return;
        }
        if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            this.writeInt(out, name, jInt);
            return;
        }
        if (jValue instanceof JsonAST.JLong) {
            JsonAST.JLong jLong = (JsonAST.JLong)jValue;
            this.writeLong(out, name, jLong);
            return;
        }
        if (JsonAST.JNull$.MODULE$.equals(jValue)) {
            this.writeNull(out, name);
            return;
        }
        if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            this.writeBoolean(out, name, jBool);
            return;
        }
        if (jValue instanceof JsonAST.JDecimal) {
            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
            this.writeDecimal(out, name, jDecimal);
            return;
        }
        throw new MatchError((Object)jValue);
    }

    private void writeArray(Output out, String name, JsonAST.JArray value) {
        out.writeByte(this.ArrayByte());
        this.RichOutput(out).writeName(name);
        IntRef i = IntRef.create((int)-1);
        List withKeys = (List)value.arr().map((Function1 & Serializable & scala.Serializable)element -> {
            ++i$1.elem;
            return new Tuple2((Object)Integer.toString(i$1.elem), element);
        }, List$.MODULE$.canBuildFrom());
        this.writeDocument(out, new JsonAST.JObject(withKeys));
    }

    private void writeString(Output out, String name, JsonAST.JString value) {
        out.writeByte(this.StringByte());
        this.RichOutput(out).writeName(name);
        byte[] bytes = value.values().getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeByte(this.TerminalByte());
    }

    private void writeDecimal(Output out, String name, JsonAST.JDecimal value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values().toDouble());
    }

    private void writeDouble(Output out, String name, JsonAST.JDouble value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values());
    }

    private void writeInt(Output out, String name, JsonAST.JInt value) {
        BoxedUnit boxedUnit;
        if (value.values().isValidInt()) {
            out.writeByte(this.IntByte());
            this.RichOutput(out).writeName(name);
            out.writeInt(value.values().intValue());
            return;
        }
        if (value.values().isValidLong()) {
            out.writeByte(this.LongByte());
            this.RichOutput(out).writeName(name);
            out.writeLong(value.values().longValue());
            return;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Skipping int value that does not fit in a long: {}", new Object[]{value});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void writeLong(Output out, String name, JsonAST.JLong value) {
        out.writeByte(this.LongByte());
        this.RichOutput(out).writeName(name);
        out.writeLong(value.values());
    }

    private void writeBoolean(Output out, String name, JsonAST.JBool v) {
        out.writeByte(this.BooleanByte());
        this.RichOutput(out).writeName(name);
        out.writeByte(v.values() ? this.BooleanTrue() : this.BooleanFalse());
    }

    private void writeNull(Output out, String name) {
        out.writeByte(this.NullByte());
        this.RichOutput(out).writeName(name);
    }

    public JsonAST.JObject readDocument(Input in) {
        int end = in.position() + in.readInt() - 1;
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (in.position() < end) {
            elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.readValue(in)}));
        }
        in.skip(1);
        return new JsonAST.JObject(elements.toList());
    }

    public Tuple2<String, JsonAST.JValue> readValue(Input in) {
        JsonAST.JString jString;
        byte by = in.readByte();
        String name = this.RichInput(in).readName();
        byte by2 = by;
        if (this.StringByte() == by2) {
            jString = new JsonAST.JString(this.readString(in));
        } else if (this.DocByte() == by2) {
            jString = this.readDocument(in);
        } else if (this.ArrayByte() == by2) {
            jString = this.readArray(in);
        } else if (this.DoubleByte() == by2) {
            jString = new JsonAST.JDouble(in.readDouble());
        } else if (this.IntByte() == by2) {
            jString = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(in.readInt()));
        } else if (this.LongByte() == by2) {
            jString = new JsonAST.JLong(in.readLong());
        } else if (this.NullByte() == by2) {
            jString = JsonAST.JNull$.MODULE$;
        } else if (this.BooleanByte() == by2) {
            jString = new JsonAST.JBool(this.readBoolean(in));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
        }
        JsonAST.JString value = jString;
        return JsonAST.JField$.MODULE$.apply(name, (JsonAST.JValue)value);
    }

    public JsonAST.JArray readArray(Input in) {
        return new JsonAST.JArray((List)this.readDocument(in).obj().map((Function1 & Serializable & scala.Serializable)x$1 -> (JsonAST.JValue)x$1._2(), List$.MODULE$.canBuildFrom()));
    }

    public void skipDocument(Input in) {
        in.skip(in.readInt() - 4);
    }

    public String readString(Input in) {
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.read(bytes);
        in.skip(1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void skipString(Input in) {
        in.skip(in.readInt() + 1);
    }

    public boolean readBoolean(Input in) {
        return in.readByte() == this.BooleanTrue();
    }

    public void skipBoolean(Input in) {
        in.skip(1);
    }

    public KryoJsonSerialization.RichOutput RichOutput(Output out) {
        return new KryoJsonSerialization.RichOutput(out);
    }

    public KryoJsonSerialization.RichInput RichInput(Input in) {
        return new KryoJsonSerialization.RichInput(in);
    }

    public static final /* synthetic */ void $anonfun$writeDocument$1(Output out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            JsonAST.JValue elem = (JsonAST.JValue)tuple2._2();
            MODULE$.writeValue(out$1, name, elem);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private KryoJsonSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.TerminalByte = 0;
        this.DoubleByte = 1;
        this.StringByte = (byte)2;
        this.DocByte = (byte)3;
        this.ArrayByte = (byte)4;
        this.BooleanByte = (byte)8;
        this.NullByte = (byte)10;
        this.IntByte = (byte)16;
        this.LongByte = (byte)18;
        this.BooleanFalse = 0;
        this.BooleanTrue = 1;
        this.NonDoc = (byte)2;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers = new ThreadLocal<byte[]>(){

            public byte[] initialValue() {
                return (byte[])Array$.MODULE$.ofDim(32, ClassTag$.MODULE$.Byte());
            }
        };
    }
}

