/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.fs.data.FileSystemDataStoreFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcSimpleFeatureActionInputFormat;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcSimpleFeatureInputFormat;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcSimpleFeatureInputFormat$;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.parquet.jobs.ParquetSimpleFeatureActionInputFormat;
import org.locationtech.geomesa.parquet.jobs.ParquetSimpleFeatureInputFormat;
import org.locationtech.geomesa.parquet.jobs.ParquetSimpleFeatureInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0003\u0007\u0001EAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQ\u0001\u0016\u0001\u0005BUCQ\u0001\u001f\u0001\u0005Be\u0014QCR5mKNK8\u000f^3n%\u0012#\u0005K]8wS\u0012,'O\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0003MNT!a\u0003\u0007\u0002\u000f\u001d,w.\\3tC*\u0011QBD\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\r\u001e!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011dG\u0007\u00025)\u0011qAC\u0005\u00039i\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011a$J\u0007\u0002?)\u0011\u0001%I\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003E\r\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002I\u0005\u00191m\\7\n\u0005\u0019z\"a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"\u0001\u0004\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002.aA\u00111CL\u0005\u0003_Q\u0011qAQ8pY\u0016\fg\u000eC\u00032\u0005\u0001\u0007!'\u0001\u0004qCJ\fWn\u001d\u0019\u0003g!\u0003B\u0001N\u001d<\r6\tQG\u0003\u00027o\u0005!Q\u000f^5m\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\u00075\u000b\u0007\u000f\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}Qi\u0011a\u0010\u0006\u0003\u0001B\ta\u0001\u0010:p_Rt\u0014B\u0001\"\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t#\u0002CA$I\u0019\u0001!\u0011\"\u0013\u0019\u0002\u0002\u0003\u0005)\u0011\u0001&\u0003\u0007}#\u0013'\u0005\u0002L\u001dB\u00111\u0003T\u0005\u0003\u001bR\u0011qAT8uQ&tw\r\u0005\u0002P%6\t\u0001K\u0003\u0002Ro\u0005\u0011\u0011n\\\u0005\u0003'B\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1A\u001d3e)\u00151\u0016\fZ6o!\tIr+\u0003\u0002Y5\tQ1\u000b]1uS\u0006d'\u000b\u0012#\t\u000bi\u001b\u0001\u0019A.\u0002\t\r|gN\u001a\t\u00039\nl\u0011!\u0018\u0006\u00035zS!a\u00181\u0002\r!\fGm\\8q\u0015\t\tg\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Gv\u0013QbQ8oM&<WO]1uS>t\u0007\"B3\u0004\u0001\u00041\u0017AA:d!\t9\u0017.D\u0001i\u0015\t9\u0001-\u0003\u0002kQ\na1\u000b]1sW\u000e{g\u000e^3yi\")\u0011g\u0001a\u0001YB!A(\\\u001e<\u0013\tQT\tC\u0003p\u0007\u0001\u0007\u0001/A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002rm6\t!O\u0003\u0002ti\u0006!A-\u0019;b\u0015\t)h\"\u0001\u0005hK>$xn\u001c7t\u0013\t9(OA\u0003Rk\u0016\u0014\u00180\u0001\u0003tCZ,GC\u0002>~\u00037\ti\u0002\u0005\u0002\u0014w&\u0011A\u0010\u0006\u0002\u0005+:LG\u000fC\u0003U\t\u0001\u0007a\u0010E\u0003\u0000\u0003\u0007\t9!\u0004\u0002\u0002\u0002)\u0011A\u000b[\u0005\u0005\u0003\u000b\t\tAA\u0002S\t\u0012\u0003B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003#\t\u0019\"A\u0004gK\u0006$XO]3\u000b\u0007\u0005Ua\"A\u0004pa\u0016tw-[:\n\t\u0005e\u00111\u0002\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000bE\"\u0001\u0019\u00017\t\r\u0005}A\u00011\u0001<\u0003!!\u0018\u0010]3OC6,\u0007")
public class FileSystemRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return SpatialRDDProvider.sft$((SpatialRDDProvider)this, params, (String)typeName);
    }

    private Logger logger$lzycompute() {
        FileSystemRDDProvider fileSystemRDDProvider = this;
        synchronized (fileSystemRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return FileSystemDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        return (SpatialRDD)WithStore$.MODULE$.apply(params).apply((Function1 & Serializable & scala.Serializable)ds -> {
            RDD rDD;
            SimpleFeatureType sft = ds.getSchema(query.getTypeName());
            FileSystemStorage storage = ds.storage(query.getTypeName());
            ArrayBuffer partitioned = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            storage.getPartitionFilters(query.getFilter(), storage.getPartitionFilters$default$2()).foreach((Function1 & Serializable & scala.Serializable)fp -> {
                ListBuffer defaults = (ListBuffer)ListBuffer$.MODULE$.empty();
                ListBuffer defaultPartitions = (ListBuffer)ListBuffer$.MODULE$.empty();
                fp.partitions().foreach((Function1 & Serializable & scala.Serializable)p -> {
                    BoxedUnit boxedUnit;
                    Seq files = storage.getFilePaths(p);
                    if (files.nonEmpty()) {
                        if (files.forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FileSystemRDDProvider.$anonfun$rdd$9(x$7)))) {
                            defaults.$plus$plus$eq((TraversableOnce)files);
                            boxedUnit = defaultPartitions.$plus$eq(p);
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder(87).append("Found modifications for partition '").append((String)p).append("': ").append("compact the partition to improve read performance").toString());
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            boxedUnit = partitioned.$plus$eq((Object)new Tuple4(p, (Object)fp.filter(), (Object)files, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                return defaults.nonEmpty() ? partitioned.$plus$eq((Object)new Tuple4((Object)defaultPartitions.mkString("', '"), (Object)fp.filter(), (Object)defaults, (Object)BoxesRunTime.boxToBoolean((boolean)false))) : BoxedUnit.UNIT;
            });
            if (partitioned.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Reading 0 partitions");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                rDD = sc.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class));
            } else {
                ArrayBuffer rdds = (ArrayBuffer)partitioned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    boolean modifications;
                    Seq files;
                    Filter filter;
                    Tuple4 tuple4 = x0$1;
                    if (tuple4 != null) {
                        BoxedUnit boxedUnit;
                        String names = (String)tuple4._1();
                        filter = (Filter)tuple4._2();
                        files = (Seq)tuple4._3();
                        modifications = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Reading partitions '{}' with {} files with filter: {}", new Object[]{names, BoxesRunTime.boxToInteger((int)files.length()), ECQL.toCQL((Filter)filter)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple4);
                    }
                    RDD rDD = FileSystemRDDProvider.runQuery$1(filter, files, modifications, conf, storage, sft, query, sc);
                    return rDD;
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                rDD = (RDD)rdds.reduceLeft((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> x$8.union(x$9));
            }
            RDD rdd = rDD;
            return SpatialRDD$.MODULE$.apply(rdd, sft);
        });
    }

    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> params, String typeName) {
        WithStore$.MODULE$.apply(params).apply((Function1 & Serializable & scala.Serializable)ds -> {
            Predef$.MODULE$.require(ds.getSchema(typeName) != null, (Function0 & Serializable & scala.Serializable)() -> "Feature type must exist before calling save. Call createSchema on the DataStore first.");
            return BoxedUnit.UNIT;
        });
        rdd.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            FileSystemRDDProvider.$anonfun$save$3(params, typeName, iter);
            return BoxedUnit.UNIT;
        });
    }

    private static final RDD runQuery$1(Filter filter, Seq paths, boolean modifications, Configuration conf$1, FileSystemStorage storage$1, SimpleFeatureType sft$1, Query query$1, SparkContext sc$1) {
        RDD rDD;
        Tuple2 tuple2;
        Job job = Job.getInstance((Configuration)conf$1);
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])((TraversableOnce)paths.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.path(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Path.class))));
        conf$1.set("mapreduce.input.fileinputformat.inputdir", job.getConfiguration().get("mapreduce.input.fileinputformat.inputdir"));
        String string = storage$1.metadata().encoding();
        String string2 = OrcFileSystemStorage$.MODULE$.Encoding();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            OrcSimpleFeatureInputFormat$.MODULE$.configure(conf$1, sft$1, query$1.getFilter(), query$1.getPropertyNames());
            tuple2 = new Tuple2(OrcSimpleFeatureInputFormat.class, OrcSimpleFeatureActionInputFormat.class);
        } else {
            String string3 = storage$1.metadata().encoding();
            String string4 = ParquetFileSystemStorage$.MODULE$.Encoding();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                ParquetSimpleFeatureInputFormat$.MODULE$.configure(conf$1, sft$1, query$1);
                tuple2 = new Tuple2(ParquetSimpleFeatureInputFormat.class, ParquetSimpleFeatureActionInputFormat.class);
            } else {
                throw new NotImplementedError(new StringBuilder(31).append("Not implemented for encoding '").append(storage$1.metadata().encoding()).append("'").toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Class base = (Class)tuple22._1();
        Class action = (Class)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)base, (Object)action);
        Tuple2 tuple24 = tuple23;
        Class base2 = (Class)tuple24._1();
        Class action2 = (Class)tuple24._2();
        if (modifications) {
            StorageConfiguration$.MODULE$.setPathActions(conf$1, paths);
            RDD rdd = sc$1.newAPIHadoopRDD(conf$1, action2, StorageConfiguration.SimpleFeatureAction.class, SimpleFeature.class);
            rDD = rdd.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> ((StorageConfiguration.SimpleFeatureAction)x$3._1()).id(), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    Iterable group = (Iterable)tuple22._2();
                    Tuple2 tuple23 = (Tuple2)group.minBy((Function1 & Serializable & scala.Serializable)x$4 -> (StorageConfiguration.SimpleFeatureAction)x$4._1(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    StorageConfiguration.SimpleFeatureAction action = (StorageConfiguration.SimpleFeatureAction)tuple23._1();
                    SimpleFeature sf = (SimpleFeature)tuple23._2();
                    tuple2 = new Tuple2((Object)action, (Object)sf);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple24 = tuple2;
                StorageConfiguration.SimpleFeatureAction action = (StorageConfiguration.SimpleFeatureAction)tuple24._1();
                SimpleFeature sf = (SimpleFeature)tuple24._2();
                Enumeration.Value value = action.action();
                Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Delete();
                Iterable iterable = !(value != null ? !value.equals(value2) : value2 != null) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)sf));
                return iterable;
            }, ClassTag$.MODULE$.apply(SimpleFeature.class));
        } else {
            rDD = sc$1.newAPIHadoopRDD(conf$1, base2, Void.class, SimpleFeature.class).map((Function1 & Serializable & scala.Serializable)x$6 -> (SimpleFeature)x$6._2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        return rDD;
    }

    public static final /* synthetic */ boolean $anonfun$rdd$9(StorageMetadata.StorageFilePath x$7) {
        Enumeration.Value value = x$7.file().action();
        Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Append();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ void $anonfun$save$3(scala.collection.immutable.Map params$1, String typeName$1, Iterator iter) {
        WithStore$.MODULE$.apply(params$1).apply((Function1 & Serializable & scala.Serializable)ds -> {
            package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(typeName$1, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                iter$1.foreach((Function1 & Serializable & scala.Serializable)x$10 -> FeatureUtils$.MODULE$.write(writer, x$10, true));
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return BoxedUnit.UNIT;
        });
    }

    public FileSystemRDDProvider() {
        SpatialRDDProvider.$init$((SpatialRDDProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

