/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.hadoop;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.hadoop.HadoopDelegate$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u0016,\u0001YB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006\u001d\u0002!\ta\u0015\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019I\u0006\u0001)A\u0005-\")!\f\u0001C!7\")A\u0010\u0001C!{\"9\u0011\u0011\u0003\u0001\u0005B\u0005MqaBA\u0014W!\u0005\u0011\u0011\u0006\u0004\u0007U-B\t!a\u000b\t\r9SA\u0011AA!\u0011%\t\u0019E\u0003b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002\\)\u0001\u000b\u0011BA$\u0011!\tiF\u0003a\u0001\n\u0013)\u0006\"CA0\u0015\u0001\u0007I\u0011BA1\u0011\u001d\tiG\u0003Q!\nYC\u0011\"a\u001c\u000b\u0005\u0004%\t!!\u001d\t\u0011\u0005u$\u0002)A\u0005\u0003gBq!a \u000b\t\u0013\t\tI\u0002\u0004\u0002\u0004*\u0001\u0011Q\u0011\u0005\u000b\u0003\u000f#\"\u0011!Q\u0001\n\u0005%\u0005BCAH)\t\u0005\t\u0015!\u0003\u0002\u0012\"1a\n\u0006C\u0001\u0003/Caa\u001d\u000b\u0005B\u0005\u0005\u0006BBAR)\u0011\u0005S\u000bC\u0004\u0002&R!\t%a*\t\u000f\u0005=F\u0003\"\u0011\u00022\"9\u0011Q\u001b\u000b\u0005B\u0005]\u0007bBAw)\u0011\u0005\u0013q\u001e\u0004\u0007\u0003gT\u0001!!>\t\u0015\u0005\u001deD!A!\u0002\u0013\tI\t\u0003\u0006\u0002\u0010z\u0011\t\u0011)A\u0005\u0003#CaA\u0014\u0010\u0005\u0002\u0005]\bbBAX=\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003+tB\u0011IA\u0000\r\u0019\u0011)A\u0003\u0001\u0003\b!Q\u0011q\u0011\u0013\u0003\u0002\u0003\u0006I!!#\t\u0015\u0005=EE!A!\u0002\u0013\t\t\n\u0003\u0004OI\u0011\u0005!\u0011\u0002\u0005\b\u0003_#C\u0011IAY\u0011\u001d\t)\u000e\nC!\u0005#\u0011a\u0002S1e_>\u0004H)\u001a7fO\u0006$XM\u0003\u0002-[\u00051\u0001.\u00193p_BT!AL\u0018\u0002\u000bU$\u0018\u000e\\:\u000b\u0005A\n\u0014aB4f_6,7/\u0019\u0006\u0003eM\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0004\u0001]j\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g\r\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006\u0011am\u001d\u0006\u0003\u00056\n!![8\n\u0005\u0011{$A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0012+G.Z4bi\u0016\fAaY8oMB\u0011q\tT\u0007\u0002\u0011*\u0011Q)\u0013\u0006\u0003Y)S!aS\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0013\ti\u0005JA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0013\u0006CA)\u0001\u001b\u0005Y\u0003\"B#\u0003\u0001\u00041E#\u0001)\u0002\u0013I,7-\u001e:tSZ,W#\u0001,\u0011\u0005a:\u0016B\u0001-:\u0005\u001d\u0011un\u001c7fC:\f!B]3dkJ\u001c\u0018N^3!\u0003%9W\r\u001e%b]\u0012dW\r\u0006\u0002]eB\u0011Ql\u001c\b\u0003=6t!a\u00187\u000f\u0005\u0001\\gBA1k\u001d\t\u0011\u0017N\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011a-N\u0001\u0007yI|w\u000e\u001e \n\u0003QJ!AM\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\t\u0011U&\u0003\u0002A\u0003&\u0011anP\u0001\u0013\r&dWmU=ti\u0016lG)\u001a7fO\u0006$X-\u0003\u0002qc\nQa)\u001b7f\u0011\u0006tG\r\\3\u000b\u00059|\u0004\"B:\u0007\u0001\u0004!\u0018\u0001\u00029bi\"\u0004\"!^=\u000f\u0005Y<\bC\u00013:\u0013\tA\u0018(\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=:\u00035Ig\u000e^3saJ,G\u000fU1uQR\u0019a0a\u0004\u0011\t}\fI\u0001\u0018\b\u0005\u0003\u0003\t)AD\u0002e\u0003\u0007I\u0011AO\u0005\u0004\u0003\u000fI\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiAA\u0002TKFT1!a\u0002:\u0011\u0015\u0019x\u00011\u0001u\u0003\u00199W\r^+sYR!\u0011QCA\u0013!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t1A\\3u\u0015\t\ty\"\u0001\u0003kCZ\f\u0017\u0002BA\u0012\u00033\u00111!\u0016*M\u0011\u0015\u0019\b\u00021\u0001u\u00039A\u0015\rZ8pa\u0012+G.Z4bi\u0016\u0004\"!\u0015\u0006\u0014\t)9\u0014Q\u0006\t\u0005\u0003_\ti$\u0004\u0002\u00022)!\u00111GA\u001b\u00031\u00198-\u00197bY><w-\u001b8h\u0015\u0011\t9$!\u000f\u0002\u0011QL\b/Z:bM\u0016T!!a\u000f\u0002\u0007\r|W.\u0003\u0003\u0002@\u0005E\"a\u0003'bufdunZ4j]\u001e$\"!!\u000b\u0002\u000f\u0019\f7\r^8ssV\u0011\u0011q\t\t\u0005\u0003\u0013\n9&\u0004\u0002\u0002L)!\u0011QJA(\u0003%\t'o\u00195jm\u0016\u00148O\u0003\u0003\u0002R\u0005M\u0013\u0001C2p[B\u0014Xm]:\u000b\u0007\u0005U#*A\u0004d_6lwN\\:\n\t\u0005e\u00131\n\u0002\u0015\u0003J\u001c\u0007.\u001b<f'R\u0014X-Y7GC\u000e$xN]=\u0002\u0011\u0019\f7\r^8ss\u0002\nQb]3u+Jdg)Y2u_JL\u0018!E:fiV\u0013HNR1di>\u0014\u0018p\u0018\u0013fcR!\u00111MA5!\rA\u0014QM\u0005\u0004\u0003OJ$\u0001B+oSRD\u0001\"a\u001b\u0010\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014AD:fiV\u0013HNR1di>\u0014\u0018\u0010I\u0001\u0011\u0011&$G-\u001a8GS2,g)\u001b7uKJ,\"!a\u001d\u0011\t\u0005U\u0014\u0011P\u0007\u0003\u0003oR!\u0001Q%\n\t\u0005m\u0014q\u000f\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\u0018!\u0005%jI\u0012,gNR5mK\u001aKG\u000e^3sA\u0005\u00192m\u001c8gS\u001e,(/Z+S\u0019\u001a\u000b7\r^8ssR\u0011\u00111\r\u0002\u0011\u0011\u0006$wn\u001c9GS2,\u0007*\u00198eY\u0016\u001c2\u0001F\u001c]\u0003\t17\r\u0005\u0003\u0002v\u0005-\u0015\u0002BAG\u0003o\u00121BR5mK\u000e{g\u000e^3yi\u0006!a-\u001b7f!\u0011\t)(a%\n\t\u0005U\u0015q\u000f\u0002\u0005!\u0006$\b\u000e\u0006\u0004\u0002\u001a\u0006u\u0015q\u0014\t\u0004\u00037#R\"\u0001\u0006\t\u000f\u0005\u001du\u00031\u0001\u0002\n\"9\u0011qR\fA\u0002\u0005EU#\u0001;\u0002\r\u0015D\u0018n\u001d;t\u0003\u0019aWM\\4uQV\u0011\u0011\u0011\u0016\t\u0004q\u0005-\u0016bAAWs\t!Aj\u001c8h\u0003\u0011y\u0007/\u001a8\u0016\u0005\u0005M\u0006CBA[\u0003w\u000by,\u0004\u0002\u00028*\u0019\u0011\u0011X\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0006]&!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB9\u0001(!1\u0002F\u0006-\u0017bAAbs\t1A+\u001e9mKJ\u0002B\u0001OAdi&\u0019\u0011\u0011Z\u001d\u0003\r=\u0003H/[8o!\u0011\ti-!5\u000e\u0005\u0005='b\u0001\"\u0002\u001e%!\u00111[Ah\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u000b]\u0014\u0018\u000e^3\u0015\r\u0005e\u0017q\\Au!\u0011\ti-a7\n\t\u0005u\u0017q\u001a\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003Cd\u0002\u0019AAr\u0003\u0011iw\u000eZ3\u0011\u0007u\u000b)/C\u0002\u0002hF\u0014!b\u0011:fCR,Wj\u001c3f\u0011!\tY\u000f\bI\u0001\u0002\u00041\u0016!D2sK\u0006$X\rU1sK:$8/\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003G\n\t\u0010C\u0004U;A\u0005\t\u0019\u0001,\u0003\u001f!\u000bGm\\8q5&\u0004\b*\u00198eY\u0016\u001c2AHAM)\u0019\tI0a?\u0002~B\u0019\u00111\u0014\u0010\t\u000f\u0005\u001d\u0015\u00051\u0001\u0002\n\"9\u0011qR\u0011A\u0002\u0005EECBAm\u0005\u0003\u0011\u0019\u0001C\u0004\u0002b\u000e\u0002\r!a9\t\u0011\u0005-8\u0005%AA\u0002Y\u0013q\u0002S1e_>\u0004H+\u0019:IC:$G.Z\n\u0004I\u0005eEC\u0002B\u0006\u0005\u001b\u0011y\u0001E\u0002\u0002\u001c\u0012Bq!a\"(\u0001\u0004\tI\tC\u0004\u0002\u0010\u001e\u0002\r!!%\u0015\r\u0005e'1\u0003B\u000b\u0011\u001d\t\t/\u000ba\u0001\u0003GD\u0001\"a;*!\u0003\u0005\rA\u0016")
public class HadoopDelegate
implements FileSystemDelegate {
    private final Configuration conf;
    private final boolean recursive;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static PathFilter HiddenFileFilter() {
        return HadoopDelegate$.MODULE$.HiddenFileFilter();
    }

    private Logger logger$lzycompute() {
        HadoopDelegate hadoopDelegate = this;
        synchronized (hadoopDelegate) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean recursive() {
        return this.recursive;
    }

    public FileSystemDelegate.FileHandle getHandle(String path) {
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        String string = PathUtils$.MODULE$.getUncompressedExtension(p.getName()).toLowerCase(Locale.US);
        if ("tar".equals(string)) {
            return new HadoopTarHandle(fc, p);
        }
        if ("zip".equals(string) ? true : "jar".equals(string)) {
            return new HadoopZipHandle(fc, p);
        }
        return new HadoopFileHandle(fc, p);
    }

    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        FileStatus[] files = fc.util().globStatus(p, HadoopDelegate$.MODULE$.HiddenFileFilter());
        if (files == null) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Input path does not exist: ").append(path).toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).isEmpty()) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(37).append("Input path does not match any files: ").append(path).toString());
        }
        Queue remaining = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])files));
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            BoxedUnit boxedUnit;
            FileStatus file = (FileStatus)remaining.dequeue();
            if (file.isDirectory()) {
                if (this.recursive()) {
                    RemoteIterator children = fc.listLocatedStatus(file.getPath());
                    Iterator<LocatedFileStatus> iter = new Iterator<LocatedFileStatus>(null, children){
                        private final RemoteIterator children$1;

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<LocatedFileStatus> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<LocatedFileStatus> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<LocatedFileStatus> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<LocatedFileStatus> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<LocatedFileStatus> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<LocatedFileStatus> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<LocatedFileStatus, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.children$1.hasNext();
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.children$1.next();
                        }
                        {
                            this.children$1 = children$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    };
                    boxedUnit = remaining.$plus$plus$eq((TraversableOnce)iter.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegate.$anonfun$interpretPath$1(f))));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            String string = PathUtils$.MODULE$.getUncompressedExtension(file.getPath().getName()).toLowerCase(Locale.US);
            boxedUnit = "tar".equals(string) ? result.$plus$eq((Object)new HadoopTarHandle(fc, file.getPath())) : (("zip".equals(string) ? true : "jar".equals(string)) ? result.$plus$eq((Object)new HadoopZipHandle(fc, file.getPath())) : result.$plus$eq((Object)new HadoopFileHandle(fc, file.getPath())));
        }
        return result.result();
    }

    public URL getUrl(String path) {
        URL uRL;
        try {
            uRL = new URL(path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(14).append("Invalid URL ").append(path).append(": ").toString(), e);
        }
        return uRL;
    }

    public static final /* synthetic */ boolean $anonfun$interpretPath$1(LocatedFileStatus f) {
        return HadoopDelegate$.MODULE$.HiddenFileFilter().accept(f.getPath());
    }

    public HadoopDelegate(Configuration conf) {
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.recursive = conf.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
        HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$hadoop$HadoopDelegate$$configureURLFactory();
    }

    public HadoopDelegate() {
        this(new Configuration());
    }

    public static class HadoopFileHandle
    implements FileSystemDelegate.FileHandle {
        private final FileContext fc;
        private final Path file;
        private String format;
        private volatile boolean bitmap$0;

        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$((FileSystemDelegate.FileHandle)this);
        }

        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$((FileSystemDelegate.FileHandle)this);
        }

        private String format$lzycompute() {
            HadoopFileHandle hadoopFileHandle = this;
            synchronized (hadoopFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$((FileSystemDelegate.FileHandle)this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        public String format() {
            if (!this.bitmap$0) {
                return this.format$lzycompute();
            }
            return this.format;
        }

        public String path() {
            return this.file.toString();
        }

        public boolean exists() {
            return this.fc.util().exists(this.file);
        }

        public long length() {
            if (this.exists()) {
                return this.fc.getFileStatus(this.file).getLen();
            }
            return 0L;
        }

        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> is.close());
        }

        public OutputStream write(int mode, boolean createParents) {
            FileSystemDelegate.CreateMode$.MODULE$.validate$extension(mode);
            EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
            Boolean bl = FileSystemDelegate.CreateMode$.MODULE$.append$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.APPEND)) : (FileSystemDelegate.CreateMode$.MODULE$.overwrite$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.OVERWRITE)) : BoxedUnit.UNIT);
            Object object = FileSystemDelegate.CreateMode$.MODULE$.create$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.CREATE)) : BoxedUnit.UNIT;
            Options.CreateOpts.CreateParent ops = createParents ? Options.CreateOpts.createParent() : Options.CreateOpts.donotCreateParent();
            return this.fc.create(this.file, flags, new Options.CreateOpts[]{ops});
        }

        public void delete(boolean recursive) {
            if (!this.fc.delete(this.file, recursive)) {
                throw new IOException(new java.lang.StringBuilder(23).append("Could not delete file: ").append(this.path()).toString());
            }
        }

        public HadoopFileHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            FileSystemDelegate.FileHandle.$init$((FileSystemDelegate.FileHandle)this);
        }
    }

    public static class HadoopTarHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            ArchiveInputStream archive = HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$hadoop$HadoopDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$hadoop$HadoopDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public HadoopTarHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }

    public static class HadoopZipHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            byte[] bytes = (byte[])package.WithClose$.MODULE$.apply((Object)PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName()), (Function1 & Serializable & scala.Serializable)is -> IOUtils.toByteArray((InputStream)is), IsCloseable$.MODULE$.closeableIsCloseable());
            return new package.ZipFileIterator(new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(bytes)), this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$hadoop$HadoopDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public HadoopZipHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }
}

