/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$IdFromRow$;
import org.locationtech.geomesa.index.api.IndexAdapter$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.conf.splitter.TableSplitter$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainNull$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0011\rf!\u0002/^\u0003\u0003A\u0007BCA\u0010\u0001\t\u0015\r\u0011\"\u0001\u0002\"!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005%\u0003A!b\u0001\n\u0003\tY\u0005\u0003\u0006\u0002b\u0001\u0011\t\u0011)A\u0005\u0003\u001bB!\"a\u0019\u0001\u0005\u000b\u0007I\u0011AA3\u0011)\t9\b\u0001B\u0001B\u0003%\u0011q\r\u0005\u000b\u0003s\u0002!Q1A\u0005\u0002\u0005m\u0004BCAB\u0001\t\u0005\t\u0015!\u0003\u0002~!Q\u0011Q\u0011\u0001\u0003\u0006\u0004%\t!a\"\t\u0015\u0005e\u0005A!A!\u0002\u0013\tI\t\u0003\u0006\u0002\u001c\u0002\u0011)\u0019!C\u0001\u0003;C!\"a/\u0001\u0005\u0003\u0005\u000b\u0011BAP\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fC\u0011\"!:\u0001\u0005\u0004%\t\"!\u001a\t\u0011\u0005\u001d\b\u0001)A\u0005\u0003OB!\"!;\u0001\u0011\u000b\u0007I\u0011CAv\u0011%\u0011\t\u0003\u0001b\u0001\n\u0003\t)\u0007\u0003\u0005\u0004X\u0001\u0001\u000b\u0011BA4\u0011%\u0019I\u0006\u0001b\u0001\n\u0003\u0019Y\u0006\u0003\u0005\u0004d\u0001\u0001\u000b\u0011BB/\u0011\u001d\u00119\f\u0001D\u0001\u0007KBqAa4\u0001\r\u0003\u0019I\u0007C\u0004\u0002f\u0002!\ta! \t\u0013\r\u0015\u0005!%A\u0005\u0002\r\u001d\u0005bBBO\u0001\u0011\u00051q\u0014\u0005\n\u0007S\u0003\u0011\u0013!C\u0001\u0007\u000fC\u0011ba+\u0001#\u0003%\ta!,\t\u000f\rE\u0006\u0001\"\u0001\u00044\"I1q\u0017\u0001\u0012\u0002\u0013\u00051q\u0011\u0005\b\u0007s\u0003A\u0011AB^\u0011%\u0019\t\rAI\u0001\n\u0003\u00199\tC\u0004\u0004D\u0002!\t!a\"\t\u000f\r\u0015\u0007\u0001\"\u0001\u0004H\"I11\u001a\u0001\u0012\u0002\u0013\u00051q\u0011\u0005\b\u0007\u001b\u0004A\u0011ABh\u0011\u001d\u0019\t\u000f\u0001C\u0001\u0007GDqaa;\u0001\t\u0003\u0019i\u000fC\u0004\u0004x\u0002!\ta!?\t\u000f\u0011\u0005\u0001\u0001\"\u0001\u0005\u0004!9A\u0011\u0001\u0001\u0005\u0002\u0011m\u0001b\u0002C)\u0001\u0011\u0005A1\u000b\u0005\n\t\u0003\u0003\u0011\u0013!C\u0001\t\u0007Cq\u0001b\"\u0001\t#!I\tC\u0005\u0005\u0010\u0002\t\n\u0011\"\u0005\u0004\b\"IA\u0011\u0013\u0001\u0012\u0002\u0013E1Q\u0016\u0005\b\t'\u0003A\u0011\tCK\u0011\u001d!9\n\u0001C!\t3Cq\u0001b(\u0001\t\u0003\"\tkB\u0004\u0002vvC\t!a>\u0007\rqk\u0006\u0012AA}\u0011\u001d\tiL\rC\u0001\u0003w<q!!@3\u0011\u0003\tyPB\u0004\u0003\u0004IB\tA!\u0002\t\u000f\u0005uV\u0007\"\u0001\u0003\b!I!\u0011B\u001bC\u0002\u0013\u0005!1\u0002\u0005\t\u0005')\u0004\u0015!\u0003\u0003\u000e!I!QC\u001bC\u0002\u0013\u0005!1\u0002\u0005\t\u0005/)\u0004\u0015!\u0003\u0003\u000e!I!\u0011D\u001bC\u0002\u0013\u0005!1\u0002\u0005\t\u00057)\u0004\u0015!\u0003\u0003\u000e!I!QD\u001bC\u0002\u0013\u0005!1\u0002\u0005\t\u0005?)\u0004\u0015!\u0003\u0003\u000e!9!\u0011\u0005\u001a\u0005\u0002\t\r\u0002b\u0002B\u0011e\u0011\u0005!1\u0006\u0005\b\u0005C\u0011D\u0011\u0001B\u001f\u0011\u001d\u0011\tF\rC\u0001\u0005'BqAa\u00173\t\u0003\u0011i\u0006C\u0004\u0003tI\"\tA!\u001e\u0007\u0013\t\u0015%\u0007%A\u0012\"\t\u001d\u0005b\u0002BE\u000b\u001a\u0005!1\u0012\u0005\b\u00057+e\u0011\u0001BO\u000f\u001d\u0019YC\rE\u0001\u0005[3qA!\"3\u0011\u0003\u0011I\u000bC\u0004\u0002>&#\tAa+\t\u000f\t%\u0015\n\"\u0001\u00030\u001a1!q]%\u0003\u0005SD!Ba\u001dM\u0005\u0003\u0005\u000b\u0011\u0002B<\u0011)\u0011Y\u000f\u0014B\u0001B\u0003%\u0011Q\u0010\u0005\b\u0003{cE\u0011\u0001Bw\u0011\u001d\u0011I\t\u0014C!\u0005oDqAa'M\t\u0003\u001a\tA\u0002\u0004\u0003(&\u00131\u0011\u0002\u0005\u000b\u0005g\u0012&\u0011!Q\u0001\n\t]\u0004B\u0003Bv%\n\u0005\t\u0015!\u0003\u0004\f!9\u0011Q\u0018*\u0005\u0002\rE\u0001b\u0002BE%\u0012\u00053\u0011\u0004\u0005\b\u00057\u0013F\u0011IB\u0012\u0011\u001d\u0019iC\rC\u0005\u0007_Aqaa\r3\t\u0013\u0019)\u0004C\u0004\u0004FI\"Iaa\u0012\t\u000f\r-#\u0007\"\u0003\u0004N\t\u0019r)Z8NKN\fg)Z1ukJ,\u0017J\u001c3fq*\u0011alX\u0001\u0004CBL'B\u00011b\u0003\u0015Ig\u000eZ3y\u0015\t\u00117-A\u0004hK>lWm]1\u000b\u0005\u0011,\u0017\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u00014\u0002\u0007=\u0014xm\u0001\u0001\u0016\u000b%\f9-!4\u0014\u000b\u0001Q\u0007/a\u0003\u0011\u0005-tW\"\u00017\u000b\u00035\fQa]2bY\u0006L!a\u001c7\u0003\r\u0005s\u0017PU3g!\r\t\u0018Q\u0001\b\u0003e~t!a\u001d@\u000f\u0005QlhBA;}\u001d\t18P\u0004\u0002xu6\t\u0001P\u0003\u0002zO\u00061AH]8pizJ\u0011AZ\u0005\u0003I\u0016L!AY2\n\u0005\u0001\f\u0017B\u00011`\u0013\u0011\t\t!a\u0001\u0002\u000fA\f7m[1hK*\u0011\u0001mX\u0005\u0005\u0003\u000f\tIA\u0001\u0006OC6,G-\u00138eKbTA!!\u0001\u0002\u0004A!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001D:dC2\fGn\\4hS:<'\u0002BA\u000b\u0003/\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u00033\t1aY8n\u0013\u0011\ti\"a\u0004\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0003IN,\"!a\t1\t\u0005\u0015\u0012Q\u0007\t\u0007\u0003O\ti#!\r\u000e\u0005\u0005%\"bAA\u0016?\u0006Aq-Z8u_>d7/\u0003\u0003\u00020\u0005%\"\u0001E$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f!\u0011\t\u0019$!\u000e\r\u0001\u0011Y\u0011q\u0007\u0002\u0002\u0002\u0003\u0005)\u0011AA\u001e\u0005\ryF%M\u0001\u0004IN\u0004\u0013\u0003BA\u001f\u0003\u0007\u00022a[A \u0013\r\t\t\u0005\u001c\u0002\b\u001d>$\b.\u001b8h!\rY\u0017QI\u0005\u0004\u0003\u000fb'aA!os\u0006\u00191O\u001a;\u0016\u0005\u00055\u0003\u0003BA(\u0003;j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005]\u0013\u0011L\u0001\bM\u0016\fG/\u001e:f\u0015\r\tY&Z\u0001\b_B,gnZ5t\u0013\u0011\ty&!\u0015\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013\u0001\u00028b[\u0016,\"!a\u001a\u0011\t\u0005%\u0014\u0011\u000f\b\u0005\u0003W\ni\u0007\u0005\u0002xY&\u0019\u0011q\u000e7\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\rM#(/\u001b8h\u0015\r\ty\u0007\\\u0001\u0006]\u0006lW\rI\u0001\bm\u0016\u00148/[8o+\t\ti\bE\u0002l\u0003\u007fJ1!!!m\u0005\rIe\u000e^\u0001\tm\u0016\u00148/[8oA\u0005Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0005\u0005%\u0005CBAF\u0003'\u000b9G\u0004\u0003\u0002\u000e\u0006EebA<\u0002\u0010&\tQ.C\u0002\u0002\u00021LA!!&\u0002\u0018\n\u00191+Z9\u000b\u0007\u0005\u0005A.A\u0006biR\u0014\u0018NY;uKN\u0004\u0013\u0001B7pI\u0016,\"!a(\u0011\t\u0005\u0005\u0016Q\u0017\b\u0005\u0003G\u000byK\u0004\u0003\u0002&\u0006-fb\u0001;\u0002(&\u0019\u0011\u0011V1\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0001\fiKC\u0002\u0002*\u0006LA!!-\u00024\u0006I\u0011J\u001c3fq6{G-\u001a\u0006\u0004A\u00065\u0016\u0002BA\\\u0003s\u0013\u0011\"\u00138eKblu\u000eZ3\u000b\t\u0005E\u00161W\u0001\u0006[>$W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005\u0005\u0017\u0011[An\u0003;\fy.!9\u0002dB9\u00111\u0019\u0001\u0002F\u0006-W\"A/\u0011\t\u0005M\u0012q\u0019\u0003\b\u0003\u0013\u0004!\u0019AA\u001e\u0005\u0005!\u0006\u0003BA\u001a\u0003\u001b$q!a4\u0001\u0005\u0004\tYDA\u0001V\u0011\u001d\ty\"\u0004a\u0001\u0003'\u0004D!!6\u0002ZB1\u0011qEA\u0017\u0003/\u0004B!a\r\u0002Z\u0012a\u0011qGAi\u0003\u0003\u0005\tQ!\u0001\u0002<!9\u0011\u0011J\u0007A\u0002\u00055\u0003bBA2\u001b\u0001\u0007\u0011q\r\u0005\b\u0003sj\u0001\u0019AA?\u0011\u001d\t))\u0004a\u0001\u0003\u0013Cq!a'\u000e\u0001\u0004\ty*\u0001\u0007uC\ndWMT1nK.+\u00170A\u0007uC\ndWMT1nK.+\u0017\u0010I\u0001\nS\u00124%o\\7S_^,\"!!<\u0011\u0007\u0005=XID\u0002\u0002rFr1a]Az\u0013\tqv,A\nHK>lUm]1GK\u0006$XO]3J]\u0012,\u0007\u0010E\u0002\u0002DJ\u001a\"A\r6\u0015\u0005\u0005]\u0018aB*dQ\u0016lWm\u001d\t\u0004\u0005\u0003)T\"\u0001\u001a\u0003\u000fM\u001b\u0007.Z7fgN\u0011QG\u001b\u000b\u0003\u0003\u007f\fQBW\u001aUC\ndWmU2iK6,WC\u0001B\u0007!\u0019\tYIa\u0004\u0002h%!!\u0011CAL\u0005\u0011a\u0015n\u001d;\u0002\u001di\u001bD+\u00192mKN\u001b\u0007.Z7fA\u0005i!L\r+bE2,7k\u00195f[\u0016\faB\u0017\u001aUC\ndWmU2iK6,\u0007%\u0001\bY5N\"\u0016M\u00197f'\u000eDW-\\3\u0002\u001faS6\u0007V1cY\u0016\u001c6\r[3nK\u0002\na\u0002\u0017.3)\u0006\u0014G.Z*dQ\u0016lW-A\bY5J\"\u0016M\u00197f'\u000eDW-\\3!\u0003)IG-\u001a8uS\u001aLWM\u001d\u000b\t\u0003O\u0012)Ca\n\u0003*!9\u00111M A\u0002\u0005\u001d\u0004bBA=\u007f\u0001\u0007\u0011Q\u0010\u0005\b\u0003\u000b{\u0004\u0019AAE)\u0011\t9G!\f\t\u000f\t=\u0002\t1\u0001\u00032\u0005\u0011\u0011\u000e\u001a\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)!!qGAW\u0003\u0011\u0019wN\u001c4\n\t\tm\"Q\u0007\u0002\b\u0013:$W\r_%e)\u0011\t9Ga\u0010\t\r\u0001\f\u0005\u0019\u0001B!a\u0019\u0011\u0019Ea\u0012\u0003NA9\u00111\u0019\u0001\u0003F\t-\u0003\u0003BA\u001a\u0005\u000f\"AB!\u0013\u0003@\u0005\u0005\t\u0011!B\u0001\u0003w\u00111a\u0018\u00135!\u0011\t\u0019D!\u0014\u0005\u0019\t=#qHA\u0001\u0002\u0003\u0015\t!a\u000f\u0003\u0007}#S'\u0001\tcCN,G+\u00192mK:\u000bW.Z&fsRA\u0011q\rB+\u0005/\u0012I\u0006C\u0004\u0002d\t\u0003\r!a\u001a\t\u000f\u0005\u0015%\t1\u0001\u0002\n\"9\u0011\u0011\u0010\"A\u0002\u0005u\u0014!C5e)>\u0014\u0015\u0010^3t)\u0011\u0011yF!\u001d\u0011\u000f-\u0014\t'a\u001a\u0003f%\u0019!1\r7\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#B6\u0003h\t-\u0014b\u0001B5Y\n)\u0011I\u001d:bsB\u00191N!\u001c\n\u0007\t=DN\u0001\u0003CsR,\u0007bBA%\u0007\u0002\u0007\u0011QJ\u0001\fS\u00124%o\\7CsR,7\u000f\u0006\u0003\u0003x\t\r\u0005#D6\u0003z\t\u0015\u0014QPA?\u0005{\n9'C\u0002\u0003|1\u0014\u0011BR;oGRLwN\u001c\u001b\u0011\t\u0005=#qP\u0005\u0005\u0005\u0003\u000b\tFA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\b\u0003\u0013\"\u0005\u0019AA'\u0005%IEM\u0012:p[J{wo\u0005\u0002FU\u0006)\u0011\r\u001d9msRQ\u0011q\rBG\u0005#\u0013)J!'\t\u000f\t=e\t1\u0001\u0003f\u0005\u0019!o\\<\t\u000f\tMe\t1\u0001\u0002~\u00051qN\u001a4tKRDqAa&G\u0001\u0004\ti(\u0001\u0004mK:<G\u000f\u001b\u0005\b\u0003/2\u0005\u0019\u0001B?\u0003\u0015\u0019H/\u0019:u)!\tiHa(\u0003\"\n\r\u0006b\u0002BH\u000f\u0002\u0007!Q\r\u0005\b\u0005';\u0005\u0019AA?\u0011\u001d\u00119j\u0012a\u0001\u0003{J3!\u0012*M\u0005A!\u0015P\\1nS\u000eLEM\u0012:p[J{wo\u0005\u0002JUR\u0011!Q\u0016\t\u0004\u0005\u0003IE\u0003\u0003BY\u0005g\u0013)L!4\u0011\u0007\t\u0005Q\tC\u0004\u0002J-\u0003\r!!\u0014\t\u000f\t]6\n1\u0001\u0003:\u0006A1.Z=Ta\u0006\u001cW\r\r\u0004\u0003<\n\r'\u0011\u001a\t\t\u0003\u0007\u0014iL!1\u0003H&\u0019!qX/\u0003\u001b%sG-\u001a=LKf\u001c\u0006/Y2f!\u0011\t\u0019Da1\u0005\u0019\t\u0015'QWA\u0001\u0002\u0003\u0015\t!a\u000f\u0003\u0007}#c\u0007\u0005\u0003\u00024\t%G\u0001\u0004Bf\u0005k\u000b\t\u0011!A\u0003\u0002\u0005m\"aA0%o!9!qZ&A\u0002\tE\u0017A\u0004;jKJ,GmS3z'B\f7-\u001a\t\u0006W\nM'q[\u0005\u0004\u0005+d'AB(qi&|g\u000e\r\u0004\u0003Z\nu'1\u001d\t\t\u0003\u0007\u0014iLa7\u0003bB!\u00111\u0007Bo\t1\u0011yN!4\u0002\u0002\u0003\u0005)\u0011AA\u001e\u0005\ryF\u0005\u000f\t\u0005\u0003g\u0011\u0019\u000f\u0002\u0007\u0003f\n5\u0017\u0011!A\u0001\u0006\u0003\tYDA\u0002`Ie\u0012aBR5yK\u0012LEM\u0012:p[J{wo\u0005\u0003MU\nE\u0016A\u00029sK\u001aL\u0007\u0010\u0006\u0004\u0003p\nM(Q\u001f\t\u0004\u0005cdU\"A%\t\u000f\tMt\n1\u0001\u0003x!9!1^(A\u0002\u0005uDCCA4\u0005s\u0014YP!@\u0003\u0000\"9!q\u0012)A\u0002\t\u0015\u0004b\u0002BJ!\u0002\u0007\u0011Q\u0010\u0005\b\u0005/\u0003\u0006\u0019AA?\u0011\u001d\t9\u0006\u0015a\u0001\u0005{\"\u0002\"! \u0004\u0004\r\u00151q\u0001\u0005\b\u0005\u001f\u000b\u0006\u0019\u0001B3\u0011\u001d\u0011\u0019*\u0015a\u0001\u0003{BqAa&R\u0001\u0004\tih\u0005\u0003SU\nE\u0006cC6\u0004\u000e\t\u0015\u0014QPA?\u0003{J1aa\u0004m\u0005%1UO\\2uS>t7\u0007\u0006\u0004\u0004\u0014\rU1q\u0003\t\u0004\u0005c\u0014\u0006b\u0002B:+\u0002\u0007!q\u000f\u0005\b\u0005W,\u0006\u0019AB\u0006))\t9ga\u0007\u0004\u001e\r}1\u0011\u0005\u0005\b\u0005\u001f3\u0006\u0019\u0001B3\u0011\u001d\u0011\u0019J\u0016a\u0001\u0003{BqAa&W\u0001\u0004\ti\bC\u0004\u0002XY\u0003\rA! \u0015\u0011\u0005u4QEB\u0014\u0007SAqAa$X\u0001\u0004\u0011)\u0007C\u0004\u0003\u0014^\u0003\r!! \t\u000f\t]u\u000b1\u0001\u0002~\u0005I\u0011\n\u001a$s_6\u0014vn^\u0001\fkVLG\rV8CsR,7\u000f\u0006\u0003\u0003f\rE\u0002b\u0002B\u00181\u0002\u0007\u0011qM\u0001\u000ekVLGM\u0012:p[\nKH/Z:\u0015\u0015\u0005\u001d4qGB\u001e\u0007{\u0019\t\u0005C\u0004\u0004:e\u0003\rA!\u001a\u0002\u000b\tLH/Z:\t\u000f\tM\u0015\f1\u0001\u0002~!91qH-A\u0002\u0005u\u0014aB5h]>\u0014X\r\u001a\u0005\b\u0007\u0007J\u0006\u0019\u0001B?\u0003\t\u0019h-A\u0007tiJLgn\u001a+p\u0005f$Xm\u001d\u000b\u0005\u0005K\u001aI\u0005C\u0004\u00030i\u0003\r!a\u001a\u0002\u001fM$(/\u001b8h\rJ|WNQ=uKN$\"\"a\u001a\u0004P\rE31KB+\u0011\u001d\u0019Id\u0017a\u0001\u0005KBqAa%\\\u0001\u0004\ti\bC\u0004\u0003\u0018n\u0003\r!! \t\u000f\r}2\f1\u0001\u0003~\u0005Y\u0011\u000eZ3oi&4\u0017.\u001a:!\u0003A\u0019XM]5bY&TX\rZ,ji\"LE-\u0006\u0002\u0004^A\u00191na\u0018\n\u0007\r\u0005DNA\u0004C_>dW-\u00198\u0002#M,'/[1mSj,GmV5uQ&#\u0007%\u0006\u0002\u0004hAA\u00111\u0019B_\u0003\u000b\fY-\u0006\u0002\u0004lA)1Na5\u0004nA21qNB:\u0007s\u0002\u0002\"a1\u0003>\u000eE4q\u000f\t\u0005\u0003g\u0019\u0019\bB\u0006\u0004vY\t\t\u0011!A\u0003\u0002\u0005m\"aA0%eA!\u00111GB=\t-\u0019YHFA\u0001\u0002\u0003\u0015\t!a\u000f\u0003\u0007}#3\u0007\u0006\u0003\u0002h\r}\u0004\"CBA/A\u0005\t\u0019ABB\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u0003l\u0005'\f9'\u0001\fuC\ndWMT1nK.+\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019II\u000b\u0003\u0004\u0004\u000e-5FABG!\u0011\u0019yi!'\u000e\u0005\rE%\u0002BBJ\u0007+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r]E.\u0001\u0006b]:|G/\u0019;j_:LAaa'\u0004\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\r|gNZ5hkJ,G+\u00192mK:\u000bW.\u001a\u000b\u0007\u0003O\u001a\tka)\t\u0013\r\u0005\u0015\u0004%AA\u0002\r\r\u0005\"CBS3A\u0005\t\u0019ABT\u0003\u0015a\u0017.\\5u!\u0015Y'1[A?\u0003q\u0019wN\u001c4jOV\u0014X\rV1cY\u0016t\u0015-\\3%I\u00164\u0017-\u001e7uIE\nAdY8oM&<WO]3UC\ndWMT1nK\u0012\"WMZ1vYR$#'\u0006\u0002\u00040*\"1qUBF\u0003A!W\r\\3uKR\u000b'\r\\3OC6,7\u000f\u0006\u0003\u0002\n\u000eU\u0006\"CBA9A\u0005\t\u0019ABB\u0003i!W\r\\3uKR\u000b'\r\\3OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003%9W\r^*qY&$8\u000f\u0006\u0003\u0004>\u000e}\u0006CBAF\u0003'\u0013)\u0007C\u0005\u0004\u0002z\u0001\n\u00111\u0001\u0004\u0004\u0006\u0019r-\u001a;Ta2LGo\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005iq-\u001a;QCJ$\u0018\u000e^5p]N\fQbZ3u)\u0006\u0014G.\u001a(b[\u0016\u001cH\u0003BAE\u0007\u0013D\u0011b!!\"!\u0003\u0005\raa!\u0002/\u001d,G\u000fV1cY\u0016t\u0015-\\3tI\u0011,g-Y;mi\u0012\n\u0014!E4fiR\u000b'\r\\3t\r>\u0014\u0018+^3ssR!\u0011\u0011RBi\u0011\u001d\u0019\u0019n\ta\u0001\u0007+\faAZ5mi\u0016\u0014\b#B6\u0003T\u000e]\u0007\u0003BBm\u0007;l!aa7\u000b\t\rM\u0017\u0011L\u0005\u0005\u0007?\u001cYN\u0001\u0004GS2$XM]\u0001\u0010GJ,\u0017\r^3D_:4XM\u001d;feR\u00111Q\u001d\t\u0007\u0003\u0007\u001c9/a3\n\u0007\r%XL\u0001\bXe&$XmQ8om\u0016\u0014H/\u001a:\u0002\u0019\u001d,G/\u00133Ge>l'k\\<\u0015\u0015\u0005\u001d4q^By\u0007g\u001c)\u0010C\u0004\u0003\u0010\u0016\u0002\rA!\u001a\t\u000f\tMU\u00051\u0001\u0002~!9!qS\u0013A\u0002\u0005u\u0004bBA,K\u0001\u0007!QP\u0001\fO\u0016$\u0018\nZ(gMN,G\u000f\u0006\u0005\u0002~\rm8Q`B\u0000\u0011\u001d\u0011yI\na\u0001\u0005KBqAa%'\u0001\u0004\ti\bC\u0004\u0003\u0018\u001a\u0002\r!! \u0002#\u001d,GOR5mi\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0004\u0005\u0006\u0011MAQ\u0003\t\u0006W\nMGq\u0001\t\u0005\t\u0013!iA\u0004\u0003\u0002D\u0012-\u0011bAA\u0001;&!Aq\u0002C\t\u000591\u0015\u000e\u001c;feN#(/\u0019;fOfT1!!\u0001^\u0011\u001d\u0019\u0019n\na\u0001\u0007/Dq\u0001b\u0006(\u0001\u0004!I\"A\u0005ue\u0006t7OZ8s[B)1Na5\u0002NQAAQ\u0001C\u000f\t?!\t\u0003C\u0004\u0004T\"\u0002\raa6\t\u000f\u0011]\u0001\u00061\u0001\u0005\u001a!9A1\u0005\u0015A\u0002\u0011\u0015\u0012!B:uCR\u001c\b#B6\u0003T\u0012\u001d\u0002\u0003\u0002C\u0015\t[i!\u0001b\u000b\u000b\u0007\u0011\rr,\u0003\u0003\u00050\u0011-\"\u0001D$f_6+7/Y*uCR\u001c\bf\u0002\u0015\u00054\u0011eBQ\b\t\u0004W\u0012U\u0012b\u0001C\u001cY\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0011m\u0012!\u0011:fa2\f7-\u001a3!o&$\b\u000eI4fi\u001aKG\u000e^3s'R\u0014\u0018\r^3hs\"2\u0015\u000e\u001c;fe2z\u0005\u000f^5p]n\u001b\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z/*c%\u0019\u0013q\rC \t\u000f\"\t%\u0003\u0003\u0005B\u0011\r\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#GC\u0002\u0005F1\f!\u0002Z3qe\u0016\u001c\u0017\r^3ec%\u0019C\u0011\nC&\t\u001b\")ED\u0002l\t\u0017J1\u0001\"\u0012mc\u0015\u00113\u000e\u001cC(\u0005\u0015\u00198-\u00197b\u0003A9W\r^)vKJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0005\u0005V\u0011mCQ\fC:!\u0011!I\u0001b\u0016\n\t\u0011eC\u0011\u0003\u0002\u000e#V,'/_*ue\u0006$XmZ=\t\u000f\rM\u0017\u00061\u0001\u0005\b!9AqL\u0015A\u0002\u0011\u0005\u0014!\u00025j]R\u001c\b\u0003\u0002C2\t_j!\u0001\"\u001a\u000b\t\u0011\u001dD\u0011N\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011!Y\u0007\"\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003W)\u0017\u0002\u0002C9\tK\u0012Q\u0001S5oiND\u0011\u0002\"\u001e*!\u0003\u0005\r\u0001b\u001e\u0002\u000f\u0015D\b\u000f\\1j]B!A\u0011\u0010C?\u001b\t!YHC\u0002\u0002*~KA\u0001b \u0005|\tIQ\t\u001f9mC&tWM]\u0001\u001bO\u0016$\u0018+^3ssN#(/\u0019;fOf$C-\u001a4bk2$HeM\u000b\u0003\t\u000bSC\u0001b\u001e\u0004\f\u0006\tr-\u001a8fe\u0006$X\rV1cY\u0016t\u0015-\\3\u0015\r\u0005\u001dD1\u0012CG\u0011%\u0019\ti\u000bI\u0001\u0002\u0004\u0019\u0019\tC\u0005\u0004&.\u0002\n\u00111\u0001\u0004(\u0006Yr-\u001a8fe\u0006$X\rV1cY\u0016t\u0015-\\3%I\u00164\u0017-\u001e7uIE\n1dZ3oKJ\fG/\u001a+bE2,g*Y7fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0004^\u0011m\u0005b\u0002CO_\u0001\u0007\u00111I\u0001\u0006_RDWM]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0010")
public abstract class GeoMesaFeatureIndex<T, U>
implements package.NamedIndex,
LazyLogging {
    private IdFromRow idFromRow;
    private final GeoMesaDataStore<?> ds;
    private final SimpleFeatureType sft;
    private final String name;
    private final int version;
    private final Seq<String> attributes;
    private final IndexMode.IndexMode mode;
    private final String tableNameKey;
    private final String identifier;
    private final boolean serializedWithId;
    private Logger logger;
    private volatile byte bitmap$0;

    public static Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes(SimpleFeatureType simpleFeatureType) {
        return GeoMesaFeatureIndex$.MODULE$.idFromBytes(simpleFeatureType);
    }

    public static Function1<String, byte[]> idToBytes(SimpleFeatureType simpleFeatureType) {
        return GeoMesaFeatureIndex$.MODULE$.idToBytes(simpleFeatureType);
    }

    public static String baseTableNameKey(String string, Seq<String> seq, int n) {
        return GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(string, seq, n);
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public GeoMesaDataStore<?> ds() {
        return this.ds;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Seq<String> attributes() {
        return this.attributes;
    }

    public IndexMode.IndexMode mode() {
        return this.mode;
    }

    public String tableNameKey() {
        return this.tableNameKey;
    }

    private IdFromRow idFromRow$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.idFromRow = GeoMesaFeatureIndex$IdFromRow$.MODULE$.apply(this.sft(), this.keySpace(), this.tieredKeySpace());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.idFromRow;
    }

    public IdFromRow idFromRow() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.idFromRow$lzycompute() : this.idFromRow;
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean serializedWithId() {
        return this.serializedWithId;
    }

    public abstract IndexKeySpace<T, U> keySpace();

    public abstract Option<IndexKeySpace<?, ?>> tieredKeySpace();

    public String tableNameKey(Option<String> partition) {
        return (String)partition.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(this.tableNameKey()).append(".").append((String)p).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tableNameKey());
    }

    public Option<String> tableNameKey$default$1() {
        return None$.MODULE$;
    }

    public String configureTableName(Option<String> partition, Option<Object> limit) {
        String key = this.tableNameKey(partition);
        GeoMesaMetadata qual$1 = this.ds().metadata();
        String x$1 = this.sft().getTypeName();
        String x$2 = key;
        boolean x$3 = qual$1.read$default$3();
        return (String)qual$1.read(x$1, x$2, x$3).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String name = this.generateTableName(partition, limit);
            this.ds().metadata().insert(this.sft().getTypeName(), key, name);
            return name;
        });
    }

    public Option<String> configureTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> configureTableName$default$2() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> deleteTableNames(Option<String> partition) {
        void var3_2;
        Seq<String> tables = this.getTableNames(partition);
        Option<String> option = partition;
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            this.ds().metadata().remove(this.sft().getTypeName(), new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.ds().metadata().scan(this.sft().getTypeName(), this.tableNameKey(), false).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GeoMesaFeatureIndex.$anonfun$deleteTableNames$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return var3_2;
    }

    public Option<String> deleteTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<byte[]> getSplits(Option<String> partition) {
        Seq shards = GeoMesaFeatureIndex.nonEmpty$1(this.keySpace().sharding().shards());
        Seq splits = GeoMesaFeatureIndex.nonEmpty$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])TableSplitter$.MODULE$.getSplits(this.sft(), this.identifier(), partition)));
        Seq result = (Seq)shards.flatMap((Function1 & Serializable & scala.Serializable)shard -> (Seq)splits.map((Function1 & Serializable & scala.Serializable)split -> ByteArrays$.MODULE$.concat(shard, split), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)result.drop(1);
    }

    public Option<String> getSplits$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getPartitions() {
        Seq seq;
        if (!TablePartition$.MODULE$.partitioned(this.sft())) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            int offset = this.tableNameKey().length() + 1;
            GeoMesaMetadata qual$1 = this.ds().metadata();
            String x$1 = this.sft().getTypeName();
            String x$2 = this.tableNameKey();
            boolean x$3 = qual$1.scan$default$3();
            seq = (Seq)qual$1.scan(x$1, x$2, x$3).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String string = k.substring(offset);
                return string;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<String> getTableNames(Option<String> partition) {
        Seq seq;
        Option<String> option = partition;
        if (None$.MODULE$.equals(option)) {
            GeoMesaMetadata qual$1 = this.ds().metadata();
            String x$12 = this.sft().getTypeName();
            String x$2 = this.tableNameKey();
            boolean x$3 = qual$1.scan$default$3();
            seq = (Seq)qual$1.scan(x$12, x$2, x$3).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Seq$.MODULE$.canBuildFrom());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            GeoMesaMetadata qual$2 = this.ds().metadata();
            String x$4 = this.sft().getTypeName();
            String x$5 = new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString();
            boolean x$6 = qual$2.read$default$3();
            seq = Option$.MODULE$.option2Iterable(qual$2.read(x$4, x$5, x$6)).toSeq();
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public Option<String> getTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getTablesForQuery(Option<Filter> filter) {
        Option partitioned = filter.flatMap((Function1 & Serializable & scala.Serializable)f -> TablePartition$.MODULE$.apply(this.ds(), this.sft()).flatMap((Function1 & Serializable & scala.Serializable)tp -> tp.partitions((Filter)f).map((Function1 & Serializable & scala.Serializable)partitions -> (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)p -> this.getTableNames((Option<String>)new Some(p)), Seq$.MODULE$.canBuildFrom()))));
        return (Seq)partitioned.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getTableNames((Option<String>)None$.MODULE$));
    }

    public WriteConverter<U> createConverter() {
        WriteConverter<U> writeConverter;
        Option<IndexKeySpace<?, ?>> option = this.tieredKeySpace();
        if (None$.MODULE$.equals(option)) {
            writeConverter = new WriteConverter.WriteConverterImpl<U>(this.keySpace());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            IndexKeySpace tier = (IndexKeySpace)some.value();
            writeConverter = new WriteConverter.TieredWriteConverter<U>(this.keySpace(), tier);
        } else {
            throw new MatchError(option);
        }
        return writeConverter;
    }

    public String getIdFromRow(byte[] row, int offset, int length, SimpleFeature feature) {
        return this.idFromRow().apply(row, offset, length, feature);
    }

    public int getIdOffset(byte[] row, int offset, int length) {
        return this.idFromRow().start(row, offset, length);
    }

    public Option<package.FilterStrategy> getFilterStrategy(Filter filter, Option<SimpleFeatureType> transform) {
        return this.getFilterStrategy(filter, transform, (Option<GeoMesaStats>)None$.MODULE$);
    }

    public Option<package.FilterStrategy> getFilterStrategy(Filter filter, Option<SimpleFeatureType> transform, Option<GeoMesaStats> stats) {
        throw new NotImplementedError();
    }

    public package.QueryStrategy getQueryStrategy(package.FilterStrategy filter, Hints hints, Explainer explain) {
        package.QueryStrategy queryStrategy;
        byte[] sharing = this.keySpace().sharing();
        Option indexValues = filter.primary().map((Function1 & Serializable & scala.Serializable)x$2 -> this.keySpace().getIndexValues((Filter)x$2, explain));
        boolean useFullFilter = this.keySpace().useFullFilter(indexValues, (Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig>)new Some((Object)this.ds().config()), hints);
        Option<Filter> ecql = useFullFilter ? filter.filter() : filter.secondary();
        Option option = indexValues;
        if (None$.MODULE$.equals(option)) {
            package.QueryStrategy queryStrategy2;
            if (filter.filter().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$2(x$3)))) {
                queryStrategy2 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            } else {
                BoxedUnit boxedUnit;
                if (QueryHints$.MODULE$.RichHints(hints).getMaxFeatures().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.BlockMaxThreshold().toInt().get()))) {
                    LazyRef filterString$lzy = new LazyRef();
                    boolean block = BoxesRunTime.unboxToBoolean((Object)QueryProperties$.MODULE$.blockFullTableScansForFeatureType(this.sft().getTypeName()).orElse((Function0 & Serializable & scala.Serializable)() -> QueryProperties$.MODULE$.BlockFullTableScans().toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                    if (block) {
                        throw new RuntimeException(new StringBuilder(57).append("Full-table scans are disabled. Query being stopped for ").append(this.sft().getTypeName()).append(": ").append(GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)).toString());
                    }
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Running full table scan for schema '{}' with filter: {}", (Object[])new String[]{this.sft().getTypeName(), GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Seq keyRanges = (Seq)new .colon.colon(new package.UnboundedRange<Object>(null), (List)Nil$.MODULE$);
                Seq byteRanges = (Seq)new .colon.colon((Object)new package.BoundedByteRange(sharing, ByteArrays$.MODULE$.rowFollowingPrefix(sharing)), (List)Nil$.MODULE$);
                queryStrategy2 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            }
            queryStrategy = queryStrategy2;
        } else if (option instanceof Some) {
            package.QueryStrategy queryStrategy3;
            Some some = (Some)option;
            Object values = some.value();
            LazyRef tiers$lzy = new LazyRef();
            IndexKeySpace<Object, U> qual$1 = this.keySpace();
            Object x$1 = values;
            int x$22 = qual$1.getRanges$default$2();
            Seq keyRanges = qual$1.getRanges(x$1, x$22).toSeq();
            Seq bytes = this.keySpace().getRangeBytes(keyRanges.iterator(), this.tieredKeySpace().isDefined()).toSeq();
            IndexKeySpace tier = (IndexKeySpace)this.tieredKeySpace().orNull(Predef$.MODULE$.$conforms());
            Filter secondary = (Filter)filter.secondary().orNull(Predef$.MODULE$.$conforms());
            if (tier == null) {
                queryStrategy3 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)bytes, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            } else if (secondary == null || GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$8(x$6)))) {
                Seq byteRanges = this.keySpace().getRangeBytes(keyRanges.iterator(), true).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    package.BoundedByteRange boundedByteRange;
                    package.ByteRange byteRange = x0$1;
                    if (byteRange instanceof package.BoundedByteRange) {
                        package.BoundedByteRange boundedByteRange2 = (package.BoundedByteRange)byteRange;
                        byte[] lo = boundedByteRange2.lower();
                        byte[] hi = boundedByteRange2.upper();
                        boundedByteRange = new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    } else if (byteRange instanceof package.SingleRowByteRange) {
                        package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                        byte[] row = singleRowByteRange.row();
                        boundedByteRange = new package.BoundedByteRange(row, ByteArrays$.MODULE$.concat(row, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    } else if (byteRange instanceof package.UpperBoundedByteRange) {
                        package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                        byte[] lo = upperBoundedByteRange.lower();
                        byte[] hi = upperBoundedByteRange.upper();
                        boundedByteRange = new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    } else if (byteRange instanceof package.LowerBoundedByteRange) {
                        package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                        byte[] lo = lowerBoundedByteRange.lower();
                        byte[] hi = lowerBoundedByteRange.upper();
                        boundedByteRange = new package.BoundedByteRange(lo, hi);
                    } else if (byteRange instanceof package.UnboundedByteRange) {
                        package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                        byte[] lo = unboundedByteRange.lower();
                        byte[] hi = unboundedByteRange.upper();
                        boundedByteRange = new package.BoundedByteRange(lo, hi);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
                    }
                    return boundedByteRange;
                }).toSeq();
                queryStrategy3 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            } else if (GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).isEmpty()) {
                queryStrategy3 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            } else {
                LazyRef minTier$lzy = new LazyRef();
                LazyRef maxTier$lzy = new LazyRef();
                Seq byteRanges = (Seq)bytes.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object object;
                    package.ByteRange byteRange = x0$2;
                    if (byteRange instanceof package.SingleRowByteRange) {
                        package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                        byte[] row = singleRowByteRange.row();
                        object = GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Product product;
                            package.ByteRange byteRange = x0$3;
                            if (byteRange instanceof package.BoundedByteRange) {
                                package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                                byte[] lo = boundedByteRange.lower();
                                byte[] hi = boundedByteRange.upper();
                                product = new package.BoundedByteRange(ByteArrays$.MODULE$.concat(row, lo), ByteArrays$.MODULE$.concat(row, hi));
                            } else if (byteRange instanceof package.SingleRowByteRange) {
                                package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                                byte[] trow = singleRowByteRange.row();
                                product = new package.SingleRowByteRange(ByteArrays$.MODULE$.concat(row, trow));
                            } else {
                                throw new MatchError((Object)byteRange);
                            }
                            return product;
                        }, Seq$.MODULE$.canBuildFrom());
                    } else if (byteRange instanceof package.BoundedByteRange) {
                        package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                        byte[] lo = boundedByteRange.lower();
                        byte[] hi = boundedByteRange.upper();
                        object = package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                    } else if (byteRange instanceof package.LowerBoundedByteRange) {
                        package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                        byte[] lo = lowerBoundedByteRange.lower();
                        byte[] hi = lowerBoundedByteRange.upper();
                        object = package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), hi));
                    } else if (byteRange instanceof package.UpperBoundedByteRange) {
                        package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                        byte[] lo = upperBoundedByteRange.lower();
                        byte[] hi = upperBoundedByteRange.upper();
                        object = package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                    } else if (byteRange instanceof package.UnboundedByteRange) {
                        package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                        byte[] lo = unboundedByteRange.lower();
                        byte[] hi = unboundedByteRange.upper();
                        object = package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, hi));
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
                    }
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                queryStrategy3 = new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain), ecql, hints, indexValues);
            }
            queryStrategy = queryStrategy3;
        } else {
            throw new MatchError((Object)option);
        }
        return queryStrategy;
    }

    public Explainer getQueryStrategy$default$3() {
        return ExplainNull$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generateTableName(Option<String> partition, Option<Object> limit) {
        String string;
        String string2 = this.ds().config().catalog();
        String prefix = ((TraversableOnce)((SeqLike)((TraversableLike)new .colon.colon((Object)this.sft().getTypeName(), (List)new .colon.colon((Object)this.name(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).mkString("_");
        String suffix = new StringBuilder(1).append("v").append(this.version()).append(partition.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append("_").append((String)p).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        String full = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable & scala.Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input), Seq$.MODULE$.canBuildFrom()), prefix, suffix);
        Option<Object> option = limit;
        if (!(option instanceof Some)) return full;
        Some some = (Some)option;
        int lim = BoxesRunTime.unboxToInt((Object)some.value());
        if (new StringOps(Predef$.MODULE$.augmentString(full)).lengthCompare(lim) <= 0) return full;
        String nums = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable & scala.Serializable)a -> String.valueOf(BoxesRunTime.boxToInteger((int)this.sft().indexOf(a))), Seq$.MODULE$.canBuildFrom()), prefix, suffix);
        if (new StringOps(Predef$.MODULE$.augmentString(nums)).lengthCompare(lim) <= 0) {
            string = nums;
            return string;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Table name length exceeds configured limit ({}), falling back to UUID: {}", new Object[]{BoxesRunTime.boxToInteger((int)lim), full});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = IndexAdapter$.MODULE$.truncateTableName(full, lim);
        }
        return string;
    }

    public Option<String> generateTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> generateTableName$default$2() {
        return None$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(0).append(this.getClass().getSimpleName()).append(this.attributes().mkString("(", ",", ")")).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof GeoMesaFeatureIndex)) return false;
        GeoMesaFeatureIndex geoMesaFeatureIndex = (GeoMesaFeatureIndex)object;
        String string = this.identifier();
        String string2 = geoMesaFeatureIndex.identifier();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        IndexMode.IndexMode indexMode = this.mode();
        IndexMode.IndexMode indexMode2 = geoMesaFeatureIndex.mode();
        if (indexMode == null) {
            if (indexMode2 != null) {
                return false;
            }
        } else if (!indexMode.equals(indexMode2)) return false;
        GeoMesaDataStore<?> geoMesaDataStore = this.ds();
        GeoMesaDataStore<?> geoMesaDataStore2 = geoMesaFeatureIndex.ds();
        if (geoMesaDataStore == null) {
            if (geoMesaDataStore2 != null) {
                return false;
            }
        } else if (!geoMesaDataStore.equals(geoMesaDataStore2)) return false;
        SimpleFeatureType simpleFeatureType = this.sft();
        SimpleFeatureType simpleFeatureType2 = geoMesaFeatureIndex.sft();
        if (simpleFeatureType == null) {
            if (simpleFeatureType2 == null) return true;
            return false;
        } else {
            if (!simpleFeatureType.equals(simpleFeatureType2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)new .colon.colon((Object)this.identifier(), (List)new .colon.colon(this.ds(), (List)new .colon.colon((Object)this.sft(), (List)new .colon.colon((Object)this.mode(), (List)Nil$.MODULE$))))).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 != null ? BoxesRunTime.boxToInteger((int)A1.hashCode()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object != null;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ void $anonfun$deleteTableNames$1(GeoMesaFeatureIndex $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        $this.ds().metadata().remove($this.sft().getTypeName(), k);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq nonEmpty$1(Seq bytes) {
        return bytes.nonEmpty() ? bytes : (Seq)new .colon.colon((Object)((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$2(Filter x$3) {
        return x$3 instanceof ExcludeFilter;
    }

    private static final /* synthetic */ String filterString$lzycompute$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        String string;
        LazyRef lazyRef = filterString$lzy$1;
        synchronized (lazyRef) {
            string = filterString$lzy$1.initialized() ? (String)filterString$lzy$1.value() : (String)filterString$lzy$1.initialize((Object)org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter$1.filter().getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE)));
        }
        return string;
    }

    private static final String filterString$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        return filterString$lzy$1.initialized() ? (String)filterString$lzy$1.value() : GeoMesaFeatureIndex.filterString$lzycompute$1(filterString$lzy$1, filter$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$7(package.ByteRange x$5) {
        return x$5 instanceof package.SingleRowByteRange;
    }

    private static final /* synthetic */ Seq tiers$lzycompute$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        Seq seq;
        LazyRef lazyRef = tiers$lzy$1;
        synchronized (lazyRef) {
            Seq seq2;
            if (tiers$lzy$1.initialized()) {
                seq2 = (Seq)tiers$lzy$1.value();
            } else {
                int multiplier = scala.math.package$.MODULE$.max(1, bytes$1.count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$7(x$5))));
                seq2 = (Seq)tiers$lzy$1.initialize((Object)tier$1.getRangeBytes(tier$1.getRanges(tier$1.getIndexValues(secondary$1, explain$1), multiplier), tier$1.getRangeBytes$default$2()).toSeq());
            }
            seq = seq2;
        }
        return seq;
    }

    private static final Seq tiers$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        return tiers$lzy$1.initialized() ? (Seq)tiers$lzy$1.value() : GeoMesaFeatureIndex.tiers$lzycompute$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$8(package.ByteRange x$6) {
        return x$6 instanceof package.UnboundedByteRange;
    }

    private static final /* synthetic */ byte[] minTier$lzycompute$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = minTier$lzy$1;
        synchronized (lazyRef) {
            byArray = minTier$lzy$1.initialized() ? (byte[])minTier$lzy$1.value() : (byte[])minTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.min((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] minTier$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        return minTier$lzy$1.initialized() ? (byte[])minTier$lzy$1.value() : GeoMesaFeatureIndex.minTier$lzycompute$1(minTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final /* synthetic */ byte[] maxTier$lzycompute$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = maxTier$lzy$1;
        synchronized (lazyRef) {
            byArray = maxTier$lzy$1.initialized() ? (byte[])maxTier$lzy$1.value() : (byte[])maxTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.max((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] maxTier$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        return maxTier$lzy$1.initialized() ? (byte[])maxTier$lzy$1.value() : GeoMesaFeatureIndex.maxTier$lzycompute$1(maxTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final String build$1(Seq attrs, String prefix$1, String suffix$1) {
        String string = prefix$1;
        return ((TraversableOnce)((SeqLike)attrs.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)suffix$1, Seq$.MODULE$.canBuildFrom())).mkString("_");
    }

    public GeoMesaFeatureIndex(GeoMesaDataStore<?> ds, SimpleFeatureType sft, String name, int version, Seq<String> attributes2, IndexMode.IndexMode mode) {
        this.ds = ds;
        this.sft = sft;
        this.name = name;
        this.version = version;
        this.attributes = attributes2;
        this.mode = mode;
        LazyLogging.$init$((LazyLogging)this);
        this.tableNameKey = GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(name, attributes2, version);
        this.identifier = GeoMesaFeatureIndex$.MODULE$.identifier(name, version, attributes2);
        this.serializedWithId = false;
    }

    public static interface IdFromRow {
        public String apply(byte[] var1, int var2, int var3, SimpleFeature var4);

        public int start(byte[] var1, int var2, int var3);
    }
}

