/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.conf.splitter;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter$Parser$;
import org.locationtech.geomesa.index.conf.splitter.SplitPatternParser;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class DefaultSplitter$ {
    public static DefaultSplitter$ MODULE$;
    private final DefaultSplitter Instance;

    static {
        new DefaultSplitter$();
    }

    public DefaultSplitter Instance() {
        return this.Instance;
    }

    public byte[][] org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$idBytes(Map<String, String> options) {
        return (byte[][])((TraversableOnce)DefaultSplitter$Parser$.MODULE$.idSplits(options).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public byte[][] org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$attributeBytes(SimpleFeatureType sft, String attribute, Map<String, String> options) {
        AttributeDescriptor descriptor = sft.getDescriptor(attribute);
        Class binding = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) : descriptor.getType().getBinding();
        return (byte[][])((TraversableOnce)DefaultSplitter$Parser$.MODULE$.attributeSplits(attribute, binding, options).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getBytes(StandardCharsets.UTF_8), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public byte[][] org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$z3Bytes(SimpleFeatureType sft, Option<String> partition, Map<String, String> options) {
        Map map;
        Enumeration.Value period = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Option option = partition.flatMap((Function1 & Serializable & scala.Serializable)p -> Try$.MODULE$.apply((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(p)).toShort()).toOption());
        if (None$.MODULE$.equals(option)) {
            map = options;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            short p2 = BoxesRunTime.unboxToShort((Object)some.value());
            String date = DateParsing$.MODULE$.format((ZonedDateTime)BinnedTime$.MODULE$.binnedTimeToDate(period).apply((Object)new BinnedTime(p2, 1L)), DateParsing$.MODULE$.format$default$2());
            map = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultSplitter$Parser$.MODULE$.Z3MinDateOption()), (Object)date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultSplitter$Parser$.MODULE$.Z3MaxDateOption()), (Object)date)})));
        } else {
            throw new MatchError((Object)option);
        }
        Map opts = map;
        return (byte[][])((TraversableOnce)DefaultSplitter$Parser$.MODULE$.z3Splits(period, opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    return ByteArrays$.MODULE$.toBytes(bin);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
            Some some = (Some)option;
            long z = BoxesRunTime.unboxToLong((Object)some.value());
            return ByteArrays$.MODULE$.toBytes(bin, z);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public byte[][] org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$z2Bytes(Map<String, String> options) {
        return (byte[][])((TraversableOnce)DefaultSplitter$Parser$.MODULE$.z2Splits(options).map((Function1 & Serializable & scala.Serializable)object -> ByteArrays$.MODULE$.toBytes(BoxesRunTime.unboxToLong((Object)object)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public Iterator<String> org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$patterns(String base, Map<String, String> options) {
        Iterator keys = package$.MODULE$.Iterator().single((Object)base).$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().range(2, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)i -> DefaultSplitter$.$anonfun$patterns$2(base, BoxesRunTime.unboxToInt((Object)i))));
        return keys.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)options.get(x$8).orNull(Predef$.MODULE$.$conforms())).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DefaultSplitter$.$anonfun$patterns$4(x$9)));
    }

    public Seq<String> org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$numberPatternSplits(SplitPatternParser.SplitPattern pattern, Class<?> binding) throws NumberFormatException {
        return (Seq)pattern.range().map((Function1 & Serializable & scala.Serializable)r -> {
            Integer.parseInt(r);
            return AttributeIndexKey$.MODULE$.encodeForQuery(r, binding);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Object> org$locationtech$geomesa$index$conf$splitter$DefaultSplitter$$bitSplits(String key, Map<String, String> options, int maskedBits) {
        Seq seq;
        Option option = options.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)DefaultSplitter$.$anonfun$bitSplits$1(x$10)));
        if (None$.MODULE$.equals(option)) {
            seq = (Seq)Nil$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            int bits2 = BoxesRunTime.unboxToInt((Object)some.value());
            Predef$.MODULE$.require(bits2 > 0 && bits2 < 64, (Function0 & Serializable & scala.Serializable)() -> "Bit split must be between 1 and 63");
            seq = (Seq)DefaultSplitter$.add$1((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, bits2).map((Function1 & Serializable & scala.Serializable)bits -> BoxesRunTime.boxToLong((long)DefaultSplitter$.toLong$1(bits, maskedBits)), Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public static final /* synthetic */ String $anonfun$patterns$2(String base$1, int i) {
        return new StringBuilder(0).append(base$1).append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$patterns$4(String x$9) {
        return x$9 != null;
    }

    public static final /* synthetic */ int $anonfun$bitSplits$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    private static final Seq add$1(Seq result, Seq bits, int remaining) {
        Seq seq;
        if (remaining == 0) {
            seq = (Seq)new .colon.colon((Object)bits, (List)Nil$.MODULE$);
        } else {
            Seq zero = DefaultSplitter$.add$1(result, (Seq)bits.$colon$plus((Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom()), remaining - 1);
            Seq one = DefaultSplitter$.add$1(result, (Seq)bits.$colon$plus((Object)BoxesRunTime.boxToInteger((int)1), Seq$.MODULE$.canBuildFrom()), remaining - 1);
            seq = (Seq)((TraversableLike)result.$plus$plus((GenTraversableOnce)zero, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)one, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private static final long toLong$1(Seq bits, int maskedBits$1) {
        String binaryString = ((TraversableOnce)((SeqLike)((TraversableLike)Seq$.MODULE$.fill(maskedBits$1, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)).$plus$plus((GenTraversableOnce)bits, Seq$.MODULE$.canBuildFrom())).padTo(64, (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom())).mkString("");
        return Long.parseLong(binaryString, 2);
    }

    private DefaultSplitter$() {
        MODULE$ = this;
        this.Instance = new DefaultSplitter();
    }
}

